/******************************************************************************\
*
* (C) Copyright 1996 by Shetef Solutions Ltd.
*
* Address:
*		Shetef Solutions Ltd.
*		P. O. Box 7938
*		Haifa 31078
*		ISRAEL
*
* Email : 	Support@shetef.com
* WWW:		http://www.shetef.com
* Tel:		+972-4-8260064
* Fax:		+972-6-271210
*
\******************************************************************************/

// sstesdlg.cpp : implementation file
//

#include "stdafx.h"
#include "sstest.h"
#include "sstesdlg.h"

#include "ssdll.h"
#include "data.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg message handlers

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();
	
	// TODO: Add extra about dlg initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
// CSstestDlg dialog

CSstestDlg::CSstestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSstestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSstestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSstestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSstestDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSstestDlg, CDialog)
	//{{AFX_MSG_MAP(CSstestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_DISABLE, OnDisable)
	ON_BN_CLICKED(IDC_ENABLE, OnEnable)
	ON_BN_CLICKED(IDC_FIX, OnFix)
	ON_BN_CLICKED(IDC_HIDE, OnHide)
	ON_BN_CLICKED(IDC_NOACCESS, OnNoaccess)
	ON_BN_CLICKED(IDC_READONLY, OnReadonly)
	ON_BN_CLICKED(IDC_RESET, OnReset)
	ON_BN_CLICKED(IDC_SAFE, OnSafe)
	ON_BN_CLICKED(IDC_SSINIT, OnSsinit)
	ON_BN_CLICKED(IDC_SSTERMINATE, OnSsterminate)
	ON_BN_CLICKED(IDC_UNFIX, OnUnfix)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void TestErrMsg(int err) {
	CHAR buf[MAX_PATH];

	switch (err) {
		case SSERR_NOERROR:
			wsprintf(buf, "No error");
			break;
		case SSERR_DLL_ALREADY_INITIALIZED:
			wsprintf(buf, "DLL already initialized");
			break;
		case SSERR_DLL_NOT_INITIALIZED:
			wsprintf(buf, "DLL not initialized yet");
			break;
		case SSERR_NOT_WIN95_OS			:
			wsprintf(buf, "We are not running currently on a windows 95 os");
			break;
		case SSERR_FAILED_LOADING_VXD	:
			wsprintf(buf, "Failed loading VxD");
			break;
		case SSERR_VXD_ALREADY_LOADED	:
			wsprintf(buf, "VxD already loaded");
			break;
		case SSERR_FAILED_UNLOADING_VXD	:
			wsprintf(buf, "failed unloading VxD");
			break;
		case SSERR_SS_NOT_INITIALIZED	:
			wsprintf(buf, "SSDLL was not initialized");
			break;
		case SSERR_FAILED_FIXING		:
			wsprintf(buf, "Failed fixing the application");
			break;
		case SSERR_FAILED_UNFIXING		:
			wsprintf(buf, "Failed un fixing the application");
			break;
		default:
			wsprintf(buf, "What, I do not know this error code!");
			break;
	}
	AfxMessageBox(buf);
}

/////////////////////////////////////////////////////////////////////////////
// CSstestDlg message handlers

BOOL CSstestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSstestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSstestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSstestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSstestDlg::OnDisable() 
{
	int rc = SSDisable();
	if (rc) {
		TestErrMsg(rc);
	}
	
}

void CSstestDlg::OnEnable() 
{
	int rc = SSEnable();
	if (rc) {
		TestErrMsg(rc);
	}
	
}

void CSstestDlg::OnFix() 
{
	int rc = SSFixApplication();
	if (rc) {
		TestErrMsg(rc);
	}
	
}

void CSstestDlg::OnHide() 
{
	CData dlg;
	int rc;

	if (dlg.DoModal() == IDOK) {
		rc = SSSetHide(dlg.m_Data, dlg.m_bSubDir, dlg.m_bExclude);
		if (rc) {
			TestErrMsg(rc);
		}
	}
	
}

void CSstestDlg::OnNoaccess() 
{
	CData dlg;
	int rc;

	if (dlg.DoModal() == IDOK) {
		rc = SSSetNoAccess(dlg.m_Data, dlg.m_bSubDir, dlg.m_bExclude);
		if (rc) {
			TestErrMsg(rc);
		}
	}
}

void CSstestDlg::OnReadonly() 
{
	CData dlg;
	int rc;

	if (dlg.DoModal() == IDOK) {
		rc = SSSetReadOnly(dlg.m_Data, dlg.m_bSubDir, dlg.m_bExclude);
		if (rc) {
			TestErrMsg(rc);
		}
	}
}

void CSstestDlg::OnReset() 
{
	SSResetAccessRestrictions();
	
}

void CSstestDlg::OnSafe() 
{
	CData dlg;
	int rc;

	if (dlg.DoModal() == IDOK) {
		rc = SSSetSafeTask(dlg.m_Data);
		if (rc) {
			TestErrMsg(rc);
		}
	}
}

void CSstestDlg::OnSsinit() 
{
	int rc = SSInit();
		if (rc) {
		TestErrMsg(rc);
	}
}

void CSstestDlg::OnSsterminate() 
{
	int rc = SSTerminate();
	if (rc) {
		TestErrMsg(rc);
	}
}

void CSstestDlg::OnUnfix() 
{
	int rc = SSUnFixApplication();
	if (rc) {
		TestErrMsg(rc);
	}
}

void CSstestDlg::OnOK() 
{
	CDialog::OnOK();
}

void CSstestDlg::OnClose() 
{
	CDialog::OnClose();
}
