// stdiovw.cpp : implementation file
//
#include "stdafx.h"
#include "test2.h"
#include "stdiovw.h"
#include <stdio.h>
#include <stdarg.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStdioView

IMPLEMENT_DYNCREATE(CStdioView, CEditView)

CStdioView::CStdioView()
{
  m_iMaxLines=100;//rather arbitrary, but what the hell...
  m_iLastCaretPos=0;
  m_bWaitingForInput=FALSE;
}

CStdioView::~CStdioView()
{
}


BEGIN_MESSAGE_MAP(CStdioView, CEditView)
    //{{AFX_MSG_MAP(CStdioView)
    ON_WM_CREATE()
  ON_WM_KEYDOWN()
  ON_WM_KEYUP()
  ON_WM_CHAR()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStdioView drawing

void CStdioView::OnDraw(CDC* pDC)
{
    CDocument* pDoc = GetDocument();
    // TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CStdioView diagnostics

#ifdef _DEBUG
void CStdioView::AssertValid() const
{
    CEditView::AssertValid();
}

void CStdioView::Dump(CDumpContext& dc) const
{
    CEditView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CStdioView message handlers
 

int CStdioView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CEditView::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    CFont fixedFont;
    fixedFont.CreateStockObject(ANSI_FIXED_FONT);
    SetFont(&fixedFont,TRUE);
    GetEditCtrl().SetReadOnly(TRUE);
    return 0;
}


int CStdioView::TextOut(LPCSTR lpString,BOOL bAddReturn)
{
  int nLines, iEndSel,iTextLength;
  unsigned idx1=0,idx2=0;
  char lastChar='\0';

  while(lpString[idx1] && idx2 < BUFFER_SIZE){
    m_buffer[idx2]=lpString[idx1];
    if(m_buffer[idx2]=='\n' && lastChar != '\r'){
      m_buffer[idx2]='\r';
      idx2++;
      m_buffer[idx2]='\n';
    }
    lastChar=m_buffer[idx2];
    idx1++;
    idx2++;
  }
  if(bAddReturn){
    m_buffer[idx2]='\r';
    idx2++;
    m_buffer[idx2]='\n';
    idx2++;
  }
  m_buffer[idx2]='\0';


  nLines = GetEditCtrl().GetLineCount();
  if (nLines > m_iMaxLines){
    SetRedraw(FALSE);
    iEndSel = GetEditCtrl().LineIndex(nLines - m_iMaxLines);
    GetEditCtrl().SetSel(0,iEndSel,TRUE);
    GetEditCtrl().ReplaceSel("");
    SetRedraw(TRUE);
  }

  iTextLength = GetEditCtrl().GetWindowTextLength();
  GetEditCtrl().SetSel(iTextLength,iTextLength);
  GetEditCtrl().ReplaceSel(m_buffer);
  return idx2;
}


int CStdioView::printf(const char *fmt,...)
{
  int ret;
  char buffer[1024];
  va_list arg_ptr;
  va_start(arg_ptr, fmt);
  vsprintf(buffer,fmt,arg_ptr);
  va_end(arg_ptr);
  ret = TextOut(buffer,FALSE);
  return ret;
}



char *CStdioView::TextIn(char *buffer,BOOL bWantNewline)
{
  int i;
  LPSTR pEditText, pBuffer;
  int iTextLength;

  buffer[0]='\0';
  
  // Move the caret to the end of the edit control 
  iTextLength = GetEditCtrl().GetWindowTextLength();
  GetEditCtrl().SetSel(iTextLength,iTextLength);
  
  //Remember where it is sitting
  m_iLastCaretPos = iTextLength;
  //Turn off the READONLY state to allow input 
  GetEditCtrl().SetReadOnly(FALSE);

  // Wait until input has finished ie. RETURN key 
  m_bWaitingForInput=TRUE;
  while(IsWindow(this->m_hWnd) && m_bWaitingForInput && m_bAppQuiting){
    MyYield();
  }
  
  if(IsWindow(this->m_hWnd)){
    //Turn READONLY state back on to disallow input 
    GetEditCtrl().SetReadOnly(TRUE);
    
    // find out where we are now 
    iTextLength = GetEditCtrl().GetWindowTextLength();
    pEditText = new char[iTextLength+2];
    GetEditCtrl().GetWindowText(pEditText,iTextLength+1);
    pBuffer=buffer;
    for(i=m_iLastCaretPos; i<=iTextLength; i++){
      if((pEditText[i] =='\r'|| pEditText[i] =='\n') && !bWantNewline)
        *pBuffer = '\0';
      else
        *pBuffer = pEditText[i];
      pBuffer++;
    }
    *pBuffer = '\0';    
  delete [] pEditText;
  }
  else{
    buffer[0]='\0';
  }
  return buffer;
}


//I don't think this is strictly WIN32 portable, 
//but I haven't checked it out yet. Caveat emptor...
void CStdioView::MyYield()
{ 
  MSG msg;
  if( ::PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE )){ 
    if ( !AfxGetApp()->PumpMessage()){ 
      m_bAppQuiting=TRUE; 
      ::PostQuitMessage(msg.wParam); 
      return; 
    } 
  } 
  // let MFC do its idle processing
  AfxGetApp()->OnIdle(0);  
}
  

void CStdioView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  int iTextLength;
  int iKeyState;
  switch(nChar){
    case VK_RETURN:
      iKeyState=GetKeyState(VK_CONTROL) & (~1); //throw away the toggle bit
      if(! iKeyState){
        iTextLength = GetEditCtrl().GetWindowTextLength();
        GetEditCtrl().SetSel(iTextLength,iTextLength);
      }
      break;
  }
  
  CEditView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CStdioView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  int iKeyState;
  switch(nChar){
    case VK_RETURN:
      iKeyState=GetKeyState(VK_CONTROL) & (~1); //throw away the toggle bit
      if(! iKeyState)
        m_bWaitingForInput=FALSE;
      break;
  }
  
  CEditView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CStdioView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  int iStartChar, iEndChar,iTemp;
  GetEditCtrl().GetSel(iStartChar,iEndChar );
  //move any selection to a valid range
  if(m_iLastCaretPos >iStartChar)
    iStartChar = m_iLastCaretPos;
  if(m_iLastCaretPos >iEndChar)
    iEndChar = m_iLastCaretPos;
  //normalise the start and end of selection
  if(iStartChar >iEndChar){
    iTemp = iStartChar;
    iStartChar = iEndChar;
    iEndChar = iTemp;
  }  
  if(nChar== VK_BACK && m_iLastCaretPos == iStartChar){
    //can't delete stuff printed previously
    MessageBeep(MB_ICONEXCLAMATION);
    return;
  }
  if(m_iLastCaretPos == iStartChar){
    //move the selection back to valid position
    GetEditCtrl().SetSel(iStartChar,iEndChar); 
  }
  
  CEditView::OnChar(nChar, nRepCnt, nFlags);
}
