// stdiovw.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CStdioView view

class CStdioView : public CEditView
{
protected:
    CStdioView();            // protected constructor used by dynamic creation
    DECLARE_DYNCREATE(CStdioView)

private:
    enum {BUFFER_SIZE=1024};
    char m_buffer[BUFFER_SIZE];
    int m_iMaxLines;
    int m_iLastCaretPos;
    BOOL m_bWaitingForInput;
    BOOL m_bAppQuiting;

// Attributes
public:

// Operations
public:
    int TextOut(LPCSTR string,BOOL bAddReturn=TRUE);
    int SetMaxLines(int iNumMaxLines){ return m_iMaxLines = iNumMaxLines >0 ? iNumMaxLines : m_iMaxLines;}
    int GetMaxLines(){return m_iMaxLines;}
    int puts( const char *string ){ return TextOut(string,TRUE);}
    int printf( const char *format,...);
    char *TextIn(char *buffer,BOOL bWantNewline=FALSE);
    char *gets(char *buffer){return TextIn(buffer,FALSE);}
    
// Overrides
public:

protected:
    virtual void OnDraw(CDC* pDC);      // overridden to draw this view

// Implementation
protected:
    virtual ~CStdioView();
#ifdef _DEBUG
    virtual void AssertValid() const;
    virtual void Dump(CDumpContext& dc) const;
#endif
    void MyYield();

    // Generated message map functions
protected:
    //{{AFX_MSG(CStdioView)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
  afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
  afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
  afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
  //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
