unit TapiCfg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, TAPI, ExtCtrls;

type
  TfmTapiCfg = class(TForm)
    Button2: TButton;
    Button3: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Edit1: TEdit;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Button1: TButton;
    procedure ComboBox1Change(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
    function GetDevCaps(hLineApp: THLineApp; dwDeviceID: Longint;
    var lpdwAPIVersion: Longint): LPLineDevCaps;
  public
    { Public declarations }
    fPhoneNumber : string;
    fDeviceID : integer;
    procedure ConfigDialing(hLineApp: THLineApp; dwNumDevs: Longint;
               var lphLine: THLine; var lphCall: THCall; sPhnNum : string; iDeviceID : Longint);

  end;

var
  fmTapiCfg: TfmTapiCfg;

implementation

{$R *.DFM}

procedure TfmTapiCfg.ConfigDialing(hLineApp: THLineApp; dwNumDevs: Longint;
               var lphLine: THLine; var lphCall: THCall; sPhnNum : string; iDeviceID : Longint);
var
   pLineDevCaps: LPLineDevCaps;
   dwAPIVersion: Longint;
   i: Longint;
begin
   {---- Fill in the TAPI device combo box}
   for i := 0 to dwNumDevs - 1 do
   begin
      pLineDevCaps := GetDevCaps(hLineApp, i, dwAPIVersion);
      if (pLineDevCaps^.dwMediaModes and LINEMEDIAMODE_DATAMODEM) <> 0 then
      begin
         ComboBox1.Items.Add(PChar(pLineDevCaps) + pLineDevCaps^.dwLineNameOffset);
      end;
      FreeMem(pLineDevCaps);
   end;

   {---- Set the values}
   Edit1.Text := sPhnNum;
   Combobox1.ItemIndex := iDeviceID;
   ComboBox1Change(Self);

   {---- Show the Form}
   ShowModal;

end;

function TfmTapiCfg.GetDevCaps(hLineApp: THLineApp; dwDeviceID: Longint;
    var lpdwAPIVersion: Longint): LPLineDevCaps;
var
   pLineDevCaps: LPLineDevCaps;
   extensionID: TLineExtensionID;
begin
   lineNegotiateAPIVersion(hLineApp, dwDeviceID, $10004, $10004,
   lpdwAPIVersion, extensionID);
   pLineDevCaps := AllocMem(SizeOf(TLineDevCaps));
   pLineDevCaps^.dwTotalSize := SizeOf(TLineDevCaps);
   lineGetDevCaps(hLineApp, dwDeviceID, lpdwAPIVersion, 0,
   pLineDevCaps^);
   if pLineDevCaps^.dwNeededSize > pLineDevCaps^.dwTotalSize then
   begin
      ReallocMem(pLineDevCaps, pLineDevCaps^.dwNeededSize);
      pLineDevCaps^.dwTotalSize := pLineDevCaps^.dwNeededSize;
      lineGetDevCaps(hLineApp, dwDeviceID, lpdwAPIVersion, 0,
      pLineDevCaps^);
   end;
   Result :=  pLineDevCaps;
end;


procedure TfmTapiCfg.ComboBox1Change(Sender: TObject);
var
   iPos : integer;
begin
   fDeviceID := ComboBox1.ItemIndex;
   iPos := Pos('COM', ComboBox1.Text);
   if iPos <> 0 then
   begin
      Edit1.Enabled := False;
      Edit1.Text := Copy(ComboBox1.Text, iPos, 4);
   end;
end;

procedure TfmTapiCfg.Edit1Change(Sender: TObject);
begin
   fPhoneNumber := Edit1.Text;
end;

procedure TfmTapiCfg.Button1Click(Sender: TObject);
begin
   lineConfigDialog(ComboBox1.ItemIndex, self.handle, Nil);
end;

procedure TfmTapiCfg.Button2Click(Sender: TObject);
begin
   fDeviceID := ComboBox1.ItemIndex;
   fPhoneNumber := Edit1.Text;
end;

end.
