/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __TKWAIT_H
#define __TKWAIT_H

#ifndef __TKPROTO
#include <sys/tkproto.h>
#endif

union	wait
{
	long	w_status;
	struct
	{
		unsigned short	w_pad0;
		unsigned short	w_Retcode : 8;
		unsigned short	w_Coredump : 1;
		unsigned short	w_Termsig : 7;
	} w_T;

	struct
	{
		unsigned short w_pad1 : 8;
		unsigned short w_Stopevent : 8;
		unsigned short w_Stopsig : 8;
		unsigned short w_Stopval : 8;
	} w_S;
};

#define	w_termsig	w_T.w_Termsig
#define	w_coredump	w_T.w_Coredump
#define	w_retcode	w_T.w_Retcode
#define	w_stopval	w_S.w_Stopval
#define	w_stopsig	w_S.w_Stopsig
#define	w_stopevent	w_S.w_Stopevent

#define	WSTOPPED	0177

/* Caller may have status allocated as an integer if using Posix waitpid function. */
#define	WIFSTOPPED(x)	(((union wait *)&(x))->w_stopval == WSTOPPED)
#define	WIFSIGNALED(x)	(((union wait *)&(x))->w_stopval != WSTOPPED && ((union wait *)&(x))->w_termsig != 0)
#define	WIFEXITED(x)	(((union wait *)&(x))->w_stopval != WSTOPPED && ((union wait *)&(x))->w_termsig == 0)

#define	WSTOPSIG(x)	(((union wait *)&(x))->w_stopsig)
#define	WTERMSIG(x)	(((union wait *)&(x))->w_termsig)
#define	WEXITSTATUS(x)	(((union wait *)&(x))->w_retcode)

struct	rusage
{
	int	ru_dummy;
};

extern	short	wait __TKPROTO((union wait *));
extern	short	wait3 __TKPROTO((union wait *, int, struct rusage *));
extern	short	waitpid __TKPROTO((int, long *, int));

#define	WNOHANG		1
#define	WUNTRACED	2

#endif
