
#ifndef _FUNCHOOK_H_
#define _FUNCHOOK_H_

 /*--------------------------------------------------------------------------*/
 /*                 PRUDENS INC (c) 1994-1996                                */
 /*                 STREAMWOOD, ILLINOIS 60107  USA                          */
 /*                 ALL RIGHTS RESERVED.                                     */
 /*                 Class: FuncHook                                          */
 /*--------------------------------------------------------------------------*/

 //
 //
 //   File :    FUNCHOOK.H
 //
 //   Purpose : This file provides generic function hook manager.
 //
 //


    /* Class: FuncHook */


/*---------------------------------------------------------------------------*/
/*                            Error Codes                                    */
/*---------------------------------------------------------------------------*/
#define FUNCHOOK_ERR_NONE                       0

#define FUNCHOOK_ERR_LOADLIBRARY                -101
#define FUNCHOOK_ERR_INIT                       -102
#define FUNCHOOK_ERR_GETPROCADDR                -111
#define FUNCHOOK_ERR_NOTHOOKED                  -121
#define FUNCHOOK_ERR_NOTFOUND                   -131
#define FUNCHOOK_ERR_INVALIDCOMMAND             -141
#define FUNCHOOK_ERR_INVALIDPARAMETER           -142
#define FUNCHOOK_ERR_WITHINCALLBACK             -146
#define FUNCHOOK_ERR_UNKNOWNFUNCTYPE            -151
#define FUNCHOOK_ERR_MEMORYALLOCATION           -161
#define FUNCHOOK_ERR_LOCK                       -162
#define FUNCHOOK_ERR_UNLOCK                     -163



/*---------------------------------------------------------------------------*/
/*                           Command Values                                  */
/*---------------------------------------------------------------------------*/
   // Constants for FuncHookSetInfo/FuncHookGetInfo
#define FUNCHOOK_CMD_HTASK                      101
#define FUNCHOOK_CMD_STATUS                     102
#define FUNCHOOK_CMD_LASTRESULT                 103
#define FUNCHOOK_CMD_PROCESS                    104
#define FUNCHOOK_CMD_PROCESSID                  105
#define FUNCHOOK_CMD_THREAD                     106
#define FUNCHOOK_CMD_THREADID                   107
#define FUNCHOOK_CMD_USERDATA                   111
#define FUNCHOOK_CMD_CALLINGLEVEL               121
#define FUNCHOOK_CMD_CALLINGLEVELGET            122
#define FUNCHOOK_CMD_RTNADDRESS                 131


   // Constants for FuncHookConfigureHook
#define FUNCHOOK_CONFIG_EXITCOND                201
#define FUNCHOOK_CONFIG_MASK                    202
#define FUNCHOOK_CONFIG_RTNSIZE                 203
#define FUNCHOOK_CONFIG_SKIPCOND                204
#define FUNCHOOK_CONFIG_BEXITCOND               211
#define FUNCHOOK_CONFIG_BMASK                   212
#define FUNCHOOK_CONFIG_BRTNSIZE                213
#define FUNCHOOK_CONFIG_BSKIPCOND               214
#define FUNCHOOK_CONFIG_EXETRAK                 221
#define FUNCHOOK_CONFIG_DOIFISLAST              222
#define FUNCHOOK_CONFIG_BYTESSAVED              231
#define FUNCHOOK_CONFIG_SAVEREG                 232
#define FUNCHOOK_CONFIG_PAROFFSET               233
#define FUNCHOOK_CONFIG_SWITCHDWORD             234

#define FUNCHOOK_REGSAVE_ES                     0x00000001L

   // Flag to force the uninstallation of the hook
#define FUNCHOOK_FLAG_FORCEUNINSTALL            0x80000000L

   // Condition code
#define FUNCHOOK_COND_NONE                      0
#define FUNCHOOK_COND_STOP                      1
#define FUNCHOOK_COND_EQ                        2
#define FUNCHOOK_COND_NE                        3
#define FUNCHOOK_COND_GT                        4
#define FUNCHOOK_COND_LT                        5
#define FUNCHOOK_COND_GE                        6
#define FUNCHOOK_COND_LE                        7


   // MASK code
#define FUNCHOOK_MASK_NONE                      0
#define FUNCHOOK_MASK_AND                       1
#define FUNCHOOK_MASK_OR                        2
#define FUNCHOOK_MASK_XOR                       3


   // RTN size
#define FUNCHOOK_RTNSIZE_NONE                   0
#define FUNCHOOK_RTNSIZE_0                      0
#define FUNCHOOK_RTNSIZE_1                      1
#define FUNCHOOK_RTNSIZE_2                      2
#define FUNCHOOK_RTNSIZE_4                      4

   // Special EXE/DLL/DRV hook types
#define FUNCHOOK_HOOKTYPE_NONE                  0
#define FUNCHOOK_HOOKTYPE_1                     1


   // Status code
#define FUNCHOOK_STATUS_LAST                    0x8000
#define FUNCHOOK_STATUS_MASK                    0x00FF


#define FUNCHOOK_STATUS_DOIT                    0x0000
#define FUNCHOOK_STATUS_TRYAGAIN                0x0001
#define FUNCHOOK_STATUS_SKIP                    0x0002
#define FUNCHOOK_STATUS_OK                      0x0003
#define FUNCHOOK_STATUS_FAIL                    0x0004
#define FUNCHOOK_STATUS_NOCALL                  0x0005


#define FUNCHOOK_STATUS_NOTDONE                 0x0100


#define FUNCHOOK_LOC_NORMAL                     0x0000
#define FUNCHOOK_LOC_FIRST                      0x0001
#define FUNCHOOK_LOC_LAST                       0x0002
#define FUNCHOOK_LOC_FIRSTMUST                  0x8001
#define FUNCHOOK_LOC_LASTMUST                   0x8002


/*---------------------------------------------------------------------------*/
/*                               A P I s                                     */
/*---------------------------------------------------------------------------*/
LONG WINAPI _export FuncHookVersion ( void );

LONG WINAPI _export FuncHookInstallHook
                    ( FARPROC     pfnHooked,
                      FARPROC     pfnHook,
                      INT         nStackCt,
                      BOOL        bLast );

LONG WINAPI _export FuncHookInstallHookEx
                    ( LPSTR       lpszModName,
                      LPSTR       lpszFuncName,
                      FARPROC     pfnHook,
                      INT         nStackCt,
                      BOOL        bLast );

BOOL WINAPI _export FuncHookConfigureHook
                    ( LONG lHookId,
                      INT  nConfigCmd,
                      LONG lConfigData,
                      LONG lConfig );

BOOL WINAPI _export FuncHookUnInstallHook (LONG lHookId);
BOOL WINAPI _export FuncHookDisable       (LONG lHookId, BOOL bDisable);

INT  WINAPI _export FuncHookGetErrorCode  (void);
LONG WINAPI _export FuncHookGetInfo       (INT nCmd, LONG lPar);
LONG WINAPI _export FuncHookSetInfo       (INT nCmd, LONG lPar, LONG lValue);

LONG WINAPI _export FuncHookGetFirst   (FARPROC lpfnHooked);
LONG WINAPI _export FuncHookGetNext    (FARPROC lpfnHooked);
LONG WINAPI _export FuncHookGetFirstEx (LPSTR lpszModName, LPSTR lpszFuncName);
LONG WINAPI _export FuncHookGetNextEx  (LPSTR lpszModName, LPSTR lpszFuncName);
LONG WINAPI _export FuncHookGetHookInfo (LONG lHookId, PVOID pData);

INT  WINAPI _export FuncHookUnlockDeletion ( INT );
LONG WINAPI _export FuncHookCBEnable ( BOOL bEnable );

INT  WINAPI FuncHookType ( LPSTR pszData );
BOOL WINAPI FuncHookValidHook ( PFN pfnFunction );

#endif

