
#ifndef _GDH_H_
#define _GDH_H_

 /**------------------------------------------------------------------------**/
 /**------------------------------------------------------------------------**/
 /**-               PRUDENS INC (c) 1994-1995                              -**/
 /**-               STREAMWOOD, ILLINOIS 60107  USA                        -**/
 /**-               ALL RIGHTS RESERVED.                                   -**/
 /**-               Class: GDH (Global Definition Header)                  -**/
 /**------------------------------------------------------------------------**/
 /**------------------------------------------------------------------------**/

 //
 //
 //   File :    GDH.H
 //
 //   Purpose : This file defines types, constants, etc. used in all the
 //                  projects.
 //



/*---------------------------------------------------------------------------*/
/* How to enable these constant definitions:                                 */
/*                                                                           */
/* 1. If compiling for Windows 3.x (16 bits), enable only                    */
/*       _WIN_, _WIN16_                                                      */
/*                                                                           */
/* 2. If compiling for Windows 95 (32 bits),  enable only                    */
/*       _WIN_, _WIN32_, _WIN95_                                             */
/*                                                                           */
/* 3. If compiling for Windows NT (32 bits),  enable only                    */
/*       _WIN_, _WIN32_, _WINNT_                                             */
/*                                                                           */
/* 4. If compiling for OS/2 2.x (32 bits),    enable only                    */
/*       _OS2_                                                               */
/*                                                                           */
/*---------------------------------------------------------------------------*/


#ifdef _OS2_
#else
#define _WIN_
#define _WIN_PF
#endif

#ifdef _WIN_
#include <windows.h>
#endif


#ifdef _OS2_
#else

#if defined(NT)
#define _WIN32_
#define _WINNT_
#define _export
#elif defined(W95)
#define _WIN32_
#define _WIN95_
#define _export
#elif defined(W32)
#define _WIN32_
#define _WIN95_
#define _WINNT_
#define _export
#else
#define _WIN16_
#endif

#endif


#ifdef _WIN_

#ifndef INT
#define INT                             int
#endif

typedef unsigned long                   ULONG;
typedef ULONG far *                     PULONG;
typedef void far *                      PVOID;
typedef FARPROC                         PFN;

#ifdef _WIN16_
#define DEF_PHUGE
typedef unsigned long huge *            PHULONG;
typedef char huge *                     PHUGE;
typedef PHUGE FAR *                     PPHUGE;
#endif

typedef LPSTR                           PSZ;
typedef LPSTR FAR *                     PLPSTR;
typedef LPSTR FAR *                     PPSZ;

typedef char                            CHAR;
typedef short                           SHORT;
typedef unsigned short                  USHORT;
typedef unsigned short FAR *            PUSHORT;
typedef unsigned int                    UINT;
typedef UINT FAR *                      PUINT;


#define HIUSHORT(l)                     ((USHORT)(((ULONG)(l) >> 16) & 0xFFFF))
#define LOUSHORT(l)                     ((USHORT)(l))

#define PLONG                           LPLONG
#define PINT                            LPINT

#ifdef _WIN16_
typedef CHAR NEAR * NPSZ;
#endif

#ifdef _WIN32_
typedef USHORT NPSZ;
#define HUGE
#define huge
#endif

#endif

#ifdef _DOS_

#define _LPSTR_
#define _wsprintf sprintf

#else

#define _LPSTR_  (LPSTR)
#define _wsprintf wsprintf

#endif

#endif

