
#include "gdh.h"
#include "funchook.h"
#include "proc.h"
#include "tskdll95.h"


#define TSKDLL_BUFSIZE          1024

HWND    hDialogBox       = (HWND) 0;

LONG    lCreateProcess = 0L;
LONG    lExitProcess   = 0L;


BOOL WINAPI TskDLLHookSet ( HWND hDlg )
{
    HINSTANCE   hDLL;
    HINSTANCE   hKrnl;
    FARPROC     pfnSrc, pfnHook;

    hDLL  = GetModuleHandle ( "TSKDLL95" );
    hKrnl = GetModuleHandle ( "KERNEL32" );

    // Setup hook for CreateProcess
    pfnHook = GetProcAddress ( hDLL,  "TskDLLCreateProcess" );
    pfnSrc  = GetProcAddress ( hKrnl, "CreateProcessA" );
    if ( !( lCreateProcess =
         FuncHookInstallHook ( pfnSrc, pfnHook, 40, TRUE ) ) )
    {
       return FALSE;
    }

    FuncHookConfigureHook ( lCreateProcess, FUNCHOOK_CONFIG_RTNSIZE , 0L, 4 );
    FuncHookConfigureHook ( lCreateProcess, FUNCHOOK_CONFIG_BRTNSIZE, 0L, 4 );

    // Setup hook for ExitProcess
    pfnHook = GetProcAddress ( hDLL,  "TskDLLExitProcess" );
    pfnSrc  = GetProcAddress ( hKrnl, "ExitProcess" );
    if ( !( lExitProcess =
         FuncHookInstallHook ( pfnSrc, pfnHook, 4, TRUE ) ) )
    {
       FuncHookUnInstallHook ( lCreateProcess );
       lCreateProcess = 0L;
       return FALSE;
    }

    FuncHookConfigureHook ( lExitProcess, FUNCHOOK_CONFIG_EXITCOND , 0L, FUNCHOOK_COND_STOP );
    FuncHookConfigureHook ( lExitProcess, FUNCHOOK_CONFIG_BEXITCOND, 0L, FUNCHOOK_COND_STOP );

    // Store window handle of the listbox for later referencing
    hDialogBox = hDlg;

    return TRUE;
}


BOOL WINAPI TskDLLHookRemove ( VOID )
{
    FuncHookUnInstallHook ( lCreateProcess );
    FuncHookUnInstallHook ( lExitProcess );

    lCreateProcess = 0L;
    lExitProcess   = 0L;

    return TRUE;
}


#define TSKDLL_NUMBUF           10
CHAR    szStringBuf [TSKDLL_NUMBUF][1024];
INT     nNextBuf = 0;

LPSTR WINAPI TskDLLBufNext ( VOID )
{
    nNextBuf = (nNextBuf + 1) % TSKDLL_NUMBUF;
    return (LPSTR) &szStringBuf [nNextBuf] [0];
}


BOOL WINAPI _export TskDLLCreateProcess ( LPCTSTR               lpApp,
                                          LPTSTR                lpCmd,
                                          LPSECURITY_ATTRIBUTES lpPAttri,
                                          LPSECURITY_ATTRIBUTES lpTAttri,
                                          BOOL                  bInherit,
                                          DWORD                 dwCreation,
                                          LPVOID                lpEnv,
                                          LPCTSTR               lpCurDir,
                                          LPSTARTUPINFO         lpStartupInfo,
                                          LPPROCESS_INFORMATION lpPInfo )
{
    INT         nStatus, nStatus1;
    BOOL        bRet;
    ULONG       ulProcess, ulThread;
    LPSTR       pszBuf = TskDLLBufNext ();

    // Retrieve and separate last-flag and status code, no need on last-flag
    nStatus1 = (INT) FuncHookGetInfo ( FUNCHOOK_CMD_STATUS, lCreateProcess );
    nStatus  = nStatus1 & FUNCHOOK_STATUS_MASK;

    // Retrieve process/thread information
    ulProcess = (ULONG)  FuncHookGetInfo ( FUNCHOOK_CMD_PROCESSID, lCreateProcess );
    ulThread  = (ULONG)  FuncHookGetInfo ( FUNCHOOK_CMD_THREADID , lCreateProcess );

    if ( IsWindow (hDialogBox) )
    {
       // Construct output string
       wsprintf ( pszBuf, "CreateProcess %08lX ", (LONG) ulThread );
       ProcProcessName ( ulProcess, &pszBuf [23] );

       // Setup parameter info
       if ( IsBadReadPtr ( lpApp, 1 ) )
            wsprintf ( pszBuf, "%s, #%08lX", (LPSTR) pszBuf, (ULONG) lpApp );
       else wsprintf ( pszBuf, "%s, %s", (LPSTR) pszBuf, (LPSTR) lpApp );
       if ( IsBadReadPtr ( lpCmd, 1 ) )
            wsprintf ( pszBuf, "%s, #%08lX", (LPSTR) pszBuf, (ULONG) lpCmd );
       else wsprintf ( pszBuf, "%s, %s", (LPSTR) pszBuf, (LPSTR) lpCmd );

       // Tell dialogbox to add the string to the listbox
       PostMessage ( hDialogBox, WMUSER_ADDSTRING, 0, (LPARAM) (LPSTR) pszBuf );
    }

    // Call actual LoadModule if no one has or has sucessfully called it
    if ( nStatus == FUNCHOOK_STATUS_DOIT )
         bRet  = CreateProcess ( lpApp, lpCmd, lpPAttri, lpTAttri, bInherit,
                                 dwCreation, lpEnv, lpCurDir,
                                 lpStartupInfo, lpPInfo );
    else bRet = (UINT) FuncHookGetInfo ( FUNCHOOK_CMD_LASTRESULT, lCreateProcess );

    return bRet;
}


VOID WINAPI _export TskDLLExitProcess ( UINT uExitCode )
{
    INT         nLast, nStatus, nStatus1;
    ULONG       ulProcess, ulThread;
    LPSTR       pszBuf = TskDLLBufNext ();

    // Retrieve and separate last-flag and status code, no need on last-flag
    nStatus1 = (INT) FuncHookGetInfo ( FUNCHOOK_CMD_STATUS, lExitProcess );
    nStatus  = nStatus1 & FUNCHOOK_STATUS_MASK;
    nLast    = nStatus1 & FUNCHOOK_STATUS_LAST;

    // Retrieve process/thread information
    ulProcess = (ULONG)  FuncHookGetInfo ( FUNCHOOK_CMD_PROCESSID, lExitProcess  );
    ulThread  = (ULONG)  FuncHookGetInfo ( FUNCHOOK_CMD_THREADID , lExitProcess  );

    if ( IsWindow (hDialogBox) )
    {
       // Construct output string
       wsprintf ( pszBuf, "ExitProcess %08lX %08lX", (LONG) ulThread );
       ProcProcessName ( ulProcess, &pszBuf [21] );
       wsprintf ( pszBuf, "%s %08lX", (LPSTR) pszBuf, (LONG) uExitCode );

       // Tell dialogbox to add the string to the listbox
       PostMessage ( hDialogBox, WMUSER_ADDSTRING, 0, (LPARAM) (LPSTR) pszBuf );
    }

    // Call actual LoadModule if no one has or has sucessfully called it
    if (nStatus != FUNCHOOK_STATUS_SKIP)
    {
       // Call actual API unless I am the last one in the chain
       if (nLast)
       {
          FuncHookUnlockDeletion ( 1 );
          ExitProcess ( uExitCode );
       }
       else
          // Notify FuncHook that no call to actual API
          nStatus = (INT) FuncHookSetInfo
                 ( FUNCHOOK_CMD_STATUS, lExitProcess, FUNCHOOK_STATUS_NOTDONE );
    }
}


/*---------------------------------------------------------------------------*/
/*                                                                           */
/* Class :  TskDLL                                                           */
/*                                                                           */
/* Name  :  DllMain                                                          */
/*                                                                           */
/* Desp  :  Entry of the DLL                                                 */
/*                                                                           */
/* Misc  :  Public/Visible entry                                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
BOOL WINAPI DllMain ( HANDLE hDLL, DWORD dwReason, LPVOID lpReserved )
{
   switch (dwReason)
   {
      case DLL_PROCESS_ATTACH:
           break;

      case DLL_THREAD_ATTACH:
           break;

      case DLL_THREAD_DETACH:
           break;

      case DLL_PROCESS_DETACH:
           break;
   }

   return TRUE;
}




