
#include "gdh.h"
#include "funchook.h"

#include "tskdll95.h"
#include "tskmon95.h"

BOOL WINAPI TskMonDlgProc ( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );

int PASCAL WinMain ( HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmd, INT nCmd )
{
    if ( FindWindow ( "TaskMonitor95", NULL ) )
    {
       MessageBox ( GetDesktopWindow (),
                    "Task Monitor does not allow multiple instance.",
                    "ERROR",
                    MB_ICONSTOP | MB_OK );
    }
    else
    {
       FARPROC  pfnDlgProc;

       pfnDlgProc = MakeProcInstance ( (FARPROC) TskMonDlgProc, hInst );
       DialogBox ( hInst, "TSKDIALOG", GetDesktopWindow (), pfnDlgProc );
    }

    return 0;
}


BOOL WINAPI TskMonDlgProc ( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
    switch ( uMsg )
    {
       case WM_INITDIALOG:
            if ( !TskDLLHookSet ( hDlg ) )
            {
               MessageBox ( GetDesktopWindow (),
                            "Unable to establish SYSTEM-wide hook.\n\n"
                            "Make sure you are not running any SPY programs\n"
                            "that causes conclict."
                            "\n\n",
                            "ERROR",
                            MB_ICONSTOP | MB_OK );
               EndDialog ( hDlg, 1 );
            }
            break;

       case WM_COMMAND:
            switch ( wParam )
            {
               case IDOK:
                    EndDialog ( hDlg, 1 );
                    return TRUE;

               case IDC_CLEAR:
                    SendDlgItemMessage ( hDlg, IDC_LISTBOX,
                                         LB_RESETCONTENT, 0, 0L );
                    return TRUE;
            }
            return FALSE;

       case WMUSER_ADDSTRING:
            SendDlgItemMessage ( hDlg, IDC_LISTBOX, LB_ADDSTRING, 0, lParam );
            break;

       case WM_DESTROY:
            TskDLLHookRemove ();
       default:
            return FALSE;

    }

    return TRUE;
}


