
# Nmake macros for building Windows 32-Bit apps

NODEBUG = 1

TARGETOS=WIN95
APPVER=4.0

!include <ntwin32.mak>

PRUDENSLIBS = FH95LITE.LIB

cflags=$(cflags) -DDEVL=1

!if "$(NODEBUG)" == "1"
cdebug      = -Od
!endif


PROJDLL      = TSKDLL95
PROJ         = TSKMON95

OBJS11 = TSKMON95.95O
OBJS21 = TSKDLL95.95B

.c.95O  :
         $(cc) -DW95 $(cdebug) -Od -Zp1 $(cflags) $(cvars) -Fo$*.95O $*.c

.c.95b :
         $(cc) -DW95 -Od -Zp1 $(cdebug) $(cflags) $(cvarsdll) -Fo$*.95B $*.c


all: $(PROJDLL).LIB $(PROJDLL).DLL $(PROJ).EXE


# Update the resource if necessary

$(PROJ).RRR : $(PROJ).RC
              $(rc) $(rcvars) -Fo$(PROJ).RRR -r $(PROJ).rc


# Update the object files if necessary

$(PROJ).95O     : $(PROJ).95B
$(PROJDLL).95B  : $(PROJDLL).C


$(PROJDLL).LIB    : $(OBJS21) $(PROJDLL).DEF
                    $(implib)                  \
                    -machine:$(CPU)            \
                    -def:$(PROJDLL).DEF        \
                    -out:$(PROJDLL).LIB        \
                    $(OBJS21) $(PRUDENSLIBS)


guilibs= libcmt.lib oldnames.lib kernel32.lib advapi32.lib user32.lib gdi32.lib

$(PROJDLL).DLL    : $(OBJS21)  $(PROJDLL).DEF
                    $(link)                    \
                    $(linkdebug) $(dlllflags)  \
                    -map:$(PROJDLL).MAP        \
                    -base:0xBFF70000           \
                    -out:$(PROJDLL).DLL        \
                    -def:$(PROJDLL).DEF        \
                    -subsystem:windows         \
                    -map:$(PROJDLL).MAP        \
                    -NODEFAULTLIB              \
                    $(OBJS21) $(guilibs) $(PRUDENSLIBS)


# Update the executable file if necessary, and if so, add the resource back in.

$(PROJ).EXE     : $(OBJS11) $(PROJ).RRR $(PROJDLL).LIB
                  $(link) $(linkdebug)  $(guiflags)     \
                   -out:$(PROJ).EXE                     \
                   -map:$(PROJ).MAP                     \
                   -base:0x00400000                     \
                   -subsystem:windows                   \
                   $(OBJS11) $(PROJDLL).LIB             \
                   $(PROJ).RRR                          \
                   $(guilibsmt)

