unit taskmon0;

// This Delphi 2.0 application can be compiled without any special procedures.
// Note that this is Delphi 2.0 code (not Delphi 1.0)
// and that the hook code works only under Windows 95.
// See the companion project, TASKDLL.DPR, for sample code illustrating
// how to hook virtually any Win32 API.
//
// This sample code is provided as-is with no warranties regarding its
// correctness or suitability to task.  Its sole purpose is to demonstrate
// one way to hook Win32 API's.  You may freely modify the sample.  See the
// file PRUDENS.TXT for information on how to remove the initial dialogbox.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

{$I TASKMONI.PAS} // Declarations common to the main program and DLL.

type
  TMainForm = class(TForm)
    AlarmCheckBox: TCheckBox;
    TaskListBox: TListBox;
    CreateProcessLabel: TLabel;
    ExitProcessLabel: TLabel;
    StartButton: TButton;
    CloseBitBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AlarmCheckBoxClick(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
    procedure CloseBitBtnClick(Sender: TObject);
  private
    HooksInstalled: Boolean;
  public
    procedure MessageWM_REFRESHMSG (var Message: TMsg); message WM_REFRESHMSG;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

// Exported functions from TASKDLL.DLL - implicit links.
function
  InitTaskDLL: Boolean;
    stdcall; external 'TASKDLL.DLL';
function
  InstallHookCreateProcess: Boolean;
    stdcall; external 'TASKDLL.DLL';
function
  InstallHookExitProcess: Boolean;
    stdcall; external 'TASKDLL.DLL';
function
  UninstallHooks: Boolean;
    stdcall; external 'TASKDLL.DLL';
function
  GetItemInLog
    (FirstItem: Boolean): PLogInfo;
      stdcall; external 'TASKDLL.DLL';
function
  SetAlarm
    (SetTheAlarm: Boolean): Boolean;
      stdcall; external 'TASKDLL.DLL';

procedure
  TMainForm.FormCreate
    (Sender: TObject);
begin
  HooksInstalled := False;
  InitTaskDLL;
end; {TMainForm.FormCreate}

procedure
  TMainForm.FormDestroy
    (Sender: TObject);
begin
  // If any hooks have been installed, they MUST BE removed;
  // otherwise, dire things happen to your system!
  if HooksInstalled then
    UninstallHooks;
end; {TMainForm.FormDestroy}

procedure
  TMainForm.AlarmCheckBoxClick
    (Sender: TObject);
begin
  SetAlarm (AlarmCheckBox.Checked);
end; {TMainForm.AlarmCheckBoxClick}

procedure
  TMainForm.StartButtonClick
    (Sender: TObject);
const
  InfoFormat = '%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x';
var
  LibraryHandle: THandle;
  FunctionAddr: Pointer;
  Hook1, Hook2: Boolean;
  Function1st11Bytes: array [0 .. 11] of Byte;
// InstallHookCreateProcess and InstallHookExitProcess can, of course, be
// done at form creation, or, as here, placed under user control.
//
// There is some error checking performed here in case the version of
// Windows 95 does not match the pattern FH95 expects.
begin
  if not HooksInstalled then begin
    Hook1 := InstallHookCreateProcess;
    if not Hook1 then begin
      LibraryHandle := LoadLibrary ('KERNEL32.DLL');
      FunctionAddr := GetProcAddress (LibraryHandle, 'CreateProcessA');
      CopyMemory (@Function1st11Bytes, FunctionAddr, 11);
      CreateProcessLabel.Caption :=
        Format (InfoFormat,
                [Function1st11Bytes [00],
                 Function1st11Bytes [01],
                 Function1st11Bytes [02],
                 Function1st11Bytes [03],
                 Function1st11Bytes [04],
                 Function1st11Bytes [05],
                 Function1st11Bytes [06],
                 Function1st11Bytes [07],
                 Function1st11Bytes [08],
                 Function1st11Bytes [09],
                 Function1st11Bytes [10]]);
      FreeLibrary (LibraryHandle);
    end;
    Hook2 := InstallHookExitProcess;
    if not Hook2 then begin
      LibraryHandle := LoadLibrary ('KERNEL32.DLL');
      FunctionAddr := GetProcAddress (LibraryHandle, 'ExitProcess');
      CopyMemory (@Function1st11Bytes, FunctionAddr, 11);
      ExitProcessLabel.Caption :=
        Format (InfoFormat,
                [Function1st11Bytes [00],
                 Function1st11Bytes [01],
                 Function1st11Bytes [02],
                 Function1st11Bytes [03],
                 Function1st11Bytes [04],
                 Function1st11Bytes [05],
                 Function1st11Bytes [06],
                 Function1st11Bytes [07],
                 Function1st11Bytes [08],
                 Function1st11Bytes [09],
                 Function1st11Bytes [10]]);
      FreeLibrary (LibraryHandle);
    end;
    if Hook1 or Hook2 then
      HooksInstalled := True;
    if HooksInstalled then
      StartButton.Caption := 'Stop Monitor';
  end
  else begin
    HooksInstalled := not UninstallHooks;
    if not HooksInstalled then
      StartButton.Caption := 'Start Monitor';
  end;
end; {TMainForm.StartButtonClick}

procedure
  TMainForm.CloseBitBtnClick
    (Sender: TObject);
begin
  Close;
end; {TMainForm.CloseBitBtnClick}

procedure
  TMainForm.MessageWM_REFRESHMSG
    (var Message: TMsg);
// In general, it is best to perform any prolonged or unnecessary processing
// (like special formatting of the output) at a time outside the callback.
// The callbacks will SendMessage WM_REFRESHMSG to the main window notifying
// it of new tasks that have been started or ended.
var
  LogInfoP: PLogInfo;
  AnApplication: String;
begin
  TaskListBox.Items.Clear;
  LogInfoP := GetItemInLog (True);
  while LogInfoP <> Nil do begin
    with LogInfoP^ do begin
      AnApplication := StrPas (Application);
      case HookType of
        CREATINGPROCESS:
          begin
            AnApplication := Copy (AnApplication, 2, Length (AnApplication) - 3);
            AnApplication := ExtractFileName (AnApplication);
            TaskListBox.Items.Add (Format ('(%.8x) %s is starting',
                                            [ProcessID,
                                             UpperCase (AnApplication)]));
          end;
        EXITINGPROCESS:
          TaskListBox.Items.Add (Format ('(%.8x) %s is ending',
                                         [ProcessID,
                                          UpperCase (AnApplication)]));
      end;
    end;
    LogInfoP := GetItemInLog (False);
  end;
end; {TMainForm.MessageWM_REFRESHMSG}

end. {taskmon0}
