//---------------------------------------------------------------------------
#pragma warn -dup
#pragma warn -sig
#include <vcl\vcl.h>
#include <vcl\inifiles.hpp>
#pragma hdrstop

#include "smtpmain.h"
#include "smtpsu.h"
//---------------------------------------------------------------------------
#pragma link "Smtp"
#pragma link "mailbase"
#pragma resource "*.dfm"
TMailForm *MailForm;
//---------------------------------------------------------------------------
__fastcall TMailForm::TMailForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::EnableControls(void)
{
  TSpeedButton *SB;
  int i;
  for (i=0; i==ToolBar->ControlCount; i++)
  {
    SB=(TSpeedButton *)ToolBar->Controls[i];
    SB->Enabled=SB->Tag != 1;
  }
  SendInfoPanel->Enabled=true;
  ProgressBar1->Visible=false;
  BodyMemo->Enabled=true;
  Cursor=crDefault;
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::DisableControls(void)
{
  TSpeedButton *SB;
  int i;
  for (i=0; i==ToolBar->ControlCount; i++)
  {
    SB=(TSpeedButton *)ToolBar->Controls[i];
    SB->Enabled=SB->Tag == 1;
  }
  SendInfoPanel->Enabled=false;
  ProgressBar1->Visible=true;
  BodyMemo->Enabled=false;
  Cursor=crHourGlass;
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::FormCreate(TObject *Sender)
{
  IniFileName=ChangeFileExt(Application->ExeName,".INI");
  TIniFile *IniFile=new TIniFile(IniFileName);
  SMTP1->Server=IniFile->ReadString("Setup","Server","");
  SMTP1->From=IniFile->ReadString("Setup","Sender","");
  SMTP1->LogFileName=IniFile->ReadString("Setup","Log File","");
  SMTP1->CharSet=(TCharSet)IniFile->ReadInteger("Setup","CharSet",0);
  SMTP1->Encoding=(TEncoding)IniFile->ReadInteger("Setup","Encoding",0);
  delete IniFile;
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  TIniFile *IniFile=new TIniFile(IniFileName);
  IniFile->WriteString("Setup","Server",SMTP1->Server);
  IniFile->WriteString("Setup","Sender",SMTP1->From);
  IniFile->WriteString("Setup","Log File",SMTP1->LogFileName);
  IniFile->WriteInteger("Setup","CharSet",(int)SMTP1->CharSet);
  IniFile->WriteInteger("Setup","Encoding",(int)SMTP1->Encoding);
  delete IniFile;
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::SetupButtonClick(TObject *Sender)
{
  SetupDlg=new TSetupDlg(this);
  try
  {
   SetupDlg->ServerEdit->Text=SMTP1->Server;
   SetupDlg->UserAddressEdit->Text=SMTP1->From;
   SetupDlg->LogFileNameEdit->Text=SMTP1->LogFileName;
   SetupDlg->CharSetComboBox->ItemIndex=(int)SMTP1->CharSet;
   SetupDlg->EncodeComboBox->ItemIndex=(int)SMTP1->Encoding;
   SetupDlg->ShowModal();
   if (SetupDlg->ModalResult==mrOk)
   {
     SMTP1->Server=SetupDlg->ServerEdit->Text;
     SMTP1->From=SetupDlg->UserAddressEdit->Text;
     SMTP1->LogFileName=SetupDlg->LogFileNameEdit->Text;
     SMTP1->CharSet=(TCharSet)SetupDlg->CharSetComboBox->ItemIndex;
     SMTP1->Encoding=(TEncoding)SetupDlg->EncodeComboBox->ItemIndex;
   }
   delete SetupDlg;
  }
  catch(...)
  {
   delete SetupDlg;
   throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::ExitButtonClick(TObject *Sender)
{
  Close();	
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::AttachButtonClick(TObject *Sender)
{
  if (OpenDialog1->Execute())
  {
    AttachmentsComboBox->Items->Assign(OpenDialog1->Files);
    AttachmentsComboBox->ItemIndex=0;
  }
  else
    AttachmentsComboBox->Items->Clear();
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::CancelButtonClick(TObject *Sender)
{
 SMTP1->Cancel();
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::SendButtonClick(TObject *Sender)
{
 if ((SMTP1->Server.Length()==0)
     | (SMTP1->From.Length()==0) | (ToEdit->Text.Length()==0))
 {
   MessageDlg("Please enter required data first",
               mtError,TMsgDlgButtons() << mbOK,0);
   return;
 }
 SMTP1->Recipient=ToEdit->Text;
 SMTP1->Subject=SubjectEdit->Text;
 SMTP1->Body=BodyMemo->Lines;
 SMTP1->Attachments=AttachmentsComboBox->Items;
 DisableControls();
 try
 {
   SMTP1->SendSingleMessage();
   EnableControls();
 }
 catch(...)
 {
   EnableControls();
   throw;
 }
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::SMTP1StatusChange(TObject *Sender)
{
  AnsiString s;
  switch (SMTP1->Status)
  {
  case msIdle :
    s="";
    break;
  case msLogIn :
    s="Logging In";
    break;
  case msLogOut :
    s="Logging Out";
    break;
  case msHeaders :
    s="Sending headers";
    break;
  case msEnvelope :
    s="Sending commands";
    break;
  case msBody :
    s="Sending message body";
    break;
  case msAttachment :
    s="Sending attachment(s)";
    break;
  case msCancel :
    s="Canceled";
    break;
  case msEnCode :
    s="Encoding the attachment(s)";
    break;
  case msConnecting :
    s="Connecting to Server";
  }
  StatusBar1->Panels->Items[0]->Text=s;
}
//---------------------------------------------------------------------------
void __fastcall TMailForm::SMTP1Progress(TObject *Sender)
{
  ProgressBar1->Position=SMTP1->Progress;
}
//---------------------------------------------------------------------------
