#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like as long as you don't try to sell it.
**
** Any attempt to sell WFC in source code form must have the permission
** of the original author. You can produce commercial executables with
** WFC but you can't sell WFC.
**
** Copyright, 1995, Samuel R. Blackburn
**
** $Workfile: $
** $Revision: $
** $Modtime: $
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#if defined( _DEBUG )
#define new DEBUG_NEW
#endif

/*
** CNetInformation stuff
*/

CNetworkInformation::CNetworkInformation()
{
   Empty();
}

CNetworkInformation::CNetworkInformation( const NETINFOSTRUCT *source )
{
   Empty();
   Copy( source );
}

CNetworkInformation::CNetworkInformation( const CNetworkInformation& source )
{
   Empty();
   Copy( source );
}

CNetworkInformation::~CNetworkInformation()
{
   Empty();
}

void CNetworkInformation::Copy( const NETINFOSTRUCT * source )
{
   ASSERT( source != NULL );

   if ( source == NULL )
   {
      Empty();
      return;
   }

   cbStructure       = source->cbStructure;
   dwProviderVersion = source->dwProviderVersion;
   dwStatus          = source->dwStatus;
   dwCharacteristics = source->dwCharacteristics;
   dwHandle          = source->dwHandle;
   wNetType          = source->wNetType;
   dwPrinters        = source->dwPrinters;
   dwDrives          = source->dwDrives;
}

void CNetworkInformation::Copy( const CNetworkInformation& source )
{
   Copy( (const NETINFOSTRUCT *) &source );
}

#if defined( _DEBUG )

void CNetworkInformation::Dump( CDumpContext& dump_context ) const
{
   dump_context << " a CNetworkInformation at " << (void *) this << "\n";
   dump_context << "{\n";
   dump_context << "   cbStructure       = " << cbStructure       << "\n";
   dump_context << "   dwProviderVersion = " << dwProviderVersion << "\n";
   dump_context << "   dwStatus          = " << dwStatus          << "\n";
   dump_context << "   dwCharacteristics = " << dwCharacteristics << "\n";
   dump_context << "   dwHandle          = " << dwHandle          << "\n";
   dump_context << "   wNetType          = " << wNetType          << "\n";
   dump_context << "   dwPrinters        = " << dwPrinters        << "\n";
   dump_context << "   dwDrives          = " << dwDrives          << "\n";
   dump_context << "}\n";
}

#endif // _DEBUG

void CNetworkInformation::Empty( void )
{
   cbStructure       = sizeof( NETINFOSTRUCT );
   dwProviderVersion = 0;
   dwStatus          = 0;
   dwCharacteristics = 0;
   dwHandle          = 0;
   wNetType          = 0;
   dwPrinters        = 0;
   dwDrives          = 0;
}
