#include "test.h"
#pragma hdrstop

void test_CLZFile( LPTSTR lz_file_name )
{
   CLZFile lz_file;

   if ( lz_file_name == (LPTSTR) NULL )
   {
      return;
   }

   CString expanded_name;

   lz_file.GetExpandedName( lz_file_name, expanded_name );

   printf( "LZ File \"%s\" expanded name is \"%s\"\n", lz_file_name, (LPCTSTR) expanded_name );

   if ( lz_file.Open( lz_file_name ) == TRUE )
   {
      CLZFile output_file;

      if ( output_file.Open( "d:\\temp\\winhlp32.exe", OF_CREATE ) == TRUE )
      {
         if ( output_file.Copy( lz_file ) == TRUE )
         {
            printf( "Successfully copied\n" );
         }
         else
         {
            CString error_message_string;
            CLZFile::TranslateErrorCode( (int) lz_file.GetError(), error_message_string );
            printf( "Can't Copy because %s\n", (LPCTSTR) error_message_string );
         }
      }
      else
      {
         CString error_message_string;
         CLZFile::TranslateErrorCode( (int) output_file.GetError(), error_message_string );
         printf( "Can't open LZ output file because %s\n", (LPCTSTR) error_message_string );
      }
   }
   else
   {
      CString error_message_string;
      CLZFile::TranslateErrorCode( (int) lz_file.GetError(), error_message_string );
      printf( "Can't open LZ file \"%s\" because \n", lz_file_name, (LPCTSTR) error_message_string );
   }
}

