/*
**  WHO_S.C  [WHOIS Server]
*/

#include <windows.h>
#include <winsock.h>

#include "wil.h"
#include "message.h"
#include "paint.h"
#include "about.h"

#ifdef WIN32
#define USE_INS HINSTANCE
#define USE_PTR PSTR
#else
#define USE_INS HANDLE
#define USE_PTR LPSTR
#endif

LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);

#define FALSE 0
#define TRUE  1

#define ONE_SEC  1000
#define TEN_SEC 10000

/*  globals */

HWND hMainWnd;            /* main window handle */

#define LF        10
#define CR        13
#define MAX_BUF  128

#define WHOIS_PORT    5001

static HMENU hMenu;
static USE_INS hInstance;
static int WinWidth = 8 * NCOLS;
static int WinHeight = 12 * NROWS + 48;
static char Temp[MAX_BUF+8];
static char InBuffer[MAX_BUF+1];
static SOCKET ListenSock = 0;
static SOCKET DataSock = 0;
static LPSTR  HostPtr;
static ULONG  HostAddr = 0;

static int AcceptFlag = FALSE;

/* miscellaneous functions */

static void DisplayError(int Code, LPSTR Msg)
{DisplayString("ERROR: ");
 if(Msg) DisplayString(Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,50);
    DisplayLine((LPSTR)Temp);
   }
}

/* WinMain */

#ifdef WIN32
int WINAPI
#else
int PASCAL
#endif
WinMain(USE_INS hInst, USE_INS hPrevInstance,
        USE_PTR szCmdLine,  int nCmdShow)
{WNDCLASS  wc;
 MSG msg;
 BOOL Result;
 if(!hPrevInstance)
   {/* register main window class */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(hInst, "HostIcon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "HostMenu";
    wc.lpszClassName = "HostWClass";
    Result = RegisterClass(&wc);
    if(!Result) return FALSE;
   }
 /* create main window */
 hInstance = hInst;
 hMainWnd = CreateWindow(
        "HostWClass",   "WHOIS Server",    WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,  CW_USEDEFAULT,
        WinWidth,       WinHeight,
        NULL,           NULL,
        hInstance,      NULL);
 ShowWindow(hMainWnd, nCmdShow);
 UpdateWindow(hMainWnd);
 hMenu = GetMenu(hMainWnd);

 /* window control loop */

 while(GetMessage(&msg,NULL,0,0))
   {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
   }
 return (msg.wParam);
} /* end WinMain */

#ifdef WIN32
LRESULT CALLBACK
#else
long FAR PASCAL
#endif
MainWndProc(HWND hWindow,UINT iMsg,WPARAM wParam,LPARAM lParam)
{int Code;
 UINT idTimer;
 HDC hDC;
 PAINTSTRUCT ps;
#ifdef WIN32
#else
 static FARPROC lpfnAboutDlgProc;
#endif
 hMainWnd = hWindow;
 switch (iMsg)
    {case WM_CREATE:
#ifdef WIN32
#else
       /* create thunk for Win16 */
       lpfnAboutDlgProc = MakeProcInstance(AboutDlgProc,hInstance);
#endif
      /* initialize paint module */
      PaintInit();
      /* attach WINSOCK */
      DisplayString("Attaching WINSOCK...");
      Code = wilAttach();
      DisplayLine("OK");
      if(Code<0) DisplayError(Code,"wilAttach fails:");
      else
        {wsprintf((LPSTR)Temp," Description: %s", wilGetDescription() );
         DisplayLine((LPSTR)Temp);
         wsprintf((LPSTR)Temp," My HostName: %s", wilGetMyHostName() );
         DisplayLine((LPSTR)Temp);
         wsprintf((LPSTR)Temp," My HostAddr: %s", wilGetMyHostDotted(0) );
         DisplayLine((LPSTR)Temp);
        }
       /* start "accept" timer */
       idTimer = SetTimer(hMainWnd,1,1000,NULL);
       if(idTimer==0)
         {DisplayLine("ERROR: No timers remaining!");
         }
       break;

     case WM_COMMAND:
         switch(wParam)
           {
            case MSG_ABOUT :
#ifdef WIN32
               DialogBox(hInstance, "AboutBox", hMainWnd, AboutDlgProc);
#else
               DialogBox(hInstance, "AboutBox", hMainWnd, lpfnAboutDlgProc);
#endif
               return 0;

            case MSG_EXIT:
              wilRelease();
              DestroyWindow(hMainWnd);
              break;

            case MSG_DEBUG:
              Code = wilDebug(0);
              wsprintf((LPSTR)Temp,"Debug(0) returned %d",Code);
              DisplayLine((LPSTR)Temp);
              break;

            case MSG_WHOIS:

              DisplayLine("Starting WHOIS Server");
              /* get local host domain name */
              HostPtr = wilGetMyHostName();
              if(HostPtr==NULL)
                {DisplayError(0, "Cannot get host name");
                 break;
                }
              /* get host IP address */
              HostAddr = wilGetHostAddr(0);
              if(HostAddr==0)
                {DisplayError(0, "Cannot get IP addess");
                 break;
                }
              wsprintf((LPSTR)Temp,"HostAddr = %s\n", wilGetHostDotted(0));
              DisplayLine((LPSTR)Temp);
              /* create listener socket */
              ListenSock = wilTcpSocket();
              if((int)ListenSock<=0)
                {DisplayError((int)Code, "wilListen:");
                 break;
                }
              /* bind address & port number */
              Code = wilBind(ListenSock, HostAddr, WHOIS_PORT);
              if(Code<=0)
                {DisplayError((int)Code, "wilBind:");
                 break;
                }
              /* listen for incoming requests */
              Code = wilListen(ListenSock,1);
              if(Code<=0)
                {DisplayError(Code, NULL);
                 break;
                }
#if 1
              wsprintf((LPSTR)Temp,"ListenSock=%d HostAddr=%lx Port=%d",
                                   ListenSock, HostAddr, WHOIS_PORT);
              DisplayLine((LPSTR)Temp);
#endif
              DisplayLine("Listening...");
              AcceptFlag = TRUE;
              break;
           }
         break;

     case WM_TIMER:

       if(!AcceptFlag) break;
       DisplayChar('?');
       /* any incoming connection ? */
       if(!wilDataIsReady(ListenSock,0)) break;
       DisplayLine("Data incoming...");
       AcceptFlag = FALSE;
       /* accept the connection */
       DataSock = wilAccept(ListenSock,ONE_SEC);
       if((int)DataSock<=0)
         {DisplayError((int)Code, "Accept:");
          break;
         }
       wsprintf((LPSTR)Temp,"DataSock=%d",(int)DataSock);
       DisplayLine((LPSTR)Temp);
       DisplayLine("Connection is accepted");
       /* read socket */
       Code = wilReadString(DataSock,(LPSTR)InBuffer,MAX_BUF);
       wsprintf((LPSTR)Temp,"Whois [%s]", InBuffer);
       DisplayLine((LPSTR) Temp);
       /* formulate & send response */
       if(lstrcmpi(InBuffer,"Mike")==0)
         {wilWriteString(DataSock,"Mike Marshall <mike@marshallsoft.com>\r\n");
          wilCloseSocket(DataSock);
         }
       else if(lstrcmpi(InBuffer,"Pam")==0)
         {wilWriteString(DataSock,"Pam Marshall <pam@marshallsoft.com>\r\n");
          wilCloseSocket(DataSock);
         }
       else if(lstrcmpi(InBuffer,"Lauren")==0)
         {wilWriteString(DataSock,"Lauren Marshall <lauren@marshallsoft.com>\r\n");
          wilCloseSocket(DataSock);
         }
       else
         {wilWriteString(DataSock,"No such user");
          wilCloseSocket(DataSock);
         }
       /* ready for next request */
       AcceptFlag = TRUE;
       break;

    case WM_PAINT:
      HideCaret(hMainWnd);
      hDC = BeginPaint(hMainWnd, &ps);
      SetMapMode(hDC,MM_ANISOTROPIC);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      PaintMain(hDC,&ps);
      EndPaint(hMainWnd,&ps);
      SetCaretPos(PaintGetColPos(),PaintGetRowPos());
      ShowCaret(hMainWnd);
      break;

    case WM_DESTROY:
      PostQuitMessage(0);
      break;

    default:
      return (DefWindowProc(hMainWnd, iMsg, wParam, lParam));
   }
 return 0;

} /* end MainWndProc */                                                                        