/*  wil.h
**
**  Use for both Win16 & Win32.
*/

#ifdef WIN32
  #ifdef _MSC_VER
     #define DLLEXPORT __stdcall
  #else
     #define DLLEXPORT __stdcall _export
  #endif
#else
  #define DLLEXPORT FAR PASCAL
#endif

#ifdef __cplusplus
  #define NoMangle extern "C"
#else
  #define NoMangle
#endif

#define WIL_READ_STATUS       1
#define WIL_WRITE_STATUS      2
#define WIL_ERROR_STATUS      3

#define WIL_NO_ERROR          1

#define WIL_CANNOT_COMPLY     0
#define WIL_EOF              -1
#define WIL_ALREADY_IN_USE   -2
#define WIL_NOT_IN_USE       -3
#define WIL_IS_BLOCKING      -4
#define WIL_BAD_STATUS_FLAG  -5
#define WIL_BAD_DOTTED       -6
#define WIL_INVALID_SOCKET   -7
#define WIL_TIMED_OUT        -8
#define WIL_NO_SOCK_ADDR     -9
#define WIL_NO_PROTOCOL     -10
#define WIL_NO_SERVICE      -11
#define WIL_NO_HOST         -12
#define WIL_EXPIRED         -13
#define WIL_ABORTED         -14

#define BYTE  unsigned char
#define WORD  unsigned int
#define ULONG unsigned long

NoMangle LPSTR DLLEXPORT  wilGetMyHostName(void);
NoMangle LPSTR DLLEXPORT  wilGetMyHostDotted(int);
NoMangle ULONG DLLEXPORT  wilGetMyHostAddr(int);
NoMangle int DLLEXPORT    wilIsDotted(LPSTR);
NoMangle int DLLEXPORT    wilIsBlocking(void);
NoMangle int DLLEXPORT    wilIsConnected(SOCKET,ULONG);
NoMangle int DLLEXPORT    wilDataIsReady(SOCKET,ULONG);
NoMangle int DLLEXPORT    wilAttach(void);
NoMangle int DLLEXPORT    wilCancelBlocking(void);
NoMangle int DLLEXPORT    wilRelease(void);
NoMangle LPSTR DLLEXPORT  wilGetDescription(void);
NoMangle LPSTR DLLEXPORT  wilGetSystemInfo(void);
NoMangle LPSTR DLLEXPORT  wilGetVendorInfo(void);
NoMangle int DLLEXPORT    wilGetMaxSockets(void);
NoMangle int DLLEXPORT    wilGetMaxUDPSize(void);
NoMangle int DLLEXPORT    wilAskHostByName(LPSTR);
NoMangle int DLLEXPORT    wilAskHostByAddr(LPSTR);
NoMangle int DLLEXPORT    wilAskProtoByName(LPSTR);
NoMangle int DLLEXPORT    wilAskProtoByNumber(int);
NoMangle LPSTR DLLEXPORT  wilGetServName(void);
NoMangle short DLLEXPORT  wilGetServPort(void);
NoMangle LPSTR DLLEXPORT  wilGetHostName(void);
NoMangle LPSTR DLLEXPORT  wilGetHostAlias(int);
NoMangle ULONG DLLEXPORT  wilGetHostAddr(int);
NoMangle LPSTR DLLEXPORT  wilGetHostDotted(int);
NoMangle LPSTR DLLEXPORT  wilGetProtoName(void);
NoMangle short DLLEXPORT  wilGetProtoNumber(void);
NoMangle int DLLEXPORT    wilAskServByName(LPSTR, LPSTR);
NoMangle int DLLEXPORT    wilAskServByPort(int, LPSTR);
NoMangle int DLLEXPORT    wilErrorText(WORD, LPSTR, int);
NoMangle int DLLEXPORT    wilDebug(int);
NoMangle SOCKET DLLEXPORT wilTcpSocket(void);
NoMangle int DLLEXPORT    wilCloseSocket(SOCKET);
NoMangle int DLLEXPORT    wilConnect(SOCKET, ULONG, short);
NoMangle int DLLEXPORT    wilSocketStatus(SOCKET,int);
NoMangle int DLLEXPORT    wilReadSocket(SOCKET,LPSTR,int);
NoMangle int DLLEXPORT    wilPeekSocket(SOCKET,LPSTR,int);
NoMangle int DLLEXPORT    wilReadString(SOCKET,LPSTR,int);
NoMangle int DLLEXPORT    wilReadLine(SOCKET,LPSTR,int);
NoMangle int DLLEXPORT    wilWaitLine(SOCKET,LPSTR,int,ULONG,ULONG);
NoMangle int DLLEXPORT    wilWriteSocket(SOCKET,LPSTR,int);
NoMangle int DLLEXPORT    wilWriteString(SOCKET,LPSTR);
NoMangle int DLLEXPORT    wilWriteLine(SOCKET,LPSTR);
NoMangle int DLLEXPORT    wilListen(SOCKET, int);
NoMangle SOCKET DLLEXPORT wilAccept(SOCKET,ULONG);
NoMangle int DLLEXPORT    wilBind(SOCKET, ULONG, short);
NoMangle ULONG DLLEXPORT  wilLocalSockAddr(SOCKET);
NoMangle short DLLEXPORT  wilLocalSockPort(SOCKET);
NoMangle ULONG DLLEXPORT  wilRemoteSockAddr(SOCKET);
NoMangle short DLLEXPORT  wilRemoteSockPort(SOCKET);
NoMangle ULONG DLLEXPORT  wilParseDecimal(LPSTR);
NoMangle int DLLEXPORT    wilAwaitEvent(SOCKET,HWND,WORD,ULONG);
NoMangle int DLLEXPORT    wilSetOOB(SOCKET, int);
NoMangle int DLLEXPORT    wilReadOOB(SOCKET, LPSTR, int);
NoMangle int DLLEXPORT    wilWriteOOB(SOCKET, LPSTR, int);

/* AWAIT macros */

#define wilAwaitConnect(s,h) wilAwaitEvent((s),(h),WM_USER,FD_CONNECT)
#define wilAwaitAccept(s,h) wilAwaitEvent((s),(h),WM_USER,FD_ACCEPT)
#define wilAwaitRead(s,h) wilAwaitEvent((s),(h),WM_USER,FD_READ)
#define wilAwaitOOB(s,h) wilAwaitEvent((s),(h),WM_USER,FD_OOB)
#define wilAwaitWrite(s,h) wilAwaitEvent((s),(h),WM_USER,FD_WRITE)
#define wilAwaitClose(s,h) wilAwaitEvent((s),(h),WM_USER,FD_CLOSE)
#define wilAwaitCancel(s,h) wilAwaitEvent((s),(h),WM_USER,0)
        