/******************************************************************************
*               Win32 Finger Application 2/11/95 by Mark Gamber               *
*                                                                             *
* Example demonstrating how to connect to a host and query it for a user name *
*    based on an internet email address.                                      *
*                                                                             *
* By using this program or any included part, the user assumes full           *
*    responsibility for it's proper use and may not hold the author liable    *
*    for any loss or damage. If unable to accept this condition, the program  *
*    and all included parts must be destroyed immediately.                    *
******************************************************************************/

#include "windows.h"
#include "winsock.h"

// === Function Prototypes ====================================================

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );

// === Global Variables =======================================================

HINSTANCE hInst;

// === Application Entry Point ================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd,
                      int nShow )
{
   hInst = hInstance;
   DialogBox( hInstance, MAKEINTRESOURCE( 10000 ), NULL, MainDlgProc );
   return( FALSE );
}

// === Main Window Procedure ==================================================

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM LParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
      {
         WSADATA wsad;

         if( WSAStartup( 0x0101, &wsad ) )          //  Initialize sockets here
            return( -1 );                   //  or fail window if sockets fails

         return( TRUE );
      }


      case WM_COMMAND:
         if( wParam == IDCANCEL )                        //  Closing dialog box
         {
            WSACleanup();
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         if( wParam == IDOK )                         //  "Find" button pressed
         {
            char szName[ 1024 ], *pszHost, *pszNext;
            struct hostent *phe;
            SOCKET s;
            BYTE * bAddr;
            int iStatus, iCount;
            SOCKADDR_IN sin;

                                                  //  Get email name to look up
            if( ! GetDlgItemText( hDlg, 100, szName, 256 ) )
            {                               //  If nothing specified, tell user
               MessageBox( hDlg, "No Name Specified!", "WinFin",
                           MB_OK | MB_ICONEXCLAMATION );
               break;                                  //  and exit dialog proc
            }

            pszHost = strchr( szName, '@' ); //  Search for name/host separator
            if( ! pszHost )                //  If not there, tell user and quit
            {
               MessageBox( hDlg, "Name requires User@HostName!", "WinFin",
                           MB_OK | MB_ICONEXCLAMATION );
               break;
            }

            *pszHost = '\0';                    //  Replace separator with NULL
            ++pszHost;                                   //  Point to host name

            phe = gethostbyname( pszHost );     //  Find host to get IP address
            if( ! phe )        //  If unable to locate host, tell user and quit
            {
               MessageBox( hDlg, "Unable to locate specified host",
                           "WinFin", MB_OK | MB_ICONEXCLAMATION );
               break;
            }
                                             //  Open a socket or die if unable
            s = socket( PF_INET, SOCK_STREAM, 0 );
            if( s == INVALID_SOCKET )
            {
               MessageBox( hDlg, "Unable to create a new TCP/IP Socket",
                           "WinFin", MB_OK | MB_ICONEXCLAMATION );
               break;
            }
   
            bAddr = *phe->h_addr_list;              //  Fill in connection data
            sin.sin_family = AF_INET;
            sin.sin_port = htons( IPPORT_FINGER );     //  Use a FINGER channel
            sin.sin_addr.s_addr = *(LPDWORD)bAddr;
            iStatus = connect( s, (LPSOCKADDR)&sin, sizeof(SOCKADDR_IN) );

            if( iStatus == SOCKET_ERROR )         //  If host connection failed
            {                                    //  close the socket, tell the
               closesocket( s );                              //  user and exit
               MessageBox( hDlg, "Unable to connect to host!", "WinFin",
                           MB_OK | MB_ICONEXCLAMATION );
               break;
            }
                                         //  Send name to host followed by CRLF
            iStatus = send( s, szName, lstrlen( szName ), 0 );
            send( s, "\r\n", 2, 0 );

            szName[ 0 ] = '\0';                   //  Set buffer to zero length
            iStatus = recv( s, szName, 256, 0 );          //  Wait for response
            if( iStatus )                         //  If something was received
            {                                        //  Empty the info listbox
               SendDlgItemMessage( hDlg, 102, LB_RESETCONTENT, 0, 0 );

               szName[ iStatus ] = '\0';
               iCount = 0;
               pszHost = szName;         //  Point to start of buffer initially
                                              
               while( 1 )
               {
                  pszNext = strchr( pszHost, '\r' );  //  Search for CR in line
                  if( pszNext && ( ( pszNext - szName ) < iStatus ) )
                     *pszNext = '\0';         //  Replace with NULL if CR found
                                                      //  Add string to listbox
                  SendDlgItemMessage( hDlg, 102, LB_ADDSTRING, 0,
                                      (LPARAM)pszHost );
                  if( pszNext )
                     pszHost = pszNext + 2;     //  If CRLF found, skip over it
                  else
                     break;                         //  If no CRLF, end of data
               }
            }
            closesocket( s );      //  Kill the socket and exit the dialog proc
            break;
         }
         break;
   }
   return( FALSE );
}                                                      //  End of MainDlgProc()

