;	͸
;	                                                              
;	                         WinRun-R.ASM                         
;	        Windows-Programmlader / Receiver-Modul, V1.00         
;	                 27.07.1993 Sven B. Schreiber                 
;	                     Assembler: MASM 6.00                     
;	                                                              
;	;
;
;
;==============================================================================
;
	include	windef.inc			;windows-definitionen
;
;==============================================================================
;
;				assembler-flags
;
;==============================================================================
;
IdleDetect		equ	0		;leerlauferkennung
;
;==============================================================================
;
;				  konstanten
;
;==============================================================================
;
WMU_IDLE		equ	WM_USER		;leerlaufmeldung
WMU_ABOUT		equ	WM_USER+1	;about-box
WMU_SIGNAL		equ	WM_USER+2	;dos-signal
;
;------------------------------------------------------------------------------
;
MPX			equ	2Fh		;multiplex-interrupt
DPMI			equ	31h		;dpmi-interface
EXEC			equ	7Fh		;executor-interrupt
;
;------------------------------------------------------------------------------
;
BUSY			equ	0		;offset: busy-flag
RESULT			equ	1		;offset: ergebnis
;
;==============================================================================
;
;			    externe dll-funktionen
;
;==============================================================================
;
	extrn	CreateSolidBrush:	far
	extrn	CreateWindow:		far
	extrn	DefWindowProc:		far
	extrn	DeleteObject:		far
	extrn	DialogBoxIndirect:	far
	extrn	DispatchMessage:	far
	extrn	EndDialog:		far
	extrn	GetDialogBaseUnits:	far
	extrn	GetMessage:		far
	extrn	GetStockObject:		far
	extrn	GetSystemMetrics:	far
	extrn	GlobalAlloc:		far
	extrn	GlobalFree:		far
	extrn	GlobalLock:		far
	extrn	GlobalUnlock:		far
	extrn	LoadCursor:		far
	extrn	LoadIcon:		far
	extrn	PeekMessage:		far
	extrn	PostMessage:		far
	extrn	PostQuitMessage:	far
	extrn	RegisterClass:		far
	extrn	SendMessage:		far
	extrn	SetBkColor:		far
	extrn	SetBkMode:		far
	extrn	SetTextColor:		far
	extrn	SetWindowText:		far
	extrn	ShowWindow:		far
	extrn	TranslateMessage:	far
	extrn	UpdateWindow:		far
	extrn	WinExec:		far
;
;==============================================================================
;
;				 datensegment
;
;==============================================================================
;
_data	segment	public 'DATA'
;
;==============================================================================
;
;			    verschiedene parameter
;
;------------------------------------------------------------------------------
;
MainStyle	equ	CS_DBLCLKS+CS_HREDRAW+CS_VREDRAW
;
hInst			HANDLE	0
hMainWnd		HANDLE	0
hModalBoxBrush		HBRUSH	0
dIntService		DWORD	0
WndClass		WNDCLASS {MainStyle,MainWnd,0,0,,,,,0,MainClass}
Msg			MSG	{}
Regs			REGS16	{}
;
;------------------------------------------------------------------------------
;
IconName		db	"DEFAULT_ICON",0
MainClass		db	"MainClass",0
MainCaption		db	"SBS WinRun-R 1.00",0
;
;==============================================================================
;
;				  dialogboxen
;
;------------------------------------------------------------------------------
;
AboutBoxData	equ	$
;
	dw	DS_MODALFRAME+DS_ABSALIGN		;DLGTEMPLATE
	dw	WS_CAPTION+WS_SYSMENU
	db	8
	dw	0,0,200,112
	db	0
	db	0
	db	"ber WinRun-R",0
;
	dw	12,12,176,40				;DLGITEMTEMPLATE
	dw	-1
	dw	SS_BLACKFRAME
	dw	WS_CHILD+WS_VISIBLE+WS_GROUP
	db	STATIC
	db	0
	db	0
;
	dw	14,14,172,36				;DLGITEMTEMPLATE
	dw	-1
	dw	SS_BLACKFRAME
	dw	WS_CHILD+WS_VISIBLE
	db	STATIC
	db	0
	db	0
;
	dw	16,18,168,8				;DLGITEMTEMPLATE
	dw	-1
	dw	SS_CENTER
	dw	WS_CHILD+WS_VISIBLE
	db	STATIC
	db	"Windows-Programmlader / Receiver-Modul",0
	db	0
;
	dw	16,28,168,8				;DLGITEMTEMPLATE
	dw	-1
	dw	SS_CENTER
	dw	WS_CHILD+WS_VISIBLE
	db	STATIC
	db	"Version 1.00",0
	db	0
;
	dw	16,38,168,8				;DLGITEMTEMPLATE
	dw	-1
	dw	SS_CENTER
	dw	WS_CHILD+WS_VISIBLE
	db	STATIC
	db	"27.07.1993 Sven B. Schreiber",0
	db	0
;
	dw	22,74,16,16				;DLGITEMTEMPLATE
	dw	-1
	dw	SS_ICON
	dw	WS_CHILD+WS_VISIBLE
	db	STATIC
	db	"DEFAULT_ICON",0
	db	0
;
	dw	162,74,16,16				;DLGITEMTEMPLATE
	dw	-1
	dw	SS_ICON
	dw	WS_CHILD+WS_VISIBLE
	db	STATIC
	db	"DEFAULT_ICON",0
	db	0
;
	dw	60,64,80,36				;DLGITEMTEMPLATE
	dw	IDOK
	dw	BS_DEFPUSHBUTTON
	dw	WS_CHILD+WS_VISIBLE+WS_GROUP
	db	BUTTON
	db	"&OK",0
	db	0
;
AboutBoxData_	equ	$-AboutBoxData
;
;------------------------------------------------------------------------------
;
_data	ends
;
;==============================================================================
;
;				  codesegment
;
;==============================================================================
;
_text	segment	public 'CODE'
	assume	cs:_text,ds:_data
;
;==============================================================================
;
;				 hauptprogramm
;
;------------------------------------------------------------------------------
;
public WinMain
;
WinMain:
	startnear
	mov	ax,ahInstance			;aktuelle instanz merken
	mov	hInst,ax
	cmp	word ptr ahPrevInstance,0	;programm bereits geladen?
	mov	ax,0
	jnz	WinMain4
	call	InitApplication			;anwendung initialisieren
	cmp	ax,0
	jz	WinMain4
	call	InitInstance			;instanz initialisieren
	cmp	ax,0
	jz	WinMain4
	call	InitIntService			;int-service initialisieren
	mov	ax,0
	jb	WinMain4
WinMain1:
	if	IdleDetect
	wincall	PeekMessage,\			;auf meldung testen
		ds,<offset Msg>,\
		0,\
		0,\
		0,\
		PM_NOREMOVE
	cmp	ax,0
	jnz	WinMain2
	wincall	PostMessage,\			;idle-meldung senden
		hMainWnd,\
		WMU_IDLE,\
		0,\
		0,0
WinMain2:
	endif
	wincall	GetMessage,\			;auf meldung warten
		ds,<offset Msg>,\
		0,\
		0,\
		0
	cmp	ax,0				;WM_QUIT?
	jz	WinMain3
	wincall	TranslateMessage,\		;virtuelle tasten bersetzen
		ds,<offset Msg>
	wincall	DispatchMessage,\		;meldung an MainWndProc geben
		ds,<offset Msg>
	jmp	WinMain1
WinMain3:
	call	Cleanup				;aufrumen
	mov	ax,Msg.wParam			;meldungsparameter liefern
WinMain4:
	endnear	aWinMain
;
;==============================================================================
;
;	>	bp  -  parameterliste
;
;	<	ax  -  ergebnis
;
;------------------------------------------------------------------------------
;
InitApplication:
	mov	ax,hInst			;instanz merken
	mov	WndClass.hInstance,ax
	wincall	LoadIcon,\			;ikone definieren
		hInst,\
		ds,<offset IconName>
	mov	WndClass.hIcon,ax
	wincall	LoadCursor,\			;cursor definieren
		0,\
		0,IDC_ARROW
	mov	WndClass.hCursor,ax
	wincall	GetStockObject,\		;hintergrund definieren
		DKGRAY_BRUSH
	mov	WndClass.hbrBackground,ax
	wincall	RegisterClass,\			;fensterklasse registrieren
		ds,<offset WndClass>
	ret
;
;==============================================================================
;
;	>	bp  -  parameterliste
;
;	<	ax  -  ergebnis
;
;------------------------------------------------------------------------------
;
InitInstance:
	wincall	GetSystemMetrics,\		;bildschirmbreite laden
		SM_CXSCREEN
	mov	cx,3				;justieren
	mul	cx
	mov	cx,4
	div	cx
	push	ax
	wincall	GetSystemMetrics,\		;bildschirmhhe laden
		SM_CYSCREEN
	mov	cx,3				;justieren
	mul	cx
	mov	cx,4
	div	cx
	pop	bx
	wincall	CreateWindow,\			;hauptfenster einrichten
		ds,<offset MainClass>,\
		ds,<offset MainCaption>,\
		WS_OVERLAPPEDWINDOW,0,\
		0,\
		0,\
		bx,\
		ax,\
		0,\
		0,\
		hInst,\
		0,0
	cmp	ax,0				;fehler?
	jz	InitInstance1
	mov	hMainWnd,ax			;handle merken
	wincall	ShowWindow,\			;hauptfenster anzeigen
		hMainWnd,\
		SW_SHOWMINNOACTIVE
	wincall	UpdateWindow,\			;hauptfensterinhalt anzeigen
		hMainWnd
	mov	ax,1				;ok
InitInstance1:
	ret
;
;==============================================================================
;
;	<	c  -  gesetzt falls fehler
;
;------------------------------------------------------------------------------
;
InitIntService:
	mov	ax,1686h			;geschtzter modus?
	int	MPX
	add	ax,-1
	jb	InitIntService1
	mov	bx,cs				;code-alias holen
	mov	ax,000Ah
	int	DPMI
	jb	InitIntService1
	push	es
	mov	es,ax				;datenselektor im cs eintragen
	mov	es:wDataSelector,ds
	pop	es
	mov	bx,ax				;code-alias freigeben
	mov	ax,0001h
	int	DPMI
	jb	InitIntService1
	mov	bl,EXEC				;alten interruptvektor merken
	mov	ax,0200h
	int	DPMI
	mov	word ptr dIntService,dx
	mov	word ptr dIntService+2,cx
	push	ds
	push	es
	mov	di,offset Regs			;real-modus-callback definieren
	mov	ax,ds
	mov	es,ax
	mov	si,offset IntService
	mov	ax,cs
	mov	ds,ax
	mov	ax,0303h
	int	DPMI
	pop	es
	pop	ds
	jb	InitIntService1
	mov	bl,EXEC				;real-modus-interrupt verbiegen
	mov	ax,0201h
	int	DPMI
	jnb	InitIntService1			;ok
	mov	dx,offset IntService		;real-modus-callback freigeben
	mov	cx,cs
	mov	ax,0304h
	int	DPMI
	stc
InitIntService1:
	ret
;
;------------------------------------------------------------------------------
;
wDataSelector		WORD	0
;
;==============================================================================
;
;	>	bp  -  parameterliste
;
;------------------------------------------------------------------------------
;
Cleanup:
	mov	bl,EXEC				;interrupt wiederherstellen
	mov	dx,word ptr dIntService
	mov	cx,word ptr dIntService+2
	mov	ax,0201h
	int	DPMI
	mov	dx,offset IntService		;real-modus-callback freigeben
	mov	cx,cs
	mov	ax,0304h
	int	DPMI
	ret
;
;==============================================================================
;
;			       interrupt-service
;
;==============================================================================
;
IntService:
	pusha
	push	ds
	push	es
	push	di
	mov	bx,(REGS16 ptr es:[di]).regDS	;dos-selektor anfordern
	mov	ax,0002h
	int	DPMI
	pop	di
	jb	IntService1			;fehler
	mov	si,(REGS16 ptr es:[di]).regSI	;datenadresse laden
	mov	di,(REGS16 ptr es:[di]).regDI	;semaphor-adresse laden
	mov	ds,cs:wDataSelector		;datensegment laden
	wincall	PostMessage,\			;signal senden
		hMainWnd,\
		WMU_SIGNAL,\
		ax,\
		si,di
IntService1:
	pop	es
	pop	ds
	popa
	push	ax
	mov	ax,[si]				;cs:ip vom stack holen
	mov	(REGS16 ptr es:[di]).regIP,ax
	mov	ax,[si+2]
	mov	(REGS16 ptr es:[di]).regCS,ax
	mov	ax,[si+4]			;flags vom stack holen
	mov	(REGS16 ptr es:[di]).regF,ax
	add	(REGS16 ptr es:[di]).regSP,6	;stack korrigieren
	pop	ax
	iret
;
;==============================================================================
;
;				 hilfsroutinen
;
;==============================================================================
;
;	>	ax     -  meldung
;		bx     -  funktionentabelle
;
;	<	dx:ax  -  ergebnis
;
;------------------------------------------------------------------------------
;
Evaluate:
	add	bx,4
	cmp	cs:word ptr [bx-4],-1		;ende der tabelle?
	jz	Evaluate1
	cmp	cs:word ptr [bx-4],ax		;meldung in tabelle gefunden?
	jnz	Evaluate
Evaluate1:
	jmp	cs:word ptr [bx-2]		;meldung bearbeiten
;
;==============================================================================
;
;	>	bx  -  template
;		cx  -  template-lnge
;		dx  -  callback-funktion
;
;	<	ax  -  dialogergebnis (-1 = fehler)
;
;------------------------------------------------------------------------------
;
DoDialog:
	push	bx
	push	cx
	push	dx
	call	CenterDialog			;dialogbox zentrieren
	pop	dx
	pop	cx
	push	cx
	push	dx
	wincall	GlobalAlloc,\			;heap-speicher reservieren
		GMEM_MOVEABLE,\
		0,cx
	cmp	ax,0				;fehler?
	mov	bx,-1
	jz	DoDialog5
	push	ax
	wincall	GlobalLock,\			;speicheradresse laden
		ax
	mov	di,ax
	or	ax,dx				;fehler?
	pop	ax
	mov	bx,-1
	jz	DoDialog4
	pop	bx
	pop	cx
	pop	si
	push	si
	push	cx
	push	bx
	push	ax
	push	es
	mov	es,dx
	mov	dl,[si+2+2]			;itemzhler laden
	inc	dl
	mov	dh,dl				;anfangswert merken
	mov	cx,2+2+1+2+2+2+2+1+1		;DLGTEMPLATE-vorspannlnge
	cld
DoDialog1:
	rep	movsb				;vorspann kopieren
DoDialog2:
	lodsb
	stosb
	cmp	al,0
	jnz	DoDialog2
	cmp	dl,dh				;DLGTEMPLATE?
	jz	DoDialog3
	movsb					;DLGITEMTEMPLATE fertigstellen
DoDialog3:
	mov	cx,2+2+2+2+2+2+2+1		;DLGITEMTEMPLATE-vorspannlnge
	dec	dl				;items zhlen
	jnz	DoDialog1
	pop	es
	pop	ax
	push	ax
	wincall	GlobalUnlock,\			;speicheradresse freigeben
		ax
	pop	ax
	pop	dx
	push	dx
	push	ax
	wincall	DialogBoxIndirect,\		;dialogbox einrichten
		hInst,\
		ax,\
		ahWnd,\
		cs,dx
	mov	bx,ax				;dialogergebnis merken
	pop	ax
DoDialog4:
	push	bx
	wincall	GlobalFree,\			;heap-speicher freigeben
		ax
	pop	bx
DoDialog5:
	mov	ax,bx				;dialogergebnis laden
	pop	dx
	pop	cx
	pop	bx
	ret
;
;==============================================================================
;
;	>	bx  -  template
;
;------------------------------------------------------------------------------
;
CenterDialog:
	push	bx
	wincall	GetSystemMetrics,\		;bildschirmbreite abfragen
		SM_CXSCREEN
	shl	ax,1
	shl	ax,1
	push	ax
	wincall	GetSystemMetrics,\		;bildschirmhhe abfragen
		SM_CYSCREEN
	shl	ax,1
	shl	ax,1
	shl	ax,1
	push	ax
	wincall	GetDialogBaseUnits		;dialogeinheiten abfragen
	pop	di
	pop	si
	pop	bx
	push	dx
	mov	cx,ax
	mul	word ptr [bx+2+2+1+2+2]		;freiraum horizontal berechnen
	sub	si,ax
	mov	ax,0
	jb	CenterDialog1			;dialogbox zu breit
	mov	ax,si				;in dialogeinheiten umrechnen
	mov	dx,0
	div	cx
	shl	dx,1				;runden
	cmp	dx,cx
	sbb	ax,-1
	shr	ax,1
CenterDialog1:
	mov	[bx+2+2+1],ax			;ursprung horizontal setzen
	pop	ax
	mov	cx,ax
	mul	word ptr [bx+2+2+1+2+2+2]	;freiraum vertikal berechnen
	sub	di,ax
	mov	ax,0
	jb	CenterDialog2			;dialogbox zu hoch
	mov	ax,di				;in dialogeinheiten umrechnen
	mov	dx,0
	div	cx
	shl	dx,1				;runden
	cmp	dx,cx
	sbb	ax,-1
	shr	ax,1
CenterDialog2:
	mov	[bx+2+2+1+2],ax			;ursprung vertikal setzen
	ret
;
;==============================================================================
;
;	>	bp     -  parameterliste
;
;	<	dx:ax  -  ergebnis
;
;------------------------------------------------------------------------------
;
Default:
	wincall	DefWindowProc,\			;standardverarbeitung
		ahWnd,\
		awMsg,\
		awParam,\
		alParamH,alParamL
	ret
;
;==============================================================================
;
;	<	dx:ax  -  ergebnis
;
;------------------------------------------------------------------------------
;
ReturnNULL:
	mov	ax,0				;ergebnis laden
	mov	dx,0
	ret
;
;==============================================================================
;
;	<	ax  -  ergebnis
;
;------------------------------------------------------------------------------
;
ReturnFALSE:
	mov	ax,0				;ergebnis laden
	mov	dx,0
	ret
;
;==============================================================================
;
;	<	ax  -  ergebnis
;
;------------------------------------------------------------------------------
;
ReturnTRUE:
	mov	ax,1				;ergebnis laden
	mov	dx,0
	ret
;
;==============================================================================
;
;				 hauptfenster
;
;==============================================================================
;
MainWnd:
	startfar
	mov	ax,awMsg			;meldungen auswerten
	mov	bx,tblMainWnd
	call	Evaluate
	endfar	aCallBack
;
;------------------------------------------------------------------------------
;
tblMainWnd:
	if	IdleDetect
	dw	WMU_IDLE,idleMainWnd			;leerlauf
	endif
	dw	WM_DESTROY,destroyMainWnd		;fenster schlieen
	dw	WM_QUERYOPEN,queryopenMainWnd		;symbol ffnen
	dw	WMU_ABOUT,aboutMainWnd			;about-box
	dw	WMU_SIGNAL,signalMainWnd		;dos-signal
	dw	-1,Default				;sonstige
;
;------------------------------------------------------------------------------
;
	if	IdleDetect
;
idleMainWnd:
	jmp	ReturnNULL			;leerlauf behandeln
;
	endif
;
;------------------------------------------------------------------------------
;
destroyMainWnd:
	wincall	PostQuitMessage,\		;programm beenden
		0
	jmp	ReturnNULL
;
;------------------------------------------------------------------------------
;
queryopenMainWnd:
	wincall	PostMessage,\			;about-box anzeigen
		hMainWnd,\
		WMU_ABOUT,\
		0,\
		0,0
	jmp	ReturnNULL			;ikone nicht ffnen
;
;------------------------------------------------------------------------------
;
aboutMainWnd:
	mov	bx,AboutBoxData			;about-box-dialog
	mov	cx,AboutBoxData_
	mov	dx,ModalBox
	call	DoDialog
	jmp	ReturnNULL
;
;------------------------------------------------------------------------------
;
signalMainWnd:
	wincall	WinExec,\			;programm starten
		awParam,alParamH,\
		anCmdShow
	push	ds
	mov	ds,awParam			;semaphor bearbeiten
	mov	di,alParamL
	mov	word ptr [di+RESULT],ax
	mov	byte ptr [di+BUSY],0
	pop	ds
	jmp	ReturnNULL
;
;==============================================================================
;
;			 nicht-modaler standarddialog
;
;==============================================================================
;
ModalBox:
	startfar
	mov	ax,awMsg			;meldungen auswerten
	mov	bx,tblModalBox
	call	Evaluate
	endfar	aCallBack
;
;------------------------------------------------------------------------------
;
tblModalBox:
	dw	WM_INITDIALOG,initdialogModalBox	;dialog initialisieren
	dw	WM_CTLCOLOR,ctlcolorModalBox		;farben whlen
	dw	WM_COMMAND,commandModalBox		;kommandos ausfhren
	dw	-1,ReturnFALSE				;sonstige
;
;------------------------------------------------------------------------------
;
initdialogModalBox:
	mov	hModalBoxBrush,0		;hintergrund neu definieren
	jmp	ReturnTRUE			;dialog initialisieren
;
;------------------------------------------------------------------------------
;
ctlcolorModalBox:
	mov	ax,alParamH			;typ laden
	cmp	ax,CTLCOLOR_DLG			;dialogbox?
	jz	ctlcolorModalBox1
	cmp	ax,CTLCOLOR_STATIC		;text?
	jz	ctlcolorModalBox1
	cmp	ax,CTLCOLOR_BTN			;button?
	jz	ctlcolorModalBox1
	jmp	ReturnFALSE			;standardfarben whlen
ctlcolorModalBox1:
	wincall	SetTextColor,\			;textfarbe setzen
		awParam,\
		H_BLACK,L_BLACK
	wincall	SetBkColor,\			;hintergrundfarbe setzen
		awParam,\
		H_CYAN,L_CYAN
	wincall	SetBkMode,\			;hintergrundmodus setzen
		awParam,\
		OPAQUE
	mov	ax,hModalBoxBrush		;hintergrundfarbe laden
	cmp	ax,0				;bereits definiert?
	jnz	ctlcolorModalBox2
	wincall	CreateSolidBrush,\		;hintergrundfarbe definieren
		H_CYAN,L_CYAN
	mov	hModalBoxBrush,ax
ctlcolorModalBox2:
	ret
;
;------------------------------------------------------------------------------
;
commandModalBox:
	cmp	word ptr awParam,IDOK		;ok?
	jz	commandModalBox1
	cmp	word ptr awParam,IDCANCEL	;abbruch?
	jz	commandModalBox1
	jmp	ReturnFALSE
commandModalBox1:
	wincall	EndDialog,\			;dialogbox schlieen
		ahDlg,\
		awParam
	wincall	DeleteObject,\			;hintergrundfarbe lschen
		hModalBoxBrush
	jmp	ReturnTRUE
;
;==============================================================================
;
_text	ends
	end
