;	͸
;	                                                              
;	                         WinRun-T.ASM                         
;	       Windows-Programmlader / Transmitter-Modul, V1.00       
;	                 27.07.1993 Sven B. Schreiber                 
;	                     Assembler: MASM 5.10                     
;	                                                              
;	;
;
;
;------------------------------------------------------------------------------
;
code	segment
	assume	cs:code,ds:code,es:code,ss:code
;
;==============================================================================
;
;				  konstanten
;
;==============================================================================
;
; ========
; adressen
; ========
;
environment	equ	002ch		;umgebungssegmentadresse
base		equ	0100h		;programmstartadresse
;
; ==========
; interrupts
; ==========
;
dos		equ	21h		;dos-bibliothek
mpx		equ	2fh		;multiplex-interrupt
exec		equ	7fh		;executor-interrupt
;
; ==============
; dos-funktionen
; ==============
;
displaytext	equ	09h		;text anzeigen
setinterrupt	equ	25h		;interruptvektor setzen
resident	equ	31h		;programm resident installieren
getinterrupt	equ	35h		;interruptvektor laden
deallocate	equ	49h		;speicher freigeben
terminate	equ	4ch		;programm beenden
listoflists	equ	52h		;dos-parameterliste laden
;
; =============
; ascii-zeichen
; =============
;
lf		equ	0ah		;line feed
cr		equ	0dh		;carriage return
;
;==============================================================================
;
;				residenter code
;
;==============================================================================
;
	org	base
start:
	jmp	control				;programminstallation
identification:
	db	'SBS_WINRUN-T_V1.00',0		;programmidentifikation
identification_	equ	$-identification	;lnge
;
;------------------------------------------------------------------------------
;
codesegment:
	dw	0				;codesegmentadresse
execbackup:
	dd	0				;alter interruptvektor
;
;------------------------------------------------------------------------------
;
input		equ	0			;offset: input-parameter
output		equ	4			;offset: output-parameter
;
datapointer:
	dd	0				;datenzeiger
;
;------------------------------------------------------------------------------
;
busy		equ	0			;offset: busy-flag
result		equ	1			;offset: ergebnis
;
semaphore:
	db	0				;busy-flag
	dw	0				;ergebnis
;
;==============================================================================
;
;	>	ds:si  -  datenadresse
;
;------------------------------------------------------------------------------
;
execservice:
	sti
	mov	word ptr cs:datapointer,si	;datenadresse merken
	mov	word ptr cs:datapointer+2,ds
	mov	word ptr [si+output],-1		;vorlufiges ergebnis eintragen
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	bp
	push	es
	mov	ax,1687h			;dpmi vorhanden?
	int	mpx
	cmp	ax,0
	jz	execservice1
	jmp	execservice3			;fehler
execservice1:
	mov	ax,1683h			;virtuelle maschine abfragen
	int	mpx
	cmp	bx,1				;system-vm?
	jz	execservice3
	call	readdata			;client-daten laden
	mov	byte ptr cs:semaphore+busy,1	;busy-flag setzen
	mov	bx,1				;system-vm whlen / callback
	mov	cx,0003h
	mov	si,0
	mov	dx,0
	mov	di,offset callback
	mov	ax,cs
	mov	es,ax
	mov	ax,1685h
	int	mpx
execservice2:
	mov	ax,1680				;zeitscheibe freigeben
	int	mpx
	cmp	byte ptr cs:semaphore+busy,0	;warten bis busy-flag gelscht
	jnz	execservice2
	call	writedata			;client-daten zurckschreiben
execservice3:
	pop	es
	pop	bp
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	lds	si,dword ptr cs:datapointer	;datenadresse laden
	cli
	iret
;
;==============================================================================
;
;	keine parameter
;
;------------------------------------------------------------------------------
;
callback:
	push	ds
	push	si
	push	di
	mov	si,0				;interrupttabelle adressieren
	mov	ds,si
	mov	di,offset execservice		;interruptvektor testen
	mov	si,cs
	sub	di,word ptr ds:(exec*4)
	sbb	si,word ptr ds:(exec*4)+2
	or	si,di
	jnz	callback1			;empfnger vorhanden
	mov	byte ptr cs:semaphore+busy,0	;busy-flag lschen
	jmp	callback2
callback1:
	mov	si,cs				;protected-mode-code aufrufen
	mov	ds,si
	mov	si,offset databuffer
	mov	di,offset semaphore
	int	exec
callback2:
	pop	di
	pop	si
	pop	ds
	iret
;
;==============================================================================
;
;	keine parameter
;
;------------------------------------------------------------------------------
;
readdata:
	lds	si,dword ptr cs:datapointer	;datenzeiger laden
	mov	ax,word ptr [si+output]		;vorlufiges ergebnis kopieren
	mov	word ptr cs:semaphore+result,ax
	lds	si,dword ptr [si+input]		;daten in den puffer kopieren
	mov	di,cs
	mov	es,di
	mov	di,offset databuffer
	mov	cx,offset databuffer_-1
	cld
	rep	movsb
	mov	al,0				;string-ende anhngen
	stosb
	ret
;
;==============================================================================
;
;	keine parameter
;
;------------------------------------------------------------------------------
;
writedata:
	mov	ax,word ptr cs:semaphore+result	;ergebnis kopieren
	lds	si,dword ptr cs:datapointer
	mov	word ptr [si+output],ax
	ret
;
;==============================================================================
;
;				 pufferbereich
;
;==============================================================================
;
databuffer_	equ	128				;datenpuffergre
;
databuffer	equ	$				;datenpuffer
freememory	equ	databuffer + databuffer_	;erste freie adresse
;
;==============================================================================
;
;			       transienter code
;
;==============================================================================
;
;	keine parameter
;
;------------------------------------------------------------------------------
;
control:
	mov	word ptr codesegment,cs		;codesegmentadresse merken
	mov	dx,offset signon		;startmeldung anzeigen
	mov	ah,displaytext
	int	dos
	call	isinstalled			;programm bereits installiert?
	cmp	ax,0
	jnz	control1
	jmp	install				;installieren
control1:
	jmp	uninstall			;deinstallieren
;
;==============================================================================
;
;	>	dx  -  text
;		al  -  errorlevel
;
;------------------------------------------------------------------------------
;
exit:
	push	ax
	mov	ah,displaytext			;text anzeigen
	int	dos
	pop	ax
	mov	ah,terminate			;programm beenden
	int	dos
;
;==============================================================================
;
;	keine parameter
;
;------------------------------------------------------------------------------
;
install:
	mov	ax,1687h			;dpmi installiert?
	int	mpx
	cmp	ax,0
	jnz	install1
	mov	dx,offset noinstall		;fehler
	mov	al,1
	jmp	exit
install1:
	push	es
	mov	al,exec				;interruptvektor laden
	mov	ah,getinterrupt
	int	dos
	mov	word ptr execbackup,bx
	mov	word ptr execbackup+2,es
	mov	ax,es				;interruptvektor frei?
	or	ax,bx
	pop	es
	jz	install2
	mov	dx,offset notinstalled		;fehler
	mov	al,3
	jmp	exit
install2:
	mov	dx,offset execservice		;serviceroutine installieren
	mov	al,exec
	mov	ah,setinterrupt
	int	dos
	push	es
	mov	si,offset environment		;umgebungsbereich lschen
	mov	es,word ptr [si]
	mov	ah,deallocate
	int	dos
	pop	es
	mov	dx,offset installed		;installationsmeldung
	mov	ah,displaytext
	int	dos
	mov	dx,offset freememory		;residente codelnge berechnen
	dec	dx
	mov	cl,4
	shr	dx,cl
	inc	dx
	mov	al,0				;exit-code laden
	mov	ah,resident			;programm resident installieren
	int	dos
;
;==============================================================================
;
;	>	ax  -  mcb-segment
;
;------------------------------------------------------------------------------
;
uninstall:
	push	ax
	mov	ax,1687h			;dpmi installiert?
	int	mpx
	cmp	ax,0
	pop	ax
	jnz	uninstall1
	mov	dx,offset nouninstall		;fehler
	mov	al,2
	jmp	exit
uninstall1:
	push	es
	mov	es,ax				;mcb adressieren
	mov	word ptr es:1,0			;speicherblock freigeben
	pop	es
	push	ds
	lds	dx,dword ptr execbackup		;alten service installieren
	mov	al,exec
	mov	ah,setinterrupt
	int	dos
	pop	ds
	mov	dx,offset uninstalled		;fertig
	mov	al,0
	jmp	exit
;
;==============================================================================
;
;	<	ax  -  mcb-segment (0 falls nicht installiert)
;
;------------------------------------------------------------------------------
;
isinstalled:
	push	es
	mov	ah,listoflists			;dos-variablenliste laden
	int	dos
	mov	es,word ptr es:[bx-2]
	mov	dx,offset freememory		;programmlnge berechnen
	dec	dx
	mov	cl,4
	shr	dx,cl
	inc	dx
isinstalled1:
	cmp	byte ptr es:0,'M'		;normaler speicherblock?
	jz	isinstalled2
	cmp	byte ptr es:0,'Z'		;letzter speicherblock?
	jnz	isinstalled3
isinstalled2:
	cmp	word ptr es:1,0			;unbenutzter block?
	jz	isinstalled3
	cmp	word ptr es:3,dx		;speicherblockgre ok?
	jnz	isinstalled3
	mov	si,offset identification	;programm-id testen
	mov	di,offset identification+16
	mov	cx,offset identification_
	cld
	repz	cmpsb
	jz	isinstalled4			;programm gefunden
isinstalled3:
	cmp	byte ptr es:0,'Z'		;keine weiteren speicherblcke?
	mov	ax,0				;fehlercode laden
	jz	isinstalled5
	mov	ax,es				;speicherblock berspringen
	add	ax,word ptr es:3
	inc	ax
	mov	es,ax
	jmp	isinstalled1			;nchsten speicherblock testen
isinstalled4:
	mov	ax,es				;mcb-adresse laden
isinstalled5:
	pop	es
	ret
;
;==============================================================================
;
;				bildschirmtexte
;
;==============================================================================
;
signon:
db cr,lf
db 'SBS Windows-Programmlader V1.00  Copyright (c) 1993 Sven B. Schreiber'
db cr,lf,'$'
;
installed:
db '--> Das Transmitter-Modul wurde installiert.',cr,lf
db '--> Deinstallation durch erneuten Aufruf.',cr,lf
db '$'
;
uninstalled:
db '--> Das Transmitter-Modul wurde deinstalliert.'
db cr,lf,'$'
;
noinstall:
db '--> Das Transmitter-Modul mu auerhalb von Windows installiert werden!'
db cr,lf,'$'
;
nouninstall:
db '--> Das Transmitter-Modul mu auerhalb von Windows deinstalliert werden!'
db cr,lf,'$'
;
notinstalled:
db '--> Hoppla ... Da hngt schon jemand in meinem Interrupt drin!'
db cr,lf,'$'
;
;==============================================================================
;
code	ends
	end	start
