;	͸
;	                                                              
;	                          WinRun.ASM                          
;	       Windows-Programmlader / Kommandointerface, V1.00       
;	                 28.07.1993 Sven B. Schreiber                 
;	                     Assembler: MASM 5.10                     
;	                                                              
;	;
;
;
;------------------------------------------------------------------------------
;
code	segment
	assume	cs:code,ds:code,es:code,ss:code
;
;==============================================================================
;
;				  konstanten
;
;==============================================================================
;
; ========
; adressen
; ========
;
dta		equ	0080h		;datentransferadresse
base		equ	0100h		;programmstartadresse
;
; ==========
; interrupts
; ==========
;
dos		equ	21h		;dos-bibliothek
exec		equ	7fh		;executor-interrupt
;
; ==============
; dos-funktionen
; ==============
;
displaychar	equ	02h		;zeichen anzeigen
displaytext	equ	09h		;text anzeigen
getinterrupt	equ	35h		;interruptvektor laden
terminate	equ	4ch		;programm beenden
;
; =============
; ascii-zeichen
; =============
;
lf		equ	0ah		;line feed
cr		equ	0dh		;carriage return
;
;==============================================================================
;
	org	base
;
;==============================================================================
;
;				     code
;
;==============================================================================
;
;	keine Parameter
;
;------------------------------------------------------------------------------
;
main:
	push	es
	mov	al,exec				;interruptvektor laden
	mov	ah,getinterrupt
	int	dos
	mov	ax,es				;transmitter installiert?
	or	ax,bx
	pop	es
	mov	dx,offset notransmitter
	mov	bl,1
	jz	main1
	mov	di,offset dta+1			;kommandozeile adressieren
	mov	bl,byte ptr [di-1]		;lnge laden
	mov	bh,0
	mov	byte ptr [di+bx],0		;stringende eintragen
	mov	al,' '				;fhrende blanks berspringen
	mov	cx,bx
	inc	cx
	cld
	repz	scasb
	dec	di
	mov	si,offset datarecord		;transmitter aufrufen
	mov	word ptr [si+input],di
	mov	word ptr [si+input+2],ds
	int	exec
	mov	si,offset datarecord		;ergebnis laden
	mov	ax,word ptr [si+output]
	cmp	ax,-1				;empfnger installiert?
	mov	dx,offset noreceiver
	mov	bl,2
	jz	main1
	call	displayword			;ergebnis anzeigen
	mov	al,0				;ok
	jmp	main2
main1:
	push	bx
	mov	ah,displaytext			;text anzeigen
	int	dos
	pop	ax
main2:
	mov	ah,terminate			;programm beenden
	int	dos
;
;==============================================================================
;
;	>	ax  -  16-bit-binrzahl
;
;------------------------------------------------------------------------------
;
displayword:
	push	ax				;16-bit-zahl anzeigen
	mov	al,ah
	call	displaybyte
	pop	ax
	jmp	displaybyte
;
;==============================================================================
;
;	>	al  -  8-bit-binrzahl
;
;------------------------------------------------------------------------------
;
displaybyte:
	push	ax				;8-bit-zahl anzeigen
	mov	cl,4
	ror	al,cl
	call	displaybyte1
	pop	ax
displaybyte1:
	and	al,0fh				;ascii-konversion
	cmp	al,10
	jb	displaybyte2
	add	al,'A'-('9'+1)
displaybyte2:
	add	al,'0'
	mov	dl,al				;ascii-ziffer anzeigen
	mov	ah,displaychar
	int	dos
	ret
;
;==============================================================================
;
;				     daten
;
;==============================================================================
;
input		equ	0			;offset: input-parameter
output		equ	4			;offset: output-parameter
;
datarecord:
	dd	0				;datenzeiger
	dw	0				;ergebnis
;
;------------------------------------------------------------------------------
;
notransmitter:
db cr,lf
db 'Das Transmitter-Modul WinRun-T ist nicht installiert.',cr,lf
db '$'
;
noreceiver:
db cr,lf
db 'Das Receiver-Modul WinRun-R ist nicht installiert.',cr,lf
db '$'
;
;==============================================================================
;
code	ends
	end	main
