/******************************************************************************
*           Winsock "WhoIs" Utility for Win32 - 2/95 by Mark Gamber           *
*                                                                             *
*
******************************************************************************/

#include "windows.h"
#include "winsock.h"

// === Function Prototypes ====================================================

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI AboutDlgProc( HWND, UINT, WPARAM, LPARAM );
DWORD WhoisUser( HWND );
DWORD GetServerList( HWND );
BOOL CopyListData( HWND );

// === Global Variables =======================================================

HINSTANCE hInst;

// === Application Entry Point ================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd,
                      int nShow )
{
   WNDCLASS wc;

   GetClassInfo( NULL, WC_DIALOG, &wc );          //  Get dialog box class info

   wc.hInstance = hInstance;
   wc.lpszClassName = "WINWHO32";                 //  so's we can superclass it
   wc.lpfnWndProc = DefDlgProc;               //  all this for an icon...sheesh
   wc.hIcon = LoadIcon( hInstance, MAKEINTRESOURCE( 100 ) );
   wc.cbWndExtra = DLGWINDOWEXTRA;

   if( ! RegisterClass( &wc ) )                  //  Quit if registration fails
      return( FALSE );

   hInst = hInstance;               //  Now just start the main dialog and exit
   DialogBox( hInstance, MAKEINTRESOURCE( 10000 ), NULL, MainDlgProc );
   return( FALSE );
}

// === Main Dialog Box ========================================================

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{  
   switch( msg )
   {
      case WM_INITDIALOG:
      {
         WSADATA wsad;
         char szServer[ 256 ];


         if( WSAStartup( 0x0101, &wsad ) )          //  Initialize sockets here
         {
            MessageBox( hDlg, "Sockets initialization failed!", "WinWho",
                        MB_OK | MB_ICONSTOP );
            EndDialog( hDlg, FALSE );
            return( TRUE );
         }

         SetProp( hDlg, "BRUSH",      //  Create a brush a save it for WM_PAINT
                  CreateSolidBrush( GetSysColor( COLOR_BTNFACE ) ) );
         SetProp( hDlg, "YELLOW", CreateSolidBrush( RGB( 255, 255, 0 ) ) );
                                           //  Get default server from INI file
         if( GetPrivateProfileString( "Server", "Server", 
                                      "whois.internic.net", szServer,
                                      256, "WINWHO.INI" ) )
            SetDlgItemText( hDlg, 102, szServer );     //  Plug into edit field
                                          //  Enable Horiz scrolling in listbox
         SendDlgItemMessage( hDlg, 101, LB_SETHORIZONTALEXTENT, 700, 0 );
         return( TRUE );
      }                                 //  End of MainDlgProc( WM_INITDIALOG )


      case WM_PAINT:              //  Paint dialog box background COLOR_BTNFACE
      {
         PAINTSTRUCT ps;
         HDC hDC;
         RECT Rect;

         hDC = BeginPaint( hDlg, &ps );
         GetClientRect( hDlg, &Rect );
         FillRect( hDC, &Rect, GetProp( hDlg, "BRUSH" ) );
         EndPaint( hDlg, &ps );
         break;
      }

      
      case WM_CTLCOLORSTATIC:       //  Paint static and groupbox COLOR_BTNFACE
      case WM_CTLCOLORBTN:
         SetBkMode( (HDC)wParam, TRANSPARENT );  
         return( (BOOL)GetProp( hDlg, "BRUSH" ) );


      case WM_CTLCOLOREDIT:
      case WM_CTLCOLORMSGBOX:
         SetBkMode( (HDC)wParam, TRANSPARENT );
         return( (BOOL)GetProp( hDlg, "YELLOW" ) );


      case WM_COMMAND:
         if( wParam == IDCANCEL )                          //  Time to go, huh?
         {
            char szServer[ 256 ];

                               //  Can't go anyplace if we're still in a thread
            if( ! IsWindowEnabled( GetDlgItem( hDlg, IDOK ) ) )
                break;

            WSACleanup();                          //  Else, close down sockets
            DeleteObject( GetProp( hDlg, "BRUSH" ) );        //  Kill our brush
            RemoveProp( hDlg, "BRUSH" );                  //  and it's property
            DeleteObject( GetProp( hDlg, "YELLOW" ) );
            RemoveProp( hDlg, "YELLOW" );
                                                   //  Save current server name
            GetDlgItemText( hDlg, 102, szServer, 256 );
            WritePrivateProfileString( "Server", "Server", szServer,
                                       "WINWHO.INI" );
            EndDialog( hDlg, TRUE );                   //  Close dialog to exit
            return( TRUE );
         }
         if( wParam == IDOK )                          //  If OK (Find) pressed
         {
            DWORD dwID;
                           //  Do nothing if disabled (This should never occur)
            if( ! IsWindowEnabled( GetDlgItem( hDlg, IDOK ) ) )
                break;
                                                   //  Start a WhoisUser thread
            CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)WhoisUser,
                          (LPVOID)hDlg, 0, &dwID );
            break;
         }
         if( wParam == 103 )                           //  Get list of servers?
         {
            DWORD dwID;

                                                   //  Not if it's already busy
            if( ! IsWindowEnabled( GetDlgItem( hDlg, IDOK ) ) )
                break;
                                            //  Start thread to get server list
            CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)GetServerList,
                          (LPVOID)hDlg, 0, &dwID );
            break;
         }
         if( wParam == 104 )
         {
            CopyListData( hDlg );
            break;
         }
         if( wParam == 105 )
         {
            DialogBox( hInst, MAKEINTRESOURCE( 10001 ), hDlg, AboutDlgProc );
            break;
         }
         break;
   }
   return( FALSE );
}                                                      //  End of MainDlgProc()

// ============================================================================

DWORD WhoisUser( HWND hDlg )
{
   struct hostent *phe;
   char szHost[ 256 ], szName[ 256 ], *pszBase, *pszNext;
   SOCKET s;
   SOCKADDR_IN sin;
   int iStatus;
   BYTE *bAddr;
   HANDLE hMem;
   char *szBuffer;
         
   
   if( ! SendDlgItemMessage( hDlg, 100, WM_GETTEXT, 256, (LPARAM)szName ) )
   {
      MessageBox( hDlg, "Nothing specified in Name field!", "WinWho",
                  MB_OK | MB_ICONEXCLAMATION );
      return( FALSE );
   }

   if( ! SendDlgItemMessage( hDlg, 102, WM_GETTEXT, 256, (LPARAM)szHost ) )
   {
      MessageBox( hDlg, "No WhoIs Server Specified (try Change)", "WinWho",
                  MB_OK | MB_ICONEXCLAMATION );
      return( FALSE );
   }

   EnableWindow( GetDlgItem( hDlg, IDOK ), FALSE );
   EnableWindow( GetDlgItem( hDlg, 103 ), FALSE );
   phe = gethostbyname( szHost );
   if( ! phe )
   {
      MessageBox( hDlg, "Unable to locate specified Server!", "WinWho",
                  MB_OK | MB_ICONEXCLAMATION );
      EnableWindow( GetDlgItem( hDlg, IDOK ), TRUE );
      EnableWindow( GetDlgItem( hDlg, 103 ), TRUE );
      return( FALSE );
   }

   s = socket( PF_INET, SOCK_STREAM, 0 );
   if( s != INVALID_SOCKET )
   {
      bAddr = *phe->h_addr_list;              //  Fill in connection data
      sin.sin_family = AF_INET;
      sin.sin_port = htons( IPPORT_WHOIS );
      sin.sin_addr.s_addr = *(LPDWORD)bAddr;
      iStatus = connect( s, (LPSOCKADDR)&sin, sizeof(SOCKADDR_IN) );

      if( iStatus != SOCKET_ERROR )         //  If host connection failed
      {
         hMem = GlobalAlloc( GHND, 32780 );
         szBuffer = GlobalLock( hMem );

         iStatus = send( s, szName, lstrlen( szName ), 0 );
         send( s, "\r\n", 2, 0 );

         while( 1 )
         {
            iStatus = recv( s, szBuffer + lstrlen( szBuffer ), 
                            32767 - lstrlen( szBuffer ), 0 );
            if( iStatus == 0 )
               break;
         }

         iStatus = lstrlen( szBuffer );
         if( iStatus )
         {
            SendDlgItemMessage( hDlg, 101, LB_RESETCONTENT, 0, 0 );
            pszBase = szBuffer;
            while( 1 )
            {
               pszNext = strchr( pszBase, '\r' );
               if( ! pszNext )
                  pszNext = strchr( pszBase, '\n' );

               if( pszNext )
               {
                  *pszNext = '\0';
                  ++pszNext;
                  if( *pszNext == '\n' )
                     ++pszNext;
               }
               
               SendDlgItemMessage( hDlg, 101, LB_ADDSTRING, 0, (LPARAM)pszBase );
               if( pszNext )
                  pszBase = pszNext;
               else
                  break;
            }
         }
         GlobalUnlock( hMem );
         GlobalFree( hMem );
      }
      closesocket( s );
   }
   EnableWindow( GetDlgItem( hDlg, IDOK ), TRUE );
   EnableWindow( GetDlgItem( hDlg, 103 ), TRUE );
   return( TRUE );
}

// ============================================================================

DWORD GetServerList( HWND hDlg )
{
   struct hostent *phe;
   char *pszBase, *pszNext;
   SOCKET s;
   SOCKADDR_IN sin;
   int iStatus;
   BYTE *bAddr;
   HANDLE hMem;
   char *szBuffer;
         
   
   phe = gethostbyname( "sipb.mit.edu" );
   if( ! phe )
      return( FALSE );
                                             //  Open a socket or die if unable
   s = socket( PF_INET, SOCK_STREAM, 0 );
   EnableWindow( GetDlgItem( hDlg, IDOK ), FALSE );
   EnableWindow( GetDlgItem( hDlg, 103 ), FALSE );
   if( s != INVALID_SOCKET )
   {
      bAddr = *phe->h_addr_list;              //  Fill in connection data
      sin.sin_family = AF_INET;
      sin.sin_port = htons( IPPORT_WHOIS );
      sin.sin_addr.s_addr = *(LPDWORD)bAddr;
      iStatus = connect( s, (LPSOCKADDR)&sin, sizeof(SOCKADDR_IN) );

      if( iStatus != SOCKET_ERROR )         //  If host connection failed
      {
         hMem = GlobalAlloc( GHND, 32780 );
         szBuffer = GlobalLock( hMem );

         send( s, "whois-servers\r\n", 15, 0 );

         while( 1 )
         {
            iStatus = recv( s, szBuffer + lstrlen( szBuffer ), 
                            32767 - lstrlen( szBuffer ), 0 );
            if( iStatus == 0 )
               break;
         }

         iStatus = lstrlen( szBuffer );
         if( iStatus )
         {
            SendDlgItemMessage( hDlg, 101, LB_RESETCONTENT, 0, 0 );
            pszBase = szBuffer;
            while( 1 )
            {
               pszNext = strchr( pszBase, '\r' );
               if( ! pszNext )
                  pszNext = strchr( pszBase, '\n' );

               if( pszNext )
               {
                  *pszNext = '\0';
                  ++pszNext;
                  if( *pszNext == '\n' )
                     ++pszNext;
               }
               
               SendDlgItemMessage( hDlg, 101, LB_ADDSTRING, 0, (LPARAM)pszBase );
               if( pszNext )
                  pszBase = pszNext;
               else
                  break;
            }
         }
         GlobalUnlock( hMem );
         GlobalFree( hMem );
      }
      closesocket( s );
   }
   EnableWindow( GetDlgItem( hDlg, IDOK ), TRUE );
   EnableWindow( GetDlgItem( hDlg, 103 ), TRUE );
   return( TRUE );
}

// ============================================================================

BOOL WINAPI AboutDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
         return( TRUE );

      case WM_COMMAND:
         if( wParam == IDOK || wParam == IDCANCEL )
         {
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         break;
   }
   return( FALSE );
}

// ============================================================================

BOOL CopyListData( HWND hDlg )
{
   HANDLE hMem;
   char *szBuffer;
   int iLines, iCount;

   iLines = SendDlgItemMessage( hDlg, 101, LB_GETCOUNT, 0, 0 );
   if( ! iLines )
      return( FALSE );

   if( ! OpenClipboard( hDlg ) )
      return( FALSE );

   EmptyClipboard();

   hMem = GlobalAlloc( GHND | GMEM_DDESHARE, 65535 );
   szBuffer = GlobalLock( hMem );
   *szBuffer = '\0';

   for( iCount = 0; iCount < iLines; iCount++ )
   {
      SendDlgItemMessage( hDlg, 101, LB_GETTEXT, iCount,
                          (LPARAM)szBuffer + lstrlen( szBuffer ) );
      lstrcat( szBuffer, "\r\n" );
   }
   GlobalUnlock( hMem );
   SetClipboardData( CF_TEXT, hMem );
   CloseClipboard();

   return( TRUE );
}

// ============================================================================
