(defun $d_err (msg)
	(if (/= msg "Function cancelled")
		(princ (strcat "\nError: " msg))
	)
	(setvar "BLIPMODE" $blip)
	(setvar "OSMODE" $osnap)
	(command "_.UNDO" "_E")
	(setvar "CMDECHO" $ehco)
	(setvar "CLAYER" $layer)
	(setq *error* olderr)
	(princ)
)

;;;---------------------- Main Program ---------------------

(defun init ()
	(setq olderr *error*)
	(setq $blip (getvar "BLIPMODE"))
	(setq $osnap (getvar "OSMODE"))
	(setq $ortho (getvar "ORTHOMODE"))
	(setq $echo (getvar "CMDECHO"))
	(setq $layer (getvar "CLAYER"))
	(command "_.UNDO" "_GROUP")
	(setvar "BLIPMODE" 0)
	(setvar "OSMODE" 0)
	(setvar "ORTHOMODE" 0)
	(setvar "CMDECHO" 0)
	(command "_.LAYER" "_M" "note" "_C" "4" "" "")
)

(defun c:item (/ pt1 pt2 text)
	(init)
	(setq pt1 (getpoint "\nPick arrow end of leader: ")
			pt2 (getpoint pt1 "\nPick bubble location: "))
	(command "pline" pt1 "w" "0" (* 0.04 (getvar "dimscale"))
		(polar pt1 (angle pt1 pt2)(* 0.12 (getvar "dimscale")))
		"_Width" "0" "0" 
		(polar pt2 (angle pt2 pt1)(* 0.1875 (getvar "dimscale"))) "")
	(command "circle" pt2 (* 0.1875 (getvar "dimscale")))
	(setq text (getstring "\nEnter item number: "))
	(command "text" "j" "m" pt2 (* 0.11 (getvar "dimscale")) "0" text)
	(setvar "BLIPMODE" $blip)
	(setvar "OSMODE" $osnap)
	(setvar "ORTHOMODE" $ortho)
	(command "_.UNDO" "_E")
	(setvar "CMDECHO" $echo)
	(setvar "CLAYER" $layer)
	(setq *error* olderr)
	(princ)
)
