
                            Revision 3.0 August 25,1992


      To all of my friends that I have spoken with throughout the world, I
 give you the final version of the DJ-580 handheld radio "Users Manual".
 I have sifted through this manual once again and restructured some areas while
 improving the index. You now have in your hands a manual that took over 250
 hours to prepare and maintain. This does not include the hundreds of telephone
 calls that I have taken collectively either at home or at work. I dedicate
 this manual to those amateurs who have spent long and endless hours trying to
 understand what their radio does. I would like to thank ALINCO ELECTRONICS for
 their support. Without this support there would be no manual. Finally, I would
 like to thank my family for their endless patience during this project.

                                About the Author

 Jay Appell, KA1SNA, brings a new style to amateur radio documentation. His
 conversational and personal style will put you, the "User" back into the
 "Users Guide". Jay was a member of the FCC Personal Users Radio Advisory
 Committee (PURAC).

 Jay started in radio broadcasting at the age of 11. His broadcast career
 extended through 1975 where he left for the field of computers. Jay joined
 Data General Corporation in 1978 where he worked as a field and systems
 technical support engineer. He left DGC in 1987 for Stratus Computer where he
 now works in the North American customer service center as a Senior Technical
 Support Engineer.

 Jay currently operates his own consultation company in Hopedale Massachusetts
 and consults with companies such as Alinco Electronics as a technical
 support writer and advisor.

 If you would like to drop Jay some electronic mail, send it to:

 Jay_Appell@cac.stratus.com
























                             Opening Page a

  1    INTRODUCTION. . . . . . . . . . . . . . . . . . . . . . .  1
       1.1  STANDARD ACCESSORIES . . . . . . . . . . . . . . . .  1
       1.2  OPTIONAL ACCESSORIES . . . . . . . . . . . . . . . .  1

  2    SPECIFICATIONS. . . . . . . . . . . . . . . . . . . . . .  2
       2.1  GENERAL SPECIFICATIONS . . . . . . . . . . . . . . .  2
       2.2  AMERICAN FREQUENCY COVERAGE. . . . . . . . . . . . .  2
       2.3  EUROPEAN FREQUENCY COVERAGE. . . . . . . . . . . . .  2
       2.4  TRANSMITTER SPECIFICATIONS . . . . . . . . . . . . .  3
       2.5  RECEIVER SPECIFICATIONS. . . . . . . . . . . . . . .  3
       2.6  BATTERY SPECIFICATIONS . . . . . . . . . . . . . . .  3
            2.6.1  EBP-20N BATTERY SPEC. . . . . . . . . . . . .  3
            2.6.2  EBP-22N BATTERY SPEC. . . . . . . . . . . . .  4
       2.7  GENERAL POWER READINGS . . . . . . . . . . . . . . .  4

  3    DESCRIPTIONS. . . . . . . . . . . . . . . . . . . . . . .  4
       3.1  FRONT PANEL CONTROLS/FUNCTIONS . . . . . . . . . . .  5
            3.1.1  LCD DISPLAY PANEL . . . . . . . . . . . . . .  5
            3.1.2  CONTROL KEYPAD. . . . . . . . . . . . . . . .  5
            3.1.3  MICROPHONE. . . . . . . . . . . . . . . . . .  5
            3.1.4  SPEAKER . . . . . . . . . . . . . . . . . . .  5
            3.1.5  VHF BAND KEY. . . . . . . . . . . . . . . . .  5
            3.1.6  UHF BAND KEY. . . . . . . . . . . . . . . . .  5
            3.1.7  SHIFT KEY . . . . . . . . . . . . . . . . . .  5
            3.1.8  STEP KEY. . . . . . . . . . . . . . . . . . .  6
            3.1.9  REV KEY . . . . . . . . . . . . . . . . . . .  7
            3.1.10 TONE KEY. . . . . . . . . . . . . . . . . . .  8
            3.1.11 PO KEY. . . . . . . . . . . . . . . . . . . .  8
            3.1.12 T.SQL KEY . . . . . . . . . . . . . . . . . .  9
            3.1.14 TMS KEY . . . . . . . . . . . . . . . . . . . 10
            3.1.15 APO KEY . . . . . . . . . . . . . . . . . . . 10
            3.1.16 DOWN ARROW AND FL/PL KEY. . . . . . . . . . . 11
            3.1.17 DUAL KEY. . . . . . . . . . . . . . . . . . . 11
            3.1.18 UP ARROW AND MESS KEY . . . . . . . . . . . . 12
            3.1.19 PRI/DIAL M KEY. . . . . . . . . . . . . . . . 12
            3.1.20 GP DSQ/DSQS KEY . . . . . . . . . . . . . . . 12
            3.1.21 SKIP/M TO V KEY . . . . . . . . . . . . . . . 12
            3.1.22 MR/MW KEY . . . . . . . . . . . . . . . . . . 13
            3.1.23 SCN/PS KEY. . . . . . . . . . . . . . . . . . 13
            3.1.24 CALL/CALL.W KEY . . . . . . . . . . . . . . . 14
            3.1.25 LAMP KEY. . . . . . . . . . . . . . . . . . . 14
            3.1.26 MONI/BS KEY . . . . . . . . . . . . . . . . . 14
       3.2  TOP PANEL CONTROLS/FUNCTIONS . . . . . . . . . . . . 15
            3.2.1  BNC ANTENNA CONNECTOR . . . . . . . . . . . . 15
            3.2.2  VHF VOLUME CONTROL. . . . . . . . . . . . . . 15
            3.2.3  VHF SQUELCH . . . . . . . . . . . . . . . . . 15
            3.2.4  POWER ON/OFF AND UHF VOLUME CONTROL . . . . . 15
            3.2.5  UHF SQUELCH . . . . . . . . . . . . . . . . . 15
            3.2.6  MAIN TUNING DIAL. . . . . . . . . . . . . . . 15
            3.2.7  SPEAKER JACK. . . . . . . . . . . . . . . . . 16
            3.2.8  MIC JACK. . . . . . . . . . . . . . . . . . . 16
            3.2.9  V.U.SPEAKER JACK. . . . . . . . . . . . . . . 16
       3.3  LEFT SIDE CONTROLS/FUNCTIONS . . . . . . . . . . . . 16
            3.3.1  FUNCTION KEY. . . . . . . . . . . . . . . . . 16
            3.3.2  PTT SWITCH. . . . . . . . . . . . . . . . . . 16
            3.3.3  BATTERY LOCK BUTTON . . . . . . . . . . . . . 17


                          Table of Contents Page b

       3.4  RIGHT SIDE CONTROLS/FUNCTIONS. . . . . . . . . . . . 17
            3.4.1  DC IN JACK. . . . . . . . . . . . . . . . . . 17
       3.5  LCD DISPLAY DESCRIPTIONS . . . . . . . . . . . . . . 17
            3.5.1  MEMORY CHANNEL. . . . . . . . . . . . . . . . 17
            3.5.2  BATTERY SAVE. . . . . . . . . . . . . . . . . 17
            3.5.3  TONE ENCODER/TONE SQUELCH . . . . . . . . . . 17
            3.5.4  PRIORITY/DUAL WATCH . . . . . . . . . . . . . 18
            3.5.5  AM. . . . . . . . . . . . . . . . . . . . . . 18
            3.5.6  SPLIT . . . . . . . . . . . . . . . . . . . . 18
            3.5.7  TIMER SCAN. . . . . . . . . . . . . . . . . . 18
            3.5.8  OUTPUT POWER. . . . . . . . . . . . . . . . . 18
            3.5.9  DIALER. . . . . . . . . . . . . . . . . . . . 18
            3.5.10 SHIFT . . . . . . . . . . . . . . . . . . . . 18
            3.5.11 DSQ . . . . . . . . . . . . . . . . . . . . . 18
            3.5.12 VHF . . . . . . . . . . . . . . . . . . . . . 18
            3.5.13 FREQUENCY INDICATOR . . . . . . . . . . . . . 18
            3.5.14 AUTO POWER OFF (APO). . . . . . . . . . . . . 18
            3.5.15 ON AIR. . . . . . . . . . . . . . . . . . . . 18
            3.5.16 S/RF. . . . . . . . . . . . . . . . . . . . . 19
            3.5.17 FREQUENCY DECIMAL POINT . . . . . . . . . . . 19
            3.5.18 TONE FREQUENCY DECIMAL POINT. . . . . . . . . 19
            3.5.19 PL (PTT LOCK) . . . . . . . . . . . . . . . . 19
            3.5.20 FL (FREQUENCY LOCK) . . . . . . . . . . . . . 19
            3.5.21 UHF . . . . . . . . . . . . . . . . . . . . . 19

  4    GETTING STARTED (RECEIVING) . . . . . . . . . . . . . . . 19
       4.1  KEY PAD DIRECT ENTRY . . . . . . . . . . . . . . . . 20
       4.2  STEP KEY . . . . . . . . . . . . . . . . . . . . . . 21
       4.3  CLEARING ENTRY . . . . . . . . . . . . . . . . . . . 22
       4.4  MONO BAND FUNCTION . . . . . . . . . . . . . . . . . 22

  5    TRANSMITTING. . . . . . . . . . . . . . . . . . . . . . . 22
       5.1  POWER OUTPUT SETTING . . . . . . . . . . . . . . . . 22
       5.2  LOW LEVEL BATTERY MODE . . . . . . . . . . . . . . . 23

  6    TRANSCEIVER MODES . . . . . . . . . . . . . . . . . . . . 23
       6.1  VFO MODE (Variable Frequency Oscillator) . . . . . . 23
       6.2  MEMORY MODE. . . . . . . . . . . . . . . . . . . . . 23
            6.2.1  PROGRAMMING A MEMORY CHANNEL (MW KEY) . . . . 23
            6.2.2  SCROLL MEMORY . . . . . . . . . . . . . . . . 24
            6.2.3  CANCELING A MEMORY CHANNEL. . . . . . . . . . 25
            6.2.4  ALLOCATION OF MEMORY CHANNELS . . . . . . . . 25
            6.2.5  MEMORY TO VFO COPY FUNCTION . . . . . . . . . 26
       6.3  CALL MODE. . . . . . . . . . . . . . . . . . . . . . 26
            6.3.1  PROGRAMMING THE CALL CHANNEL (W KEY). . . . . 26
            6.3.2  ACTIVATING CALL CHANNEL . . . . . . . . . . . 27
            6.3.3  CALL CHANNEL TO VFO COPY FUNCTION . . . . . . 27

  7    PRIORITY FUNCTIONS. . . . . . . . . . . . . . . . . . . . 27
       7.1  VFO PRIORITY . . . . . . . . . . . . . . . . . . . . 27
       7.2  MEMORY PRIORITY. . . . . . . . . . . . . . . . . . . 28
       7.3  CALL PRIORITY. . . . . . . . . . . . . . . . . . . . 28
       7.4  DUAL WATCH FUNCTION. . . . . . . . . . . . . . . . . 29
            7.4.1  VFO/MEMORY DUAL WATCH . . . . . . . . . . . . 29
            7.4.2  CALL/VFO DUAL WATCH . . . . . . . . . . . . . 30
            7.4.3  CALL/MEMORY DUAL WATCH. . . . . . . . . . . . 30


                          Table of Contents Page c

  8    SCANNING FUNCTIONS. . . . . . . . . . . . . . . . . . . . 30
       8.1  VFO SCAN . . . . . . . . . . . . . . . . . . . . . . 31
            8.1.1  PROGRAM BAND SCAN MODE (VFO MODE) . . . . . . 31
       8.2  MEMORY SCAN MODE . . . . . . . . . . . . . . . . . . 32
            8.2.1  MEMORY CHANNEL SKIP MODE. . . . . . . . . . . 33
       8.3  SCANNING TYPES . . . . . . . . . . . . . . . . . . . 33
       8.4  OTHER SCANNING INFORMATION . . . . . . . . . . . . . 33
            8.4.1  DUAL BAND SCAN. . . . . . . . . . . . . . . . 33
            8.4.2  DUAL BAND SCANNING WITH MEMORY PRIORITY . . . 34

  9    REPEATER OPERATIONS . . . . . . . . . . . . . . . . . . . 34
       9.1  SPLIT FREQUENCY FUNCTION . . . . . . . . . . . . . . 34
            9.1.1  VFO MODE SPLIT. . . . . . . . . . . . . . . . 34
            9.1.2  MEMORY MODE SPLIT . . . . . . . . . . . . . . 35
       9.2  REV KEY. . . . . . . . . . . . . . . . . . . . . . . 35
       9.3  RESETTING RADIO. . . . . . . . . . . . . . . . . . . 35
       9.4  CTCSS ENCODE/DECODE. . . . . . . . . . . . . . . . . 36

  10   AUTOPATCH OPERATION (AUTOMATIC DIALER). . . . . . . . . . 37
       10.1 PROGRAM AUTODIAL NUMBER. . . . . . . . . . . . . . . 37
       10.2 CLEAR DIALER MEMORY. . . . . . . . . . . . . . . . . 37
       10.3 CORRECTING CODES IN DIALER MEMORY. . . . . . . . . . 37
       10.4 TRANSMIT/CHANGE AUTODIAL NUMBER. . . . . . . . . . . 38
       10.5 MANUAL DIAL. . . . . . . . . . . . . . . . . . . . . 39
       10.6 DISABLE AUTODIAL . . . . . . . . . . . . . . . . . . 39
       10.7 DIALER RATE ADJUST . . . . . . . . . . . . . . . . . 39

  11   DIGITAL SQUELCH (DSQ) . . . . . . . . . . . . . . . . . . 40
       11.1 DSQ SCHEME . . . . . . . . . . . . . . . . . . . . . 40
       11.2 PROGRAMMING ALL DSQ CODES. . . . . . . . . . . . . . 41
       11.3 DSQ MODES. . . . . . . . . . . . . . . . . . . . . . 42
            11.3.1  TRANSMITTING (CODE SQUELCH). . . . . . . . . 43
            11.3.2  RECEIVING (CODE SQUELCH) . . . . . . . . . . 43
            11.3.3  TRANSMITTING (GROUP CALLING) . . . . . . . . 43
            11.3.4  RECEIVING (GROUP CALLING). . . . . . . . . . 44
            11.3.5  TRANSMITTING (PRIVATE CALLING IN A GROUP). . 44
            11.3.6  RECEIVING (PRIVATE CALLING IN A GROUP) . . . 44
            11.3.7  TRANSMITTING (PRIVATE CALL). . . . . . . . . 45
            11.3.8  RECEIVING (PRIVATE CALL) . . . . . . . . . . 45
       11.4 ERROR CODE . . . . . . . . . . . . . . . . . . . . . 45
       11.5 TIMING CONSIDERATIONS. . . . . . . . . . . . . . . . 45
       11.6 DSQ WILDCARDS  . . . . . . . . . . . . . . . . . . . 46
       11.7 DIGITAL SIGNAL MESSAGE . . . . . . . . . . . . . . . 46
            11.7.1  TRANSMITTING DIGITAL SIGNAL MESSAGE. . . . . 47
            11.7.2  RECEIVING DIGITAL SIGNAL MESSAGE . . . . . . 47
            11.7.3  TRANSMITTING WITH DIGITAL SIGNAL DISPLAYED . 47
            11.7.4  REVIEW DIGITAL SIGNAL MESSAGE MEMORY . . . . 47
            11.7.5  CLEARING MESSAGE MEMORY. . . . . . . . . . . 48

  12   CROSS BAND REPEATER . . . . . . . . . . . . . . . . . . . 48
       12.1 ACTIVATE CROSS BAND REPEATER . . . . . . . . . . . . 48
       12.2 DEACTIVATE CROSS BAND REPEATER . . . . . . . . . . . 48






                          Table of Contents Page d

  13   FULL DUPLEX OPERATION . . . . . . . . . . . . . . . . . . 49
       13.1 ENABLE SPEAKER FULL-DUPLEX . . . . . . . . . . . . . 49
       13.2 DISABLE SPEAKER SEMI-DUPLEX. . . . . . . . . . . . . 49

  14   AIRCRAFT RECEIVE MODIFICATION . . . . . . . . . . . . . . 50





















































                          Table of Contents Page e

   1      INTRODUCTION

          We at Alinco would like to thank you for purchasing the ALINCO
          DJ-580T (US Model)/DJ-580E (European Model). Radios and  other
          products made by ALINCO rank as  some finest in the world. Your
          DJ-580T/E has been  manufactured and tested very carefully at the
          factory and will give you satisfactory operation for many years. We
          are confident that you will be very satisfied with your choice of
          this fine ALINCO radio.

   1.1    STANDARD ACCESSORIES

          When you unpack your ALINCO transceiver, you will find the standard
          accessories which include:

          1. Ni-Cad Battery Pack (7.2V @ 700mAH).EBP-20N
          2. AC Wall Charger..(120V)DJ-580/T.....EDC-24
          3. Belt Clip
          4. Hand Strap
          5. Dual Band Rubber Flex Antenna
          6. Schematic Diagram
          7. Instruction Manual
          8. Warranty registration card

   1.2    OPTIONAL ACCESSORIES

          To enhance your DJ-580 radio further, optional accessories are
          available. At ALINCO, we strongly recommend that you purchase
          appropriate accessories to get full features and performance from
          your radio.

          1. Ni-Cad Battery Pack (7.2V @ 700mAH).EBP-20N
          2. Ni-Cad Battery Pack (12V @ 700mAH) .EBP-22N
          3. Dry Cell (6-AA) Pack . . . . . . . .EDH-6
          4. Quick Ni-cad battery charger . . . .EDC-34
          5. Mobile DC Power Cable/Noise Filter .EDC-36
                               w/o Noise Filter .EDC-43
          6. Earphone . . . . . . . . . . . . . .EME-6
          7. DC cable for power supply. . . . . .EDC-37
          8. Earphone/Earphone. . . . . . . . . .EME-6
          9. Earphone/Microphone w PTT. . . . . .EME-11
         10. Speaker/Microphone . . . . . . . . .EMS-2Z
        *11. Remote Control Speaker/Microphone. .EMS-8Z
         12. Headset with PTT/VOX . . . . . . . .EME-10K
         13. Soft Case. . . . . . . . . . . . . .ESC-17 for EBP-20N or EDH-6
         14. Tone Squelch Unit. .(580-E). . . . .EJ-12U

          * =  This Speaker/Mic has 3 keys. One key is marked with an up
               arrow, another with a down arrow. These are used to
               increment and decrement frequency or memory channel. The
               last key is labeled "A" and toggles between the memory
               and VFO function.






                                     Page 1

   2      SPECIFICATIONS

          The specifications outlined for this product are for use in the
          amateur bands only. No guarantee or warranty, either specific   or
          implied, will apply to any function or specification outside the
          amateur bands. Individual radios may experience different
          performance and/or specification levels. All specifications and
          features are subject to change without notice or obligation.

   2.1    GENERAL SPECIFICATIONS

          Channel Spacing:             5, 10, 12.5, 15, 20, 25 KHz
                                       steps
          Memory Channels:             42 Channels (20 VHF, 20 UHF)
                                        1 VHF Call Channel
                                        1 UHF Call Channel
          Antenna Impedance:           50 Ohms unbalanced
          Microphone Input Impedance:  2K Ohms
          Signal Type:                 F3
          Power Supply Requirements:   13.8 Volts DC
          Dimensions (Radio Only):
                                       Height =  140mm  (4 1/8")
                                       Width  =   58mm  (2 1/2")
                                       Depth  =   33mm  (1 1/2")
          Weight:                      Approximately 410g
          DTMF:                        16 Button Key Pad
          Subaudible Tones:            Encode and Decode installed

   2.2    AMERICAN FREQUENCY COVERAGE

          The frequency coverage listed as follows applies to the DJ-580T.

          VHF Band:     144.000 - 147.995 MHz  (TX)
                        130.000 - 173.995 MHz  (RX)
                        110.000 - 173.995 MHz  (RX)* Only after Modification
          UHF Band:     440.000 - 449.995 MHz  (TX)
                        420.000 - 479.995 MHz  (RX)
                       *850.000 - 975.000 MHz  (RX)* Only after Modification

          * Band coverage may vary. Refer to subsection 3.5.18 for more
            information on the "tone frequency decimal point".

   2.3    EUROPEAN FREQUENCY COVERAGE

          The frequency coverage listed as follows applies to the DJ-580E.

          VHF Band:     144.000 - 145.995 MHz  (TX)
                        130.000 - 173.995 MHz  (RX)
                        130.000 - 173.995 MHz  (RX)* Only after Modification
          UHF Band:     430.000 - 439.995 MHz  (TX)
                        420.000 - 479.995 MHz  (RX)
                       *850.000 - 975.000 MHz  (RX)* Only after Modification

          * Band coverage may vary. Refer to subsection 3.5.18 for more
            information on the "tone frequency decimal point".



                                     Page 2

   2.4    TRANSMITTER SPECIFICATIONS

          Output Power:           2 Watts with Standard EBP-20N Battery
                                  5 Watts with Optional EBP-22N Battery
          Modulation System:      Variable reactance FM
          Max. Freq. Deviation:   +/- 5KHz
          Spurious Emission:      Less than 60dB below carrier

          Tone Frequency:         67.0 to 250.3 Hz (38 selections)
                                  DJ-580T (Subaudible Encoding Tone)
                                  DJ-580E (1,750 Hz Tone Burst)
          Microphone:             Electret Condenser
          Operating Mode:
                         Simplex:
                          Duplex: 5KHz steps minimum between 0-15.995 MHz
                                  from receiver frequency.
          CTCSS Encoder:          Built-in and included as standard
          CTCSS Decoder:          Built-in and included as standard

   2.5    RECEIVER SPECIFICATIONS

          Receiver System:        Superheterodyne, Dual Conversion
          Sensitivity:            12dB SINAD less than - 15dB per microvolt
          Intermediate Frequency: VHF - 1st IF 55.05 MHz
                                        2nd IF 455 KHz
                                  UHF - 1st IF 23.05 MHz
                                        2nd IF 455 KHz
          Audio Power Output:     250 mw (10% Total Harmonic Distortion)
          Speaker Impedance:      8 Ohms

   2.6    BATTERY SPECIFICATIONS

          The "PO" function selects output power levels. The transmitter
          output power is determined by battery type and output power
          setting.

   2.6.1  EBP-20N BATTERY SPEC

          The EBP-20N is supplied with your radio when purchased.

                                                PO FUNCTION
                                          -----------------------------
          Battery Capacity:               700 mAh
          Output Voltage:                 7.2 Volts
          PO (Power Output function):     L - 0.25 Watt  output power
                                          M - 1.00 Watt  output power
                                          H - 2.50 Watts output power

          Charge Times and Chargers:      EDC-34 (120V) Approx.  1 Hour
                                          EDC-35 (220V) Approx.  1 Hour
                                          EDC-24 (120V) Approx. 14 Hours
                                          EDC-25 (220V) Approx. 14 Hours

          Charging Temperature:           0 to +45 Degrees C
          Storage Temperature:            -20 to +45 Degrees C



                                     Page 3

   2.6.2  EBP-22N BATTERY SPEC

          The EBP-22N is supplied with your radio when purchased.

                                                PO FUNCTION
                                          -----------------------------
          Battery Capacity:               700 mAh
          Output Voltage:                 12.0 Volts
          PO (Power Output function):     L - 0.25 Watt  output power
                                          M - 1.00 Watt  output power
                                          H - 5.00 Watts output power

          Charge Times and Chargers:      EDC-34 (120V) Approx. 1.8 Hours
                                          EDC-35 (220V) Approx. 1.8 Hours
                                          EDC-24 (120V) Approx. 14 Hours
                                          EDC-25 (220V) Approx. 14 Hours

          Charging Temperature:           0 to +45 Degrees C
          Storage Temperature:            -20 to +45 Degrees C

   2.7    GENERAL POWER READINGS

          The author of this manual has made these power readings available
          to you because of general interest. These readings are approximate
          and should be treated as such.

          Baseline:   7.2 Volt Pack = 8.50 Fresh Charge

          Note: All Ratings are in Milliamps and are approximated.

                                             Low High
                                             --- -----
              VHF Only UHF Muted............  58-65 ma
              UHF Only VHF Muted............  54-57 ma
              Both bands active............. 100-105ma

          The following ratings are approximated and based on Both bands
          active.
                                           Item rating   Total Reading
                                            Low  High    Low   High
                                           ----------- ---------------
            Any Key pressed...............   3 -  5 ma   103 - 109 ma
            LMP (Lamp On).................  56 - 61 ma   156 - 162 ma
            Squelch open (No volume)......  10 - 15 ma   110 - 119 ma
            Squelch open (Full Volume)....  70 - 77 ma   170 - 181 ma
            Function Button Pressed.......  .3 - .5 ma   100.3-104.5ma
            Battery Saver (Deduction).....  35 - 70 ma     Erratic

   3      DESCRIPTIONS

          This section will discuss what the function or control is and how
          to use it. The subsections are broken down into smaller sections
          for easy access.





                                     Page 4


  3.1    FRONT PANEL CONTROLS/FUNCTIONS

          The following descriptions are those functions necessary to utilize
          full functionality of the DJ/580T/E.

   3.1.1  LCD DISPLAY PANEL

          Refer to Section 3.5 for further details on the LCD display panel.

   3.1.2  CONTROL KEYPAD

          The control pad includes 16 multi-functional command keys that
          control and execute various operations for the DJ-580T/E. It also
          serves as a DTMF keypad.

   3.1.3  MICROPHONE

          An electret condenser microphone is built into the front panel.
          When transmitting, speak directly into the microphone from a
          distance of approximately 5 inches. The speaker/microphone
          connectors are labeled as follows:

               Smaller Jack
               (MIC JACK):          Tip: PTT Line/Transmit Audio
                                    Ring: 5VDC (for EME-10K option)
                                    Sleeve: Signal Ground

               Larger Jack
               (SPEAKER JACK):      Tip: Receive Audio
                                    Ring: Remote Control (for EMS-8 option)
                                    Sleeve: Signal Ground

          If you decide to use the V.U.SP jack while using the SPeaker jack,
          the VHF audio will not be heard. The VHF audio is routed through
          the V.U.SP jack.

   3.1.4  SPEAKER

          The speaker is located below the key pad on the front panel. It's
          rated at 8 ohms and not in operation when an external speaker is
          used.

   3.1.5  VHF BAND KEY

          Pressing this key allows for operation on the 2 meter VHF band.

   3.1.6  UHF BAND KEY

          Pressing this key allows for operation on the 70 cm UHF band.

   3.1.7  SHIFT KEY

          The SHIFT KEY is used to change frequency offset and shift. The
          symbols - , + and star symbol are used to indicate shifts.



                                     Page 5

            1. Press and hold the FUNC key, then press the SHIFT key
               repeatedly until the desired shift appears on the LCD display.

                 The - symbol indicates that the transmitter will subtract
                  the offset with the transmitted frequency.

                  The + symbol indicates that the transmitter will add the
                  offset with the transmitted frequency.

                  The star symbol indicates a split offset. Refer to Section
                  9.1 for more information.

                  Simplex operation is active when neither the - or + or star
                  symbol is displayed on the LCD display. If OFF appears in
                  place of the frequency during transmit, the selected
                  frequency is out-of-band.

            2. Select the Active Band by pressing the VHF or UHF key. The LCD
               display returns to frequency.

                                     *** NOTE ***

               For larger incremental frequency changes press and hold the
               FUNC key then rotate the Main Tuning dial. This increments the
               1MHZ digit.

               Amateur radio repeaters utilize separate transmitter and
               receiver sections. The transmitter frequency may be offset
               either above or below the receive frequency according to
               repeater coordination conventions. The standard offset for the
               2 meter band is 600 Khz. Offset for the 70cm band is 5 Mhz.
               Offset direction varies according to established band
               plans.

               EXAMPLE: SHIFT

               1. Select the Active Band by pressing the VHF or UHF key.

               2. Press and hold the FUNC key, then press the SHIFT key. An
                  offset will be displayed on the LCD display.

               3. Rotate the Main Tuning dial or press either arrow key to
                  select the desired offset. For larger incremental frequency
                  changes, press the FUNC key then rotate the Main Tuning
                  dial.

               4. Select the Active Band by pressing the VHF or UHF key or
                  PTT key to complete offset procedure.

                        DJ-580T                DJ-580E

                  VHF:  600 Khz (0.60)   VHF:  600 Khz (0.60)
                  UHF:    5 Mhz (5.00)   UHF:  7.6 Mhz (7.60)

   3.1.8  STEP KEY

          The STEP function is used to select desired incremental changes of

                                     Page 6

          receive/transmit frequencies, in steps of 5, 10, 12.5, 15, 20 or
          25Khz. Get more information on "GETTING STARTED" in section 4. The
          step rate changes when in other frequency regions (See Aircraft
          Receive Modification).

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press and hold the FUNC key, then press the STEP key. The
               channel step will change each time the STEP key is pressed.
               You can also change the channel step by using the Main Tuning
               dial, UP ARROW or DOWN ARROW keys.

            3. Select the Active Band by pressing the VHF or UHF key to set
               channel step and return to operating frequency.

               After channel step is set, the receive/transmit frequency will
               increase or decrease by the value selected when you turn the
               Main Tuning dial.

               When the transmit frequency extends beyond permissible limits,
               Off will be displayed on the LCD display. The transmitter will
               not transmit when Off is displayed. Refer to the following
               OFFSET frequency chart (TABLE 1) before you actually transmit.
               The transmitting frequency may differ from the frequency that
               appears on the LCD display.

                 LCD DISPLAY FREQUENCY       ACTUAL FREQUENCY

                  ***.*02.5 Khz               ***.*00.0 Khz
                  ***.*07.5 Khz               ***.*05.0 Khz
                  ***.*17.5 Khz               ***.*15.0 Khz
                  ***.*22.5 Khz               ***.*20.0 Khz
                  ***.*27.5 Khz               ***.*25.0 Khz
                  ***.*32.5 Khz               ***.*30.0 Khz
                  ***.*42.5 Khz               ***.*40.0 Khz
                  ***.*47.5 Khz               ***.*45.0 Khz
                  ***.*52.5 Khz               ***.*50.0 Khz
                  ***.*57.5 Khz               ***.*55.0 Khz
                  ***.*67.5 Khz               ***.*65.0 Khz
                  ***.*72.5 Khz               ***.*70.0 Khz
                  ***.*77.5 Khz               ***.*75.0 Khz
                  ***.*82.5 Khz               ***.*80.0 Khz
                  ***.*92.5 Khz               ***.*90.0 Khz
                  ***.*97.5 Khz               ***.*95.0 Khz

                        TABLE 1 OFFSET FREQUENCY CHART

   3.1.9  REV KEY

          The REV key allows instant reversal of the REV function is also
          useful to check the repeater input to determine if another station
          is heard directly so you can go simplex. To activate the REV
          function:

            1. Press and hold the FUNC key, then press the REV key. The
               repeater input frequency and opposite SHIFT indicator will
               appear on the LCD display panel.

                                     Page 7

            2. Press and hold the FUNC key, then press the REV key again to
               cancel the REV function.

            If the REV key is pressed and a beep is heard with no change, the
            frequency would have been out of band and no change will take
            place. The beep won't be heard through the speaker if it has been
            turned off. See Section 9.2 for more information.

   3.1.10 TONE KEY

          The Tone Encoder and Tone (Decoder) Squelch function is  standard
          on the DJ-580T/E. Tone Encode and Decode work on the Active Band
          only. The DJ-580T/E has 38 settings from 67.0 hz to 250.3 hz (TABLE
          2). Utilize the TONE key to access these settings. Access to an
          increasing number of repeaters is restricted by requiring that a
          sub-audible tone be transmitted with the input signal to open the
          repeater. To select the needed tone, perform the following:

            1. Press and hold the FUNC key, then press the TONE key. A tone
               frequency will appear in the LCD display.

            2. Rotate the Main Tuning dial or either the UP ARROW or DOWN
               ARROW key to the desired tone frequency.

            3. Select the Active Band by pressing the VHF or UHF key.

            4. The tone has now been selected, now you need to enable it.
               Press the T.SQL key.

               Refer to section 9.4 for more information.

                            Sub-Audible Tone Chart
                   ========================================
                    67.0   71.9   74.4   77.0   79.7   82.5
                    85.4   88.5   91.5   94.8   97.4  100.0
                   103.5  107.2  110.9  114.8  118.8  123.0
                   127.3  131.8  136.5  141.3  146.2  151.4
                   156.7  162.2  167.9  173.8  179.9  186.2
                   192.8  203.5  210.7  218.1  225.7  233.6
                   241.8  250.3

                           TABLE 2 SUB-AUDIBLE TONES

   3.1.11 PO KEY

          Change power output levels by performing the following.

            1. Press and hold the FUNC key, then press the PO key repeatedly
               to obtain the desired output power.

               When H is displayed it means that the output power is at
               maximum/high for battery rating. When M is displayed it means

               that the output power is at mid range for battery rating. When
               L is displayed it means that the output power is at the lowest
               range for battery rating. Refer to the battery specifications
               for more on output levels.

                                     Page 8

                                *** WARNING ***

               It is possible to cause UHF receive interference while
               transmitting on VHF. To avoid this from happening, make sure
               that the VHF frequency x 3 does not equal the frequency on
               UHF. For example, if VHF transmit frequency is 146.190 the UHF
               frequency should not be set at 438.570.

   3.1.12 T.SQL KEY

          The Tone Encoder and Tone (Decoder) Squelch function is standard on
          the DJ-580T/E. Tone Encode and Decode works on the Active Band
          only. In other words, it is expected that you can only speak on one
          band at a time. When changing over to the other band, another tone
          may be used. Further clarification is made in the cross band repeat
          section. The DJ-580T/E has 38 settings from 67.0 hz to 250.3 hz
          (TABLE 3). Utilize the TONE key to access these settings. Access to
          an increasing number of repeaters is restricted by requiring that a
          sub-audible tone be transmitted with the input signal to open the
          repeater. In the following examples, it is presumed that you are
          learning how to operate the Tone Encode/Decoder for the first time.

          Selecting Tone Encoding

            1. Press and hold the FUNC key, then press the TONE key. A tone
               frequency will appear in the LCD display.

            2. Rotate the Main Tuning dial or either the UP ARROW or DOWN
               ARROW key to the desired tone frequency.

            3. Select the Active Band by pressing the VHF or UHF key.

            4. Press and hold the FUNC key, then press the T.SQL key. A white
               lettered T in a black box will appear on the top left-hand
               side of the LCD display. This indicator means that you have
               enabled subaudible tone encoding.

          Selecting Tone Decoding

            1. Press and hold the FUNC key, then press the TONE key. A tone
               frequency will appear in the LCD display.

            2. Rotate the Main Tuning dial or either the UP ARROW or DOWN
               ARROW key to the desired tone frequency.

            3. Select the Active Band by pressing the VHF or UHF key.

            4. Press and hold the FUNC key, then press the T.SQL key. A white
               lettered T in a black box will appear on the top left-hand
               side of the LCD display. This indicator means that you have
               enabled subaudible tone encoding.

            5. Press and hold the FUNC key, then press the T.SQL key. The
               letters SQL will appear to the right of the T indicator just
               mentioned in step 4. When T and SQL display, then tone squelch
               or tone decoding is enabled.


                                     Page 9

            The tone frequency is now stored and will be transmitted with the
            repeater input frequency.

                            Sub-Audible Tone Chart
                   ========================================
                    67.0   71.9   74.4   77.0   79.7   82.5
                    85.4   88.5   91.5   94.8   97.4  100.0
                   103.5  107.2  110.9  114.8  118.8  123.0
                   127.3  131.8  136.5  141.3  146.2  151.4
                   156.7  162.2  167.9  173.8  179.9  186.2
                   192.8  203.5  210.7  218.1  225.7  233.6
                   241.8  250.3

                           TABLE 3 SUB-AUDIBLE TONES

   3.1.13 BEEP KEY

          When the BEEP is on, each key pressed will sound a BEEP.

            1. Press and hold the FUNC key, then press the BEEP key. Each
               time the BEEP key is pressed the speaker will emit a high or
               low pitch tone. If the tone is high pitch, the BEEP is
               disabled, if low it is enabled.

            The BEEP function, when set, will be activated on both bands. The
            BEEP will sound only if the BEEP function is on.

            The radio comes preset with a low/soft beep audio level. If you
            would like to increase this level to high, perform the following.

            1. Press and hold the FUNC key, then press the * key. The LCD
               will display FL.

            2. Press and hold the FUNC key, then press the STEP key. The
               display will indicate bEEPH, for beep tone high level audio.

            3. Press and hold the FUNC key, then press the STEP key. The
               display will indicate bEEPL, for beep tone low level audio.

            4. Press and hold the FUNC key, then press the * key three (3)
               times to clear FL/PL from the display and exit beep tone level
               mode.

   3.1.14 TMS KEY

          This key is used to select 1 of 3 scan modes. Refer to section 8.3
          for more information.

   3.1.15 APO KEY

          The APO key is used to Automatically Power Off the radio. Using
          this function prevents inadvertent waste of battery power when the
          radio is left ON unintentionally. Here's how to use it.

            1. Press and hold the FUNC key, then press the APO key. You will
               see APo 30 displayed.


                                    Page 10

            2. The time of 30 minutes is preset from the factory. The time
               duration can be selected by rotating the Main Tuning Dial. The
               time is adjustable from 5 to 60 minutes.

            3. Press and hold the FUNC key, then press the APO key. A beep
               will be heard and the APO indicator will display on the LCD.
               If there is no activity within the time you have specified, a
               series of beeps will be heard, 30 seconds later the LCD will
               become blank. Battery power has now been removed from the
               radio. To re-initialize APO, turn the radio off and back on
               again.

            4. Exit the APO function, select the Active Band by pressing the
               VHF or UHF key. The APO indicator should still be displayed on
               the LCD.

            5. To cancel APO, press and hold the FUNC key, then press the APO
               key 2 times. The APO indication should now disappear from the
               display. Exit the APO function, select the Active Band by
               pressing the VHF or UHF key.

            Any signal received during the APO time period, APO resets back
            to the beginning.

   3.1.16 DOWN ARROW AND FL/PL KEY

          The DOWN ARROW toggles different values depending on what task you
          are utilizing. It is often used to decrease VFO frequency value. If
          this key is held down, the value will decrease continuously.

            FL stands for Frequency Lock. In this mode the main keypad,
            SCN/PS and CALL/W keys are locked and don't function.

            PL stands for Push To Talk Lock. In this mode both bands are
            locked from the Push to Talk switch. Frequencies can still be
            entered and stored.

          These are useful features to prevent unauthorized functioning while
          the radio is in unattended monitoring mode. Here's how to use these
          features.

            1. Press and hold the FUNC key, then press the FL/PL key. Each
               time you press the key, you will toggle the field which will
               be displayed as follows: FL, PL then FL and PL and finally
               both functions disabled.

   3.1.17 DUAL KEY

          This function is used to monitor two particular channels. The
          possibilities are:

               o VFO and MEMORY channels
               o VFO and CALL channels
               o VFO and VFO channels
               o CALL and MEMORY channels



                                    Page 11

          In other words, dual channel monitoring will listen to two
          channels. Here's how to make it happen for VFO and MEMORY. You can
          incorporate the same procedure with the other possibilities of DUAL
          WATCH.

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press the MR key. Select the desired memory channel by using
               the Main Tuning Dial.

               The 2 digit memory channel number will blink if it hasn't been
               programmed. More on memory channel programming can be found in
               section 6.2.

            3. Return to VFO Mode and enter a VFO frequency.

            4. Press and hold the FUNC key, then press the DUAL key. The PRI
               indicator will now blink on and off on the display. The radio
               will cycle alternately between VFO frequency and Memory
               frequency for 1/2 second.

            5. When a signal is received, the signal is held for 5 seconds.

            6. To release the DUAL/WATCH function, press the PRI or chosen
               VFO key.

   3.1.18 UP ARROW AND MESS KEY

          The UP ARROW toggles different values depending on what task you
          are utilizing. It is often used to increase VFO frequency value. If
          this key is held down, the value will increase continuously.

          The MESS key is used for Digital Signal messages. Refer to section
          11.7.

   3.1.19 PRI/DIAL M KEY

          PRI stands for Priority. When the PRI key is pressed the priority
          function is active.

          The DIAL M key is used for storing and automatically transmit a
          sequence of numbers/codes. This would be commonly used for
          autopatch use. Refer to section 10 for more information.

   3.1.20 GP DSQ/DSQS KEY

          This key is used in conjunction with DTMF squelch control. More
          information can be found in section 11.

   3.1.21 SKIP/M TO V KEY

          The SKIP key is used to skip selected memory channels during a
          memory scan.

          The M to V function of this key is used to copy information from a
          memory location into the VFO.


                                    Page 12

   3.1.22 MR/MW KEY

          MR stands for Memory Read. This function is used to examine what
          information is in a memory channel.

          MW stands for Memory Write. This function is used to write/store
          frequencies and features into a memory channel. Refer to section
          6.2 on for more information.

            1. Press the MR key to put the Active Band into Memory Channel
               mode. A 2 digit memory channel number (0-19) will appear.
               These 2 digits will flash if nothing has been programmed into
               the memory channel.

            2. Pressing the SCN key will increment each programmed memory
               channel one at a time. Use the Main Tuning Dial to either
               increment or decrement scanning.

   3.1.23 SCN/PS KEY

          The SCN key is used to continually scan frequencies in VFO or
          memory mode. Press the key down for approximately one second and
          scan will begin. Scan is active by virtue of the flashing decimal
          point, just right of the 1 megahertz digit. To cease scan, press
          the SCN key once again.

          PS stands for Programmable Scan. This is used when you want to scan
          a range of frequencies. You may scan a range of frequencies on VHF
          and perform the same for UHF at the same time. Here is how it
          works.

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Now enter the lower range frequency via the keypad.

            3. Press the MR key. Rotate the Main Tuning Dial and select
               memory channel P1.

            4. Press and hold the FUNC key, then press the MW key. A beep
               will sound from the speaker and memory channel P1 will stop
               blinking. P1 has been successfully programmed with the lower
               frequency.

            5. Now enter the higher range frequency via the keypad.

            6. Press the MR key. Rotate the Main Tuning Dial and select
               memory channel P2.

            7. Press and hold the FUNC key, then press the MW key. A beep
               will sound from the speaker and memory channel P2 will stop
               blinking. P2 has been successfully programmed with the upper
               frequency.

            8. Select the Active VFO band as you did in step 1.




                                    Page 13

            9. Press and hold the FUNC key, then press the PS key. The
               display will show scanning of ranges programmed between P1 and
               P2. The P indicator should begin to blink on the LCD display.

           10. Exit programmable scan, select the Active Band by pressing the
               VHF or UHF key or SCN key.

               If you are scanning (SCN) or manually tuning, consider the
               following.

               o  When passing a 500KHz boundary, a single beep will be heard
                  through the speaker.

               o  When incrementing frequencies past a 1MHz boundary, a low
                  beep followed by a high beep will be heard through the
                  speaker.

               o  When decrementing frequencies past a 1MHz boundary, a high
                  beep followed by a low beep will be heard through the
                  speaker.

               o  The Battery Saver feature will not function when in the SCN
                  function, even though the BS indicator is displayed on the
                  LCD.

   3.1.24 CALL/CALL.W KEY

          Each band has 1 Call channel which is immediately accessible by
          pressing the CALL key. An often used frequency of interest such as
          a preferred local repeater, is usually programmed into the Call
          channel.

          The CALL key is used to gain access to the CALL channel.

          The CALL.W key is used to write information into the CALL channel.

               Refer to section 6.3 for more information.

   3.1.25 LAMP KEY

          The lamp key allows you to read the display at night, or those
          areas where it is difficult to read the LCD display.

            1. Press the LAMP key to illuminate the LCD display. The lamp
               goes out automatically after five seconds.

            2. If you wish for the lamp to remain on, press and hold the FUNC
               key, then press the LAMP key.

   3.1.26 MONI/BS KEY

          MONI is short for the word MONITOR or SQUELCH OPEN. Activate this
          feature as follows:

            1. Press and hold the MONI key to override the squelch on the
               band selected. In this mode, weak signals below the squelch
               threshold may be heard.

                                    Page 14

               BS is short for Battery Saver. The battery saver feature
               reduces unnecessary battery drain by alternating between
               listening and the Battery Saver mode. If there is no operation
               for a period of 5 seconds the BS mode will listen for a signal
               for approximately 130 ms then Battery Save for approximately
               390 ms. This cycle is repeated continuously. Perform the
               following to activate or deactivate Battery Save feature. You
               can set this function in VHF or UHF or both bands together.

            1. To activate battery save feature, press and hold the FUNC key,
               then press the BS key until the symbol S is displayed.

            2. To deactivate battery save feature, press and hold the FUNC
               key, then press the BS key until the S disappears.

                                 *** NOTE ***

               Battery Saver is not active during SCN function, even though
               the S indicator is displayed on the LCD.

   3.2    TOP PANEL CONTROLS/FUNCTIONS

          The following section describes the controls that are located on
          the top panel.

   3.2.1  BNC ANTENNA CONNECTOR

          You should attach a suitable Dual-Band antenna that will yield a
          low SWR. The antenna connected should satisfy both the 2 meter and
          70 cm (440MHz) band.

   3.2.2  VHF VOLUME CONTROL

          Adjusts the VHF audio level. Rotate control clockwise to increase
          volume , and counter clockwise to decrease.

   3.2.3  VHF SQUELCH

          Start by turning the knob fully counter clockwise, then rotate the
          knob back clockwise until background noise is silent.

   3.2.4  POWER ON/OFF AND UHF VOLUME CONTROL

          Power is not applied to the radio when the POWER knob is fully
          counter clockwise. When the POWER knob is rotated clockwise, power
          is applied to the radio and volume for the UHF band may be
          adjusted.

   3.2.5  UHF SQUELCH

          Start by turning the knob fully counter clockwise, then rotate the
          knob back clockwise until background noise is silent.

   3.2.6  MAIN TUNING DIAL

          Press the VHF or UHF key to select the Active Band. The Main Tuning
          dial may be rotated in either direction to select transmit and

                                    Page 15

          receive frequencies, frequency steps, subaudible tones and transmit
          frequency offsets. The frequency will increase/decrease by one MHz
          depending on the direction of the tuning dial rotation.

   3.2.7  SPEAKER JACK

          An external speaker rated at 8 ohms may be plugged into this jack.
          The built-in speaker is disabled when an external speaker is
          plugged into this jack.

          If you decide to use the V.U.SP jack while using the SPeaker jack,
          the VHF audio will not be heard. The VHF audio is routed through
          the V.U.SP jack.

   3.2.8  MIC JACK

          An external microphone may be plugged into this jack.

   3.2.9  V.U.SPEAKER JACK

          The DJ-580T/E features an external 1/8" stereo jack that makes
          accessible the audio supplied from each band (UHF/VHF). When a
          stereo headset is used, each band is heard separately, in each
          earphone. Separate external speakers may be plugged into this jack
          by using a mini dual stereo adapter plug. Volume from the VHF band
          will be heard on the left channel and UHF will be heard on the
          right channel. It is advisable to use the SPeaker jack when using a
          mono plug.
                                 *** NOTE ***

          When this jack is in use, the speaker jack located on the top of
          the radio will be disabled.

          If you decide to use the V.U.SP jack while using the SPeaker jack,
          the VHF audio will not be heard. The VHF audio is routed through
          the V.U.SP jack.

   3.3    LEFT SIDE CONTROLS/FUNCTIONS

          The following controls are located on the left side of the radio as
          viewed with front panel facing the operator.

   3.3.1  FUNCTION KEY

          Controls access to secondary functions. These secondary functions
          are those functions printed in green on the front panel. It is
          necessary to activate the function key to access these secondary
          functions. While holding the FUNC key, press the desired command
          key.

   3.3.2  PTT SWITCH

          Press and hold this button to transmit. While holding the PTT
          SWITCH you may speak into the microphone.




                                    Page 16


                                   *** NOTE ***

          On the DJ-580E the lower portion of the PTT SWITCH is used to
          transmit Tone Burst, and the upper portion is the PTT SWITCH. On
          the DJ-580T either button activates PTT SWITCH.


   3.3.3  BATTERY LOCK BUTTON

          The battery lock button releases the battery from the radio. The
          battery is keyed in order to avoid the battery from being inserted
          incorrectly. To attach the battery, slide battery in guides from
          left to right until the lock snaps battery into place. To remove
          battery, push and hold the lock button upwards and slide the
          battery to the left (from vantage point where radio front panel is
          facing you).

   3.4    RIGHT SIDE CONTROLS/FUNCTIONS

          The following controls are located on the right side of the radio
          as viewed with front panel facing the operator.

   3.4.1  DC IN JACK

          Utilizing this jack will provide maximum output power. Plug an
          external 13.8 VDC power source into this jack.

                                *** CAUTION ***

          Observe correct plug polarity. The tip of the connector is (+) and
          the sleeve is (-).

          When a voltage source is applied to this jack the battery is cutoff
          and no charging to the battery will take place.

          The EDC-36 or EDC-37 is recommended as optional accessories. Refer
          to section 1.2 for additional information on OPTIONAL ACCESSORIES.

   3.5    LCD DISPLAY DESCRIPTIONS

          The following subsections discuss those indicators viewed on the
          LCD display.

   3.5.1  MEMORY CHANNEL

          This 2 digit indicator shows that the selected band is in memory
          mode and displays the memory channel number.

   3.5.2  BATTERY SAVE

          The symbol S appears while battery save function is activated.

   3.5.3  TONE ENCODER/TONE SQUELCH

          The symbol T appears when tone encoder is active and TSQL when tone
          squelch (Decode) function is activated.

                                    Page 17

   3.5.4  PRIORITY/DUAL WATCH

          The symbol PRI appears when PRIORITY/DUAL WATCH function are
          activated.

   3.5.5  AM

          This symbol will appear when the aircraft modification has been
          performed. The symbol AM indicates that the AM detector is active.
          Refer to Section 14 for information on the aircraft modification.

   3.5.6  SPLIT

          The star symbol appears when the split function is activated.

   3.5.7  TIMER SCAN

          This T symbol appears above the (frequency) 10KHz digit. When the T
          symbol disappears, BUSY SCAN is activated. When the T symbol is
          present, TIMER SCAN is activated. The radio defaults to BUSY SCAN.

   3.5.8  OUTPUT POWER

          When the symbol L is displayed, LOW power is active. The indicator
          M is for MID power and H for HIGH power.

   3.5.9  DIALER

          When the telephone symbol appears, the DIALER MEMORY is activated.

   3.5.10 SHIFT

          The symbols +, - or star are used by the shift function.

   3.5.11 DSQ

          When P or G and DSQ are displayed, DSQ functions are enabled. DSQ
          stands for DTMF squelch control.

   3.5.12 VHF

          The VHF symbol indicates that the VHF band has been selected.

   3.5.13 FREQUENCY INDICATOR

          Receive and transmit frequencies, offset and tone frequencies,
          channel steps, DSQ codes and dialer memory channel numbers are
          displayed in this area depending on the selected mode.

   3.5.14 AUTO POWER OFF (APO)

          APO appears when AUTO POWER OFF is activated.

   3.5.15 ON AIR

          The symbol ON AIR appears when transmitting.


                                    Page 18

   3.5.16 S/RF

          In receive mode the S/RF symbol and Signal/RF bars will be
          displayed to show signal strength. When transmitting occurs, the ON
          AIR symbol and Signal/RF bars indicate RF output power.

   3.5.17 FREQUENCY DECIMAL POINT

          When receive, transmit or offset frequencies are displayed on the
          LCD, the decimal point divides MHz and KHz.

   3.5.18 TONE FREQUENCY DECIMAL POINT

          When the Tone frequency is displayed, the decimal point divides Hz
          and 0.1 Hz.

                                   *** NOTE ***

            This decimal point is also used to indicate that the PLL
            circuitry isn't locking in on the frequency entered. In other
            words, you are unlikely to receive the frequency that you have
            entered when this decimal point is blinking within the frequency
            displayed on the LCD.

   3.5.19 PL (PTT LOCK)

          The PL symbol indicates that the PTT switch is locked. The radio
          will not transmit even if the PTT switch is pressed accidentally.

   3.5.20 FL (FREQUENCY LOCK)

          FL stands for FREQUENCY LOCK. When FL is displayed, the command and
          control function keys are locked out. Utilizing this function
          prevents accidental use of command and control pad keys.

   3.5.21 UHF

          This symbol indicates that the UHF band has been selected.

   4      GETTING STARTED (RECEIVING)

            1. Adjust the following switches and controls on the top of the
               radio.

                  o POWER/UHF KNOB:    OFF
                  o VOLUME CONTROLS:   Fully Counter Clockwise
                  o SQUELCH CONTROLS:  Fully Counter Clockwise

            2. Connect a battery or external 13.8 Volt DC Power Supply to the
               radio.

            3. Connect a dual band antenna with the appropriate antenna
               connector to the top of the radio. The type of antenna fitting
               that is expected is a BNC type.

            4. Rotate the POWER knob clockwise until power is applied to the
               radio.

                                    Page 19

            5. Rotate the VHF volume control (left knob) and the UHF volume
               control (center knob) clockwise until a signal (or noise) is
               heard through the speaker. The display should be illuminated
               and indicate frequencies for both bands. The initial factory
               delivered settings for VHF are found in Table 4, UHF in Table
               5.

               VHF

               VFO Frequency:      145.000 MHz  DSQ Setting:      None
               Memory Frequency:   Empty        Call Frequency:   145.000 MHz
               Channel Step(580T): 5 KHz        Tone Setting:     None
               Channel Step(580E): 12.5 KHz     Tone Frequency:   88.5
               Shift:              None         Transmitter Output: Mid
               Offset Frequency:   0.6 MHz      Call Freq.(580T): 145.000 MHz
               Memory Channel:     1            Call Freq.(580E): 145.000 MHz

                         TABLE 4 VHF DEFAULT SETTINGS

               UHF

               VFO Freq. 580T:     445.000 MHz  DSQ Setting:      None
               VFO Freq. 580E:     433.000 MHz  Call Freq.(580T): 445.000 MHz
               Memory Channel:     1            Call Freq.(580E): 433.000 MHz
               Channel Step(580T): 5 KHz        Offset Freq.(580T): 5 MHz
               Channel Step(580E): 12.5 KHz     Offset Freq.(580E): 7.6 MHz
               Shift:              None         Tone Frequency:     88.5 Hz
               Tone Setting:       None         Transmitter Output: Mid

                         TABLE 5 UHF DEFAULT SETTINGS

            6. Rotate the Main Tuning dial, and select an open frequency on
               each band. Rotate the squelch control clockwise for each band
               until the S/RF indicator disappears from each band on the LCD
               display.

            7. Select the desired band by pressing the VHF or UHF buttons.
               The VHF symbol will display on the LCD when VHF is enabled.
               The UHF symbol will display on the LCD when UHF is enabled.

                                      *** NOTE ***

               When the external power source is connected, make sure you
               power off the radio before turning off the power supply.

   4.1    KEY PAD DIRECT ENTRY

          When frequency is selected by key pad direct entry, numbers will
          appear on the LCD display as they are entered on the key pad.

            To enter frequency directly from the key pad, try the following.
            The following example will use the two meter frequency 146.52.

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Enter the 100MHz digit first. Example: 1--.---


                                    Page 20

            3. Enter the  10MHz digit next.  Example: 14-.---

            4. Enter the   1MHz digit next.  Example: 146.---

            5. Enter the 100KHz digit next.  Example: 146.5--

            6. Enter the  10KHz digit next.  Example: 146.52-

            7. Enter the   1KHz digit last.  Example: 146.520

            If radio STEP is greater than 10KHz, the 10KHz digit will be the
            last digit to enter followed by a higher pitch beep. The band
            indicator will stop flashing.

            If radio STEP is selected for 5KHz, enter the last digit.

   4.2    STEP KEY

          The STEP function is used to select desired incremental changes of
          receive/transmit frequencies, in steps of 5, 10, 12.5, 15, 20 or
          25KHz. Use this feature as follows:

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press and hold the FUNC key, then press the STEP key. Change
               the channel step by using the Main Tuning dial, A/UP ARROW or
               B/DOWN ARROW keys.

            3. Select the Active Band by pressing the VHF or UHF key to set
               channel step and return to operating frequency.

            4. After channel step is set, the receive/transmit frequency will
               increase or decrease by the value selected when you turn the
               Main Tuning dial.

                                 *** NOTE ***

            The following rules apply to channel steps as indicated.

            When 5 KHz channel step is selected, keys 0 and 5 are available
            for entry into the 1KHz digit.

            When 10 KHz channel step is selected, keys 0, 1, 2, 3, 4, 5, 6,
            7, 8 and 9 are available for entry into the 10KHz digit.

            When 12.5 KHz channel step is selected, keys 0, 1, 2, 3, 5, 6, 7
            and 8 are available for entry into the 10KHz digit.

            When 15 KHz channel step is selected, keys 0, 1, 3, 4, 6, 7 and 9
            are available for entry into the 10KHz digit.

            When 20 KHz channel step is selected, keys 0, 2, 4, 6, and 8 are
            available for entry into the 10KHz digit.

            When 25 KHz channel step is selected, keys 0, 2, 5 and 7 are
            available for entry into the 10KHz digit.


                                    Page 21

   4.3    CLEARING ENTRY

          To clear an error during key pad entry, you may:

            o Press the VHF or UHF band key, or
            o Press the PTT key.

   4.4    MONO BAND FUNCTION

          If you only want to use one band without distraction from the other
          band, follow these steps for mono band.

            1. Power off the radio.

            2. Press either the VHF or UHF key while powering on the radio.

            Restore dual band capability by pressing the inactive band key.
            If VHF is selected for mono band operation, press the UHF key to
            restore dual band operation.

   5      TRANSMITTING

            1. Make sure that you follow all steps set forth in the "GETTING
               READY" section (Section 4) first.

            2. Select a frequency, shift direction, shift value, and sub-
               audible tone frequency.

            3. Check to see if the frequency is in use before transmitting.

            4. Select appropriate transmitter output level.

            5. Press the PTT switch and speak approximately 5" from the
               microphone, located on the front of the radio.

   5.1    POWER OUTPUT SETTING

          There are three power settings on the DJ-580T/E. You may select
          either High (H), Medium (M) or Low (L) from the PO    function on
          the front panel. Refer to the battery specifications for more on
          output levels.

          Change power output levels by performing the following.

            1. Press and hold the FUNC key, then press the PO key repeatedly
               to obtain the desired output power.

                                    *** WARNING ***

          It is possible to cause UHF receive interference while
          transmitting on VHF. To avoid this from happening, make sure that
          the VHF frequency x 3 does not equal the frequency on UHF. For
          example, if VHF transmit frequency is 146.190 the UHF frequency
          should not be set at 438.570.




                                    Page 22

   5.2    LOW LEVEL BATTERY MODE

          This function allows for extended use due to power drop in battery.
          The FULL indicator will begin to flash when battery drops to
          approximately 6.2 volts. When you operate your squelch just on the
          threshold, it will begin to open at approximately 4.75 volts. The
          sensitivity and transmit power will begin to drop at this time
          compared to normal operation. The radio will continue to operate
          until approximately 4.50 volts. At this point in time the battery
          should be charged.

   6      TRANSCEIVER MODES

          The DJ-580T/E has 3 modes; VFO mode, Memory mode and Call mode.

   6.1    VFO MODE (Variable Frequency Oscillator)

          The transceiver will be in VFO mode. This mode is used to change
          frequency and select the desired channel step, offset frequency (up
          to 10.995 MHz by 5 KHz), tone frequency (38 frequencies in Hz),
          Dual Watch, etc.

            1. Select the Active Band by pressing the VHF or UHF key.

   6.2    MEMORY MODE

          The following guidelines will help you to program and manipulate
          memory channels. In memory mode, memory channels can be reviewed.
          Other features include Memory Scan, Memory Priority and Dual Watch.
          To select the memory mode, press the MR key. The memory used last
          will display:

            o Frequency
            o Memory channel number
            o Other programmed functions

   6.2.1  PROGRAMMING A MEMORY CHANNEL (MW KEY)

          To write functions to any memory channel, it is necessary to first
          set those functions in the VFO mode.

            o  Select VFO mode (VHF or UHF band key).
            o  Select the receive frequency.
            o  Select the repeater shift - or + or split
            o  Select the required offset. Consult your Repeater Directory.
            o  Select the proper CTCSS subaudible tone "T". Consult your
               Repeater Directory.
            o  Select Tone Squelch (Decoder) "T SQL".
            o  Select Tone Frequency

          After selecting and setting the required functions you can write
          (store) those functions to a memory channel as follows:

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Select a frequency, shift direction, shift value, CTCSS
               subaudible tone, Tone squelch and Tone frequency.

                                    Page 23

            3. Press the MR key. A two-digit memory channel number will be
               displayed on the LCD. If these digits are flashing, it means
               that this channel number has no information stored.

            4. Rotate the Main Tuning Dial clockwise to choose the desired
               memory channel number (clockwise to increase, counter
               clockwise to decrease).  Select the desired memory channel
               number (0 to 19).

            5. Press and hold the FUNC key along with the MW key to write
               (store) frequency to memory.

            6. Press the MR key to exit.

          An alternate method for programming the memory channel is provided
          as follows:

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press the MR key. A two-digit memory channel number will be
               displayed on the LCD. If these digits are flashing, it means
               that this channel number has no information stored.

            3. Turn the Main Tuning Dial clockwise to choose the desired
               memory channel number (clockwise to increase, counter
               clockwise to decrease).  Select the desired memory channel
               number (0 to 19).

            4. Select a frequency, shift direction, shift value, CTCSS
               subaudible tone, Tone squelch and Tone frequency.

            5. Press and hold the FUNC key along with the MW key to write
               (store) to memory.

            6. Press the MR key to exit.

   6.2.2  SCROLL MEMORY

          Scrolling the VHF or UHF bank of memory channels up or down can be
          accomplished 1 of 2 ways.

          MR KEY

            1. Press the MR key to put the Active Band into Memory Channel
               mode. The memory channel number (0-19) will appear. A flashing
               channel number indicates that no information has been
               programmed into this memory channel. Turn the Main Tuning dial
               to increment and decrement the memory channel or use the UP
               ARROW/DOWN ARROW keys.

            2. Press the MR key to exit MEMORY MODE and return to VFO MODE.
               The two digit memory channel will disappear from the LCD
               display showing that you have returned to VFO MODE.





                                    Page 24

               You can scan the memory channels with the SCN key, elect to
               skip any memory channel with the SKIP key, or select the scan
               type with the TMS key. Refer to the section SCANNING FUNCTIONS
               (Section 8) for more information.

               The DJ-580T/E has two (02) banks of memory channels:

               First, the VHF bank has 20 memory channels that are accessed
               with the MR key.

               Secondly, the UHF bank has 20 memory channels that are
               accessed with the MR key.

   6.2.3  CANCELING A MEMORY CHANNEL

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press the MR key.

            3. Rotate the Main Tuning Dial to choose the desired memory
               channel number (clockwise to increase, counter clockwise to
               decrease). Select a non-flashing memory channel number.

            The number of memory channels will change if you have utilized
            the ALLOCATION OF MEMORY CHANNELS feature. The radio defaults
            it's memory channels from 0 to 19 on VHF and 0 to 19 on UHF.

            4. Press and hold the FUNC key, then press the MW key to cancel
               this memory channel. The two digit memory channel number will
               now begin to flash indicating that the content of this memory
               channel has been cleared.

   6.2.4  ALLOCATION OF MEMORY CHANNELS

          Using this feature will allow you to free up memory channels from
          either band and allocate to the other band for frequency storage.

          EXAMPLE: ALLOCATE MEMORY CHANNELS

          Lets say you wish that you had 25 programmable VHF memory channels
          but the radio comes defaulted to 20. No problem, that's why this
          feature has been included. Since the radio has 40 channels in
          total, 20 for each VFO, it is possible to allocate all 40 channels
          to one band for memory programming. This scenario would leave the
          other band with no programmable memory channels. Here is how to
          make it all happen.

            1. Press and hold the FUNC key, then press the * key. The symbol
               FL will appear on the LCD display.

            2. Press and hold the FUNC key, then press the 1 key. The number
               of allocated memory channels for each VFO will appear on each
               band display.

               When the Main Tuning Dial is rotated clockwise, the number of
               possible VHF memory channels will increase. This number will
               increase while the allocated memory channels from the UHF side
               will decrease.
                                    Page 25

               When the Main Tuning Dial is rotated counter clockwise, the
               number of possible UHF memory channels will increase. This
               number will increase while the allocated memory channels from
               the VHF side will decrease.

            3. Press and hold the FUNC key, then press the * key four (4)
               times to clear FL/PL from the display and exit beep tone level
               mode.

   6.2.5  MEMORY TO VFO COPY FUNCTION

          This function is used to copy details of a memory or call channel
          into a VFO.

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press the MR key.

            3. Select a memory channel number by rotating the Main Tuning
               dial.

            4. Press and hold the FUNC key, then press the C key. The
               information from the memory channel has been copied to the
               VFO, currently displayed.

   6.3    CALL MODE

          The CALL mode allows a single key to use an immediately desired
          programmed frequency. Each band has one Call Channel which can be
          accessed by pressing the CALL key. A preferred local repeater is
          usually programmed into the Call Channel. The indicator C appears
          on the LCD when Call Priority and/or Dual Watch function is active.

   6.3.1  PROGRAMMING THE CALL CHANNEL (W KEY)

          To write functions to a CALL Channel, it is necessary to first set
          those functions in the VFO mode.

            o  Select VFO mode (VHF or UHF band).
            o  Select the receive frequency.
            o  Select the repeater shift - or +
            o  Select the required offset. Consult your Repeater Directory.
            o  Select the proper CTCSS subaudible tone "T". Consult your
               Repeater Directory.
            o  Select Tone Squelch (Decoder) "T SQL".
            o  Select Tone Frequency

          After selecting and setting the required functions you can write
          (store) those functions into a CALL Channel as follows:

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Select a frequency, shift direction, shift value, CTCSS
               subaudible tone, Tone squelch and Tone frequency.




                                    Page 26

            3. Press and hold the FUNC key, then press the CALL key. The
               frequency selected in step 2 will be stored into the CALL
               channel. The C indicator appears on the LCD showing you that
               your current mode is CALL channel mode.

            4. Press the CALL key again to return to previous mode and
               frequency.

   6.3.2  ACTIVATING CALL CHANNEL

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press the CALL key. The CALL indicator C will appear on the
               LCD display.

            3. Press the CALL key again to return to previous mode and
               frequency.


   6.3.3  CALL CHANNEL TO VFO COPY FUNCTION

          This function is used to copy details of a memory or call channel
          into a VFO.

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press the CALL key.

            3. Press and hold the FUNC key, then press the C key. The
               information from the call channel has been copied to the VFO,
               currently displayed.

   7      PRIORITY FUNCTIONS

          The following priority functions are available:

            o VFO Priority
            o Memory Priority
            o Call Priority (Dual Watch)

   7.1    VFO PRIORITY

          In this mode a VFO frequency is received for 4 seconds and a Memory
          frequency is received for 1/2 a second. This cycle will repeat
          continuously. Here is how it works:

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Select and enter a frequency.

            3. Press the MR key to activate Memory mode. If the memory
               channel is blinking, it hasn't been programmed.

            4. Rotate the Main Tuning Dial to a desired Memory Channel that
               has been programmed. You may also use the UP ARROW or DOWN
               ARROW key to change memory channels.


                                    Page 27

            5. Return to the Active Band VFO as you selected in step 1.

            6. Press the PRI key to begin priority function. The LCD will
               display PRI.

            7. Press the PRI key to stop the priority function. The LCD will
               remove the flashing PRI from the display.

                                 *** NOTE ***

            When a signal is received on the memory channel a BEEP will be
            emitted once from the speaker.

            In VFO priority, the transmitter may be activated on either
            frequency. Press the PTT switch when the desired frequency is
            displayed on the LCD.

   7.2    MEMORY PRIORITY

          In this mode a Memory frequency is received for 5 seconds and a VFO
          frequency is received for 2 second in a continuous cycle. Here is
          how it works:

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Select and enter a frequency.

            3. Press the MR key to activate Memory mode. If the memory
               channel is blinking, it hasn't been programmed.

            4. Rotate the Main Tuning Dial to a desired Memory Channel that
               has been programmed. You may also use the up or DOWN ARROW to
               change memory channels.

            5. Press the PRI key to begin priority function. The LCD will
               display PRI.

            6. Press the PRI key to stop the priority function. The LCD will
               remove PRI from the display.

                                 *** NOTE ***

            When a signal is received on the VFO frequency a BEEP will be
            emitted once from the speaker.

            In memory priority, the transmitter may be activated on either
            frequency. Press the PTT switch when the desired frequency is
            displayed on the LCD.

   7.3    CALL PRIORITY

          The VFO frequency or Memory channel is scanned for approximately
          1/2 second and the programmed CALL frequency is scanned for
          approximately 4 seconds.

            1. Select the Active Band by pressing the VHF or UHF key.


                                    Page 28

            2. If the CALL channel hasn't been programmed yet, refer to
               section 6.3.1 for more information.

            3. Enter a frequency into the VFO or select a Memory channel in
               memory channel mode.

            4. Press the CALL key for approximately 1/2 second. Call priority
               will begin to cycle between the CALL channel and the selected
               VFO or memory channel.

            5. Press the PRI key to begin priority function. The LCD will
               display PRI.

            6. Press the PRI key to stop the priority function. The LCD will
               remove PRI from the display.

                                 *** NOTE ***

          When a signal is received on the VFO frequency a BEEP will be
          emitted once from the speaker.

          In CALL priority, the transmitter may be activated on either
          frequency. Press the PTT switch when the desired frequency is
          displayed on the LCD.

   7.4    DUAL WATCH FUNCTION

          Unlike priority, there is no period for listening between two
          modes. Dual Watch is a constant monitoring of two modes.

   7.4.1  VFO/MEMORY DUAL WATCH

          Perform the following for VFO/MEMORY DUAL WATCH.

            1. Select the Active Band by pressing the VHF or UHF key. Enter a
               desired frequency.

            2. Press the MR key and select the desired memory channel.

            3. Return to the VFO mode as selected in step #1.

            4. Press and hold the FUNC key, then press the DUAL key. The
               radio will begin with the VFO frequency followed by the memory
               channel frequency. The cycling between these frequencies is
               approximately .5 second.

            5. Press the VFO button as selected in step #1 to stop DUAL
               WATCH.

                            *** OPERATING HINT ***

            Without stopping DUAL WATCH operation, you can enter a new
            frequency into the selected VFO and DUAL WATCH will continue
            automatically. Enter the new VFO frequency via the key pad. DUAL
            WATCH operation will be suspended while you are entering the new
            VFO frequency, but will resume operation after you have completed
            entry.

                                    Page 29

   7.4.2  CALL/VFO DUAL WATCH

          Unlike priority, there is no time period for listening between two
          modes. Dual Watch is a constant monitoring of two modes. Perform
          the following for CALL/VFO DUAL WATCH.

            1. Select the Active Band by pressing the VHF or UHF key. Enter a
               desired frequency.

            2. Press the CALL key. The CALL channel must be programmed.

            3. Press and hold the FUNC key, then press the DUAL key. The
               radio will begin with the CALL frequency followed by the VFO
               frequency. The cycling between these frequencies is
               approximately .5 second.

            4. Press the Active Band key as performed in step 1 to stop DUAL
               WATCH.

   7.4.3  CALL/MEMORY DUAL WATCH

          Unlike priority, there is no time period for listening between two
          modes. Dual Watch is a constant monitoring of two modes. Perform
          the following for CALL/MEMORY DUAL WATCH.

            1. Press the MR key and select the desired memory channel.

            2. Press the CALL key. The CALL channel must be programmed.

            3. Press and hold the FUNC key, then press the DUAL key. The
               radio will begin with the CALL frequency followed by the
               memory channel frequency. The cycling between these
               frequencies is approximately .5 second.

            4. Press the VFO button as selected in step #1 to stop DUAL
               WATCH.

   8      SCANNING FUNCTIONS

          The DJ-580T/E offers various scanning options and 3 scanning modes
          described a little later on in this section. First lets look at the
          scanning options, they are:

          VFO Scan                      - Scans either band
                                          independently.

          Program Band Scan (VFO Mode)  - Scans programmed lower to
                                          upper frequencies. You may scan a
                                          range of frequencies.

          Memory Scan                   - Each band may scan memory
                                          channels independently.

          Whether you are scanning (SCN) or manually tuning, when;

               o  Passing a 500KHz boundary a single beep will be heard
                  through the speaker.

                                    Page 30

               o  Incrementing frequencies past a 1MHz boundary, a low beep
                  followed by a high beep will be heard.

               o  Decrementing frequencies past a 1MHz boundary, a high beep
                  followed by a low beep will be heard.

   8.1    VFO SCAN

          Each band may scan VFO channels independently. When in Band Scan
          mode the DJ-580T/E scans by channel Step. Refer to Section 3.1.7
          for more information on the channel Step key. As the scan passes
          through any 500 KHz or 1 MHz point a tone will sound if the BEEP
          function is active.

            1. Select the Active Band by pressing the VHF or UHF key twice.
               The purpose for pressing the band key twice is in the event
               you are in memory mode by mistake.

            2. Press the SCN key for approximately 1 second, a beep will be
               heard. Release the SCN key. Use the Main Tuning dial or UP
               ARROW or DOWN ARROW keys to scan in a particular direction.

            3. Whether you are cycling upward or downward, during scan the
               decimal point will flash indicating that scanning has begun.

            4. When a signal is received, scanning will stop and remain on
               that frequency. When channel goes quiet or Main Tuning Dial is
               rotated clockwise or counter clockwise, scanning will
               continue.

            5. To cancel scanning press the SCN key. A beep will not be heard
               when initially pressed, but will be heard when the SCN key is
               released.

               All 3 scan types can be applied to Band Scan.

   8.1.1  PROGRAM BAND SCAN MODE (VFO MODE)

          This scan option allows the scanning of a range of VFO frequencies.
          Each band may have independent scan ranges. The lower band limit is
          programmed into Memory Channel P1. The upper band limit is
          programmed into Memory Channel P2. You may initiate Program Band
          Scan from either VFO or Memory mode.

          EXAMPLE: STORING LOWER/UPPER RANGES

            1. Select the Active Band by pressing the VHF or UHF key, for
               example VHF.

            2. Enter a desired Lower Frequency via the key pad, for example
               "146.000".

            3. Press the MR key.

            4. Rotate the Main Tuning Dial until P1 is displayed.



                                    Page 31

            5. Press and hold the FUNC key, then press the MW key to store
               the selected Lower Frequency into memory.

            6. Enter a desired Upper Frequency via the key pad like 146.100.

            7. Press the MR key.

            8. Rotate the Main Tuning Dial until P2 is displayed.

            9. Press and hold the FUNC key, then press the MW key to store
               the selected Upper Frequency into memory.

           10. Press and hold the FUNC key, then press the SCN key. The
               letter P will begin to blink on the display. Scanning from
               146.000 to 146.100 has begun.

           11. Press the Active Band key as performed in step 1 to stop this
               function. Pressing the SCN key will also cease this function.

                                 *** NOTE ***

               The upper limit frequency and Lower limit frequency may be
               stored into either P1 or P2.

   8.2    MEMORY SCAN MODE

          This scan option allows the user to scan frequencies that have been
          programmed in any (or all) of the memory channels. Bands may be
          scanned individually or both bands may be scanned simultaneously.

            1. Select the Active Band by pressing the VHF or UHF key twice.
               The purpose for pressing the band key twice is in the event
               you are in memory mode by mistake.

            2. Press the MR key.

            3. Press the SCN key for approximately 1 second, a beep will be
               heard. Release the SCN key. Use the Main Tuning dial or UP
               ARROW or DOWN ARROW keys to scan in a particular direction.

            4. Whether you are cycling upward or downward, during scan the
               decimal point will flash indicating that scanning has begun.

            5. When a signal is received, scanning will stop and remain on
               that frequency. When channel goes quiet or Main Tuning dial is
               rotated clockwise or counter clockwise, scanning will
               continue.

            6. Press the Active Band as performed in step 1 to stop this
               function. To cancel scanning press the SCN key. A beep will
               not be heard when initially pressed, but will be heard when
               the SCN key is released.






                                    Page 32

   8.2.1  MEMORY CHANNEL SKIP MODE

          Memory Channel Skip permits unwanted memory channels to be skipped
          during memory scan. This step presumes that you have already
          programmed some/all memory channels.

            1. Press the MR key.

            2. Rotate the Main Tuning Dial until the memory channel that you
               want to skip is displayed.

            3. Press the SKIP key. The decimal point will disappear from the
               frequency displayed, indicating this frequency will be
               skipped. Perform step 2 and 3 for each memory channel that you
               wish to skip.

            4. To cancel Memory Channel Skip, press the SKIP key again. The
               decimal point will re-appear, and that memory channel will now
               be restored to scan status.

   8.3    SCANNING TYPES

          The DJ-580T/E offers 3 different scanning modes as shown below. The
          initial factory setting is the Busy Channel Scan.

          Busy Scan  - Stops at a busy channel or frequency until
                       clear. Two seconds after the signal ceases, scanning
                       resumes.

          Timed Scan - Stops at busy channel or frequency, then
                       resumes scan 5 seconds later even if the
                       channel remains busy. Scanning will also
                       resume when a signal received ceases.

          Selecting a Scan Type:

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press and hold the FUNC key, then press the TMS key. A black
               block with a white lettered T will appear, indicating to you
               that "Timed Scan" has been selected.

            3. Press and hold the FUNC key, then press the TMS key again to
               leave "Timed Scan". The black block with a white lettered T
               will disappear from the LCD display.

            The DJ-580 will be in "Busy Scan" when not in "Timed Scan".

   8.4    OTHER SCANNING INFORMATION

          This subsection talks about all other information pertinent to
          radio scan.

   8.4.1  DUAL BAND SCAN

          You may want to scan both bands at the same time. You can perform
          that function by following this example.

                                    Page 33

          EXAMPLE: DUAL BAND SCAN

            1. Press the VHF key.

            2. Press the UP ARROW key for approx. 1 second.

            3. Press the UHF key.

            4. Press the UP ARROW key for approx. 1 second.

   8.4.2  DUAL BAND SCANNING WITH MEMORY PRIORITY

          If you want to activate PRIORITY on both bands while SCANNING, no
          problem, follow this example.

          EXAMPLE: DUAL BAND SCAN WITH DUAL BAND PRIORITY

            1. Press the VHF key.

            2. Press the MR key and rotate Main Tuning dial for a desired
               memory channel.

            3. Press the VHF key.

            4. Press the SCN key for approx. 1 second.

            5. Press the PRI key.

            6. Press the UHF key.

            7. Press the MR key and rotate Main Tuning dial for a desired
               memory channel.

            8. Press the UHF key.

            9. Press the SCN key for approx. 1 second.

           10. Press the PRI key.

   9      REPEATER OPERATIONS

          Amateur radio repeaters utilize separate transmitter and receiver
          sections. The transmitter frequency may be offset either above or
          below the receive frequency according to repeater coordination
          conventions.

   9.1    SPLIT FREQUENCY FUNCTION

          When standard offsets will not satisfy an input or output
          frequency, a split is utilized for this purpose. Split can be
          configured on the DJ-580 for VFO and MEMORY modes. The split
          frequency function will not operate in CALL mode.

   9.1.1  VFO MODE SPLIT

          Perform the following for VFO MODE SPLIT.


                                    Page 34

            1. Select the Active Band (VFO) by pressing the VHF or UHF key.
               Enter a frequency into the VFO for your output (receive)
               frequency.

            2. Press the MR key. Program or select a frequency in any MEMORY
               channel for your input (transmit) frequency.

            3. Enter VFO as selected in step 1. VFO frequency is used for
               receive and the MEMORY channel is used for transmit.

            4. Press and hold the FUNC key, then press the SHIFT key
               repeatedly until the star symbol appears on the display. The
               split setup is now complete.

   9.1.2  MEMORY MODE SPLIT

          Perform the following for MEMORY MODE SPLIT.

            1. Press the MR key. Program or select a frequency in any MEMORY
               channel for your input (transmit) frequency.

            2. Select the Active Band (VFO) by pressing the VHF or UHF key.
               Enter a frequency into a VFO for your output (receive)
               frequency.

            3. Press the MR key again. The MR frequency is used for receive
               and the VFO frequency is used for transmit.

            4. Press and hold the FUNC key, then press the SHIFT key
               repeatedly until the star symbol appears on the display. The
               split setup is now complete.

   9.2    REV KEY

          In some areas there may be repeaters operating on repeater
          frequency pairs, the exact reverse of another repeater in the area.
          That is, the input of one repeater is the output frequency of the
          other and vice versa. To avoid the inconvenience of reprogramming
          every time both repeaters are in range, the REV key allows instant
          reversal of the input and output frequencies and the offset
          direction. The REV function is also useful to check the repeater
          input to determine if another station is heard directly so you can
          go simplex. To activate the REV function:

               1. Press and hold the FUNC key, then press the REV key. The
                  repeater input frequency and opposite SHIFT indicator will
                  appear on the LCD display panel.

               2. Press and hold the FUNC key, then press the REV key again
                  to cancel the REV function.

   9.3    RESETTING RADIO

                                    *** NOTE ***

            Resetting the radio will erase all user programmed information
            (frequencies,shifts,offsets etc.) Make sure that this information

                                    Page 35

            has been written down before proceeding.

            1. Make sure radio is powered off.

            2. Press and hold the FUNC key in while turning on the radio via
               the power knob. The LCD will display 145.00 (VHF) and 445.00
               (UHF).
                                 *** NOTE ***

            If you were to hold the func key in and not let it go while
            powering up the radio, all display segments will be shown.

   9.4    CTCSS ENCODE/DECODE

          CTCSS encoding allows you to select the proper tone frequency to
          open another operators radio receiver or repeater. CTCSS decoding
          enables another operator to select the tone your receiver requires
          enabling you to hear them. Unlike Code Squelch operation (Refer to
          section 11 for details), a specific tone frequency is used. Here's
          how to use CTCSS Encoding/Decoding.

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press and hold the FUNC key, then press the TONE key.

            3. Rotate the Main Tuning dial to the desired tone.

            4. When the tone has been selected enter the Active Band by
               pressing either the VHF or UHF key.

            5. Press and hold the FUNC key, press the T.SQL key repeatedly.
               Tone settings will cycle each time the T.SQL key is pressed.
               It cycles as follows on the LCD display:

               o  The Tone Encoder is Enabled when the letter T is displayed
                  on LCD.

               o  The Tone Decoder Squelch function is enabled when the
                  letter T and SQL is displayed on the LCD. When this
                  function is active, you would expect a particular tone to
                  open your radio receiver.

               o  When the T and SQL is not displayed, the encoder/decoder is
                  disabled.

               EXAMPLE: TONE ENCODER/DECODER

                  Radio for Joe              Radio for Linda
                  -------------              ---------------
                  Tone set: 100.0            Tone set: 100.0
                  T displayed (ENCODE)       T and SQL displayed (DECODE)

               A) Radio operator "Joe" is calling "Linda". The interesting
                  point here is that when the radio that Linda is using
                  displays T and SQL, nothing will be heard through her
                  radio speaker when squelch is opened up (fully counter


                                    Page 36

                  clockwise). You will notice however that the S/RF
                  indicator will be shown on the LCD when squelch is
                  opened.

               B) The only way that Linda will hear Joe is for Joe to send
                  the proper tone to open Linda's radio receiver. If Joe
                  doesn't send the right tone, Linda's radio will remain
                  silent.

  10      AUTOPATCH OPERATION (AUTOMATIC DIALER)

          The DJ-580T/E offers three automatic dialer memories. A telephone
          number may be entered in either the VHF or the UHF frequency mode.
          The stored telephone number is transmitted on whichever band is
          selected as the Active Band.

  10.1    PROGRAM AUTODIAL NUMBER

          To enter a telephone number, perform the following:

            1. Press and hold the FUNC key, then press the A key. The
               selected VFO frequency display will clear and display C1 or C2
               or C3. Rotate the Main Tuning dial clockwise or counter-
               clockwise to obtain a desired dialer memory. The telephone
               symbol will display on the LCD and flash, indicating that the
               dialer memory is ready to accept the number to be stored. You
               may enter up to 16 numbers, letters and symbols, four at a
               time in four groups.

            2. The telephone number or codes should be entered in order from
               the beginning. The following characters can be used:
                                0-9, A-D, *, #

            3. Press and hold the FUNC key, then press the A key to store the
               entered telephone number or codes. The telephone symbol stops
               flashing and is on steady to show that this function is
               active.

               Proceed to Section 10, 10.4 to transmit the dial sequence.
               Clear out dialer memory to enter a new sequence.

  10.2    CLEAR DIALER MEMORY

            1. Press and hold the FUNC key, then press the A key.

            2. Rotate the Main Tuning dial to the dialer memory you wish to
               clear.

            3. Press and hold the FUNC key, then press the C key followed by
               the A once again.

  10.3    CORRECTING CODES IN DIALER MEMORY

            1. Press and hold the FUNC key, then press the A key.

            2. Rotate the Main Tuning dial to the dialer memory you wish to
               make a correction in.

                                    Page 37

            3. Press and hold the FUNC key, then rotate the Main Tuning dial
               until the sequence of digits you wish to correct have just
               exited the display.

            EXAMPLE: CORRECTING DIALER CODES

               Programmed number is 123567890, but you forgot 4!

            1. Press and hold the FUNC key, then press the A key.

            2. Rotate the Main Tuning dial to the dialer memory you wish to
               make a correction in.

            3. Press and hold the FUNC key, then rotate the Main Tuning until
               the numeral 3 is displayed.

                  This represents the last digit displayed on the LCD.
                  | These digits are hidden just right of last digit shown.
                  v vvvvvv
                123 567890

            4. Now enter 4567890. After you play with this for awhile you
               will see how it works.

  10.4    TRANSMIT/CHANGE AUTODIAL NUMBER

          After performing the steps in section 10.1, perform the following
          steps to transmit the programmed number.

            1. Press and hold the FUNC key, then press the "A" key.

            2. The telephone symbol could be blinking which represents an
               unprogrammed dialer memory channel. Refer to Section 10.
               Otherwise, rotate the main tuning knob to the desired dialer
               memory channel.

               Verify that the blinking telephone symbol appears on the LCD
               display.

            3. Press the PTT switch for an instant. This will return you to
               VFO mode.

            4. To transmit dialer memory channel, Press and hold the PTT key.

                              ** LOOK AT LCD DISPLAY **

               You are now transmitting. The ON AIR symbol should display on
               the LCD display.

            5. While transmitting press the FUNC key to send/transmit the
               autodial sequence.
                                     ** LISTEN **

               The dialer sequence that you programmed earlier will be
               transmitted. You can hear the tones that are being sent
               through the DJ-580 speaker.


                                    Page 38

                                 HIDDEN FUNCTIONALITY

               This is where you will have to experiment a bit. You can
               change the dialer sequence timing. Refer to Section 10.7 for
               all of these new details.

  10.5    MANUAL DIAL

          In some instances you may want to dial a number manually. perform
          the following steps.

            1. The telephone symbol should not appear on your display. If it
               does, press and hold the FUNC key, then press the A key, the C
               key and finally the A key again.

            2. Press and hold the PTT key.

            3. Now dial the number on your keypad as you would a telephone.

  10.6    DISABLE AUTODIAL

          Performing the following step will erase a stored number in the
          autodialer.

            1. Press and hold the FUNC key, then press the A key, the C key
               and finally the A key again.

            You can either clear the dialer channel or not press the FUNC key
            during a transmission.

  10.7    DIALER RATE ADJUST

          The following steps are used for changing the dialer and DSQ tone
          rates. This function may not appear/be available on earlier DJ-580
          units.

            1. Press the * key. The symbol FL will appear on the LCD display.

            2. Press the following keys in sequence: #, 1, 2, 3. The LCD will
               display the letter C. If you repeat this step continuously the
               letters will change as follows:

                    C,D,upside down A,H,0,1,2,3,4,5,6,7,8,9,A,B

            Each of these indicators are associated with a different rate
            during transmission. The fastest begins at 1 and the slowest is
            zero. The letters are variations of slow rates.











                                    Page 39

  11      DIGITAL SQUELCH (DSQ)

          DSQ stands for DTMF Squelch Control. DSQ is very versatile and will
          allow you to:

            o  Make a transmission that will specifically be heard by a
               particular group (of your choosing, by a code sequence).
            o  Place a private call to a selected person in a group.
            o  Call a single operator.
            o  Straight DSQ transmission

          This feature is achieved by use of DTMF Tones that will either open
          (or keep closed) the DJ-580T/E. In this section you will learn how
          to transmit and receive the DSQ SCHEME! A radio must be DSQ
          compatible to take advantage of these features.

  11.1    DSQ SCHEME

          Before we get started let's look at the DSQ tone structure.
          Depending on the transmission type (Group, Private etc.), a
          particular tone sequence will be sent. The tone structure is broken
          down into the following areas:

            o  GROUP Code - 3 digit sequence
            o  OTHER'S Code - 3 digit sequence
            o  OWN Code - 3 digit sequence
            o  MISC Codes

          The following explanation of each area will help you to fully
          understand how each is utilized.

          3 DIGIT "GROUP" CODE

          By programming a 3 digit group code your members of a group would
          receive a common transmission. Perhaps this group wouldn't want to
          hear a transmission meant for another group that has another 3
          digit code sequence.

          EXAMPLE: GROUP CODE

          Lets say that you are helping the local police department find a
          missing child. They have split 10 radio operators
          into 2-five person teams. Let's call them team 1 and team 2.

          Each member of team 1 has a radio with a group code of 111.
          Each member of team 2 has a radio with a group code of 222.

          The police have just found evidence that the child is definitely
          located in team 2 territory. The central transmission point now
          needs to contact the members of team 1 and notify them that their
          search area must be changed. They will send out a 111 group code
          (tone sequence) to team 1. By virtue of the group code 111, all
          members of team 1 will hear the message and team 2 will hear
          nothing on their radios. A separate transmission to group 2 could
          be placed with specific updated information!



                                    Page 40

          3 DIGIT "OTHER'S" CODE

          This code is used as an identifier of another station. In other
          words, it is the other persons "own" code.

          EXAMPLE: OTHERS CODE

          Lets say that an individual in team 1 needs to be given some
          specific information. The receiving stations identifier is referred
          to as the other's code. We will send that person the information by
          virtue of their 3 digit "own" code. You must enter their "own" code
          into your "others" code field.

          3 DIGIT "OWN" CODE

          A transmitting station uses 3 digits as a personal identification
          number. A receiving station uses this code to identify who called
          them.

          EXAMPLE: OWN CODE

          Lets say that you will receive some specific information. The other
          person will need to know your "own" code before your radio will
          receive a private call. Your "own" code is also  necessary, because
          the other person receiving your message will see your "own" code
          displayed on their radio LCD.

          MISC CODES

          16 numbers, letters and symbols can be used for coding. Here's what
          you can use; 0-9, A-D, * and #. An "H" will appear on the LCD when
          the * is entered and upside down A will appear when the # is
          entered. The # sign is used as a wild card. Refer to WILDCARD for
          more information.

  11.2    PROGRAMMING ALL DSQ CODES

          Place your radio in front of you. The following steps get your
          radio set for DSQ operation.

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press and hold the FUNC key, then press the B key. The LCD
               display will indicate A-000.

            3. Enter 3 digits for the group that YOU want to call. In other
               words, a unique calling code for a specific group.

               EXAMPLE: PROGRAM 1ST GROUP CODE

                                     A-123

            4. Rotate the Main Tuning dial clockwise until B-000 is displayed
               on the LCD.

            5. Enter 3 digits for another group that YOU might call. This is
               an additional group calling code.

                                    Page 41

               EXAMPLE: PROGRAM 2ND GROUP CODE

                                     B-456

            6. Rotate the Main Tuning dial clockwise until P-000 is displayed
               on the LCD.

            7. Enter 3 digits for your "own" Personal code. This is your
               unique identification code.

               EXAMPLE: PROGRAM YOUR OWN CODE

                                     P-100

            8. Rotate the Main Tuning dial clockwise until y-000 is displayed
               on the LCD.

            9. And now you must select the "others" 3 digit code. This is the
               operator you're calling. Lets say you're calling operator 200,
               enter "200" on the keypad.

               EXAMPLE: PROGRAM THE OTHERS CODE

                                     y-200

           10. Rotate the Main Tuning dial clockwise until nn-00 is displayed
               on the LCD.

           11. Enter a two digit code that will become the Digital Signal
               Message.

               EXAMPLE: DIGITAL SIGNAL MESSAGE

                                     nn-07

           12. Press the VHF or UHF key to end setup.

               Only radios with DSQ functionality are capable of receiving
               and/or transmitting DSQ tasks. These tasks are described in
               the following sub-sections, have fun!

  11.3    DSQ MODES

          This section will address all functions of DSQ and describe how
          they should be used. Only through experimentation of DSQ will you
          get the hang of it. DSQ functionality comes in various flavors, and
          they are shown in the following table.

                       DSQ FUNCTION               LCD DISPLAY
               -----------------------------   -----------------
                       Straight DSQ                    D.SQ
                       Group Calling               G   D.SQ
                 Private Calling In A Group        G P D.SQ
                       Private Call                  P D.SQ




                                    Page 42

  11.3.1  TRANSMITTING (CODE SQUELCH)

          Coded Squelch is a unique 3 digit sequence, when sent to another
          unit configured only for D.SQ, will open the receiver for
          reception. It's always a good idea to have a cheat card that lists
          each units identifier (own code) and group codes.

            1. Select the Active Band by pressing the VHF or UHF key.

            2. Press and hold the FUNC key, then press the B key.

            3. Rotate the Main Tuning dial and select either A- for GROUP A
               or B- for GROUP B. Each group should have a unique identifier
               code. If either GROUP A or B doesn't contain the desired 3
               digit code, enter it in at this time via the keypad.

            4. Return to the Active Band as selected in step 1.

            5. Press the B key several times until "D.SQ" displays on the
               upper right-hand corner of the LCD.

            6. When you press the PTT key, the Code Squelch is transmitted
               automatically. At the conclusion of the 3 digits being
               transmitted, the operators radio (who you are calling)
               receiver will accept your transmission.

  11.3.2  RECEIVING (CODE SQUELCH)

          If the received Code Squelch signal matches the set Code Squelch
          code, D.SQ will begin to flash on the LCD display. In addition, an
          audible alert will be heard through the speaker.

          If the receiver is on receive mode by code squelch, it is possible
          to communicate within 1.5 seconds after a received signal is
          clipped.

  11.3.3  TRANSMITTING (GROUP CALLING)

          When you select this option, you will be able to contact many
          operators that collectively make up a group. If operators with
          compatible DSQ functionality are configured correctly, and all have
          the same group code programmed, their radios should open and
          receive your call. It's always a good idea to have a cheat card
          that lists each units identifier (own code) and group codes. Here's
          what you have to do.

            1. Press the B key.

            2. Rotate the Main Tuning dial and select either A- for GROUP A
               or B- for GROUP B. Each group should have a unique identifier
               code.

            3. Press the B key several times until G D.SQ displays on the
               upper right-hand corner of the LCD.

            4. When you press the PTT switch, the GROUP code selected will be
               transmitted to all units in the GROUP.

                                    Page 43

               If you are using GROUP A in step 2 and wish to change to GROUP
               B, follow steps 1-4 again.

               The following DSQ code is transmitted as shown:

                   (3 DIGIT GROUP CODE) * (3 DIGIT OWN CODE)

  11.3.4  RECEIVING (GROUP CALLING)

          To receive DSQ coded calls in GROUP CALLING, setup your radio for G
          DSQ as follows:

            1. Press and hold the FUNC key, then press the B key until G DSQ
               appears on the LCD display.

          When the received DSQ code matches the first 3 digits of your
          display (group code), the G DSQ indicator will begin to flash. If
          the BEEP is off, the squelch will open for as long as the calling
          operator is transmitting. If the BEEP is on, an audible beep will
          be emitted from the radio and the indicator will display which
          group is calling. Reset the display by pressing the Active Band key
          or PTT.

  11.3.5  TRANSMITTING (PRIVATE CALLING IN A GROUP)

          It's always a good idea to have a cheat card that lists each units
          identifier (own code) and group codes.

            1. Press the B key.

            2. Rotate the Main Tuning dial and select either A- for GROUP A
               or B- for GROUP B. Each group should have a unique identifier
               code.

            3. Press the B key several times until GPDSQ displays on the
               upper right-hand corner of the LCD.

            4. Press the PTT switch to transmit the DSQ code or press the VFO
               key for the band you are working.

            The following DSQ code is transmitted as shown:

            (3 DIGIT GROUP CODE) (1 DIGIT OTHERS CODE) * (1 DIGIT OWN CODE)

  11.3.6  RECEIVING (PRIVATE CALLING IN A GROUP)

          To receive DSQ coded calls in PRIVATE CALL IN A GROUP, setup your
          radio for GPDSQ as follows:

            1. Press the B key until GPD.SQ appears on the LCD display.

          When the received DSQ code matches the first 3 digits of your group
          and your own code, the DSQ GP indicator will begin to flash. If the
          BEEP is off, the squelch will open for as long as the calling
          operator is transmitting. If the BEEP is on, an audible beep will



                                    Page 44

          be emitted from the radio and the indicator will display which
          group is calling. Reset the display by pressing the Active Band key
          or PTT.

  11.3.7  TRANSMITTING (PRIVATE CALL)

          This option would be used when someone is calling only you. This is
          different from encode/decode because you determine your own
          identification code and not a subaudible tone. It's always a good
          idea to have a cheat card that lists each units identifier (own
          code) and group codes.

            1. Press the B key.

            2. Press the B key several times until P D.SQ displays on the
               upper right-hand corner of the LCD.

            3. Press the PTT key to transmit the DSQ code or press the VFO
               key for the band you are working.

            The following DSQ code is transmitted as shown:

                  (3 DIGIT OTHERS CODE) * (3 DIGIT OWN CODE)

  11.3.8  RECEIVING (PRIVATE CALL)

          To receive DSQ coded calls in PRIVATE CALL, setup your radio for P
          D.SQ as follows:

            1. Press and hold the FUNC key, then press the B key until P D.SQ
               appears on the LCD display.

  11.4    ERROR CODE

          When the "Other's" private code is not confirmed the LCD display
          will indicate "Er".

  11.5    TIMING CONSIDERATIONS

          On occasions you may find that the operation of DSQ through some
          older repeaters may be unpredictable. This occurs on initial
          transmit with your DJ-580. When you transmit, a time delay occurs
          before the repeater is fully transmitting. The DJ-580 will begin to
          transmit the DSQ tone sequence during the repeater transmit delay.
          The DJ-580 can delay 450 ms or 750 ms. In addition, the timing
          period for the tone burst sequence can be adjusted. Please refer to
          section 10.7 for more information.

          It is possible to delay the time to transmit codes to about 750ms
          after the PTT key is pressed.

            1. Press and hold the FUNC key, then press the * key. The LCD
               display will display FL.

            2. Press and hold the FUNC key, then press the 4 key. The LCD
               display will display d-750 or d-450. Repeat this step until
               the desired selection is made.

                                    Page 45

            3. Press and hold the FUNC key, then press the * key. Repeat this
               step until FL and PL is absent from the display.

  11.6    DSQ WILDCARDS

          The # symbol is a wildcard that may be substituted for any one
          digit,letter or symbols used in DSQ codes. When the # symbol is
          entered it appears on the LCD display as an upside down A. The
          wildcard allows for the combination of many groups. If the first or
          first and second digits of several group codes are the same, you
          can replace the second and third digits (or just third digit) with
          a # mark, and thus transmit to all those groups.

          EXAMPLE: WILDCARDS

            1. Enter the 2 meter frequency of 146.520.

            2. Press and hold the FUNC key, then press the DSQS key. Select
               any code squelch memory channel.

            3. Release the FUNC key now and select a 3 digit code squelch
               code using the keypad.

               Example: Enter the 3 digit code 1#5.

            4. Press the FUNC key to return the LCD display to operating
               frequency.

               Example: Now you will see on the LCD display P45.52.

            5. Press the D.SQL key repeatedly (2 times) until C appears in
               the 100 MHz digit location.

               Example:   C45.620

            If the incoming coded calls are anyone with a group code as
            follows, the call will be received by your radio.

               o  105 through 195
               o  1A5 through 1D5
               o  1*5
               o  1#5

            6. When you receive a call from another station, the C will flash
               on and off for as long as the other operator is transmitting.
               Your radio has already memorized who was calling you, so press
               the PTT switch and you will transmit to that station directly.
               When you have completed your QSO, enter the wildcard sequence
               again to open your radio to all other stations again.

  11.7    DIGITAL SIGNAL MESSAGE

          This function allows you to send or receive messages consisting of
          2 digit codes.




                                    Page 46

  11.7.1  TRANSMITTING DIGITAL SIGNAL MESSAGE

          You can retain 1 signal message in the transmitter memory.

            1. Press and hold the FUNC key, then press the B key.

            2. Rotate the Main Tuning dial and select a message memory
               channel nn.

            3. Enter a 2 digit message code. This is a code that has been
               predetermined and understood by the operating parties.

            4. Press the VHF or UHF key to end setup.

            5. Set the appropriate paging function (D.SQ, G D.SQ etc).

            6. Press the PTT key to transmit the DSQ code. Continue to hold
               the PTT key and press the CALL key.

               What the receiving operator will see on the display will be
               the unit number f the calling station followed by the 2 digit
               code. The following is the sequence sent:

                          # (2 DIGIT SIGNAL MESSAGE)

  11.7.2  RECEIVING DIGITAL SIGNAL MESSAGE

            1. Set the appropriate paging function (D.SQ, G D.SQ etc).

            2. When the appropriate codes are received, your receiver will
               open to hear the calling operator. When the digital signal
               message is sent shortly after the initial transmission, you
               will see on the LCD display the 3 digit calling station
               followed by a - and then the 2 digit digital signal message.

  11.7.3  TRANSMITTING WITH DIGITAL SIGNAL DISPLAYED

          While a digital signal message is displayed, press the PTT switch.
          Your signal will be transmitted back to the station calling by
          using the displayed DSQ settings. The frequency will return to your
          LCD display.

  11.7.4  REVIEW DIGITAL SIGNAL MESSAGE MEMORY

          You can store up to 3 previously received digital signal messages.
          The first two memories store the messages in received order. The
          third memory stores the latest message. These messages display the
          3 digit calling station followed by the 2 digit message. Here's how
          to view digital signal message memory.

            1. Press and hold the FUNC key, then press the MESS key. Select
               any code squelch memory channel. The latest message will be
               displayed on the LCD display.

            2. Rotate the Main Tuning dial to review the previously sent
               messages in n1 through n2. You can also use the arrow keys to
               review these messages.

                                    Page 47

  11.7.5  CLEARING MESSAGE MEMORY

          If you find it necessary to clear out messages, proceed with the
          following steps.

            1. Select the memory number and press the C key once to clear out
               that location.

  12      CROSS BAND REPEATER

          The DJ-580 is capable of cross band repeat. To simplify matters, it
          means that when you transmit on one band it is simultaneously heard
          on the other band. Ok you want to set up a cross band repeater?
          Here are a few things to remember about cross band repeat:

            1. When cross band repeat is active, you cannot change
               frequencies or utilize other functions with the exception of
               cross band deactivation.

            2. Set squelch threshold before you activate cross band repeat.

            3. No radio modification is necessary to activate this function.

            4. This isn't a 100% duty cycle repeater. If the radio becomes
               extremely hot to the touch, the radio should be allowed a cool
               down time.

            5. Use cross band repeat in either Low or Mid power only.

            6. Cross band repeat will not allow for different CTCSS
                  Encode/Decode tones on each band.

               Using cross band repeat allows a user to enter on one band and
               cross over to the other band. You may use shifts or operate in
               simplex operation.

  12.1    ACTIVATE CROSS BAND REPEATER

          Here are the steps for cross band repeat.

            1. Rotate the volume controls for the VHF and UHF bands fully
               counter-clockwise.

            2. Press and hold the FUNC key, then press the FL key. The LCD
               should display FL.

            3. Press each key once as follows: #, 5, 0 and 8. You should
               notice that the word oPEn displays on the LCD and the opposite
               band indicator will begin to blink. The radio is now in cross
               band repeat. When a signal is received on one band, it will be
               retransmitted onto the other band.







                                    Page 48

  12.2    DEACTIVATE CROSS BAND REPEATER

          To return to original mode perform the following:

            1. Press and hold the FUNC key, then you will press the FL/PL key
               4 times. After you press it the first time the LCD will
               display CLoSE. This indicates to you that cross band repeat
               has been disabled. The other 3 times that you press the FL/PL
               key will turn off the FL and PL indicators.

  13      FULL DUPLEX OPERATION

          The principles of Full Duplex operation is very much like a
          telephone. The idea behind this is that when you are talking (let's
          say) on 2 meters you will hear the transmission from the other
          station on the 440 band. He will hear you on 2 meters.

          YOUR STATION                                  OTHER STATION

          TRANSMIT ON 2 METERS ------ -------- -------  RECEIVE ON 2 METERS
          RECEIVE ON 440 BAND  <-----<--------<-------- TRANSMIT ON 440 BAND

  13.1    ENABLE SPEAKER FULL-DUPLEX

          Enabling the speaker will cause feedback unless an external
          earphone or headset is used.

            1. Press and hold the FUNC key, then press the * key. The LCD
               should display FL.

            2. Press and hold the FUNC key, then press the 5 key. The LCD
               should display Fd-on. Repeat this step until the field
               indicates Fd-on.

            3. Press and hold the FUNC key, then press the FL/PL key
               repeatedly until the FL and PL indicators are absent from the
               LCD display.

  13.2    DISABLE SPEAKER SEMI-DUPLEX

          Perform the following steps:

            1. Press and hold the FUNC key, then press the * key. The LCD
               should display FL.

            2. Press and hold the FUNC key, then press the 5 key. The LCD
               should display Fd-oF. Repeat this step until the field
               indicates Fd-oF.

            3. Press and hold the FUNC key, then press the FL/PL key
               repeatedly until the FL and PL indicators are absent from the
               LCD display.






                                    Page 49

  14      AIRCRAFT RECEIVE MODIFICATION

          The radio will have to be opened and modified to receive aircraft
          and some frequencies in the 800 and 900Mhz region. This procedure
          isn't difficult if you take your time. If you are unsure of your
          ability to open and/or perform this mod, please find someone with
          this know how!
                                 *** NOTE ***

            Don't even think of performing this modification unless you
            have the right tools and temperament.

            1. Turn the radio off and remove the battery pack.

            2. CAREFULLY remove the 4 phillips screws on the bottom of the
               radio. These screws represent each corner of the
               bottom of the radio.

                                  Front of Radio
                        +---------------------------------+
                        |  * <- Remove these screws -  *  |
                        |                                 |
                        |  * <- Remove these screws -  *  |
                        +---------------------------------+

                            BOTTOM VIEW OF RADIO SHOWN

            3. You are about to remove the battery connector plate. There are
               wires connected to this plate. When moving the plate out of
               the way, don't pull further then you have to in order to see
               into the bottom of the radio. Locate a BRIGHT RED LOOPED WIRE.
               Remove or cut (tape exposed ends) this jumper. That's all
               there is folks!

                                *** WARNING ***

               You should be extremely careful not to cut the wrong wire. You
               may cut the BRIGHT RED LOOPED WIRE. Don't cut the pink or
               orange wire by mistake.


            4. Take your time and reassemble the radio. Make sure that during
               reassembly that you:

               o  Don't forget to place long tension arm (part of the battery
                  connector plate) into the battery lock clip located on the
                  same side of the radio as the PTT switch.

               REMEMBER, be patient and take your time. Never force anything
               together! It came apart easily, it should go back together
               that way.

            5. Reset the radio (Section 9.3) and enjoy a hot aircraft
               receiver. You will be able to enter a frequency range from
               108-173.995MHz. The receiver will actually begin to receive
               around 110 MHz.  Another way to gain access into the airband
               is, press the "FUNC" button while pressing the "VHF" key.

                                    Page 50

                             *** MULTI BAND RECEIVE ***

            After you modified your DJ-580 for Airband, you also enable
            coverage for some frequencies in the 800 and 900Mhz region. To
            receive coverage in this area, you can enter the frequency
            directly from the keypad or press the "FUNC" button while
            pressing the "UHF" key. The STEP key in regions will only allow
            increments of 10, 12.5, 20 and 25KHz.

                                 *** NOTE ***

            If you see a second decimal point blink in the frequency
            displayed, this means that the PLL circuitry isn't locked.
            Example:  108.0.0
                           ^____ This decimal point will blink.











































                                    Page 51

  ACCESSORIES
          OPTIONAL. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 1
          STANDARD. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 1
  AIRCRAFT RECEIVE. . . . . . . . . . . . . . . . . . . . . . . . . . . . .50
  ANTENNA CONNECTOR . . . . . . . . . . . . . . . . . . . . . . . . . . . .15
  APO KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .10
          AUTO POWER OFF INDICATOR. . . . . . . . . . . . . . . . . . . . .18
  AUTOMATIC DIALER (AUTODIAL) . . . . . . . . . . . . . . . . . . . . . . .37
          CLEAR DIALER MEMORY . . . . . . . . . . . . . . . . . . . . . . .37
          CORRECTING CODES IN DIALER MEMORY . . . . . . . . . . . . . . . .37
          DIALER RATE ADJUST. . . . . . . . . . . . . . . . . . . . . . . .39
          DISABLE AUTODIAL. . . . . . . . . . . . . . . . . . . . . . . . .39
          MANUAL DIAL . . . . . . . . . . . . . . . . . . . . . . . . . . .39
          PROGRAMMING AUTODIAL NUMBER . . . . . . . . . . . . . . . . . . .37
          TRANSMIT/CHANGE AUTODIAL NUMBER . . . . . . . . . . . . . . . . .38
  BATTERY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 3
          APO KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . .10
          BATTERY SAVE INDICATOR. . . . . . . . . . . . . . . . . . . . . .17
          BS KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .14
          EBP-20N . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 3
          EBP-22N . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 4
          LOCK BUTTON . . . . . . . . . . . . . . . . . . . . . . . . . . .17
          LOW LEVEL BATTERY MODE. . . . . . . . . . . . . . . . . . . . . .23
  BEEP KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .10
  BNC ANTENNA CONNECTOR . . . . . . . . . . . . . . . . . . . . . . . . . .15
  BS KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .14
  CALL KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .14
  CALL MODE . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .26
          ACTIVATING CALL CHANNEL . . . . . . . . . . . . . . . . . . . . .27
          CALL KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . .14
          COPY TO VFO FUNCTION. . . . . . . . . . . . . . . . . . . . . . .27
          PROGRAMMING THE CALL CHANNEL. . . . . . . . . . . . . . . . . . .26
  CALL PRIORITY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .28
  CALL.W KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .14
          CALL WRITE (CALL.W) KEY . . . . . . . . . . . . . . . . . . . . .14
  CLEARING ENTRY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .21
  CONTROL KEY PAD . . . . . . . . . . . . . . . . . . . . . . . . . . . 5, 20
          CLEARING ENTRY. . . . . . . . . . . . . . . . . . . . . . . . . .21
          KEY PAD DIRECT ENTRY. . . . . . . . . . . . . . . . . . . . . . .20
  CROSS BAND REPEATER . . . . . . . . . . . . . . . . . . . . . . . . . . .48
          ACTIVATE CROSS BAND REPEAT. . . . . . . . . . . . . . . . . . . .48
          DEACTIVATE CROSS BAND REPEAT. . . . . . . . . . . . . . . . . . .49
  CTCSS ENCODE/DECODE . . . . . . . . . . . . . . . . . . . . . . . . . . .36
  DECODE. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .36
  DESCRIPTIONS. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 4
          APO KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . .10
          BEEP KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . .10
          BNC ANTENNA CONNECTOR . . . . . . . . . . . . . . . . . . . . . .15
          CALL/CALL.W KEY . . . . . . . . . . . . . . . . . . . . . . . . .14
          CONTROL KEY PAD . . . . . . . . . . . . . . . . . . . . . . . . . 5
          DOWN ARROW AND FL/PL KEY. . . . . . . . . . . . . . . . . . . . .11
          DUAL KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . .11
          GP DSQ/DSQS KEY . . . . . . . . . . . . . . . . . . . . . . . . .12
          LAMP KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . .14
          LCD DISPLAY PANEL . . . . . . . . . . . . . . . . . . . . . . 5, 17
          MAIN TUNING DIAL. . . . . . . . . . . . . . . . . . . . . . . . .15
          MESS KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . .12

                                    Page 52

          MIC JACK. . . . . . . . . . . . . . . . . . . . . . . . . . . . .16
          MICROPHONE. . . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          MONI/BS KEY . . . . . . . . . . . . . . . . . . . . . . . . . . .14
          MR/MW KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . .12
          PO KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 8
          POWER ON/OFF CONTROL. . . . . . . . . . . . . . . . . . . . . . .15
          PRI/DIAL M KEY. . . . . . . . . . . . . . . . . . . . . . . . . .12
          REV KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . 7, 35
          SCN/PS KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . .13
          SHIFT KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          SKIP/M TO V KEY . . . . . . . . . . . . . . . . . . . . . . . . .12
          SPEAKER . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          SPEAKER JACK. . . . . . . . . . . . . . . . . . . . . . . . . . .16
          STEP KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . 6, 21
          T.SQL KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . 9
          TMS/VCS KEY . . . . . . . . . . . . . . . . . . . . . . . . . . .10
          TONE KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 8
          UHF BAND KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          UHF SQUELCH . . . . . . . . . . . . . . . . . . . . . . . . . . .15
          UHF VOLUME CONTROL. . . . . . . . . . . . . . . . . . . . . . . .15
          UP ARROW AND MESS KEY . . . . . . . . . . . . . . . . . . . . . .12
          V.U.SPEAKER JACK. . . . . . . . . . . . . . . . . . . . . . . . .16
          VHF BAND KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          VHF SQUELCH . . . . . . . . . . . . . . . . . . . . . . . . . . .15
          VHF VOLUME CONTROL. . . . . . . . . . . . . . . . . . . . . . . .15
  DIAL M KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .12
  DIALER. . . . . . . . . . . . . . . . . . . . . . . . .SEE AUTOMATIC DIALER
  DIGITAL SIGNAL MESSAGE. . . . . . . . . . . . . . . . . . . . . . . . . .46
          TRANSMITTING. . . . . . . . . . . . . . . . . . . . . . . . . . .47
          RECEIVING . . . . . . . . . . . . . . . . . . . . . . . . . . . .47
          REVIEW MESSAGE MEMORY . . . . . . . . . . . . . . . . . . . . . .47
          CLEARING MESSAGE MEMORY . . . . . . . . . . . . . . . . . . . . .48
  DOWN ARROW KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .11
  DSQ
          CLEARING MESSAGE MEMORY . . . . . . . . . . . . . . . . . . . . .47
          DIGITAL SIGNAL MESSAGE. . . . . . . . . . . . . . . . . . . . . .46
          DIGITAL SQUELCH . . . . . . . . . . . . . . . . . . . . . . . . .40
          DSQ MODES . . . . . . . . . . . . . . . . . . . . . . . . . . . .42
          ERROR CODE. . . . . . . . . . . . . . . . . . . . . . . . . . . .45
          PROGRAMMING ALL DSQ CODES . . . . . . . . . . . . . . . . . . . .41
          RECEIVING (CODE SQUELCH). . . . . . . . . . . . . . . . . . . . .43
          RECEIVING (GROUP CALLING) . . . . . . . . . . . . . . . . . . . .44
          RECEIVING (PRIVATE CALL). . . . . . . . . . . . . . . . . . . . .45
          RECEIVING (PRIVATE CALLING IN A GROUP). . . . . . . . . . . . . .44
          RECEIVING DIGITAL SIGNAL MESSAGE. . . . . . . . . . . . . . . . .47
          REVIEW DIGITAL SIGNAL MESSAGE MEMORY. . . . . . . . . . . . . . .47
          SCHEME. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .40
          TIMING CONSIDERATIONS . . . . . . . . . . . . . . . . . . . . . .45
          TRANSMITTING (CODE SQUELCH) . . . . . . . . . . . . . . . . . . .43
          TRANSMITTING (GROUP CALLING). . . . . . . . . . . . . . . . . . .43
          TRANSMITTING (PRIVATE CALL) . . . . . . . . . . . . . . . . . . .45
          TRANSMITTING (PRIVATE CALLING IN A GROUP) . . . . . . . . . . . .44
          TRANSMITTING DIGITAL SIGNAL MESSAGE . . . . . . . . . . . . . . .47
          TRANSMITTING WITH DIGITAL SIGNAL DISPLAYED. . . . . . . . . . . .47
          WILDCARDS . . . . . . . . . . . . . . . . . . . . . . . . . . . .46
  DSQS KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .12
  DUAL KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .11

                                    Page 53

  DUAL WATCH. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .29
          CALL/MEMORY . . . . . . . . . . . . . . . . . . . . . . . . . . .30
          CALL/VFO. . . . . . . . . . . . . . . . . . . . . . . . . . . . .30
          DUAL KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . .11
          PRIORITY/DUAL WATCH INDICATOR . . . . . . . . . . . . . . . . . .18
          VFO/MEMORY. . . . . . . . . . . . . . . . . . . . . . . . . . . .29
  ENCODE. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .36
  FL/PL KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .11
  FREQUENCY
          FREQUENCY INDICATOR . . . . . . . . . . . . . . . . . . . . . . .18
          STEP KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . 6, 21
  FREQUENCY COVERAGE
          AMERICAN. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 2
          EUROPEAN. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 2
  FRONT PANEL
          LCD DISPLAY . . . . . . . . . . . . . . . . . . . . . . . . . . .17
  FRONT PANEL CONTROLS/FUNCTIONS. . . . . . . . . . . . . . . . . . . . . . 5
  FULL DUPLEX OPERATION . . . . . . . . . . . . . . . . . . . . . . . . . .49
  FUNCTION KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .16
  GP DSQ KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .12
  INTRODUCTION. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 1
  LAMP KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .14
  LCD DISPLAY DESCRIPTIONS. . . . . . . . . . . . . . . . . . . . . . . 5, 17
          AM. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .18
          APO (AUTO POWER OFF). . . . . . . . . . . . . . . . . . . . . . .18
          BATTERY SAVE. . . . . . . . . . . . . . . . . . . . . . . . . . .17
          DIALER. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .18
          DSQ INDICATOR . . . . . . . . . . . . . . . . . . . . . . . . . .18
          FL (FREQUENCY LOCK) . . . . . . . . . . . . . . . . . . . . . . .19
          FREQUENCY DECIMAL POINT . . . . . . . . . . . . . . . . . . . . .19
          FREQUENCY INDICATOR . . . . . . . . . . . . . . . . . . . . . . .18
          MEMORY CHANNEL. . . . . . . . . . . . . . . . . . . . . . . . . .17
          ON AIR. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .18
          OUTPUT POWER. . . . . . . . . . . . . . . . . . . . . . . . . . .18
          PL (PTT LOCK) . . . . . . . . . . . . . . . . . . . . . . . . . .19
          PRIORITY/DUAL WATCH . . . . . . . . . . . . . . . . . . . . . . .18
          S/RF. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .19
          SHIFT . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .18
          SPLIT . . . . . . . . . . . . . . . . . . . . . . . . . . . .18, 35
          TIMER SCAN. . . . . . . . . . . . . . . . . . . . . . . . . . . .18
          TONE ENCODER/TONE SQUELCH . . . . . . . . . . . . . . . . . . . .17
          TONE FREQUENCY DECIMAL POINT. . . . . . . . . . . . . . . . . . .19
          UHF . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .19
          VHF . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .18
  LEFT SIDE CONTROLS
          BATTERY LOCK BUTTON . . . . . . . . . . . . . . . . . . . . . . .17
          FUNCTION KEY. . . . . . . . . . . . . . . . . . . . . . . . . . .16
          PTT SWITCH. . . . . . . . . . . . . . . . . . . . . . . . . . . .16
  LOW LEVEL BATTERY MODE. . . . . . . . . . . . . . . . . . . . . . . . . .23
  M TO V (MEMORY to VFO) KEY. . . . . . . . . . . . . . . . . . . . . . . .12
  MAIN TUNING DIAL. . . . . . . . . . . . . . . . . . . . . . . . . . . . .15
  MEMORY CHANNEL
          SKIP MODE . . . . . . . . . . . . . . . . . . . . . . . . . . . .32
  MEMORY MODE . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .23
          ALLOCATION OF MEMORY CHANNELS . . . . . . . . . . . . . . . . . .25
          CANCELLING A MEMORY CHANNEL . . . . . . . . . . . . . . . . . . .25
          MEMORY TO VFO COPY FUNCTION . . . . . . . . . . . . . . . . . . .26

                                    Page 54

  MEMORY MODE (CONTINUED)
          PROGRAMMING A MEMORY CHANNEL (MW KEY) . . . . . . . . . . . . . .23
          SCROLL MEMORY . . . . . . . . . . . . . . . . . . . . . . . . . .24
          SPLIT . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .35
  MEMORY PRIORITY . . . . . . . . . . . . . . . . . . . . . . . . . . . . .28
  MEMORY SCAN . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .32
          MEMORY CHANNEL SKIP MODE. . . . . . . . . . . . . . . . . . . . .32
  MESS KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .12
  MICROPHONE. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          MICROPHONE JACK . . . . . . . . . . . . . . . . . . . . . . . . .16
  MODIFICATION
          AIRCRAFT RECEIVE. . . . . . . . . . . . . . . . . . . . . . . . .50
  MONI KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .14
  MONO BAND FUNCTION. . . . . . . . . . . . . . . . . . . . . . . . . . . .22
  MR KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .13, 24
  MR/MW KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .13
  MW KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .13, 23
  PO (POWER OUTPUT) KEY . . . . . . . . . . . . . . . . . . . . . . . . . . 8
  POWER
          APO KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . .10
          BS KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .14
          DC IN JACK. . . . . . . . . . . . . . . . . . . . . . . . . . . .17
          EBP-20N BATTERY . . . . . . . . . . . . . . . . . . . . . . . . . 3
          EBP-22N BATTERY . . . . . . . . . . . . . . . . . . . . . . . . . 4
          GENERAL POWER READINGS. . . . . . . . . . . . . . . . . . . . . . 4
          LCD OUTPUT POWER INDICATOR. . . . . . . . . . . . . . . . . . . .18
          ON/OFF CONTROL. . . . . . . . . . . . . . . . . . . . . . . . . .15
          OUTPUT SETTING. . . . . . . . . . . . . . . . . . . . . . . . . .22
          PO KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 8
  PRI KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .12
          PRIORITY/DUAL WATCH INDICATOR . . . . . . . . . . . . . . . . . .17
  PRIORITY FUNCTIONS. . . . . . . . . . . . . . . . . . . . . . . . . . . .27
          CALL PRIORITY . . . . . . . . . . . . . . . . . . . . . . . . . .28
          MEMORY PRIORITY . . . . . . . . . . . . . . . . . . . . . . . . .28
          VFO PRIORITY. . . . . . . . . . . . . . . . . . . . . . . . . . .27
  PS KEY
          PROGRAMMABLE SCAN (PS) Key. . . . . . . . . . . . . . . . . . . .13
  PTT SWITCH. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .16
  REPEATER OPERATIONS . . . . . . . . . . . . . . . . . . . . . . . . . . .34
          MEMORY MODE SPLIT . . . . . . . . . . . . . . . . . . . . . .18, 35
          REV KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . .35
          SPLIT FREQUENCY FUNCTION. . . . . . . . . . . . . . . . . . .18, 34
          VFO MODE SPLIT. . . . . . . . . . . . . . . . . . . . . . . .18, 34
  RESETTING RADIO . . . . . . . . . . . . . . . . . . . . . . . . . . . . .35
  REV KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 7, 35
  RIGHT SIDE CONTROLS
          DC IN JACK. . . . . . . . . . . . . . . . . . . . . . . . . . . .17
  SCANNING. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .30
          DUAL BAND SCAN. . . . . . . . . . . . . . . . . . . . . . . . . .33
          DUAL BAND WITH MEMORY PRIORITY. . . . . . . . . . . . . . . . . .34
          MEMORY SCAN . . . . . . . . . . . . . . . . . . . . . . . . . . .32
          PROGRAM BAND SCAN MODE. . . . . . . . . . . . . . . . . . . . . .31
          TYPES . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .33
          VFO SCAN. . . . . . . . . . . . . . . . . . . . . . . . . . . . .31
  SCN KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .13



                                    Page 55

  SHIFT KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          SHIFT INDICATOR . . . . . . . . . . . . . . . . . . . . . . . . .18
          SPLIT SHIFT INDICATOR . . . . . . . . . . . . . . . . . . . .17, 35
  SKIP KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .12, 33
  SPEAKER . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          JACK. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .16
          VHF/UHF SPEAKER JACK. . . . . . . . . . . . . . . . . . . . . . .16
          ENABLE SPEAKER FULL DUPLEX. . . . . . . . . . . . . . . . . . . .49
          DISABLE SPEAKER SEMI DUPLEX . . . . . . . . . . . . . . . . . . .49
  SPECIFICATIONS. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 2
          AMERICAN FREQUENCY COVERAGE . . . . . . . . . . . . . . . . . . . 2
          BATTERY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 3
          EBP-20N BATTERY . . . . . . . . . . . . . . . . . . . . . . . . . 4
          EUROPEAN FREQUENCY COVERAGE . . . . . . . . . . . . . . . . . . . 2
          GENERAL . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 2
          RECEIVER. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 3
          TRANSMITTER . . . . . . . . . . . . . . . . . . . . . . . . . . . 3
  SQUELCH
          UHF . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .15
          VHF . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .15
  STEP KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 6, 21
  T.SQL (TONE SQUELCH) KEY. . . . . . . . . . . . . . . . . . . . . . . . . 9
  TMS KEY
          TIMED MEMORY SCAN (TMS) KEY . . . . . . . . . . . . . . . . . . .10
          TIMER SCAN INDICATOR. . . . . . . . . . . . . . . . . . . . . . .18
  TONE KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 8
  TONE SQUELCH (T.SQL) KEY. . . . . . . . . . . . . . . . . . . . . . . . . 9
          TONE ENCODER/TONE SQUELCH INDICATOR . . . . . . . . . . . . . . .17
  TOP PANEL
          BNC ANTENNA CONNECTOR . . . . . . . . . . . . . . . . . . . . . .15
          CONTROLS AND FUNCTIONS. . . . . . . . . . . . . . . . . . . . . .15
          MAIN TUNING DIAL. . . . . . . . . . . . . . . . . . . . . . . . .15
          POWER ON/OFF AND UHF VOLUME CONTROL . . . . . . . . . . . . . . .15
          SPEAKER JACK. . . . . . . . . . . . . . . . . . . . . . . . . . .16
          UHF SQUELCH . . . . . . . . . . . . . . . . . . . . . . . . . . .15
          VHF SQUELCH . . . . . . . . . . . . . . . . . . . . . . . . . . .15
          VHF VOLUME CONTROL. . . . . . . . . . . . . . . . . . . . . . . .15
  TRANSCEIVER MODES . . . . . . . . . . . . . . . . . . . . . . . . . . . .23
          CALL MODE . . . . . . . . . . . . . . . . . . . . . . . . . . . .26
          MEMORY MODE . . . . . . . . . . . . . . . . . . . . . . . . . . .23
          VFO . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .23
  TRANSMITTING. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .22
          LOW LEVEL BATTERY MODE. . . . . . . . . . . . . . . . . . . . . .22
          POWER OUTPUT SETTING. . . . . . . . . . . . . . . . . . . . . . .22
  UHF
          BAND KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          INDICATOR . . . . . . . . . . . . . . . . . . . . . . . . . . . .19
          SQUELCH . . . . . . . . . . . . . . . . . . . . . . . . . . . . .15
          VOLUME CONTROL. . . . . . . . . . . . . . . . . . . . . . . . . .15
  UP ARROW KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .12
  VFO MODE. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .23
          SPLIT . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .34
  VFO PRIORITY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .27
  VFO SCAN. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .31




                                    Page 56

  VHF
          BAND KEY. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 5
          INDICATOR . . . . . . . . . . . . . . . . . . . . . . . . . . . .18
          SQUELCH . . . . . . . . . . . . . . . . . . . . . . . . . . . . .15
          VOLUME CONTROL. . . . . . . . . . . . . . . . . . . . . . . . . .15
  VOLUME CONTROL
          UHF . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .15
          VHF . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .15
  W KEY . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .26

















































                                    Page 57

