Date:       Wed, 26 Jul 89 12:04:40 EST
From: MKELLY@CARLETON.CA
Reply-To: "MKELLY/2020"@CARLETON.CA
Subject:    PRO 2020 SCANNER MOD

Here is the mod for the Radio Shack Pro-2020 Scanner that I posted
to Info-Hams Vol 89 Issue 314, Slightly condensed.
It adds another 80 memories to the existing 20, in four banks of  20,
and suggests other mods.
It MIGHT be helpfull for other scanners that store frequency info in
a ram seperate from the cpu chip.
The address, data, and WE lines on the old and new ram are paralleled.
Chip enable from the cpu is multiplexed to the old and new ram, with
the mux select being driven by a high order line from a counter. The
high order address lines on the new ram are driven off of the low
order bits of the same counter that drives the mux.  These counter
lines also drive a binary->7 segment decoder/led driver to indicate
which bank the machine is using.  The mux output is inhibited by a
power_on_reset signal to prevent spurious writes during power up.
CE1 from the cpu goes to the input to a 1 to 2 mux (1 input, CE1;
2 outputs, OLD_CE1, NEW_CE1).
The mux is made of 1/2 of a 74hc00 2 input nand and 2/3 of a 74hc10
3 input nand. There is one 3 in nand unused, inputs are tied high.
The 3input nands drive the ce lines on the rams.  The third input on
each of the two 3 in nands is driven by the power_on_reset line that
goes to CE2 of the ram in the original machine.  This signal stays
low until the rest of the system is powered up and stable,  preventing
spurious chip selects (& writes) until the power up sequence is complete.
The top 2 address lines of the new ram (1k x 4 cmos) are selected by a
4520 4 bit binary counter configured to count 0,1,2,3,4 with binary
output 101 decoded with another 1/4 of the 74hc00 looking for a high on
Q0 and Q2 of the counter at the same time.  This signal is inverted
(using the last 1/4 of the 74hc00) and fed into the clear line of the
counter.  The clock inputs are configured so a low on the clock will
increase the count. The line(s) being used for the clock have a resistor
to counter vcc and a capacitor to ground.  The bank select switch is a
SPST N.O. switch that shorts the capacitor.
Q2 goes to the select input of the mux.  When Q2 is low, chip selects
from the cpu go thru to the new ram, and when it is high, the chip
selects go to the original ram, as before, like this:
Q0  Q1  Q2
0   0   0  new ram bank 00  bank display reads 0
1   0   0  new ram bank 01  bank display reads 1
0   1   0  new ram bank 10  bank display reads 2
1   1   0  new ram bank 11  bank display reads 3
0   0   1  old ram (only one bank)  bank display reads 4
1   0   1  generate asynch reset and go back to 0 0 0
The bank display
is a FND367 using 470 ohm resistors to +5v.  The display driver is a
4511 driven off the SECOND counter in the 4520 package.  Since one of
the segments in a 0-1-2-3-4 counter is always on, it is run (via its
resistor) directly off +5, rather than off of the 4511.
I used rather stiff decoupling (around 100uF in parallel with .1uF)
on the display "module" (4511+fnd367), and the expansion board on both
+5V and +5VBACKUP lines.  This may be excessive, but overkill doesn't  hurt

THE NEXT TIME I'm in there, I will probably switch the 4520 power line
onto the battery backup, so it will power up in the bank I left it in,
rather than at any bank at random as it does now.  If I were doing it
again, I would drive the 4511 off the same lines as the address, rather
than using the second counter in the package, because on power up, the
two halves of the counter chip might have different numbers in them,
causing the bank display to "lie" to you until you go to bank zero (when
both halves get a reset and get synched up again)
I have decided that the scan speed is too slow to make any practical use
of the idea of decoding "20" in the channel number display and using
it to clock the "bank" counter.  With that many channels being scanned,
the chances of catching anything diminish too far.

THE NEXT MOD is to put a fet switch (probably a TIS73 jfet) across the
"speed" switch, with a capacitor from the gate to the switched +5V line
and a resistor from the gate to ground.  This should hold the "speed"  key
on the keypad closed on power up, so the machine starts off in "fast"
speed, rather than in slow.   I havent thought this one out yet, so if
you beat me to it, lemme know how it works.
This mode isn't the best one to send schematics through, so if you
want a schematic of the mod, send me a papermail address.  Mine is:
Mike Kelly, Carleton University, Colonel By Dr., Ottawa, Ontario,
Canada, K1S 5B6.                 73.. mike k. (VE3 FFK)

------------------------------

