// IDE Debug - FiveWin Debug Support

#include "FiveWin.ch"

static oWndDbg

//----------------------------------------------------------------------------//

function Debug()

   local oIcon, oBar

   if oWndDbg != nil
      return nil
   endif

   DEFINE ICON oIcon RESOURCE "Debug"

   DEFINE WINDOW oWndDbg FROM 1, 1 TO 23, 33 ;
      ICON oIcon TITLE "Debug Window" ;
      MDICHILD COLOR "W+/N*"              // By defaults gets the MdiFrame

   DEFINE BUTTONBAR oBar OF oWndDbg

   DEFINE BUTTON OF oBar RESOURCE "AddWatch" ;
      MESSAGE "Inspect a new variable"

   DEFINE BUTTON OF oBar RESOURCE "DelWatch" ;
      MESSAGE "End inspecting this variable"

   DEFINE BUTTON GROUP OF oBar RESOURCE "Local" ;
      MESSAGE "Watch local variables"

   DEFINE BUTTON OF oBar RESOURCE "_Static" ;
      MESSAGE "Watch static variables"

   DEFINE BUTTON OF oBar RESOURCE "Private" ;
      MESSAGE "Watch private variables"

   DEFINE BUTTON OF oBar RESOURCE "Public" ;
      MESSAGE "Watch public variables"

   DEFINE BUTTON GROUP OF oBar RESOURCE "AllVars" ;
      MESSAGE "Watch all of them"

   ACTIVATE WINDOW oWndDbg ;
      VALID ( oWndDbg := nil, .t. )       // Destroy the Object

return nil

//----------------------------------------------------------------------------//

function FwWatch( cProc, nLine )

   local n := 0

   if oWndDbg != nil
      while ! Empty( ProcName( n ) )
         oWndDbg:Say( 2 + n, 2, ProcName( n++ ) )
      end
   endif

return nil

//----------------------------------------------------------------------------//
