#include "FiveWin.ch"

#define IT_UNDEFINED 0
#define IT_BITMAP    1
#define IT_DATABASE  2
#define IT_DIALOG    3
#define IT_DOC       4
#define IT_ICON      5
#define IT_INDEX     6
#define IT_MENU      7
#define IT_PROGRAM   8
#define IT_REPORT    9
#define IT_SOUND    10

// If you are using Clipper 5.01 change the following:
// #define IDE_DRIVERS DbfNtx

#define    IDE_DRIVERS  DbfNtx    // , DbfCdx, DbfMdx, DbfNdx, DbPx
#translate DRIVERS( <Driver1> [,<Driver2>] ) ;
        => { <(Driver1)> [,<(Driver2)>] }

static oWnd, oWndAreas, oItemAreas, oIcon

static cIncPath, cLibPath, cProject, lWorkAreas

static aPrjBmps := {}
static aObjBmps := {}
static aDbfBmps := {}
static aRptBmps := {}

//----------------------------------------------------------------------------//

function Main()

   local oBrush, oBar, oDlg

   SET RESOURCES TO "Ide.dll"
   SET 3DLOOK ON

   IdeInit()

   extern IDE_DRIVERS

   RddSetDefault( "DbfNtx" )

   DEFINE BRUSH oBrush STYLE TILED

   DEFINE ICON oIcon RESOURCE "FwIde"

   DEFINE WINDOW oWnd FROM 0, 0 TO 23, 78 ;
      TITLE FWVERSION + " - IDE" ;
      BRUSH oBrush ;
      ICON  oIcon ;
      MDI ;
      MENU BuildMenu() ;
      MENUINFO 5                   // Where Windows will report of MdiChild
      
   DEFINE BUTTONBAR oBar 3D SIZE 33, 33 OF oWnd

   DEFINE BUTTON RESOURCE "Info" OF oBar ;
      MESSAGE "About FiveWin" ;
      ACTION ShellAbout( FWVERSION + " IDE", FWCOPYRIGHT, oIcon:hIcon )

   DEFINE BUTTON RESOURCE "SelFile" OF oBar ;
      MESSAGE "Select a file" ACTION SelFile()

   DEFINE BUTTON RESOURCE "Exit" OF oBar ACTION oWnd:End() ;
      MESSAGE "Exit from IDE"

   DEFINE BUTTON RESOURCE "Cut" OF oBar GROUP ;
      MESSAGE "Cut to Clipboard" ACTION MsgInfo( "Cut" )

   DEFINE BUTTON RESOURCE "Copy" OF oBar ;
      MESSAGE "Copy to Clipboard" ACTION MsgInfo( "Copy" )

   DEFINE BUTTON RESOURCE "Paste" OF oBar ;
      MESSAGE "Paste from Clipboard" ACTION MsgInfo( "Paste" )

   DEFINE BUTTON RESOURCE "Project" GROUP OF oBar ;
      MESSAGE "Open a project" ACTION PrjOpen()

   DEFINE BUTTON RESOURCE "Debug" OF oBar ;
      MESSAGE "Inspects the application Stack" ACTION StackInspect()

   DEFINE BUTTON RESOURCE "Objects" OF oBar ;
      MESSAGE "Inspects the IDE Object" ACTION ObjInspect( oWnd, "oWnd" )

   DEFINE BUTTON RESOURCE "DataBase" GROUP OF oBar ;
      MESSAGE "Use a database" ACTION DbfOpen()

   DEFINE BUTTON RESOURCE "Edit" OF oBar ;
      MESSAGE "Review a program" ACTION PrgOpen()

   DEFINE BUTTON RESOURCE "Menu" OF oBar ;
      MESSAGE "Review a menu" ACTION MnuOpen()

   DEFINE BUTTON RESOURCE "Dialog" OF oBar ;
      MESSAGE "Review a dialog Box" ACTION DlgOpen()

   DEFINE BUTTON RESOURCE "Report" OF oBar ;
      MESSAGE "Review a report" ACTION ReportOpen()

   DEFINE BUTTON RESOURCE "Doc" OF oBar ;
      MESSAGE "Review documentation files" ACTION DocOpen()

   DEFINE BUTTON RESOURCE "Trash" GROUP OF oBar ;
      MESSAGE "Control of deleted objects"

   DEFINE BUTTON RESOURCE "MsDos" GROUP OF oBar ;
      MESSAGE "Quick access to MsDos" ;
      ACTION WinExec( "Command.com" )

   // @ 2, 2 BITMAP RESOURCE "Fw16" NOBORDER OF oWnd:oWndClient

   SET MESSAGE OF oWnd TO FWVERSION + " - " + FWCOPYRIGHT

   ACTIVATE WINDOW oWnd MAXIMIZED ;
      ON INIT ( If( lWorkAreas, WorkAreas(),),;
                If( ! Empty( cProject ), PrjOpen( cProject ),) ) ;
      ON RIGHT CLICK IdePopup() ;
      VALID MsgYesNo( "Exit FiveWin IDE ?" )

   AEval( aPrjBmps, { | hBmp | DeleteObject( hBmp ) } )
   AEval( aObjBmps, { | hBmp | DeleteObject( hBmp ) } )
   AEval( aDbfBmps, { | hBmp | DeleteObject( hBmp ) } )
   AEval( aRptBmps, { | hBmp | DeleteObject( hBmp ) } )

return nil

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "&Program"
      MENU
        MENUITEM "&New..."   ACTION PrgNew()  MESSAGE "Creates a new program"
        MENUITEM "&Open..."  ACTION PrgOpen() MESSAGE "Edit a previous program"
        MENUITEM "&Save..."
        MENUITEM "&Save as..."
        SEPARATOR
        MENUITEM "&Execute..."    MESSAGE "Execute a program"
        MENUITEM "&Parameters..." MESSAGE "Select execution parameters"
        SEPARATOR
        MENUITEM "&Exit..." ACTION oWnd:End() ;
          MESSAGE "Finishing with FiveWin IDE"
      ENDMENU

      MENUITEM "&DataBases"
      MENU
         MENUITEM "&Use DBF..." ACTION DbfOpen() ;
            MESSAGE "Open a DataBase"

         MENUITEM "&Create DBF..."  ACTION DbfNew() ;
            MESSAGE "Create a new DataBase"

         MENUITEM oItemAreas PROMPT "&WorkAreas..." ;
            ACTION WorkAreas() ;
            MESSAGE "Inspects the DataBase WorkAreas"

         SEPARATOR
         MENUITEM "I&ndexes..."  ACTION IdxBuilder() MESSAGE "Build a new Index"
         MENUITEM "&Relations..." MESSAGE "Control of existing relations"
         MENUITEM "&Filters..."   MESSAGE "Controls of existing filters"
         SEPARATOR
         MENUITEM "New r&eport..." ACTION ReportNew() ;
            MESSAGE "Design a new report"
      ENDMENU

      MENUITEM "&Resources"
      MENU
         MENUITEM "&Bitmaps" ACTION BmpOpen() MESSAGE "Review a bitmap"
         MENUITEM "&Dialog Boxes..."  ACTION DlgOpen() MESSAGE "Review a Dialog Box"
         MENUITEM "&Icons..."
         MENUITEM "&PullDown Menu..."
         MENUITEM "&Sound..."         ACTION WinExec( "SoundRec" )
         MENUITEM "&Video..."
         SEPARATOR
         MENUITEM "&Compile RC... " ;
            ACTION WinExec( "rc.pif" + ;
                            cGetFile( "Windows Resources (*.rc) | *.rc",;
                                      "Select a RC" ) )
         MENUITEM "&Resource WorkShop" ;
            ACTION WinExec( "c:\borlandc\bin\WorkShop" ) ;
            MESSAGE "Use Borland's Resource WorkShop"
      ENDMENU

      MENUITEM "Pr&oject"
      MENU
         MENUITEM "&New Project..." ACTION PrjNew() ;
            MESSAGE "Creates a new project"

         MENUITEM "&Open Project..." ACTION PrjOpen() ;
            MESSAGE "Use a previous defined project"

         SEPARATOR
         MENUITEM "&Review Documentation..." ;
            MESSAGE "Review documentation files" ACTION DocOpen()

         MENUITEM "&Review Libraries..." ;
            MESSAGE "Review Libraries LIB files"

         SEPARATOR
         MENUITEM "&Configure..." ACTION PrjConfig() ;
            MESSAGE "Set default Project parameters"

         MENUITEM "&Build"
         SEPARATOR
         MENUITEM "&FiveWin RegisterEXE()" ;
            MESSAGE "Free a FiveWin application" ;
            ACTION RegisterEXE()
      ENDMENU

      MENUITEM "&Windows"
      MENU
         MENUITEM "&Arrange Icons"            ACTION oWnd:ArrangeIcons() ;
            MESSAGE "Reorganize iconized windows positions on the desktop"

         MENUITEM "&Vertical Tile Windows"    ACTION oWnd:Tile() ;
            MESSAGE "Adjust vertical position of windows over the desktop"

         MENUITEM "&Horizontal Tile Windows"  ACTION oWnd:Tile( .t. ) ;
            MESSAGE "Adjust horizontal position of windows over the desktop"

         MENUITEM "&Cascade Windows"          ACTION oWnd:Cascade() ;
            MESSAGE "Adjust order position of windows over the desktop"

         MENUITEM "C&lose All Windows"        ACTION oWnd:CloseAll() ;
            MESSAGE "Close all child windows over the desktop"

         SEPARATOR
         MENUITEM "&Inspect IDE Window " ;
            MESSAGE "Inspect the Object IDE Window" ;
            ACTION ObjInspect( oWnd, "oWnd" )
      ENDMENU

      MENUITEM "&Help"
      MENU
         MENUITEM "&Contents..."   MESSAGE "FiveWin IDE Help contents"
         MENUITEM "&Search..."     MESSAGE "Search help for a specific topic"
         MENUITEM "&Using help..." MESSAGE "How to use the IDE Help"
         SEPARATOR
         MENUITEM "&About" ;
            ACTION ShellAbout( FWVERSION + " IDE", FWCOPYRIGHT, oIcon:hIcon )

      ENDMENU
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function PrgNew()

   local cPrgName
   local nStart   := 1

   while File( cPrgName := ( "NONAM" + SubStr( Str( nStart + 100, 3 ), 2 ) ;
                             + ".prg" ) )
      nStart++
   end

   PrgOpen( cPrgName )

return nil

//----------------------------------------------------------------------------//

function PrgOpen( cPrgName )

   local oWndEdit, oBar, oGet, oIco, oCrsPen
   local cText

   DEFAULT cPrgName := cGetFile( "Clipper Program (*.prg) | *.prg",;
                                 "Select a PRG" )
   if Empty( cPrgName )
      return nil
   else
      cText = MemoRead( cPrgName )
   endif

   DEFINE ICON oIco RESOURCE "Write"

   DEFINE CURSOR oCrsPen RESOURCE "Pen"

   DEFINE WINDOW oWndEdit FROM 1, 1 TO 23, 33 ;
      TITLE "Program: " + cNoPath( cNoExt( cPrgName ) ) MDICHILD OF oWnd ;
      ICON oIco

   DEFINE BUTTONBAR oBar OF oWndEdit

   DEFINE BUTTON RESOURCE "ToDisk" OF oBar ;
      MESSAGE "Save to disk" ;
      ACTION ( oGet:Save(), MemoWrit( cPrgName, cText ), Tone( 900, 1 ) )

   DEFINE BUTTON RESOURCE "Compile" GROUP OF oBar ;
      ACTION ( oGet:SetFocus( .f. ),;
               MemoWrit( cPrgName, cText ),;
               WinExec( "compile.pif " + cPrgName ) )

   DEFINE BUTTON RESOURCE "Link" OF oBar ;
      ACTION WinExec( "link.pif " + ;
                      SubStr( cPrgName, 1, RAt( ".", cPrgName ) - 1 ) )

   DEFINE BUTTON RESOURCE "Exec"    OF oBar ;
      ACTION WinExec( SubStr( cPrgName, 1, RAt( ".", cPrgName ) - 1 ) )

   DEFINE BUTTON RESOURCE "Font" GROUP OF oBar ACTION oGet:SelFont() ;
      MESSAGE "Selects a new font and text color"

   DEFINE BUTTON RESOURCE "Clr"  OF oBar ACTION oGet:SelColor() ;
      MESSAGE "Selects a new background color"

   @ 0, 0 GET oGet VAR cText MEMO OF oWndEdit CURSOR oCrsPen

   oWndEdit:SetControl( oGet )

   oGet:bRClicked = { || ThisInspect( oGet ) }

   ACTIVATE WINDOW oWndEdit

return nil

//----------------------------------------------------------------------------//

function PrjNew()

   local cPrjName
   local nStart := 1

   while File( cPrjName := ( "PROJEC" + SubStr( Str( nStart + 100, 3 ), 2 ) ;
                             + ".prj" ) )
      nStart++
   end

   if ! File( cPrjName )
      DbCreate( cPrjName, { { "TYPE",     "N",  2, 0 },;
                            { "NAME",     "C", 50, 0 },;
                            { "DESCRIPT", "C", 50, 0 } } )
   endif

   PrjOpen( cPrjName )

return nil

//----------------------------------------------------------------------------//

function PrjOpen( cPrjName )

   local oIco, oWndPrj, oBrw, oBar, oFont
   local cNtxName, cAlias
   local nType
   FIELD Type, Name, Descript

   DEFAULT cPrjName := cGetFile( "FiveWin IDE Project ( *.prj ) | *.prj",;
                                 "Select a Project" )

   if Len( aPrjBmps ) == 0
      aPrjBmps = { LoadBitmap( GetResources(), "QesSmal" ),;
                   LoadBitmap( GetResources(), "BmpSmal" ),;
                   LoadBitmap( GetResources(), "DbfSmal" ),;
                   LoadBitmap( GetResources(), "DlgSmal" ),;
                   LoadBitmap( GetResources(), "DocSmal" ),;
                   LoadBitmap( GetResources(), "IcoSmal" ),;
                   LoadBitmap( GetResources(), "IdxSmal" ),;
                   LoadBitmap( GetResources(), "MnuSmal" ),;
                   LoadBitmap( GetResources(), "PrgSmal" ),;
                   LoadBitmap( GetResources(), "RptSmal" ),;
                   LoadBitmap( GetResources(), "SndSmal" ) }
   endif

   if ! Empty( cPrjName )
      USE ( cPrjName ) NEW SHARED
      If RecCount() == 0
         APPEND BLANK
         Type     := 0
         Name     := "UnDefined"
         Descript := "No description available"
      endif
      cNtxName = SubStr( cNoPath( cPrjName ), 1,;
                         At( ".", cNoPath( cPrjName ) ) - 1 )
      INDEX ON Type TO ( cNtxName )
      SET INDEX TO ( cNtxName )
   else
      return nil
   endif

   cAlias = Alias()

   DEFINE ICON oIco RESOURCE "Project"

   DEFINE WINDOW oWndPrj FROM 1, 35 TO 23, 79 ;
      TITLE "Project: " + cNoPath( cNoExt( cPrjName ) ) MDICHILD OF oWnd ;
      ICON oIco

   DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

   @  0, 0 LISTBOX oBrw ;
      FIELDS aPrjBmps[ Min( Max( ( cAlias )->Type + 1, 1 ),;
                            Len( aPrjBmps ) ) ],;
                       Upper( cNoPath( ( cAlias )->Name ) ),;
                       ( cAlias )->Descript ;
      FIELDSIZES 16, 110, 500 ;
      HEADERS " ", "Name", "Description" ;
      OF oWndPrj ;
      ON DBLCLICK ItemOpen( oBrw ) ;
      ON CHANGE If( oWndAreas != nil, oWndAreas:oControl:Refresh(),) ;
      FONT oFont ;
      SIZE 400, 400

   DEFINE BUTTONBAR oBar OF oWndPrj

   DEFINE BUTTON OF oBar RESOURCE "New" ;
      ACTION oBrw:RecAdd() ;
      MESSAGE "Add a new item to the project"

   DEFINE BUTTON OF oBar RESOURCE "Edit" ;
      ACTION ItemNew( oBrw ) ;
      MESSAGE "Edit the current project item"

   DEFINE BUTTON OF oBar RESOURCE "Del" ;
      MESSAGE "Delete the current project item" ;
      ACTION ItemDel( oBrw )

   DEFINE BUTTON OF oBar RESOURCE "InspSma" ;
      ACTION ItemOpen( oBrw ) ;
      MESSAGE "Inspect the current project item"

   DEFINE BUTTON RESOURCE "Font" GROUP OF oBar ACTION oBrw:SelFont() ;
      MESSAGE "Selects a different font and Text Color"

   DEFINE BUTTON RESOURCE "Clr" OF oBar ACTION oBrw:SelColor() ;
      MESSAGE "Selects the Background Color"

   oWndPrj:SetControl( oBrw )

   ACTIVATE WINDOW oWndPrj ;
      VALID If( MsgYesNo( "Close project ?" ), oBrw:lCloseArea(), .f. )

   if oWndAreas != nil
      oWndAreas:oControl:Refresh()  // We updates the info on the WorkAreas
   endif                            // inspector

return nil

//----------------------------------------------------------------------------//

function DbfOpen( cDbfName, cDriver )

   local oWndBrw, oBar, oBrw, oIco, oWndRec, oFont
   local nFilter
   local cAlias

   DEFAULT cDriver  := "DbfNtx"

   if Empty( cDbfName )
      cDbfName := cGetFile( "Standard dbf (*.dbf) | *.dbf |" + ;
                            "FoxPro cdx (*.dbf) | *.dbf |" + ;
                            "dBase IV mdx (*.dbf) | *.dbf |" + ;
                            "dBase III+ ndx (*.dbf) | *.dbf |" + ;
                            "Paradox db (*.db) | *.db", ;
                            "Select a DataBase to use" )

      cDriver = DRIVERS( IDE_DRIVERS )[ nGetFileFilter() ]
   endif

   if ! Empty( cDbfName )

      USE ( cDbfName ) NEW VIA ( cDriver ) SHARED ;
         ALIAS ( cCheckArea( cNoExt( cNoPath( cDbfName ) ) ) )

      cAlias = Alias()

      DEFINE ICON oIco RESOURCE "Browse"

      DEFINE WINDOW oWndBrw FROM 1, 1 TO 23, 33 ;
         TITLE "DataBase: " + cNoExt( cNoPath( cDbfName ) ) ;
         ICON oIco MDICHILD OF oWnd

      DEFINE BUTTONBAR oBar OF oWndBrw

      DEFINE BUTTON RESOURCE "New" OF oBar ;
         ACTION ( oBrw:RecAdd(), oBrw:Refresh() ) ;
         MESSAGE "Add a new record"

      DEFINE BUTTON RESOURCE "Edit" OF oBar ;
         MESSAGE "Edit current record" ;
         ACTION  oWndRec := RecEdit( "Record: " + cAlias, oBrw )

      DEFINE BUTTON RESOURCE "Del" OF oBar ;
         MESSAGE "Delete current record" ;
         ACTION ( ( cAlias )->( DelToggle() ), oBrw:DrawSelect() )

      DEFINE BUTTON RESOURCE "Top" GROUP OF oBar ;
         ACTION oBrw:GoTop() ;
         MESSAGE "Go to first record"

      DEFINE BUTTON RESOURCE "Rewind" OF oBar ;
         ACTION oBrw:PageUp() ;
         MESSAGE "Go to previous page"

      DEFINE BUTTON RESOURCE "Prev" OF oBar ;
         ACTION oBrw:GoUp() ;
         MESSAGE "Go previous record"

      DEFINE BUTTON RESOURCE "Next" OF oBar ;
         ACTION oBrw:GoDown() ;
         MESSAGE "Go to next record"

      DEFINE BUTTON RESOURCE "Forward" OF oBar ;
         ACTION oBrw:PageDown() ;
         MESSAGE "Go to next page"

      DEFINE BUTTON RESOURCE "Bottom" OF oBar ;
         ACTION oBrw:GoBottom() ;
         MESSAGE "Go to last record"

      DEFINE BUTTON RESOURCE "Font" GROUP OF oBar ;
         ACTION oBrw:SelFont() ;
         MESSAGE "Select a new font"

      DEFINE BUTTON RESOURCE "Clr" OF oBar ;
         ACTION ( oBrw:SelColor(),;
                  If( oWndRec != nil,;
                  oWndRec:oControl:SetColor( oBrw:nClrText, oBrw:nClrPane ),) ) ;
         MESSAGE "Select a new backcolor"

      DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

      @ 0, 0 LISTBOX oBrw FIELDS OF oWndBrw ;
         ON CHANGE ( If( oWndAreas != nil, oWndAreas:oControl:Refresh(),),;
                     If( oWndRec != nil, oWndRec:oControl:Refresh(),) ) ;
         ON DBLCLICK oWndRec := RecEdit( "Record: " + cAlias, oBrw ) ;
         SIZE 400, 400 FONT oFont

      oBrw:bLine = { | aTemp | aTemp := _aFields( cAlias ),;
                               AAdd( aTemp, nil ), AIns( aTemp, 1 ),;
                               aTemp[ 1 ] := If( ( cAlias )->( Deleted() ),;
                               aDbfBmps[ 2 ], aDbfBmps[ 1 ] ), aTemp }

      AAdd( oBrw:aColSizes, nil )
      AIns( oBrw:aColSizes, 1 )
      oBrw:aColSizes[ 1 ] = 16

      AAdd( oBrw:aHeaders, nil )
      AIns( oBrw:aHeaders, 1 )
      oBrw:aHeaders[ 1 ] = ""

      oWndBrw:SetControl( oBrw )

      ACTIVATE WINDOW oWndBrw ;
         VALID ( If( oWndRec != nil, oWndRec:End(),),;
                 oBrw:lCloseArea() )

      if oWndAreas != nil
         oWndAreas:oControl:Refresh()  // We updates the info on the WorkAreas
      endif                            // Inspector

   endif

return nil

//----------------------------------------------------------------------------//

static function DelToggle()

   if RLock()
      if Deleted()
         DbReCall()
      else
         DbDelete()
      endif
      UNLOCK
   endif

return nil

//----------------------------------------------------------------------------//

// Checks for a possible area name conflict

static function cCheckArea( cDbfName )

   local n      := 2
   local cAlias := cDbfName

   while Select( cAlias ) != 0
      cAlias = cDbfName + AllTrim( Str( n++ ) )
   end

return cAlias

//----------------------------------------------------------------------------//

function IdeInit()

   local oIni

   INI oIni FILENAME "\" + CurDir() + "\Ide.ini"

      GET cIncPath SECTION "Path" ENTRY "Include" ;
         DEFAULT "c:\clipper5\include" OF oIni

      GET cLibPath SECTION "Path" ENTRY "Lib" ;
         DEFAULT "c:\clipper5\lib" OF oIni

      GET cProject SECTION "Project" ENTRY "Name" ;
         DEFAULT "" OF oIni

      GET lWorkAreas SECTION "Project" ENTRY "WorkAreas" ;
         DEFAULT .f. OF oIni

   ENDINI

   aObjBmps = { LoadBitmap( GetResources(), "Array" ),;
                LoadBitmap( GetResources(), "Block" ),;
                LoadBitmap( GetResources(), "Chain" ),;
                LoadBitmap( GetResources(), "Date" ),;
                LoadBitmap( GetResources(), "Logic" ),;
                LoadBitmap( GetResources(), "Number" ),;
                LoadBitmap( GetResources(), "Memo" ),;
                LoadBitmap( GetResources(), "Object" ),;
                LoadBitmap( GetResources(), "Undefined" ),;
                LoadBitmap( GetResources(), "SmallBug" ),;
                LoadBitmap( GetResources(), "NoInfo" ) }

   aDbfBmps = { LoadBitmap( GetResources(), "NoDeleted" ),;
                LoadBitmap( GetResources(), "Deleted" ) }

   aRptBmps = { LoadBitmap( GetResources(), "Header" ),;
                LoadBitmap( GetResources(), "Body" ),;
                LoadBitmap( GetResources(), "Footer" ) }

   // MsgInfo( Str( AddFontResource( GetResources() ) ) )

return nil

//----------------------------------------------------------------------------//

function BmpNew()

   WinExec( "PBrush" )

return nil

//----------------------------------------------------------------------------//

function BmpOpen( cBmpFile )

   local oWndBmp, oBar, oBmp, oIcon

   DEFAULT cBmpFile := cGetFile( "Windows Bitmap (*.bmp) | *.bmp",;
                                 "Select a BMP" )

   if ! Empty( cBmpFile )

      DEFINE ICON oIcon RESOURCE "Bitmap"

      DEFINE WINDOW oWndBmp FROM 1, 1 TO 23, 33 ;
         ICON oIcon TITLE "Bitmap: " + cNoPath( cNoExt( cBmpFile ) ) ;
         MDICHILD OF oWnd

      DEFINE BUTTONBAR oBar OF oWndBmp

      DEFINE BUTTON RESOURCE "Edit" OF oBar ;
         ACTION WinExec( "pbrush " + cBmpFile ) ;
         MESSAGE "Edit this Bitmap"

      DEFINE BUTTON RESOURCE "ZoomOut" OF oBar ;
         ACTION ( oBmp:lStretch := ! oBmp:lStretch, oBmp:Refresh( .t. ) ) ;
         MESSAGE "Adjust this Bitmap"

      @ 0, 0 BITMAP oBmp FILENAME cBmpFile SCROLL OF oWndBmp

      oWndBmp:SetControl( oBmp )

      ACTIVATE WINDOW oWndBmp

   endif

return nil

//----------------------------------------------------------------------------//

function DbfNew()

   local oDlg, oGet, oType, oLen, oDec, oLbx, oBtnAdd, oBtnEdit, oCbx
   local cName    := Space( 10 )
   local cType    := "C"
   local nLen     := 10
   local nDec     :=  0
   local cField   := Space( 20 )
   local cTypes   := "CNLDM"
   local aLens    := { 10, 10, 1, 8, 8 }
   local cDbfName := Space( 12 )
   local lEditing := .f.
   local cDriver  := "DbfNtx"

   DEFINE DIALOG oDlg RESOURCE "DbfBuild"

   REDEFINE GET oGet VAR cName ID 110 OF oDlg

   REDEFINE COMBOBOX oType VAR cType  ITEMS { "C", "N", "L", "D", "M" } ;
      ON CHANGE ( nLen := aLens[ At( cType, cTypes ) ], oLen:Refresh() );
      ID 120 OF oDlg

   REDEFINE GET oLen VAR nLen PICTURE "9999" ID 130 OF oDlg

   REDEFINE GET oDec VAR nDec PICTURE "9"    ID 140 OF oDlg

   REDEFINE BUTTON oBtnAdd ID 150 OF oDlg ;
      ACTION AddField( oLbx, oGet, oBtnAdd, oBtnEdit,;
                       @cName, cType, nLen, nDec, @lEditing )

   REDEFINE BUTTON ID 160 OF oDlg ACTION oDlg:End()

   REDEFINE LISTBOX oLbx VAR cField ID 170 OF oDlg

   REDEFINE BUTTON oBtnEdit ID 180 OF oDlg ;
      ACTION EditField( oBtnAdd, oBtnEdit,;
                        cField, @cName, @cType, @nLen, @nDec, @lEditing,;
                        oGet, oType, oLen, oDec )

   REDEFINE BUTTON ID 190 OF oDlg ACTION oLbx:Del()

   REDEFINE GET cDbfName ID 210 OF oDlg

   REDEFINE COMBOBOX oCbx VAR cDriver ;
      ITEMS { "DbfNtx", "DbfCdx", "DbfMdx", "DbfNdx", "DbPx" } ;
      ID 230 OF oDlg

   REDEFINE BUTTON ID 220 OF oDlg ;
      ACTION BuildDbf( RTrim( cDbfName ), oLbx, cDriver )

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

static function AddField( oLbx, oGet, oBtnAdd, oBtnEdit,;
                          cName, cType, nLen, nDec, lEditing )

   if Empty( cName )
      MsgInfo( "I need a field name", "Sorry" )
   else
      if ! lEditing
         oLbx:Add( xPadR( cName, 100 ) + Chr( 9 ) + cType + ;
                   xPadL( Str( nLen, 3 ), 50 ) + xPadL( Str( nDec, 1 ), 20 ),;
                   oLbx:GetPos() )
			else
         oLbx:Modify( xPadR( cName, 100 ) + Chr( 9 ) + cType + ;
                      xPadL( Str( nLen, 3 ), 50 ) + xPadL( Str( nDec, 1 ), 20 ) )
         oBtnAdd:SetText( "&Add" )
         oBtnEdit:Enable()
         lEditing = .f.
      endif
      cName = Space( 10 )
      oGet:Refresh()
      oGet:SetFocus()
   endif

return nil

//----------------------------------------------------------------------------//

static function BuildDbf( cDbfName, oLbx, cDriver )

   local aFields := {}
   local n

   if Empty( cDbfName )
      MsgAlert( "I need a DBF name", "Sorry" )
      return nil
   endif

   if Len( oLbx:aItems ) == 0
      MsgAlert( "No fields defined", "Sorry" )
      return nil
   endif

   if At( ".", cDbfName ) == 0
      cDbfName += ".dbf"
   endif

   if File( cDbfName )
      if ! MsgYesNo( "Create it again?", "That DBF already exists" )
         return nil
      endif
   endif

   for n = 1 to Len( oLbx:aItems )
      AAdd( aFields, FieldInfo( AllTrim( oLbx:aItems[ n ] ) ) )
   next

   RddSetDefault( cDriver )
   DbCreate( cDbfName, aFields )
   RddSetDefault( "DbfNtx" )

   MsgInfo( "DBF created!", "AllRight" )

return nil

//----------------------------------------------------------------------------//

static function FieldInfo( cItem )

return { StrToken( cItem, 1 ),;
         StrToken( cItem, 2 ),;
         Val( StrToken( cItem, 3 ) ),;
         Val( StrToken( cItem, 4 ) ) }

//----------------------------------------------------------------------------//

static function EditField( oBtnAdd, oBtnEdit, cField,;
                           cName, cType, nLen, nDec, lEditing,;
                           oName, oType, oLen, oDec )

   if ! Empty( cField )
      oBtnAdd:SetText( "&Replace" )
      oBtnEdit:Disable()
      lEditing = .t.

      cName = StrToken( cField, 1 )
      cType = StrToken( cField, 2 )
      nLen  = Val( StrToken( cField, 3 ) )
      nDec  = Val( StrToken( cField, 4 ) )

      oName:Refresh()
      oType:Refresh()
      oLen:Refresh()
      oDec:Refresh()
   else
      MsgInfo( "Select a field to edit", "Please" )
   endif

return nil

//----------------------------------------------------------------------------//

function ItemOpen( oBrw )

   local nType     := ( oBrw:cAlias )->Type
   local cFileName := ( oBrw:cAlias )->Name

   if nType != 0 .and. ! File( cFileName )
      MsgAlert( "I can't find that file!" )
      return nil
   endif

   do case
      case nType == IT_UNDEFINED
           ItemNew( oBrw )

      case nType == IT_BITMAP
           BmpOpen( cFileName )

      case nType == IT_DIALOG
           DlgOpen( cFileName )

      case nType == IT_DOC
           DocOpen( cFileName )

      case nType == IT_MENU
           MnuOpen( cFileName )

      case nType == IT_DATABASE
           DbfOpen( cFileName )

      case nType == IT_PROGRAM
           PrgOpen( cFileName )

      case nType == IT_SOUND
           WinExec( "SoundRec " + cFileName )

      case nType == IT_REPORT
           ReportOpen( cFileName )
   endcase

return nil

//----------------------------------------------------------------------------//

function ItemNew( oBrw )

   local oDlg, oGet
   local cFile := PadR( ( oBrw:cAlias )->Name, 50 )
   local cDescript := PadR( ( oBrw:cAlias )->Descript, 50 )
   local aItems := { "Bitmap", "DataBase", "Dialog", "Documentation",;
                     "Icon", "Index", "Menu", "Program", "Report", "Sound" }
   local cType := aItems[ Min( Max( ( oBrw:cAlias )->Type, 1 ), Len( aItems ) ) ]

   DEFINE DIALOG oDlg RESOURCE "PrjItem"

   REDEFINE GET oGet VAR cFile ID 110 OF oDlg

   REDEFINE COMBOBOX cType ITEMS aItems ;
     ID 120 OF oDlg

   REDEFINE GET cDescript ID 130 OF oDlg

   REDEFINE BUTTON ID 140 OF oDlg ;
      ACTION ( cFile := cGetIdeFile( AScan( aItems, cType ) ),;
               oGet:Refresh() )

   ACTIVATE DIALOG oDlg

   if oDlg:nResult == IDOK
      if ( oBrw:cAlias )->( RLock() )
         ( oBrw:cAlias )->Type     := If( ! Empty( cFile ),;
                                          AScan( aItems, cType ), 0 )
         ( oBrw:cAlias )->Name     := cFile
         ( oBrw:cAlias )->Descript := cDescript
         oBrw:UpStable()
         oBrw:Refresh()
         ( oBrw:cAlias )->( DbUnLock() )
      else
         MsgAlert( "DataBase in Net use! Unable to perform the operation" )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

function ItemDel( oBrw )

   if MsgYesNo( "Do you want to delete the current item ?" )
      if ( oBrw:cAlias )->( RLock() )
         ( oBrw:cAlias )->( DbDelete() )
         // ( oBrw:cAlias )->( DbPack() )
         ( oBrw:cAlias )->( DbUnLock() )
         oBrw:Refresh()
      endif
   endif

return nil

//----------------------------------------------------------------------------//

function cNoPath( cFileName )

return SubStr( cFileName, RAt( "\", cFileName ) + 1 )

//----------------------------------------------------------------------------//

function cNoExt( cFileName )

return SubStr( cFileName, 1, RAt( ".", cFileName ) - 1 )

//----------------------------------------------------------------------------//

function WorkAreas()

   local oBrw, oBar
   local nAlias := 1
   local nPos   := 1

	 if oWndAreas == nil

     oItemAreas:SetCheck( .t. )          // Toggle the PullDown MenuItem

     DEFINE WINDOW oWndAreas MDICHILD FROM 13, 1 TO 23, 75 ;
        TITLE "Work Areas Inspector" OF oWnd

			DEFINE BUTTONBAR oBar OF oWndAreas

			DEFINE BUTTON OF oBar ;
				 ACTION oBrw:Refresh()

      DEFINE BUTTON GROUP OF oBar RESOURCE "Indexes" ;
         ACTION IdxInfo( nAlias ) MESSAGE "Review Indexes information"

      DEFINE BUTTON OF oBar RESOURCE "Fields" ;
         MESSAGE "Review fields information"

      @ 0, 0 LISTBOX oBrw FIELDS xPadL( AllTrim( Str( nAlias, 3 ) ), 28 ), ;
                Alias( nAlias ), ;
                If( ( nAlias )->( BoF() ), "Yes", "No" ), ;
                If( ( nAlias )->( EoF() ), "Yes", "No" ), ;
                GetIndexKey( nAlias ),;
                xPadL( AllTrim( Str( ( nAlias )->( RecNo() ) ) ), 42 ), ;
                xPadL( AllTrim( Str( ( nAlias )->( RecCount() ) ) ), 42 ), ;
                GetRddName( nAlias ), ;
                xPadL( AllTrim( Str( ( nAlias )->( FCount() ) ) ), 42 ), ;
                xPadL( AllTrim( Str( ( nAlias )->( RecSize() ) ) ), 42 ) ;
            FIELDSIZES 34, 90, 32, 32, 40, 48, 48, 80, 48, 48 ;
            HEAD "Area", "Alias", "BOF", "EOF", "Index", "RecNo", "Total", "RDD", "Fields", "RecSize" ;
						OF oWndAreas

		 oBrw:bGoTop		= { || nAlias := GetFirstArea(), nPos := 1 }
     oBrw:bGoBottom = { || nAlias := GetLastArea(),  nPos := CountAreas() }
     oBrw:bSkip     = { | nWant, nDo | ;
                          nDo := Min( Max( nWant, 1 - nPos ),;
                          CountAreas() - nPos ), ;
                          nPos += nDo, nAlias := GetArea( nPos ), nDo }
     oBrw:bLogicLen = { || CountAreas() }

		 oWndAreas:SetControl( oBrw )

     ACTIVATE WINDOW oWndAreas ;
        VALID ( oWndAreas := nil, oItemAreas:SetCheck( .f. ), .t. )
  endif

return nil

//----------------------------------------------------------------------------//

static function GetLastArea()

	local n := 1
	while ! Empty( Alias( n++ ) )
  end

return n

//----------------------------------------------------------------------------//

static function GetFirstArea()

	local n := 1
	while Empty( alias( n++ ) )
  end

return n

//----------------------------------------------------------------------------//

static function CountAreas()

	local n
  local nAreas := 0

	for n = 1 to 255
		if ! Empty( Alias( n ) )
      nAreas++
    endif
  next

return nAreas

//----------------------------------------------------------------------------//

static function GetArea( nArea )

	local n
  local nAreas := 0

	for n = 1 to 255
		if ! Empty( Alias( n ) )
      nAreas++
			if n == nArea
        return nAreas
      endif
    endif
  next

return nAreas

//----------------------------------------------------------------------------//

function IdxInfo( nAlias )

  local oWndIdx, oBrw
  local aIdx   := {}
  local nIdx   := 1
  local nOrder := 1

  // Add the current index list to aIdx array

  if Empty( Alias( nAlias ) )
     MsgStop( "No used workareas" )
     return nil
  endif

  for nOrder = 1 to 15
    AAdd( aIdx, { ( nAlias )->( OrdName( nOrder ) ), ;
                  ( nAlias )->( OrdKey( nOrder  ) ), ;
                  ( nAlias )->( OrdFor( nOrder  ) ), ;
                  ( nAlias )->( OrdBagName( nOrder ) ) } )
  next

  DEFINE WINDOW oWndIdx FROM 2, 1 TO 12, 78 ;
     TITLE "Area " + Alias( nAlias ) + ": Indexes Information" ;
     MDICHILD OF oWnd

  @ 0, 0 LISTBOX oBrw ;
     FIELDS xPadL( cValToChar( nIdx ), 20 ), ;
            aIdx[ nIdx, 1 ], ;
            aIdx[ nIdx, 2 ], ;
            aIdx[ nIdx, 3 ], ;
            aIdx[ nIdx, 4 ]  ;
     FIELDSIZES 27, 90, 250, 180, 140 ;
     HEADERS "Ord", "Index Name", "Index Key", "Index For Scope", "BagName" ;
     OF oWndIdx

  oWndIdx:SetControl( oBrw )

  // Some blocks for management the browse array

  oBrw:bLogicLen = { || Len( aIdx ) }

  oBrw:bGoTop    = { || nIdx := 1 }
  oBrw:bGoBottom = { || nIdx := Len( aIdx ) }
  oBrw:bSkip     = { | nWant, nDo | ;
                      nDo := Min( Max( nWant, 1 - nIdx ), ;
                      Len( aIdx ) - nIdx ), ;
                      nIdx += nDo, nDo }

  ACTIVATE WINDOW oWndIdx

return nil

//----------------------------------------------------------------------------//

function SelFile()

   local cExt
   local cFile := cGetIdeFile()

   if ! Empty( cFile )

      cExt = SubStr( cFile, RAt( ".", cFile ) + 1 )

      do case
         case cExt == "PRG"
              PrgOpen( cFile )

         case cExt == "BMP"
              BmpOpen( cFile )

         case cExt == "DBF"
              DbfOpen( cFile )

         case cExt == "SCR"
              DlgOpen( cFile )

         case cExt == "DOC"
              DocOpen( cFile )

         case cExt == "ICO"

         case cExt == "IDX"

         case cExt == "MNU"

         case cExt == "RPT"
              ReportOpen( cFile )

         case cExt == "WAV"
              WinExec( "SoundRec " + cFile )
      endcase
   endif

return nil

//----------------------------------------------------------------------------//

function cGetIdeFile( nFilter )

return cGetFile( "Windows Bitmap (*.bmp) | *.bmp |" + ;
                 "DataBase (*.dbf) | *.dbf |" + ;
                 "FiveWin Dialog (*.scr) | *.scr |" + ;
                 "FiveWin Documentation (*.doc) | *.doc |" + ;
                 "Windows Icon (*.ico) | *.ico |" + ;
                 "FiveWin Index (*.idx) | *.idx |" + ;
                 "FiveWin Menu (*.mnu) | *.mnu |" + ;
                 "Clipper Program (*.prg) | *.prg |" + ;
                 "FiveWin Report (*.rpt) | *.rpt |" + ;
                 "Windows sound (*.wav) | *.wav",;
                 "Select a File", nFilter )

//----------------------------------------------------------------------------//

function PrjConfig()

   local oDlg, oPrj, oIni
   local cPrj := If( cProject == nil, Space( 40 ), PadR( cProject, 40 ) )
   local cPrg := Space( 20 )

   DEFINE DIALOG oDlg RESOURCE "PrjConfig"

   REDEFINE GET oPrj VAR cPrj ID 110 OF oDlg

   REDEFINE CHECKBOX lWorkAreas ID 120 OF oDlg

   REDEFINE GET cPrg ID 130 OF oDlg

   REDEFINE BUTTON ID 140 OF oDlg ;
      ACTION ( cPrj := cGetFile( "FiveWin Project (*.prj) | *.prj",;
               "Select a Project" ), oPrj:Refresh() )

   ACTIVATE DIALOG oDlg CENTERED ;
      ON RIGHT CLICK ThisInspect( oDlg )

   if oDlg:nResult == IDOK
      INI oIni FILENAME "\" + CurDir() + "\Ide.ini"
          SET SECTION "Project" ENTRY "WorkAreas" OF oIni TO lWorkAreas
          SET SECTION "Project" ENTRY "Name"      OF oIni TO cPrj
      ENDINI
      cProject = cPrj
   endif

return nil

//----------------------------------------------------------------------------//

function GetIndexKey( nArea )

return If( ! Empty( Alias( nArea ) ),;
       If( ( nArea )->( IndexOrd() ) != 0, "Yes", "No" ), Space( 30 ) )

//----------------------------------------------------------------------------//

function GetRddName( nArea )

return If( ! Empty( Alias( nArea ) ), ( nArea )->( RddName() ), Space( 30 ) )

//----------------------------------------------------------------------------//

function BtnInspect( oBtn )

   local oDlg
   local nRow     := oBtn:nTop
   local nCol     := oBtn:nLeft
   local cCaption := oBtn:cCaption

   DEFINE DIALOG oDlg RESOURCE "BtnInspect"

   REDEFINE GET nRow     ID 110 OF oDlg
   REDEFINE GET nCol     ID 120 OF oDlg
   REDEFINE GET cCaption ID 150 OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function DbPack() ; PACK ; return nil

//----------------------------------------------------------------------------//

function RecEdit( cTitle, oBrwParent )

   local oWndRec, oBrw, oIco, oFont
   local cAlias := Alias()
   local nField := 1
   local aInfo  := DbStruct()

   DEFINE ICON oIco RESOURCE "Record"

   DEFINE WINDOW oWndRec FROM 1, 43 TO 23, 79 ;
      TITLE cTitle MDICHILD ;
      ICON oIco

   DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

   @ 2, 0 LISTBOX oBrw FIELDS "" ;
      HEADERS "", "Field", "Value" ;
      SIZES   16,      95,    400 ;
      SIZE 400, 400 ;
      COLOR oBrwParent:nClrText, oBrwParent:nClrPane ;
      FONT oFont

   oBrw:bLine     = { || ( cAlias )->( FldInfo( nField, aInfo[ nField ][ 2 ] ) ) }
   oBrw:bLogicLen = { || ( cAlias )->( FCount() ) }
   oBrw:bGoTop    = { || nField := 1 }
   oBrw:bGoBottom = { || nField := ( cAlias )->( FCount() ) }
   oBrw:bSkip     = { | nSkip, nOld | nOld := nField, nField += nSkip,;
                  nField := Min( Max( nField, 1 ), ( cAlias )->( FCount() ) ),;
                  nField - nOld }

   oWndRec:SetControl( oBrw )

   ACTIVATE WINDOW oWndRec ;
      VALID ( oWndRec := nil, .t. )            // Destroy the Object

return oWndRec

//----------------------------------------------------------------------------//

static function FldInfo( nField, cType )

   local uData := FieldGet( nField )

return { aObjBmps[ At( cType, "ABCDLNMOU" ) ], Field( nField ),;
         cValToChar( uData ) }

//----------------------------------------------------------------------------//

function GetWndMain()  ; return oWnd       // to export oWnd to other modules
function GetWndAreas() ; return oWndAreas  // to export oWndAreas "      "
function GetObjBmps()  ; return aObjBmps
function GetRptBmps()  ; return aRptBmps

//----------------------------------------------------------------------------//

function IdePopup()

   local oMenu

   MENU oMenu POPUP
      MENUITEM "&Configure"
      MENU
         MENUITEM "&Project..." ;
            MESSAGE "Set the default values of the IDE" ;
            ACTION PrjConfig()

         MENUITEM "&Control Panel..." ;
            MESSAGE "Set Windows default values" ;
            ACTION WinExec( "Control" )
      ENDMENU

      MENUITEM "&Inspect..."
      MENU
         MENUITEM "&Object IDE Window" ;
            MESSAGE "Inspect the Object IDE" ;
            ACTION ObjInspect( oWnd, "oWnd" )

         MENUITEM "&Application Stack" ;
            MESSAGE "Inspect the whole application stack" ;
            ACTION  StackInspect()

         MENUITEM "&Windows API activity" ;
            MESSAGE "Inspect the messages sent by Windows" ;
            ACTION  ApiInspect()

         MENUITEM "&Memory available" ;
            MESSAGE "Memory values availables"
      ENDMENU
   ENDMENU

   ACTIVATE POPUP oMenu AT 200, 200 OF oWnd

return nil

//----------------------------------------------------------------------------//

function cGetNewFileName( cName, cExt )

   local cTemp := cName + "." + cExt
   local nId   := 1

   while File( cTemp )
      cTemp = cName + AllTrim( nId ) + "." + cExt
   end

return cTemp

//----------------------------------------------------------------------------//
