#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function MnuNew()

   local cMnuName
   local nStart := 1

   while File( cMnuName := ( "MENU" + SubStr( Str( nStart + 100, 3 ), 2 ) ;
                             + ".mnu" ) )
      nStart++
   end

   if ! File( cMnuName )
      DbCreate( cMnuName, { { "MENUITEM", "C", 60, 0 },;
                            { "ID",       "N",  4, 0 },;
                            { "MESSAGE",  "C", 60, 0 },;
                            { "ACTION",   "C", 60, 0 } } )
   endif

   MnuOpen( cMnuName )

return nil

//----------------------------------------------------------------------------//

function MnuOpen( cMnuName )

   local oIco, oWndMenu, oBar, oLbx, oMenuTree, oItem

   DEFAULT cMnuName := cGetNewFileName( "MENU", "MNU" )

   TREE oMenuTree BITMAPS "PluSmal", "MinSmal"

      TREEITEM oItem PROMPT "&First"
      TREE
         TREEITEM "&One"
         TREE
            TREEITEM "&One"
            TREEITEM "&Two"
            TREEITEM "&Three"
         ENDTREE
         TREEITEM "&Two"
         TREEITEM "&Three"
      ENDTREE

      TREEITEM "&Second"
      TREE
         TREEITEM "&One"
         TREEITEM "&Two"
         TREEITEM "&Three"
      ENDTREE

      TREEITEM "&Third"
      TREE
         TREEITEM "&One"
         TREEITEM "&Two"
         TREEITEM "&Three"
      ENDTREE
   ENDTREE

   DEFINE ICON oIco RESOURCE "Menu"

   DEFINE WINDOW oWndMenu FROM 1, 1 TO 23, 33 ;
      TITLE "Menu: " + cNoPath( cNoExt( cMnuName ) ) ;
      ICON oIco MDICHILD

   DEFINE BUTTONBAR oBar OF oWndMenu

   DEFINE BUTTON RESOURCE "New"  OF oBar
   DEFINE BUTTON RESOURCE "Edit" OF oBar
   DEFINE BUTTON RESOURCE "Del"  OF oBar

   DEFINE BUTTON RESOURCE "Exec" GROUP OF oBar
   DEFINE BUTTON RESOURCE "RC"   OF oBar
   DEFINE BUTTON RESOURCE "PRG"  OF oBar

   DEFINE BUTTON RESOURCE "Font" GROUP OF oBar ;
      ACTION oLbx:SelFont()

   DEFINE BUTTON RESOURCE "Clr" OF oBar ;
      ACTION oLbx:SelColor()

   @ 0, 0 LISTBOX oLbx ;
      FIELDS OemToAnsi( oItem:GetText() ) ;
      HEADERS "PullDown Menu Items" ;
      SIZES 16, 300 ;
      ON LEFT DBLCLICK ( oItem:Toggle(), oLbx:Refresh() ) ;
      OF oWndMenu ;
      SIZE 400, 400

   oLbx:bLine     = { || oItem:GetLabel() }
   oLbx:aColSizes = { || oItem:ColSizes() }
   oLbx:bGoTop    = { || oItem := oMenuTree:oFirst }
   oLbx:bGoBottom = { || oItem := oMenuTree:oLast }
   oLbx:bSkip     = { | n | oItem := oItem:Skip( @n ), n }
   oLbx:bLogicLen = { || oMenuTree:nCount() }

   oWndMenu:SetControl( oLbx )

   oMenuTree:OpenAll()
   oMenuTree:Draw()

   ACTIVATE WINDOW oWndMenu

return nil

//----------------------------------------------------------------------------//
