// FiveWin IDE - Windows API messages Inspector

#include "FiveWin.ch"

static oWnd
static aMsgs := { { "STOP", 0, 0, 0, 0 } }
static nMsgs := 80

//----------------------------------------------------------------------------//

function ApiInspect()

   local oBrw

   if oWnd != nil
      return nil
   endif

   DEFINE WINDOW oWnd FROM 1, 1 TO 23, 33 ;
      TITLE "Windows API Inspector" MDICHILD

   @ 0, 0 LISTBOX oBrw FIELDS "" ;
      HEADERS    "hWnd", "Windows Message", "nWParam", "nLParam" ;
      COLSIZES       80,               200,       100,      100  ;
      SIZE 400, 400  OF oWnd

   oBrw:bLine = { || { cValToChar( aMsgs[ oBrw:nAt ][ 1 ] ),;
                       LoadValue(  aMsgs[ oBrw:nAt ][ 2 ] ),;
                       cValToChar( aMsgs[ oBrw:nAt ][ 3 ] ),;
                       cValToChar( aMsgs[ oBrw:nAt ][ 4 ] ) } }
   oBrw:SetArray( aMsgs )
   oWnd:SetControl( oBrw )

   ACTIVATE WINDOW oWnd ;
      VALID ( SetMsgInspector(), oWnd := nil, .t. )

   SetMsgInspector( "SHOWMSGS" )

return nil

//---------------------------------------------------------------------------//

function ShowMsgs( hWnd, nMsg, nWParam, nLParam )

   if Len( aMsgs ) == nMsgs
      SetMsgInspector()
      return nil
   endif

   if oWnd != nil .and. hWnd != oWnd:hWnd
      AAdd( aMsgs, { hWnd, nMsg, nWParam, nLParam } )
   endif

return nil

//---------------------------------------------------------------------------//
