#ifndef _FONT_CH
#define _FONT_CH

#define LF_HEIGHT          1
#define LF_WIDTH           2
#define LF_ESCAPEMENT      3
#define LF_ORIENTATION     4
#define LF_WEIGHT          5
#define LF_ITALIC          6
#define LF_UNDERLINE       7
#define LF_STRIKEOUT       8
#define LF_CHARSET         9
#define LF_OUTPRECISION   10
#define LF_CLIPPRECISION  11
#define LF_QUALITY        12
#define LF_PITCHANDFAMILY 13
#define LF_FACENAME       14

#xcommand DEFINE FONT <oFont> ;
             [ NAME <cName> ] ;
             [ SIZE <nWidth>, <nHeight> ] ;
             [ <from:FROM USER> ] ;
             [ <bold: BOLD> ] ;
       => ;
          <oFont> := TFont():New( <cName>, <nWidth>, <nHeight>, <.from.>,;
                                  [<.bold.>] )

#xcommand ACTIVATE   FONT <oFont> => <oFont>:Activate()

#xcommand DEACTIVATE FONT <oFont> => <oFont>:DeActivate()

#xcommand RELEASE    FONT <oFont1> [,<oFontN> ] ;
       => ;
          <oFont1>:Release() [; <oFontN>:Release() ]

#xcommand SET FONT ;
             [ OF <oWnd> ] ;
             [ TO <oFont> ] ;
       => ;
          <oWnd>:SetFont( <oFont> )

#endif
