#ifndef _WINDOW_CH
#define _WINDOW_CH

//----------------------------------------------------------------------------//
// Cursor Commands

#xcommand DEFINE CURSOR <oCursor> ;
             [ <resource: RESOURCE, RESNAME, NAME> <cResName> ] ;
       => ;
          <oCursor> := TCursor():New( <cResName> )

#xcommand RELEASE CURSOR <oCursor> => <oCursor>:End()

//----------------------------------------------------------------------------//
// Window Commands

#xcommand DEFINE WINDOW [<oWnd>] ;
             [ MDICHILD ] ;
             [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
             [ TITLE <cTitle> ] ;
             [ BRUSH <oBrush> ] ;
             [ CURSOR <oCursor> ] ;
             [ MENU <oMenu> ] ;
             [ ICON <oIco> ] ;
             [ OF <oParent> ] ;
             [ <vscroll: VSCROLL> ] ;
             [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
             [ <pixel: PIXEL> ] ;
       => ;
          [<oWnd> := ] TMdiChild():New( <nTop>, <nLeft>, <nBottom>, <nRight>,;
             <cTitle>,, <oMenu>, <oParent>, <oIco>, <.vscroll.>, <nClrFore>,;
             <nClrBack>, <oCursor>, <oBrush>, <.pixel.> )

#xcommand DEFINE WINDOW <oWnd> ;
             [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
             [ TITLE <cTitle> ] ;
             [ STYLE <nStyle> ] ;
             [ MENU  <oMenu> ] ;
             [ BRUSH <oBrush> ] ;
             [ ICON  <oIcon> ] ;
             [ MDI ] ;
             [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ] ;
             [ <vScroll: VSCROLL, VERTICAL SCROLL> ] ;
             [ <hScroll: HSCROLL, HORIZONTAL SCROLL> ] ;
             [ MENUINFO <nMenuInfo> ] ;
             [ <border: NONE, SINGLE> ] ;
       => ;
          <oWnd> := TMdiFrame():New( <nTop>, <nLeft>, <nBottom>, <nRight>,;
             <cTitle>, <nStyle>, <oMenu>, <oBrush>, <oIcon>, <nClrFore>,;
             <nClrBack>, [<.vScroll.>], [<.hScroll.>], <nMenuInfo>,;
             [Upper(<(border)>)] )

#xcommand DEFINE WINDOW <oWnd> ;
             [ FROM <nTop>, <nLeft> TO <nBottom>, <nRight> ] ;
             [ TITLE <cTitle> ] ;
             [ <color: COLOR, COLORS> <nClrFore> [,<nClrBack>] ];
             [ OF <oParent> ] ;
             [ BRUSH <oBrush> ] ;                         // Contained Objects
             [ CURSOR <oCursor> ] ;
             [ ICON  <oIcon> ] ;
             [ MENU <oMenu> ] ;
             [ STYLE <nStyle> ] ;                          // Styles
             [ BORDER <border: NONE, SINGLE> ] ;
             [ <NoSysMenu:  NOSYSMENU, NO SYSMENU> ] ;
             [ <NoCaption:  NOCAPTION, NO CAPTION, NO TITLE> ] ;
             [ <NoIconize:  NOICONIZE, NOMINIMIZE> ] ;
             [ <NoMaximize: NOZOOM, NO ZOOM, NOMAXIMIZE, NO MAXIMIZE> ] ;
             [ <vScroll: VSCROLL, VERTICAL SCROLL> ] ;
             [ <hScroll: HSCROLL, HORIZONTAL SCROLL> ] ;
       => ;
          <oWnd> := TWindow():New( <nTop>, <nLeft>, <nBottom>, <nRight>,;
             <cTitle>, <nStyle>, <oMenu>, <oBrush>, <oIcon>, <oParent>,;
             [<.vScroll.>], [<.hScroll.>], <nClrFore>, <nClrBack>, <oCursor>,;
             [Upper(<(border)>)], !<.NoSysMenu.>, !<.NoCaption.>,;
             !<.NoIconize.>, !<.NoMaximize.> )

#xcommand ACTIVATE WINDOW <oWnd> ;
             [ <show: ICONIZED, NORMAL, MAXIMIZED> ] ;
             [ ON [ LEFT ] CLICK <uLClick> ] ;
             [ ON RIGHT CLICK <uRClick> ] ;
             [ ON MOVE <uMove> ] ;
             [ ON RESIZE <uResize> ] ;
             [ ON PAINT <uPaint> ] ;
             [ ON KEYDOWN <uKeyDown> ] ;
             [ ON INIT <uInit> ] ;
             [ ON UP <uUp> ] ;
             [ ON DOWN <uDown> ] ;
             [ ON PAGEUP <uPgUp> ] ;
             [ ON PAGEDOWN <uPgDn> ] ;
             [ ON LEFT <uLeft> ] ;
             [ ON RIGHT <uRight> ] ;
             [ ON PAGELEFT <uPgLeft> ] ;
             [ ON PAGERIGHT <uPgRight> ] ;
             [ VALID <uValid> ] ;
       => ;
          <oWnd>:Activate( [ Upper(<(show)>) ],;
                           <oWnd>:bLClicked [ := \{ |nRow,nCol,nKeyFlags| <uLClick> \} ], ;
                           <oWnd>:bRClicked [ := \{ |nRow,nCol,nKeyFlags| <uRClick> \} ], ;
                           <oWnd>:bMoved    [ := <{uMove}> ], ;
                           <oWnd>:bResized  [ := <{uResize}> ], ;
                           <oWnd>:bPainted  [ := <{uPaint}> ], ;
                           <oWnd>:bKeyDown  [ := \{ |nKey| <uKeyDown> \} ],;
                           <oWnd>:bInit     [ := \{ | Self | <uInit> \} ],;
                           [<{uUp}>], [<{uDown}>], [<{uPgUp}>], [<{uPgDn}>],;
                           [<{uLeft}>], [<{uRight}>], [<{uPgLeft}>], [<{uPgRight}>],;
                           [<{uValid}>] )

//----------------------------------------------------------------------------//
// ButtonBar Commands

#xcommand DEFINE BUTTONBAR [ <oBar> ] ;
             [ <size: SIZE, BUTTONSIZE, SIZEBUTTON > <nWidth>, <nHeight> ] ;
             [ <_3d: 3D, 3DLOOK> ] ;
             [ <mode: TOP, LEFT, RIGHT, ADJUST> ] ;
             [ <wnd: OF, WINDOW, DIALOG> <oWnd> ] ;
             [ CURSOR <oCursor> ] ;
      => ;
         [ <oBar> := ] TBar():New( <oWnd>, <nWidth>, <nHeight>, <._3d.>,;
             [ Upper(<(mode)>) ], <oCursor> )

#xcommand DEFINE BUTTON [ <oBtn> ] ;
             [ <bar: OF, BUTTONBAR > <oBar> ] ;
             [ <resource: NAME, RESNAME, RESOURCE> <cResName1> [,<cResName2>] ] ;
             [ <file: FILE, FILENAME, DISK> <cBmpFile1> [,<cBmpFile2>] ] ;
             [ <action:ACTION,EXEC> <uAction> ] ;
             [ <group: GROUP > ] ;
             [ MESSAGE <cMsg> ] ;
             [ <adjust: ADJUST > ] ;
      => ;
         [ <oBtn> := ] TBtnBmp():NewBar( <cResName1>, <cResName2>,;
                                         <cBmpFile1>, <cBmpFile2>,;
                                         <cMsg>, <{uAction}>, <.group.>,;
                                         <oBar>, <.adjust.> )

//----------------------------------------------------------------------------//
// MESSAGE BAR

#xcommand SET MESSAGE [ OF <oWnd> ] [ TO <cMsg> ] => ;
          <oWnd>:oMsgBar := TMsgBar():New( <oWnd>, <cMsg> )
          
#xcommand DEFINE MESSAGE BAR [<oMsg>] OF <oWnd> ;
             [ PROMPT <cMsg> ] ;
      => ;
         [<oMsg>:=] <oWnd>:oMsgBar := TMsgBar():New( <oWnd>, <cMsg> )

//----------------------------------------------------------------------------//

#endif
