//----------------------------------------------------------------------------//
//  FiveWin 1.5 - Ejemplos
//  (c) A.Linares, F.Pulpn 1993
//----------------------------------------------------------------------------//

#include "FiveWin.ch"

#define ID_PRGNAME     110
#define ID_MEMVAR      120
#define ID_DEBUGGER    130
#define ID_CREDITS     140
#define ID_DEFID       150
#define ID_INCLUDE     160
#define ID_NOLINES     170
#define ID_ONEMODULE   180
#define ID_NOSYMBOL    190
#define ID_OBJDIR      200
#define ID_PREPROCESS  210
#define ID_NOCOMMENTS  220
#define ID_LIBREQUEST  230
#define ID_CHECKSYNTAX 240
#define ID_COMMANDS    250
#define ID_MEMVARS     260
#define ID_WARNINGS    270

#define ID_HELP        998

//----------------------------------------------------------------------------//

function Main( cPrgName )

   local hBorland
   local oDlg
   local lMemVar     := .f., lDebugger    := .f., lCredits    := .f., lDefId    := .f.,;
         lInclude    := .f., lNoLines     := .f., lOneModule  := .f., lNoSymbol := .t.,;
         lObjDir     := .f., lPreProcess  := .f., lNoComments := .f.,;
         lLibRequest := .f., lCheckSyntax := .f., lCommands   := .f.,;
         lMemVars    := .f., lWarnings    := .f.

   local cCmdLine    := "Clipper "
   local cId         := ""
   local cInclude    := "c:\clipper5\include"
   local cObjDir     := "c:\clipper5\obj"

   if PCount() == 0
      MsgAlert( "Sintaxis: Compile <Programa>.prg" + Chr( 13 ) + ;
                "(c) FiveWin 1.5, Linares & Pulpon, 1993",;
                "Llamar a Clipper" )
   else
      hBorland = LoadLibrary( "BWCC.dll" )
      SET RESOURCES TO "Compile.dll"

      DEFINE DIALOG oDlg NAME "Clipper"

      REDEFINE GET cPrgName ID ID_PRGNAME OF oDlg

      REDEFINE CHECKBOX lMemVar      ID ID_MEMVAR      OF oDlg
      REDEFINE CHECKBOX lDebugger    ID ID_DEBUGGER    OF oDlg
      REDEFINE CHECKBOX lCredits     ID ID_CREDITS     OF oDlg
      REDEFINE CHECKBOX lDefId       ID ID_DEFID       OF oDlg ;
         ON CLICK GetId( lDefId, @cId )

      REDEFINE CHECKBOX lInclude     ID ID_INCLUDE     OF oDlg ;
         ON CLICK GetInclude( lInclude, @cInclude )

      REDEFINE CHECKBOX lNoLines     ID ID_NOLINES     OF oDlg
      REDEFINE CHECKBOX lOneModule   ID ID_ONEMODULE   OF oDlg
      REDEFINE CHECKBOX lNoSymbol    ID ID_NOSYMBOL    OF oDlg
      REDEFINE CHECKBOX lObjDir      ID ID_OBJDIR      OF oDlg ;
         ON CLICK GetObjDir( lObjDir, @cObjDir )

      REDEFINE CHECKBOX lPreProcess  ID ID_PREPROCESS  OF oDlg
      REDEFINE CHECKBOX lNoComments  ID ID_NOCOMMENTS  OF oDlg
      REDEFINE CHECKBOX lLibRequest  ID ID_LIBREQUEST  OF oDlg
      REDEFINE CHECKBOX lCheckSyntax ID ID_CHECKSYNTAX OF oDlg
      REDEFINE CHECKBOX lCommands    ID ID_COMMANDS    OF oDlg
      REDEFINE CHECKBOX lMemVars     ID ID_MEMVARS     OF oDlg
      REDEFINE CHECKBOX lWarnings    ID ID_WARNINGS    OF oDlg

      REDEFINE BUTTON ID 10 OF oDlg ACTION cGetFile( "*.prg", "Seleccione un PRG" )
      REDEFINE BUTTON ID ID_HELP OF oDlg ACTION MsgInfo( "FiveWin 1.0" )

      ACTIVATE DIALOG oDlg CENTERED

      if oDlg:nResult == ID_OK
         cCmdLine += AllTrim( cPrgName ) + " " + ;
                     If( lMemVar,      "/a ", "" ) + ;
                     If( lDebugger,    "/b ", "" ) + ;
                     If( lCredits,     "/credits ", "" ) + ;
                     If( lDefId,       "/d ", "" ) + ;
                     If( lInclude,     "/i" + cInclude + " ", "" ) + ;
                     If( lNoLines,     "/l ", "" ) + ;
                     If( lOneModule,   "/m ", "" ) + ;
                     If( lNoSymbol,    "/n ", "" ) + ;
                     If( lObjDir,      "/o ", "" ) + ;
                     If( lPreProcess,  "/p ", "" ) + ;
                     If( lNoComments,  "/p ", "" ) + ;
                     If( lCheckSyntax, "/s ", "" ) + ;
                     If( lCommands,    "/u ", "" ) + ;
                     If( lMemVars,     "/v ", "" ) + ;
                     If( lWarnings,    "/w ", "" )
          MsgInfo( cCmdLine )
          WinExec( cCmdLine )
      endif

      FreeLibrary( hBorland )
      SET RESOURCES TO

   endif

return

//----------------------------------------------------------------------------//

function GetInclude( lInclude, cInclude )

   local oDlg
   local cTemp := cInclude

   if lInclude
      DEFINE DIALOG oDlg NAME "AnyText" TITLE "Directorio ficheros Cabecera"

      REDEFINE GET cTemp ID 110 OF oDlg

      ACTIVATE DIALOG oDlg

      if oDlg:nResult == 1        // IDOK
         cInclude = cTemp
      endif
   endif

return

//----------------------------------------------------------------------------//

function GetId( lId, cId )

   local oDlg
   local cTemp := cId

   if lId
      DEFINE DIALOG oDlg NAME "AnyText" TITLE "Definir Identificador"

      REDEFINE GET cTemp ID 110 OF oDlg

      ACTIVATE DIALOG oDlg

      if oDlg:nResult == 1        // IDOK
         cId = cTemp
      endif
   endif

return

//----------------------------------------------------------------------------//

function GetObjDir( lObjDir, cObjDir )

   local oDlg
   local cTemp := cObjDir

   if lObjDir

      DEFINE DIALOG oDlg NAME "AnyText" TITLE "Directorio para OBJ resultante"

      REDEFINE GET cTemp ID 110 OF oDlg

      ACTIVATE DIALOG oDlg

      if oDlg:nResult == 1        // IDOK
         cObjDir = cTemp
      endif
   endif

return

//----------------------------------------------------------------------------//
