// Warning: Under construction. Not available yet!
// FiveGuru 1.0  - Our Guru for building applications in FiveWin!

// Visual Design tools

// Some have 'experts' and others have 'wizards...", but here
// we have a real Guru!!!  <g>

#include "FiveWin.ch"
#include "FiveGuru.ch"

static oWnd, oBar, oMsg, oMenu
static nBrushStyle := 1

//----------------------------------------------------------------------------//

function Main()

   local oBmp

   SET 3DLOOK ON

   DEFINE WINDOW oWnd FROM 1, 1 TO 20, 70 TITLE "FiveGuru 1.0"

   @ 6, 24 BITMAP oBmp FILENAME "..\bitmaps\FiveGuru.bmp" OF oWnd

   ACTIVATE WINDOW oWnd MAXIMIZED ;
      ON RIGHT CLICK MainQuery()

return nil

//----------------------------------------------------------------------------//

function MainQuery()

   local oDlg
   local cTitle     := PadR( oWnd:cTitle, 50 )
   local lButtonBar := ( oBar  != nil )
   local lMsgBar    := ( oMsg  != nil )
   local lMenu      := ( oMenu != nil )
   local lBrush     := .f.

   DEFINE DIALOG oDlg RESOURCE "AppInspect"

   REDEFINE GET cTitle ID 110 OF oDlg ;
      VALID ( oWnd:cTitle := AllTrim( cTitle ), .t. )

   REDEFINE CHECKBOX lButtonBar ID 120 OF oDlg ;
      ON CHANGE ToggleButtonBar()

   REDEFINE CHECKBOX lMsgBar ID 130 OF oDlg ;
      ON CHANGE ToggleMessageBar()

   REDEFINE CHECKBOX lMenu ID 150 OF oDlg ;
      ON CHANGE ToggleMenu()

   REDEFINE CHECKBOX lBrush ID ID_BRUSH OF oDlg ;
      ON CHANGE BrushInspect()

   REDEFINE BUTTON ID ID_ADDCONTROL OF oDlg ACTION ( oDlg:End(), AddControl() )

   REDEFINE BUTTON ID ID_GEN OF oDlg ;
      ACTION ( oWnd:cGenPRG( "GuruCode.prg" ),;
               MsgInfo( "Ok, See GuruCode.prg" ) )

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function AddControl()

   local oDlg, oCtrl
   local nControl  := 1
   local lCheckBox := .f.
   local cItem     := ""

   DEFINE DIALOG oDlg RESOURCE "Controls"

   REDEFINE RADIO nControl ID ID_PUSHBUTTON, ID_CHECKBOX, ID_LISTBOX OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

   if oDlg:nResult == ID_OK
      do case
         case nControl == 1
              @ 3, 3 BUTTON oCtrl PROMPT "&PushButton" SIZE 100, 30 OF oWnd
              oCtrl:lDrag = .t.

         case nControl == 2
              @ 3, 3 CHECKBOX oCtrl VAR lCheckBox PROMPT "&CheckBox" SIZE 100, 30 OF oWnd
              oCtrl:lDrag = .t.

         case nControl == 3
              @ 3, 3 LISTBOX oCtrl VAR cItem ;
                ITEMS { "This", "is", "a", "listbox" } ;
                SIZE 150, 150 OF oWnd
              oCtrl:lDrag = .t.

      endcase
   endif

return nil

//----------------------------------------------------------------------------//

function ToggleButtonBar()

   if oBar == nil
      DEFINE BUTTONBAR oBar OF oWnd
      oBar:bRClicked = { || BarInspect() }
   else
      oBar:End()
      oBar = nil
   endif

return nil

//----------------------------------------------------------------------------//

function ToggleMessageBar()

   if oMsg == nil
      DEFINE MESSAGE BAR oMsg OF oWnd
      oMsg:bRClicked = { || MsgInspect() }
   else
      oMsg:End()
      oMsg = nil
   endif

return nil

//----------------------------------------------------------------------------//

function ToggleMenu()

   if oMenu == nil
      MENU oMenu
         MENUITEM "&MenuItem..." ACTION MenuItemInspect()
         MENU
            MENUITEM "&One..."
            MENUITEM "&Two..."
            MENUITEM "&Three..."
         ENDMENU

         MENUITEM RESOURCE "MenuInsp" ACTION MenuInspect()
      ENDMENU
      oWnd:SetMenu( oMenu )
   else
      oMenu:End()
      oMenu = nil
   endif

return nil

//----------------------------------------------------------------------------//

function MsgInspect()

   local oDlg
   local cMessage := PadR( oMsg:cMsgDef, 60 )

   DEFINE DIALOG oDlg RESOURCE "MsgInspect"

   REDEFINE GET cMessage ID 110 OF oDlg

   ACTIVATE DIALOG oDlg CENTERED

   if oDlg:nResult == ID_OK
      oMsg:cMsgDef = AllTrim( cMessage )
      oMsg:Refresh()
   endif

return nil

//----------------------------------------------------------------------------//

function BarInspect()

   local oDlg
   local lGroup := .f.

   DEFINE DIALOG oDlg RESOURCE "BarInspect"

   REDEFINE CHECKBOX lGroup ID 110 OF oDlg

   REDEFINE BUTTON ID 120 OF oDlg ACTION AddBarButton( lGroup )

   REDEFINE BUTTON ID ID_SELCOLOR OF oDlg ;
      ACTION oBar:SetColor( oBar:nClrText, ChooseColor( oBar:nClrPane ) )

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function AddBarButton( lGroup )

   local oBtnBmp

   if lGroup
      DEFINE BUTTON oBtnBmp OF oBar ACTION MsgInfo( "Button" ) GROUP ;
         MESSAGE "I am a button"
   else
      DEFINE BUTTON oBtnBmp OF oBar ACTION MsgInfo( "Button" ) ;
         MESSAGE "I am a button"
   endif

   oBtnBmp:bRClicked = { || BtnBmpInspect( oBtnBmp ) }

return nil

//----------------------------------------------------------------------------//

function BtnBmpInspect( oBtnBmp )

   local oDlg
   local cBmpUp   := Space( 40 )
   local cBmpDown := Space( 40 )
   local lUp      := .t.
   local cFile

   DEFINE DIALOG oDlg RESOURCE "BtnBmpInspect"

   REDEFINE GET cBmpUp ID ID_BITMAPUP OF oDlg ;
      VALID ( lUp := .t., oBtnBmp:SetFile( cBmpUp ), .t. )

   REDEFINE BUTTON ID ID_FIND OF oDlg ;
      ACTION If( ! Empty( cFile := cGetFile( "*.bmp", "Select a BMP file" ) ),;
             oBtnBmp:SetFile( If( lUp, cFile, "" ), If( ! lUp, cFile, "" ) ),)

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function MenuInspect()

   local oDlg

   DEFINE DIALOG oDlg RESOURCE "MenuInspect"

   ACTIVATE DIALOG oDlg CENTERED NOWAIT

return nil

//----------------------------------------------------------------------------//

function MenuItemInspect()

   local oDlg
   local cAction := ""

   DEFINE DIALOG oDlg RESOURCE "MenuItemInspect"

   REDEFINE COMBOBOX cAction ITEMS { "DialogBox", "Window", "PopMenu" } ;
      ID ID_ACTION OF oDlg

   REDEFINE BUTTON ID ID_EXECUTE OF oDlg ACTION NewWindow()

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function BrushInspect()

   local oDlg

   DEFINE DIALOG oDlg RESOURCE "BrushInspect"

   REDEFINE RADIO nBrushStyle ID ID_BORLAND, ID_TILED, ID_BRICKS OF oDlg ;
      ON CLICK oWnd:SetBrush( TBrush():New( { "BORLAND",;
         "TILED", "BRICKS" }[ nBrushStyle ] ) )

   REDEFINE BUTTON ID ID_COLORSELECT OF oDlg ;
      ACTION oWnd:SetBrush( TBrush():New(,ChooseColor()) )

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function NewWindow()

   local oWndChild

   DEFINE WINDOW oWndChild FROM 2, 2 TO 12, 40 TITLE "Child Window" ;
      STYLE WS_OVERLAPPEDWINDOW

   ACTIVATE WINDOW oWndChild

return nil

//----------------------------------------------------------------------------//
