// Testing Brushes

#include "FiveWin.ch"

static oWnd

//----------------------------------------------------------------------------//

function Main()

   DEFINE WINDOW oWnd FROM 1, 1 TO 20, 70 TITLE "Bitmaps Demo" ;
                 MENU BuildMenu()

   SET MESSAGE OF oWnd TO "FiveWin 1.0 - Dynamic Bitmaps Loading and Brushed Background"

   ACTIVATE WINDOW oWnd  MAXIMIZED ;
      ON INIT CreaHija()

return


//---------------------------------------------------------------------------//

function BuildMenu()

   local oMenu
   
   MENU oMenu
      
      MENUITEM OemToAnsi( "&Informacin" )
      MENU
         MENUITEM "&Acerca de..." ;
            ACTION MsgInfo( "(C) A.Linares, F.Pulpn 1993", "FiveWin 1.0" ) ;
            MESSAGE OemToAnsi( "Informacin acerca de este programa" )
         SEPARATOR
         MENUITEM "&Salir..." ACTION ;
            If( MsgYesNo( OemToAnsi( "Desea terminar " + ;
                          "la ejecucin del programa ?" ) ), oWnd:End,) ;
            MESSAGE OemToAnsi( "Terminar la ejecucin del programa" )
      ENDMENU
      
      MENUITEM "&Fondos de Ventana"
      MENU
         MENUITEM "PreDefined Styles"
         MENU
            MENUITEM "&Horizontal" ACTION SetBrush( "HORIZONTAL", nRGB( 0,   255,   0 ) )
            MENUITEM "&Vertical"   ACTION SetBrush( "VERTICAL",   nRGB( 20,   30,  40 ) )
            MENUITEM "&FDiagonal"  ACTION SetBrush( "FDIAGONAL",  nRGB( 255,   0,  35 ) )
            MENUITEM "&BDiagonal"  ACTION SetBrush( "BDIAGONAL" )
            MENUITEM "&Cross"      ACTION SetBrush( "CROSS" )
            MENUITEM "&DiagCross"  ACTION SetBrush( "DIAGCROSS",  nRGB(   0, 100, 255 ) )
         ENDMENU

         MENUITEM "FiveWin new Styles"
         MENU
            MENUITEM "&Borland" ACTION SetBrush( "BORLAND" )
            MENUITEM "&Bricks"  ACTION SetBrush( "BRICKS" )
            MENUITEM "&Tiled"   ACTION SetBrush( "TILED" )
         ENDMENU

         MENUITEM "From a &Bitmap" ACTION BmpBrush()

         MENUITEM OemToAnsi( "Using &Colors" )
         MENU
            MENUITEM "&Negro"        ACTION Solido(   0,   0,   0 )
            MENUITEM "&Gris"         ACTION Solido( 128, 128, 128 )
            MENUITEM "Gris &Claro"   ACTION Solido( 192, 192, 192 )
            MENUITEM "&Blanco"       ACTION Solido( 255, 255, 255 )
            MENUITEM "&Rojo"         ACTION Solido( 128,   0,   0 )
            MENUITEM "&Verde"        ACTION Solido(   0, 128,   0 )
            MENUITEM "&Azul"         ACTION Solido(   0,   0, 128 )
            MENUITEM "&Celeste"      ACTION Solido(   0, 128, 128 )
            MENUITEM "A&marillo"     ACTION Solido( 128, 128,   0 )
            MENUITEM "Mag&enta"      ACTION Solido( 128,   0, 128 )
            MENUITEM "&Vd. mismo..." ACTION SelColor()
         ENDMENU
      ENDMENU
   ENDMENU

RETURN oMenu

//---------------------------------------------------------------------------//

function SetBrush( cStyle, nRGBColor )

   local oBrush

   // FiveWin new predefined Brushes don't need colors
   // Windows standard brushes support colors

   if nRGBColor == nil
      DEFINE BRUSH oBrush STYLE ( cStyle )
   else
      DEFINE BRUSH oBrush STYLE ( cStyle ) COLOR nRGBColor
   endif

   SET BRUSH OF oWnd TO oBrush

return

//---------------------------------------------------------------------------//

function BmpBrush()

   local cBitmap := cGetFile( "*.bmp", "Seleccione un Bitmap" )
   local oBrush

   if ! Empty( cBitmap )

      DEFINE BRUSH oBrush FILE cBitmap

      SET BRUSH OF oWnd TO oBrush

   endif

return

//---------------------------------------------------------------------------//

procedure Solido( nR, nG, nB )

   local oBrush

   DEFINE BRUSH oBrush COLOR nRGB( nR, nG, nB )

   SET BRUSH OF oWnd TO oBrush

return

//----------------------------------------------------------------------------//

function CreaHija()

   local oWndTools, oWndDraw

   DEFINE WINDOW oWndTools FROM 2, 2 TO 24, 12 OF oWnd

   ACTIVATE WINDOW oWndTools ;
      ON PAINT Draw( oWndTools, "Tools.bmp" )


   DEFINE WINDOW oWndDraw FROM 2, 22 TO 25, 52 OF oWnd

   ACTIVATE WINDOW oWndDraw ;
      ON PAINT Draw( oWndDraw, "Draw.bmp" )

return

//----------------------------------------------------------------------------//

function Draw( oWndC, cBitmap )

   local hBitmap

   oWndC:GetDC()

   hBitmap = ReadBitmap( oWndC:hDC, cBitmap )
   DrawBitmap( oWndC:hDC, hBitmap, 0, 0 )

   oWndC:ReleaseDC()

   DeleteObject( hBitmap )

return

//----------------------------------------------------------------------------//

function SelColor()

   local oBrush

   DEFINE BRUSH oBrush COLOR ChooseColor()

   SET BRUSH OF oWnd TO oBrush

return

//----------------------------------------------------------------------------//
