#include "FiveWin.ch"

#define LTGRAY_BRUSH       1
#define GRAY_BRUSH         2

#define WM_ERASEBKGND     20
#define WM_LBUTTONDBLCLK 515  // 0x203

#define GW_HWNDNEXT        2
#define GW_CHILD           5

static nId := 100
static nPoint
static nMRow, nMCol

//----------------------------------------------------------------------------//

CLASS TControl FROM TWindow

   DATA   nHelpId
   DATA   bSetGet
   DATA   cCaption
   DATA   lCaptured, lDrag

   METHOD Change() VIRTUAL

   METHOD Click() VIRTUAL

   METHOD cToChar( cCtrlClass )
   METHOD Init( hDlg )

   METHOD GetNewId() INLINE ++nId

   METHOD End()

   METHOD HandleEvent( nMsg, nWParam, nLParam )

   MESSAGE SetFocus METHOD _SetFocus()

   METHOD Colors()
   METHOD DrawItem( nPStruct ) VIRTUAL
   METHOD Paint()              VIRTUAL
   METHOD FillMeasure()        VIRTUAL

   METHOD VarPut( uVal ) INLINE  If( ValType( ::bSetGet ) == "B",;
                                 Eval( ::bSetGet, uVal ),)

   METHOD VarGet() INLINE If( ValType( ::bSetGet ) == "B", Eval( ::bSetGet ),)

   METHOD LButtonDown( nRow, nCol, nKeyFlags )

   METHOD LButtonUp( nRow, nCol, nKeyFlags )

   METHOD MouseMove( nRow, nCol, nKeyFlags )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD cToChar( cCtrlClass ) CLASS TControl

   DEFAULT cCtrlClass := ::ClassName(),;
           ::cCaption := "",;
           ::nId      := ::GetNewId(),;
           ::nStyle   := nOR( WS_CHILD, WS_VISIBLE, WS_TABSTOP )

return cCtrl2Chr( ::nTop, ::nLeft, ::nBottom, ::nRight,;
                  ::nId, ::nStyle, cCtrlClass, ::cCaption )

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TControl

   local oRect

   DEFAULT ::lActive := .t., ::lDrag := .f., ::lCaptured := .f.

   if( ( ::hWnd := GetDlgItem( hDlg, ::nId ) ) != 0 )
      oRect         = ::GetRect()
      ::nTop        = oRect:nTop
      ::nLeft       = oRect:nLeft
      ::nBottom     = oRect:nBottom
      ::nRight      = oRect:nRight

      If( ::lActive, ::Enable(), ::Disable() )

      ::Link()

      if ::oFont != nil
         ::SetFont( ::oFont )
      else
         ::SetFont( ::oWnd:oFont )
      endif

   else
     #define NOVALID_CONTROLID   1
     Eval( ErrorBlock(), _FWGenError( NOVALID_CONTROLID, "No: " + ;
                                      Str( ::nId, 6 ) ) )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD _SetFocus() CLASS TControl

   local hCtrlNext

   if ::lWhen()
      SetFocus( ::hWnd )
   else
      hCtrlNext = GetWindow( ::hWnd, GW_HWNDNEXT )
      if GetParent( hCtrlNext ) != ::oWnd:hWnd
         hCtrlNext = GetWindow( ::oWnd:hWnd, GW_CHILD )
      endif
      SetFocus( hCtrlNext )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TControl

   local nDlgCode

   do case
      case nMsg == WM_PAINT          // Standard Controls must use default
           return nil                // painting procedures

      case nMsg == WM_COMMAND
           return Super:Command( nWParam, nLParam )

      case nMsg == WM_CLICK
           ::Click()

      case nMsg == WM_CHANGE
           ::Change()

      case nMsg == WM_COLOR
           ::hDC = nWParam
           return ::Colors()

      case nMsg == WM_DESTROY
           ::Release()

      case nMsg == FW_MEASURE
           return ::FillMeasure( nLParam )

      case nMsg == FW_DRAW
           return ::DrawItem( nLParam )

      case nMsg == WM_GETDLGCODE
           nDlgCode = ::GetDlgCode()
           if ! Empty( nDlgCode )
              return nDlgCode
           endif

      case nMsg == WM_KEYDOWN
           if nWParam == VK_F1
              HelpTopic( ::nHelpId )
           endif

      case nMsg == WM_KILLFOCUS
           ::LostFocus()
           if GetParent( nWParam ) == ::oWnd:hWnd .and. ! ::oWnd:lValidating
              PostMessage( ::hWnd, FW_LOSTFOCUS )
           endif

      case nMsg == FW_LOSTFOCUS
           if ! ::oWnd:lValidating
              ::oWnd:lValidating = .t.
              if ! ::lValid()
                 SetFocus( ::hWnd )
              endif
              ::oWnd:lValidating = .f.
           endif

      case nMsg == WM_MOUSEMOVE
           return ::MouseMove( nLoWord( nLParam ), nHiWord( nLParam ), nWParam )

      case nMsg == WM_SETFOCUS
           ::oWnd:nResult := Self
           ::GotFocus()

      case nMsg == WM_LBUTTONDOWN
           return ::LButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_LBUTTONUP
           return ::LButtonUp( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_RBUTTONDOWN
           ::RButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_LBUTTONDBLCLK
           if ::bLDblClick != nil
              Eval( ::bLDblClick )
           endif

      case nMsg == WM_ERASEBKGND
           if ::oBrush != nil
              FillRect( nWParam, GetClientRect( ::hWnd ), ::oBrush:hBrush )
              return 1
           endif
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD Colors() CLASS TControl

   DEFAULT ::nClrText := GetTextColor( ::hDC ),;
           ::nClrPane := GetBkColor( ::hDC ),;
           ::oBrush   := TBrush():New( ,::nClrPane,)

   SetTextColor( ::hDC, ::nClrText )
   SetBkColor( ::hDC,   ::nClrPane )

return ::oBrush:hBrush

//----------------------------------------------------------------------------//

METHOD LButtonDown( nRow, nCol, nKeyFlags ) CLASS TControl

   if ::lDrag
      if ! ::lCaptured
         ::Capture()
         ::lCaptured = .t.
         nMRow  = nRow
         nMCol  = nCol
         nPoint = 0
         CtrlDrawFocus( ::hWnd )
      endif
      return 0
   endif

return nil

//----------------------------------------------------------------------------//

METHOD LButtonUp( nRow, nCol, nKeyFlags ) CLASS TControl

   if ::lDrag
      if ::lCaptured
         ReleaseCapture()
         ::lCaptured = .f.
         if nPoint != 0
            CtrlDrawFocus( ::hWnd, nHiWord( nPoint ) - nMRow,;
                                   nLoWord( nPoint ) - nMCol )
            ::Move( ::nTop + nRow - nMRow, ::nLeft + nCol - nMCol )
            ::oWnd:Refresh( .t. )
         else
            CtrlDrawFocus( ::hWnd, 0, 0 )
         endif
      endif
      return 0
   endif

return nil

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TControl

   if ::lDrag
      if ::lCaptured
         CursorCatch()
         if nPoint != 0
            CtrlDrawFocus( ::hWnd, nHiWord( nPoint ) - nMRow,;
                                   nLoWord( nPoint ) - nMCol )
         else
            CtrlDrawFocus( ::hWnd, 0, 0 )
         endif
         nPoint = nMakeLong( nRow, nCol )
         CtrlDrawFocus( ::hWnd, nHiWord( nPoint ) - nMRow,;
                                nLoWord( nPoint ) - nMCol )
      else
         CursorSize()
      endif
      return 0
   else
      return Super:MouseMove( nRow, nCol, nKeyFlags )
   endif

return 0

//----------------------------------------------------------------------------//

METHOD End() CLASS TControl

   local nAt := AScan( ::oWnd:aControls, { | oCtrl | oCtrl:hWnd == Self:hWnd } )

   if nAt != 0
      ADel( ::oWnd:aControls, nAt )
      ASize( ::oWnd:aControls, Len( ::oWnd:aControls ) - 1 )
   endif

return Super:End()

//----------------------------------------------------------------------------//
