#include "FiveWin.ch"

#define LTGRAY_BRUSH     1
#define GRAY_BRUSH       2

#define WM_ACTIVATE      6
#define WM_NCACTIVATE  134  // 0x0086
#define WM_CTLCOLOR     25  // 0x19       // Don't remove Color Control
#define WM_ERASEBKGND   20  // 0x0014     // or controls will not shown
                                          // colors !!!
#define WM_GETFONT      49  // 0x0031
#define WM_DRAWITEM     43  // 0x002B
#define WM_MEASUREITEM  44  // 0x002C

#define WM_VBXFIREEVENT  864       // 0x0360

#define CBN_SELCHANGE      1

#define BM_SETSTYLE        WM_USER + 4

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TDialog FROM TWindow

   DATA   cResName
   DATA   hResources
   DATA   lCentered, lModal, lModify, lVbx

   METHOD New( nTop, nLeft, nBottom, nRight, cCaption, cResName, hResources,;
               lVbx, nStyle, nClrText, nClrBack, oBrush, oWnd ) CONSTRUCTOR

   METHOD Define( nTop, nLeft, nBottom, nRight, cCaption, nStyle,;
                  nClrText, nClrPane, oBrush ) CONSTRUCTOR

   METHOD Activate( bClicked, bMoved, bPainted, lCentered, bValid, lModal,;
                    bInit, bRClicked )

   METHOD Command( nWParam, nLParam )
   METHOD cToChar()
   METHOD DefControl( oControl )

   METHOD Release() INLINE If( ! ::lModal, Super:Release(), )
   METHOD End( nResult )
   METHOD FocusNext( hCtrlFocus, lPrevius )
   METHOD GetItem( nId ) INLINE  GetDlgItem( ::hWnd, nId )

   METHOD HandleEvent( nMsg, nWParam, nLParam )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cCaption, cResName, hResources,;
            lVbx, nStyle, nClrText, nClrBack, oBrush, oWnd ) CLASS TDialog

   DEFAULT hResources := GetResources(), lVbx := .f.,;
           nStyle     := nOR( DS_MODALFRAME, WS_POPUP, WS_CAPTION, WS_SYSMENU ),;
           nClrText   := CLR_BLACK, nClrBack := CLR_LIGHTGRAY

   ::aControls  = {}
   ::cResName   = cResName
   ::cCaption   = cCaption
   ::hResources = hResources
   ::lModify    = .t.
   ::lVbx       = lVbx
   ::lVisible   = .f.
   ::nResult    = 0
   ::nTop       = nTop
   ::nLeft      = nLeft
   ::nBottom    = nBottom
   ::nRight     = nRight
   ::nStyle     = nStyle
   ::oWnd       = oWnd

   ::SetColor( nClrText, nClrBack, oBrush )

   if lVbx
      VbxInit()
   endif

   if ! lRegistered
      ::Register( nOr( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   SetWndDefault( Self )          //  Set Default DEFINEd Window

return nil

//----------------------------------------------------------------------------//

METHOD Activate( bLClicked, bMoved, bPainted, lCentered, ;
                 bValid, lModal, bInit, bRClicked ) CLASS TDialog

   static nDlgCount := 0

   local hActiveWnd, hWnd

   DEFAULT lCentered := .f., lModal := .t., ::hWnd := 0

   ++nDlgCount

   hActiveWnd = If( ::oWnd != nil, ::oWnd:hWnd,;
                If( nDlgCount > 1 .or. lWRunning(),;
                    GetActiveWindow(), 0 ) )

   ::lCentered   = lCentered
   ::lModal      = lModal
   ::bLClicked   = bLClicked
   ::bRClicked   = bRClicked
   ::bValid      = bValid
   ::bInit       = bInit
   ::bPainted    = bPainted
   ::bMoved      = bMoved
   ::nResult     = nil
   ::lValidating = .f.
   ::lVisible    = .t.

   if bInit != nil
      if !Eval( bInit, Self )
          ::nResult  = IDCANCEL
          ::lVisible = .f.
          return nil             // <<---------- Warning: Exiting!
      endif
   endif

   if lModal
      ::nResult = if( ! Empty( ::cResName ),;
                      DialogBox( ::hResources, ::cResName,;
                                      hActiveWnd, Self ),;
                      DialogBoxIndirect( GetInstance(), ::cToChar(),;
                                      hActiveWnd, Self ) )
      if ::nResult == -1
         CreateDlgError( Self )
      endif

   else
      if ( Len( ::aControls ) > 0 .and. CanRegDialog() ) .or. ;
           Len( ::aControls ) == 0

         ::hWnd = if( ! Empty( ::cResName ),;
                       CreateDlg( ::hResources, ::cResName,;
                                  hActiveWnd, Self ),;
                       CreateDlgIndirect( GetInstance(), ::cToChar(),;
                                  hActiveWnd, Self ) )

         if ::hWnd == 0
            CreateDlgError( Self )
         endif

         ::Link( .f. )

         if len( ::aControls ) > 0 .and. ! RegDialog( ::hWnd )

            ::SendMsg( WM_CLOSE )

            MsgAlert( "Not possible to create more non-modal Dialogs" )
            
            endif

         ShowWindow( ::hWnd )

      else

         MsgAlert( "Not possible to create more non-modal Dialogs" )

      endif

   endif

   nDlgCount--

   if ::lModal
      ::lVisible = .f.
   endif

return nil

//---------------------------------------------------------------------------//

METHOD DefControl( oCtrl ) CLASS TDialog

   if AScan( ::aControls, { | o | o:nId == oCtrl:nId } ) > 0
      #define DUPLICATED_CONTROLID  2
      Eval( ErrorBlock(), _FWGenError( DUPLICATED_CONTROLID, ;
                          "No: " + Str( oCtrl:nId, 6 ) ) )
   else
      AAdd( ::aControls, oCtrl )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD FocusNext( hCtrlFocus, lPrevius ) CLASS TDialog

   local hCtrlNext := NextDlgTab( ::hWnd, hCtrlFocus, lPrevius )

   if hCtrlNext != hCtrlFocus
      SetFocus( hCtrlNext )

      // DLGC_BUTTON || DLGC_DEFPUSHBUTTON = 8224
      if SendMessage( hCtrlNext, WM_GETDLGCODE, 0, 0 ) = 8224
         SendMessage( hCtrlNext, BM_SETSTYLE, BS_DEFPUSHBUTTON, 1 )
      endif
   else
      MessageBeep( -1 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Command( nWParam, nLParam ) CLASS TDialog

   do case
      case ::oPopup != nil
           ::oPopup:Command( nWParam )
           ::oPopup = nil

      case nLParam == 0 .and. ::oMenu != nil
           ::oMenu:Command( nWParam )

      case nWParam > 0
           do case
              case nHiWord( nLParam ) == BN_CLICKED

                   if nLoWord( nLParam ) > 0 .and. nWParam != IDCANCEL

                      if ::nResult != nil  // latest control which had focus

                         ::nResult:LostFocus()    // updates related variable

                         // There is a pending Valid, it is not a clicked button
                         if ::nResult:nID != nWParam .and. !::nResult:lValid()
                            return nil
                         endif

                      endif

                      if AScan( ::aControls, { |o| o:nID == nWParam } ) > 0
                         SendMessage( nLoWord( nLParam ), WM_CLICK, 0, 0 )
                      elseif nWParam == IDOK
                         ::End( IDOK )
                      endif

                   else

                      if nWParam == IDOK

                         ::FocusNext( GetFocus(), .f. )

                      elseif nLoWord( nLParam ) > 0 .and. ; // There is a control for IDCANCEL
                             AScan( ::aControls, { |o| o:nID == nWParam } ) > 0
                            SendMessage( nLoWord( nLParam ), WM_CLICK, 0, 0 )
                      else
                         ::End( IDCANCEL )
                      endif

                   endif

                   return nil

              case nHiWord( nLParam ) == CBN_SELCHANGE
                   SendMessage( nLoWord( nLParam ), WM_CHANGE, 0, 0 )

           endcase
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD cToChar() CLASS TDialog

   local cResult
   local aControls := ::aControls
   local n

   DEFAULT ::cCaption := ""

   cResult = cDlg2Chr( Len( aControls ),;
                       ::nTop, ::nLeft, ::nBottom, ::nRight,;
                       ::cCaption, ::nStyle )

   for n = 1 to Len( aControls )
      cResult += aControls[ n ]:cToChar()
   next

return cResult

//----------------------------------------------------------------------------//

METHOD Define( nTop, nLeft, nBottom, nRight, cCaption, nStyle, lVbx,;
               nClrText, nClrBack, oBrush ) CLASS TDialog

   DEFAULT lVbx     := .f.,;
           nClrText := CLR_BLACK, nClrBack := CLR_LIGHTGRAY

   ::hWnd     = 0
   ::nTop     = nTop
   ::nLeft    = nLeft
   ::nBottom  = nBottom
   ::nRight   = nRight
   ::cCaption = cCaption
   ::nStyle   = nStyle
   ::lVbx     = lVbx

   ::SetColor( nClrText, nClrBack, oBrush )

return nil

//----------------------------------------------------------------------------//

METHOD End( nResult ) CLASS TDialog

   DEFAULT nResult := 2              // Cancel

   if ! ::lModal
      PostMessage( ::hWnd, WM_CLOSE, nResult )
   else
      if ValType( ::bValid ) == "B"
         if ! Eval( ::bValid, Self )
            return 1
         endif
      endif

      ::nResult = nResult
      EndDialog( ::hWnd, nResult )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TDialog

   do case
      case nMsg == WM_INITDIALOG
            if ::lVbx
               if ! VbxInitDialog( ::hWnd, ::hResources, ::cResName )
                  MsgAlert( "Error on VBX's initialization" )
               endif
            endif
            if ::oFont == nil
               ::oFont = TFont()
               ::oFont:hFont = ::SendMsg( WM_GETFONT )
            endif
            AEval( ::aControls, { | oCtrl | oCtrl:Init( ::hWnd ) } )
            if ::lCentered
               WndCenter( ::hWnd )
            endif
            if ::cCaption != nil
               ::cTitle = ::cCaption
            endif
            return .t.                              // .t. for focus

      case nMsg == WM_CLOSE
           if ! ::lModal
              if ValType( ::bValid ) == "B"
                 if ! Eval( ::bValid, Self )
                    return nil
                 endif
              endif

               ::nResult = nWParam

              ::lVisible = .f.
              DestroyWindow( ::hWnd )
              return .t.
           endif
           
      case nMsg == WM_COLOR
           ::hDC = nWParam
           return ::Colors()

      case nMsg == WM_COMMAND
           ::Command( nWParam, nLParam )

      case nMsg == WM_CTLCOLOR
           return SendMessage( nLoWord( nLParam ),;   // Handle Child
                               WM_COLOR,;             // FiveWin Message
                               nWParam )              // Child hDC

      case nMsg == WM_DESTROY
           if ! ::lModal
              ::Release()
              return .t.
           endif

      case nMsg == WM_VBXFIREEVENT
           // MsgInfo( "Vbx Fire Event" )

      case nMsg == WM_MEASUREITEM
           return Super:HandleEvent( nMsg, nWParam, nLParam )

      case nMsg == WM_DRAWITEM
           return Super:HandleEvent( nMsg, nWParam, nLParam )

      case nMsg == WM_LBUTTONDOWN
           return ::LButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_RBUTTONDOWN
           return ::RButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_VSCROLL
           ::VScroll( nWParam, nLParam )

      case nMsg == WM_HSCROLL
           ::HScroll( nWParam, nLParam )

      case nMsg == WM_ERASEBKGND
           if ::oBrush != nil
              FillRect( nWParam, GetClientRect( ::hWnd ), ::oBrush:hBrush )
              return .t.
           endif

      case nMsg == WM_PAINT
           ::BeginPaint()
           ::Paint()
           ::EndPaint()
           return 0

      case nMsg == WM_DDE_ACK
           DdeAck( nWParam, nLParam, ::hWnd )
   endcase

return nil

//----------------------------------------------------------------------------//

METHOD Colors() CLASS TDialog

   SetTextColor( ::hDC, ::nClrText )
   SetBkColor( ::hDC, ::nClrPane )

return .t.

//----------------------------------------------------------------------------//
// Conection with Borland's VBX DLL

DLL STATIC FUNCTION VbxInitDialog( hWnd AS WORD, hInstance AS WORD,;
                       cResName AS STRING ) AS BOOL PASCAL LIB "BIVBX.DLL"

DLL STATIC FUNCTION VbxInit() AS BOOL PASCAL LIB "BIVBX.DLL"

//----------------------------------------------------------------------------//

static function CreateDlgError( Self )

   #define CANNOTCREATE_DIALOG 3
   Eval( ErrorBlock(), ;
        _FwGenError( CANNOTCREATE_DIALOG, CHR(13)+CHR(10) + ;
                     If( !Empty( ::cResName ), "Resource: " + ::cResName,;
               "Title: " + If( Empty( ::cCaption ), "", ::cCaption ) ) ) )
return nil

//----------------------------------------------------------------------------//
