// LinkLists in Clipper !!!

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TLinkList

   DATA   oFirst, oLast

   METHOD Add( cLabel, nLevel, hBmpOpen, hBmpClose )
   METHOD OpenAll()
   METHOD GetLast()
   METHOD nCount()

   METHOD Draw( cPrevDraw )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD Add( cLabel, nLevel, hBmpOpen, hBmpClose ) CLASS TLinkList

   local oItem := TTreeItem():New( cLabel, nLevel, hBmpOpen, hBmpClose )

   if ::oFirst == nil
      ::oFirst = oItem
      ::oLast  = oItem
   else
      ::oLast:SetNext( oItem )
      oItem:oPrev   = ::oLast
      ::oLast       = oItem
   endif

return oItem

//----------------------------------------------------------------------------//

METHOD OpenAll() CLASS TLinkList

   local oItem := ::oFirst

   while oItem != nil
      oItem:Open()
      oItem = oItem:GetNext()
   end

return nil

//----------------------------------------------------------------------------//

METHOD GetLast() CLASS TLinkList

   if ::oLast:lOpened
      return ::oLast:oTree:GetLast()
   else
      return ::oLast
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Draw( cPrevDraw ) CLASS TLinkList

   local oItem := ::oFirst

   while oItem != nil
      oItem:Draw( cPrevDraw )
      oItem = If( oItem:oNext != nil .and. ;    // Don't use GetNext()
                  oItem:oNext:nLevel == oItem:nLevel,;
                  oItem:oNext, nil )
   end

return nil

//----------------------------------------------------------------------------//

METHOD nCount() CLASS TLinkList

   local oItem  := ::oFirst
   local nItems := 0

   while oItem != nil
      nItems++
      oItem = oItem:GetNext()
   end

return nItems

//----------------------------------------------------------------------------//
