#include "FiveWin.ch"

#define LB_ADDSTRING         ( WM_USER +  1 )
#define LB_INSERTSTRING      ( WM_USER +  2 )
#define LB_DELETESTRING      ( WM_USER +  3 )
#define LB_RESETCONTENT      ( WM_USER +  5 )
#define LB_SETCURSEL         ( WM_USER +  7 )
#define LB_GETCURSEL         ( WM_USER +  9 )
#define LB_GETCOUNT          ( WM_USER + 12 )
#define LB_DIR               ( WM_USER + 14 )
#define LB_ERR                           -1

#define COLOR_WINDOW       5
#define COLOR_WINDOWTEXT   8

//----------------------------------------------------------------------------//

CLASS TListBox FROM TControl

   DATA   aItems
   DATA   bChanged
   DATA   lOwnerDraw, nBmpSize
   DATA   cFileSpec

   METHOD New( nRow, nCol, bSetGet, aItems, nWidth, nHeight, bChanged,;
               oWnd, bValid, nClrFore, nClrBack, lPixel, lDesign ) CONSTRUCTOR

   METHOD ReDefine( nId, bSetGet, aItems, bChanged,  oWnd, nHelpId,;
                    lOwnerDraw, nBmpSize, bValid, cFileSpec,;
                    nClrFore, nClrBack ) CONSTRUCTOR

   METHOD cToChar() INLINE Super:cToChar( "LISTBOX" )

   METHOD Init( hDlg ) INLINE  Super:Init( hDlg ),;
                               ::Default()

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD Select( nItem ) INLINE ::SendMsg( LB_SETCURSEL, nItem, 0 )

   METHOD Set( cNewItem )

   METHOD Add( cItem, nAt )
   METHOD Modify( cItem, nAt )
   METHOD Insert( cItem, nAt )
   METHOD Del( nAt )
   METHOD GetItem( nItem ) INLINE  LbxGetItem( ::hWnd, nItem )

   METHOD Len() INLINE  SendMessage( ::hWnd, LB_GETCOUNT )

   METHOD LostFocus()

   METHOD Reset() INLINE Eval( ::bSetGet, "" ),;
                         ASize( ::aItems, 0 ),;
                         ::SendMsg( LB_RESETCONTENT )

   METHOD Change()

   METHOD FillMeasure( nPInfo ) INLINE  LbxMeasure( nPInfo, ::nBmpSize )

   METHOD DrawItem( nPStruct ) INLINE  LbxDrawItem( nPStruct, ::aItems )

   METHOD GetPos() BLOCK ;             // it has to be a BLOCK
      { | Self, nPos | nPos := ::SendMsg( LB_GETCURSEL ),;
                       If( nPos == -1, 0, nPos + 1 ) }

   METHOD Default()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, bSetGet, aItems, nWidth, nHeight, bChanged, ;
            oWnd, bValid, nClrFore, nClrBack, lPixel, lDesign )  CLASS TListBox

   if nClrFore == nil
      nClrBack := GetSysColor( COLOR_WINDOW )
   endif

   DEFAULT aItems   := {}, nWidth := 40, nHeight := 40,;
           nClrFore := GetSysColor( COLOR_WINDOWTEXT ),;
           lPixel   := .f., lDesign := .f.

   ::cCaption   = ""
   ::nTop       = nRow * If( lPixel, 1, 14 )
   ::nLeft      = nCol * If( lPixel, 1,  8 )
   ::nBottom    = ::nTop  + nHeight - 1
   ::nRight     = ::nLeft + nWidth - 1
   ::aItems     = aItems
   ::bSetGet    = bSetGet
   ::bChanged   = bChanged
   ::oWnd       = oWnd
   ::lOwnerDraw = .f.
   ::nStyle     = nOR( LBS_NOTIFY, WS_TABSTOP, LBS_DISABLENOSCROLL,;
                       LBS_USETABSTOPS, WS_CHILD, WS_VISIBLE, WS_BORDER,;
                       WS_VSCROLL, If( lDesign, WS_THICKFRAME, 0 ) )
   ::nId        = ::GetNewId()
   ::bValid     = bValid
   ::lDrag      = lDesign
   ::lCaptured  = .f.

   ::SetColor( nClrFore, nClrBack )

   if oWnd:lVisible
      ::Create( "LISTBOX" )
      ::Default()
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, bSetGet, aItems, bChanged, oWnd, nHelpId,;
                 lOwnerDraw, nBmpSize, bValid, cFileSpec, nClrFore,;
                 nClrBack ) CLASS TListBox

   if nClrFore == nil
      nClrBack := GetSysColor( COLOR_WINDOW )
   endif

   DEFAULT aItems   := {}, nBmpSize := 30,;
           nClrFore := GetSysColor( COLOR_WINDOWTEXT )

   ::nId        = nId
   ::hWnd       = 0
   ::aItems     = aItems
   ::bSetGet    = bSetGet
   ::bChanged   = bChanged
   ::oWnd       = oWnd
   ::nHelpId    = nHelpId
   ::lOwnerDraw = lOwnerDraw
   ::nBmpSize   = nBmpSize
   ::bValid     = bValid
   ::cFileSpec  = cFileSpec
   ::lDrag      = .f.
   ::lCaptured  = .f.

   ::SetColor( nClrFore, nClrBack )

   if lOwnerDraw
      AEval( ::aItems, ;
             { | cBitmap, n | ::aItems[ n ] := ReadBitmap( 0, cBitmap ) } )
   endif

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Set( cNewItem ) CLASS TListBox

   local nAt := AScan( ::aItems,;
                       { | cItem | Upper( AllTrim( cItem ) ) == ;
                                   Upper( AllTrim( cNewItem ) ) } )

   if nAt != 0
      ::Select( nAt - 1 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD LostFocus() CLASS TListBox

   local nAt := ::SendMsg( LB_GETCURSEL )

   Super:LostFocus()

   if nAt != -1
      Eval( ::bSetGet, ::aItems[ nAt + 1 ] )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Add( cItem, nAt ) CLASS TListBox

   DEFAULT nAt := Len( ::aItems )

   if nAt == Len( ::aItems )
      AAdd( ::aItems, cItem )
      ::SendMsg( LB_ADDSTRING, nAt, cItem )
   else
      ASize( ::aItems, Len( ::aItems ) + 1 )
      AIns( ::aItems, nAt + 1 )
      ::aItems[ nAt + 1 ] = cItem
      ::SendMsg( LB_INSERTSTRING, nAt, cItem )
   endif

   ::SendMsg( LB_SETCURSEL, nAt )

return nil

//----------------------------------------------------------------------------//

METHOD Modify( cItem, nAt ) CLASS TListBox

   if nAt == nil
      if ( nAt := ::SendMsg( LB_GETCURSEL ) ) != -1
         nAt++
      endif
   endif

   if nAt > 0
      ::aItems[ nAt ] = cItem
      ::SendMsg( LB_DELETESTRING, nAt - 1 )
      ::SendMsg( LB_INSERTSTRING, nAt - 1, cItem )
      ::SendMsg( LB_SETCURSEL, nAt - 1 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Insert( cItem, nAt ) CLASS TListBox

   if nAt == nil
      if ( nAt := ::SendMsg( LB_GETCURSEL ) ) != -1
         nAt++
      endif
   endif

   if nAt > 0
      ASize( ::aItems, Len( ::aItems ) + 1 )
      AIns( ::aItems, nAt )
      ::aItems[ nAt ] = cItem
      ::SendMsg( LB_INSERTSTRING, nAt - 1, cItem )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Del( nAt ) CLASS TListBox

   if nAt == nil
      if ( nAt := ::SendMsg( LB_GETCURSEL ) ) != -1
         nAt++
      endif
   endif

   if nAt > 0
      ADel( ::aItems, nAt )
      ASize( ::aItems, Len( ::aItems ) - 1 )
      ::SendMsg( LB_DELETESTRING, nAt - 1 )
      ::SendMsg( LB_SETCURSEL, Min( nAt, Len( ::aItems ) ) - 1 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Change() CLASS TListBox

   Eval( ::bSetGet, ::aItems[ ::SendMsg( LB_GETCURSEL ) + 1 ] )

   if ::bChanged != nil
      Eval( ::bChanged, Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Default() CLASS TListBox

   local nAt
   local cStart := Eval( ::bSetGet )
   local aFiles

   if ! ::lOwnerDraw
      if ! Empty( ::cFileSpec )
         aFiles = Directory( ::cFileSpec )
         for nAt = 1 to Len( aFiles )
            AAdd( ::aItems, aFiles[ nAt ][ 1 ] )
         next
         ASort( ::aItems )
      endif

      AEval( ::aItems, { | cItem, nAt | ::SendMsg( LB_ADDSTRING, nAt, cItem ) } )

      nAt = AScan( ::aItems, { | cItem | Upper( AllTrim( cItem ) ) == ;
                                         Upper( AllTrim( cStart ) ) } )
      if nAt != 0
         ::SendMsg( LB_SETCURSEL, nAt - 1 )
      endif
   else
      AEval( ::aItems, { | cItem | ::Add( "Testing..." ) } )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TListBox

   local nResult := Super:MouseMove( nRow, nCol, nKeyFlags )

return If( ::lDrag, nResult, nil )    // We want standard behavior !!!

//----------------------------------------------------------------------------//
