#include "FiveWin.ch"

#define MF_ENABLED       0
#define MF_GRAYED        1
#define MF_DISABLED      2
#define MF_BITMAP        4
#define MF_CHECKED       8
#define MF_POPUP        16  // 0x0010
#define MF_BYPOSITION 1024  // 0x0400
#define MF_SEPARATOR  2048  // 0x0800

static oLastItem
static hClass

//----------------------------------------------------------------------------//

CLASS TMenu

   DATA   hMenu
   DATA   aItems
   DATA   oWnd
   DATA   lSysMenu

   METHOD New( lPopup, oWnd )  CONSTRUCTOR
   METHOD ReDefine( cResName ) CONSTRUCTOR
   METHOD NewSys( oWnd )       CONSTRUCTOR
   METHOD Add( oMenuItem )
   METHOD Command( nCommand )

   METHOD LastItem() INLINE oLastItem

   METHOD GetMenuItem( nItemId ) INLINE  SearchItem( ::aItems, nItemId )

   METHOD Activate( nRow, nCol, oWnd )

   METHOD Refresh() INLINE ::oWnd:SetMenu( Self )

   METHOD Reset() INLINE If( ::lSysMenu, GetSystemMenu( ::oWnd:hWnd, .t. ),;
                         DestroyMenu( ::hMenu ) ), ::hMenu := CreateMenu(),;
                         ::aItems := {}

   METHOD Release() INLINE ReleaseItems( ::aItems )

   METHOD End() INLINE If( ::oWnd != nil, SetMenu( ::oWnd:hWnd, 0 ),),;
                           DestroyMenu( ::hMenu )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( lPopup, oWnd ) CLASS TMenu

   DEFAULT lPopup := .f.

   ::hMenu    = If( lPopup, CreatePopupMenu(), CreateMenu() )
   ::aItems   = {}
   ::lSysMenu = .f.

   if oWnd != nil
      oWnd:SetMenu( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( cResName ) CLASS TMenu

   local hMenu := LoadMenu( GetResources(), cResName )

   ::hMenu    = hMenu
   ::aItems   = {}
   ::lSysMenu = .f.

   ResBuild( Self )

return nil

//----------------------------------------------------------------------------//

METHOD NewSys( oWnd ) CLASS TMenu

   local n

   if oWnd != nil
      ::oWnd  = oWnd
      ::hMenu = GetSystemMenu( oWnd:hWnd, .f. )
   endif
   ::aItems   = {}
   ::lSysMenu = .t.

return nil

//----------------------------------------------------------------------------//

METHOD Add( oMenuItem ) CLASS TMenu

   AAdd( ::aItems, oMenuItem )

   oMenuItem:oMenu = Self

   if oMenuItem:bAction:ClassName() == "TMENU"
      if oMenuItem:hBitmap == 0
         AppendMenu( ::hMenu, MF_POPUP, oMenuItem:bAction:hMenu,;
                     oMenuItem:cPrompt )
      else
         AppendMenu( ::hMenu, nOR( MF_POPUP, MF_BITMAP ),;
                     oMenuItem:bAction:hMenu, oMenuItem:hBitmap )
      endif
   else
      if oMenuItem:cPrompt != nil
         AppendMenu( ::hMenu,;
                     nOR( If( oMenuItem:lActive, MF_ENABLED,;
                          nOR( MF_DISABLED, MF_GRAYED ) ),;
                          If( oMenuItem:lChecked, MF_CHECKED, 0 ) ),;
                     oMenuItem:nId, oMenuItem:cPrompt )
      else
         if oMenuItem:hBitmap != 0
            AppendMenu( ::hMenu, MF_BITMAP,;
                        oMenuItem:nId, oMenuItem:hBitmap )
         else
            AppendMenu( ::hMenu, MF_SEPARATOR, oMenuItem:nId, "" )
         endif
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Command( nCommand ) CLASS TMenu

   local oMenuItem := ::GetMenuItem( nCommand )

   if oMenuItem != nil
      if ValType( oMenuItem:bAction ) == "B"
         oLastItem = oMenuItem
         Eval( oMenuItem:bAction )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Activate( nRow, nCol, oWnd ) CLASS TMenu

   if oWnd != nil
      oWnd:oPopup = Self
      TrackPopup( ::hMenu, 1, nRow, nCol, 0, oWnd:hWnd )

      // We cannot release here oWnd:oPopup since it has not
      // beeing processed the command yet !!!
      // We release oWnd:oPopup after processing the :Command()
      // at TWindow::Command()

      SysRefresh()
      oWnd:oPopup = nil
   endif

return nil

//----------------------------------------------------------------------------//

static function SearchItem( aItems, nId )

   local n      := 1
   local lFound := .f.
   local oReturn

   if hClass == nil
      hClass = TMenu():ClassH()
   endif

   while n <= Len( aItems ) .and. ! lFound
      if aItems[ n ]:nId == nId
         return aItems[ n ]
      else
         if aItems[ n ]:bAction:ClassH() == hClass
            if aItems[ n ]:bAction:hMenu == nId
               return nil
            else
               oReturn = SearchItem( aItems[ n ]:bAction:aItems, nId )
               if oReturn != nil
                  exit
               endif
            endif
         endif
      endif
      n++
   end

return oReturn

//----------------------------------------------------------------------------//

static function ReleaseItem( aItems )

   local n := 1
   local oItem

   if hClass == nil
      hClass = TMenu():ClassH()
   endif

   while n <= Len( aItems )
      oItem = aItems[ n ]
      if oItem:bAction != nil
         if oItem:bAction:ClassH() == hClass
            ReleaseItem( oItem:bAction:aItems )
         endif
      endif
      oItem:Release()
      n++
   end

return nil

//----------------------------------------------------------------------------//

static function ResBuild( oMenu )

   local n
   local hMenu := oMenu:hMenu
   local hSubMenu
   local oSubMenu, oMenuItem

   for n = 1 to GetMItemCount( hMenu )
         oMenuItem          = TMenuItem()
         oMenuItem:nId      = GetMItemID( hMenu, n - 1 )
         oMenuItem:cPrompt  = GetMenuString( hMenu, n - 1, MF_BYPOSITION )
         oMenuItem:cMsg     = ""
         oMenuItem:lChecked = lAnd( GetMenuState( hMenu, n - 1, MF_BYPOSITION ), MF_CHECKED )
         oMenuItem:lActive  = lAnd( GetMenuState( hMenu, n - 1, MF_BYPOSITION ), MF_ENABLED )
         oMenuItem:oMenu    = oMenu
         oMenuItem:hBitmap  = 0
         AAdd( oMenu:aItems, oMenuItem )
         if ( hSubMenu := GetSubMenu( hMenu, n - 1 ) ) != 0
            oSubMenu          = TMenu()
            oSubMenu:hMenu    = hSubMenu
            oSubMenu:lSysMenu = .f.
            oSubMenu:aItems   = {}
            oMenuItem:bAction = oSubMenu
            ResBuild( oSubMenu )
         endif
   next

return nil

//----------------------------------------------------------------------------//
