#include "FiveWin.ch"

#define LTGRAY_BRUSH 1

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TMeter FROM TControl

   DATA   nTotal

   METHOD New( nRow, nCol, bSetGet, nTotal, oWnd, nWidth, nHeight ) CONSTRUCTOR

   METHOD ReDefine( nId, bSetGet, nTotal, oWnd ) CONSTRUCTOR

   METHOD HandleEvent( nMsg, nWParam, nLParam )

   METHOD Paint() BLOCK ;
      { | Self, nActual | MeterPaint( ::hWnd, ::hDC,;
                          nActual := Eval( ::bSetGet ), ::nTotal,;
                          nActual * 100 / ::nTotal ) }

   METHOD Set( nActual )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, bSetGet, nTotal, oWnd, nWidth, nHeight ) CLASS TMeter

   DEFAULT nTotal := 10, nWidth := 300, nHeight := 20

   ::nTop     = nRow * 14
   ::nLeft    = nCol *  8
   ::nBottom  = ::nTop  + nHeight
   ::nRight   = ::nLeft + nWidth
   ::oWnd     = oWnd
   ::nStyle   = nOR( WS_CHILD, WS_VISIBLE, WS_BORDER )
   ::nId      = ::GetNewId()
   ::bSetGet  = bSetGet
   ::nTotal   = nTotal
   ::nClrPane  = CLR_GRAY
   ::nClrText  = CLR_WHITE
   ::lDrag     = .f.
   ::lCaptured = .f.

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   if oWnd:ClassName() != "TDIALOG"
      ::Create()
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, bSetGet, nTotal, oWnd ) CLASS TMeter

   DEFAULT nTotal := 10

   ::nId     = nId
   ::bSetGet = bSetGet
   ::nTotal  = nTotal
   ::oWnd    = oWnd
   ::nClrPane  = CLR_GRAY
   ::nClrText  = CLR_WHITE
   ::lDrag     = .f.
   ::lCaptured = .f.

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   if oWnd != nil
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TMeter

   if nMsg == WM_PAINT
      ::BeginPaint()
      ::Paint()
      ::EndPaint()
      return 0
   endif

return Super:HandleEvent( nMsg, nWParam, nLParam )

//----------------------------------------------------------------------------//

METHOD Set( nActual ) CLASS TMeter

   DEFAULT nActual := Eval( ::bSetGet )

   if nActual > ::nTotal
      nActual = ::nTotal
   endif

   if nActual < 0
      nActual = 0
   endif

   Eval( ::bSetGet, nActual )

   ::Refresh( .f. )

return nil

//----------------------------------------------------------------------------//
