#include "FiveWin.ch"

#define LTGRAY_BRUSH       1
#define TRANSPARENT        1

#define SS_CENTER          1

#define DLGC_BUTTON     8192   // 0x2000

#define COLOR_WINDOW       5
#define COLOR_WINDOWTEXT   8

#define WM_NCHITTEST     132  // 0x84

//----------------------------------------------------------------------------//

CLASS TSay FROM TControl

   DATA   lBorder, lCenter
   DATA   cPicture

   METHOD New( nRow, nCol, cText, oWnd, cPicture, oFont,;
               lCentered, lBorder, lPixels, nClrText, nClrBack,;
               nWidth, nHeight, lDesign ) CONSTRUCTOR

   METHOD ReDefine( nId, cText, oWnd, lCentered, lBorder, nClrText,;
                    nClrBack )  CONSTRUCTOR

   METHOD cToChar() INLINE  Super:cToChar( "STATIC" )

   METHOD HandleEvent( nMsg, nWParam, nLParam )

   METHOD Init( hDlg )

   METHOD SetText( cText ) INLINE ;
                    ::cCaption := If( ::cPicture != nil,;
                                  Transform( cText, ::cPicture ),;
                                  cValToChar( cText ) ),;
                    SetWindowText( ::hWnd, ::cCaption )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, cText, oWnd, cPicture, oFont,;
            lCentered, lBorder, lPixels, nClrText, nClrBack,;
            nWidth, nHeight, lDesign ) CLASS TSay

   ::cPicture  = cPicture
   ::cCaption  = If( Empty( cPicture ), cValToChar( cText ),;
                     Transform( cText, cPicture ) )

   DEFAULT lBorder  := .f., lCentered := .f., lPixels := .f.,;
           oWnd     := GetWndDefault(),;
           nClrText := oWnd:nClrText, nClrBack := oWnd:nClrPane,;
           nWidth   := ( If( oFont != nil, Abs( oFont:nWidth ), 8 ) * Len( ::cCaption ) ) - 4,;
           nHeight  := If( oFont != nil, Abs( oFont:nHeight ), 13 ),;
           lDesign  := .f.

   ::lBorder = lBorder
   ::lCenter = lCentered

   if ! lPixels
      ::nTop  = nRow * If( oFont != nil, Abs( oFont:nHeight ), 13 ) + 2
      ::nLeft = nCol * If( oFont != nil, Abs( oFont:nWidth ), 8 )
   else
      ::nTop  = nRow
      ::nLeft = nCol
   endif

   ::nBottom   = ::nTop + nHeight - 1
   ::nRight    = ::nLeft + nWidth - 1

   ::oWnd      = oWnd
   ::oFont     = oFont
   ::nId       = ::GetNewId()
   ::nStyle    = nOR( WS_CHILD, WS_VISIBLE ,;
                      If( ::lCenter , SS_CENTER, SS_LEFT ),;
                      If( ::lBorder, WS_BORDER, 0 ),;
                      If( lDesign, WS_THICKFRAME, 0 ) )
   ::lDrag     = lDesign
   ::lCaptured = .f.

   ::SetColor( nClrText, nClrBack )

   if oWnd:lVisible
      ::Create( "STATIC" )
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, cText, oWnd, cPicture, lCentered, lBorder,;
                 nClrText, nClrBack ) CLASS TSay

   DEFAULT lCentered := .f., lBorder := .f.,;
           nClrText  := oWnd:nClrText, nClrBack := oWnd:nClrPane

   ::nId       = nId
   ::cPicture  = cPicture
   ::cCaption  = If( Empty( cPicture ), cValToChar( cText ),;
                     Transform( cText, cPicture ) )
   ::oWnd      = oWnd
   ::hWnd      = 0
   ::lBorder   = lBorder
   ::lCenter   = lCentered
   ::lDrag     = .f.
   ::lCaptured = .f.

   ::SetColor( nClrText, nClrBack )
   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TSay

   Super:Init( hDlg )

   if ! Empty( ::cCaption )
      ::cTitle = ::cCaption
      SetWindowText( ::hWnd, ::cCaption )
   else
      ::cCaption = GetWindowText( ::hWnd )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TSay

   if ::lDrag .and. nMsg == WM_NCHITTEST      // To have a standard behavior on Clicks
      return DefWindowProc( ::hWnd, nMsg, nWParam, nLParam )
   endif

return Super:HandleEvent( nMsg, nWParam, nLParam )

//----------------------------------------------------------------------------//
