//----------------------------------------------------------------------------//
// MCI - Media Control Interface                                              //
// (c) FiveWin 1.2                                                            //
//----------------------------------------------------------------------------//

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TMci

   DATA   nError, nId
   DATA   cType, cFileName
   DATA   oWnd

   METHOD New( cDevice, cFileName )  CONSTRUCTOR

   METHOD lOpen() BLOCK ;
      { | Self, nId | ::nError := nMciOpen( ::cType, ::cFileName, @nId ),;
                      ::nId := nId, ::nError == 0 }

   METHOD Play( nFrom, nTo ) BLOCK ;
      { | Self, nFrom, nTo | ::nError := nMciPlay( ::nId, nFrom, nTo ) }

   METHOD cGetError() BLOCK ;
      { | Self, cError | mciGetErrorString( ::nError, @cError ), cError }

   METHOD SetWindow( oWnd ) BLOCK ;
      { | Self, oWnd | ::oWnd := oWnd,;
                       ::nError := nMciWindow( ::nId, oWnd:hWnd ) }

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cDevice, cFileName ) CLASS TMci

   DEFAULT cDevice := ""

   ::nError    = 0
   ::nId       = 0
   ::cType     = cDevice
   ::cFileName = cFileName

return

//----------------------------------------------------------------------------//
