// Trees management for Clipper !!!

#include "FiveWin.ch"

static aTrees := {}
static nLevel := 0

static cBmpOp, cBmpCl

//----------------------------------------------------------------------------//

function TreeBegin( cBmpOpen, cBmpClose )

   local oTree := TLinkList()

   if ! Empty( cBmpOpen )
      cBmpOp = cBmpOpen
      cBmpCl = cBmpClose
   endif

   AAdd( aTrees, oTree )
   nLevel++

return oTree

//----------------------------------------------------------------------------//

function _TreeItem( cLabel, cBmpOpen, cBmpClose )

   local hBmpOpen, hBmpClose

   DEFAULT cBmpOpen := cBmpOp, cBmpClose := cBmpCl

   if ! Empty( cBmpOpen )
      hBmpOpen  = LoadBitmap( GetResources(), cBmpOpen )
      hBmpClose = LoadBitmap( GetResources(), cBmpClose )
   endif

return ATail( aTrees ):Add( cLabel, nLevel, hBmpOpen, hBmpClose )

//----------------------------------------------------------------------------//

function TreeEnd()

   local oTree := ATail( aTrees )

   if Len( aTrees ) > 1
      ASize( aTrees, Len( aTrees ) - 1 )
      ATail( aTrees ):oLast:oTree = oTree
      oTree:oFirst:oPrev = ATail( aTrees ):oLast
   endif

   nLevel--

return nil

//----------------------------------------------------------------------------//
