#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

void WindowBoxIn( HDC hDC, RECT * pRect );

//----------------------------------------------------------------------------//

CLIPPER MeterPaint()         //  hWnd, hDC, nActual, nTotal, nPercent
{
   HWND hWnd = _parni( 1 );
   HDC  hDC  = _parni( 2 );
   RECT rc, rcClient;
   WORD wCol, wRight;
   BYTE cChars[ 4 ];
   WORD wPercent = _parni( 5 );

   if( wPercent == 100 )
   {
       cChars[ 0 ] = '1';
       cChars[ 1 ] = '0';
   }
   else
   {
       cChars[ 0 ] = ' ';
       cChars[ 1 ] = ( wPercent < 10 ? ' ' : ( BYTE ) ( wPercent / 10 )   + '0' );
   }
   cChars[ 2 ] = ( BYTE ) ( wPercent % 10 )   + '0';
   cChars[ 3 ] = '%';

   GetClientRect( hWnd, &rc );

   rcClient.top    = rc.top;
   rcClient.left   = rc.left;
   rcClient.bottom = rc.bottom - 1;
   rcClient.right  = rc.right  - 1;

   wCol   = ( ( rc.right - rc.left ) / 2 ) - 16;
   wRight = rc.right;
   rc.top++;
   rc.left++;
   rc.bottom--;
   rc.right = ( WORD ) --rc.right * wPercent / 100;

   SetBkColor( hDC, RGB( 0, 0, 255 ) );
   SetTextColor( hDC, RGB( 255, 255, 255 ) );

   ExtTextOut( hDC, wCol, 2, ETO_CLIPPED | ETO_OPAQUE, &rc, cChars, 4, 0 );

   WindowBoxIn( hDC, &rcClient );

   SetBkColor( hDC, RGB( 192, 192, 192 ) );
   SetTextColor( hDC, 0 );

   rc.left  = rc.right + 1;
   rc.right = wRight - 1;

   if( wPercent < 100 )
       ExtTextOut( hDC, wCol, 2, ETO_CLIPPED | ETO_OPAQUE, &rc, cChars, 4, 0 );

   _retni( 0 );
}

//----------------------------------------------------------------------------//
