#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

#define TRANSPARENT          1
#define OPAQUE               2
#define CLR_BLACK            0
#define CLR_GRAY       8421504   // RGB( 128, 128, 128 )
#define CLR_LIGHTGRAY 12632256   // RGB( 192, 192, 192 )
#define CLR_WHITE     16777215   // RGB( 255, 255, 255 )
#define CLR_CYAN       8421376   // RGB(   0, 128, 128 )
#define CLR_LIGHTCYAN 16776960   // RGB(   0, 255, 255 )
#define CLR_BLUE       8388608   // RGB(   0,   0, 128 )

//----------------------------------------------------------------------------//

CLIPPER Say3D()  // ( hWnd,hDc, cCaption, lRaised, lCentered )
{
   HWND   hWnd      = _parni( 1 );
   HDC    hDC       = _parni( 2 );
   LPBYTE cCaption  = _parc( 3 );
   WORD   wLen      = _parclen( 3 );
   BOOL   bRaised   = ! _parl( 4 );
   WORD   wCentered = _parl( 5 ) ? DT_CENTER : 0;
   HFONT  hFont     = _parni( 6 );
   HFONT  hOldFont;
   RECT   rc;

   GetClientRect( hWnd, &rc );
   SetTextColor( hDC, CLR_WHITE );
   SetBkColor( hDC, CLR_LIGHTGRAY );

   rc.bottom++;
   FillRect( hDC, &rc, GetStockObject( LTGRAY_BRUSH ) );
   rc.bottom--;

   if( ! bRaised )
   {
      rc.top++;
      rc.left++;
   }
   if( hFont )
      hOldFont = SelectObject( hDC, hFont );

   DrawText( hDC, cCaption, wLen, &rc, DT_NOCLIP | wCentered );

   SetTextColor( hDC, CLR_BLACK );
   SetBkMode( hDC, TRANSPARENT );
   if( ! bRaised )
   {
      rc.top--;
      rc.left--;
   }
   else
   {
      rc.top++;
      rc.left++;
   }
   DrawText( hDC, cCaption, wLen, &rc, DT_NOCLIP | wCentered );

   if( hFont )
      SelectObject( hDC, hOldFont );
}

//----------------------------------------------------------------------------//
