//----------------------------------------------------------------------------//
// FiveWin 1.0 - Windows ExeType conversor utility
//
// Esta utilidad se proporciona para aquellos usuarios de LINK.EXE en
// versiones anteriores a la 5.3
//
// Compilar con CLIPPER ExeType.prg /n
//----------------------------------------------------------------------------//

// #include "FiveWin.ch"     // if you want to use it from inside Windows !!!

#include "FileIO.ch"

//----------------------------------------------------------------------------//

function Main( cFileName, cNewType )

   local hFile
   local cNE_Offset    := "  "
   local cNE_Signature := "  "
   local cCurrent      := "  "

   ? "FiveWin 1.0 - Windows ExeType conversor"
   ? "(c) A.Linares & F.Pulpn, 1993"

   if cFileName == nil
      ? "Sintax: ExeType FileName.exe 3.1     --> or other Windows version"
      ?
   else
      ? "working..."
      ?
      if ( hFile := FOpen( cFileName, FO_READWRITE ) ) == -1
         ? "Error opening file"
         return
      endif

      FSeek( hFile, 60, FS_SET )
      FRead( hFile, @cNE_Offset, 2 )

      FSeek( hFile, Bin2W( cNE_Offset ), FS_SET )
      FRead( hFile, @cNE_Signature, 2 )

      if cNE_Signature != "NE"
         ? "This not seems to be a Windows EXE file"
         FClose( hFile )
         return
      else
         ? "NE - New Executable signature detected..."
      endif

      FSeek( hFile, 60, FS_RELATIVE )
      FRead( hFile, @cCurrent, 2 )

      ?  "   Current version: "
      ?? AllTrim( Str( Asc( SubStr( cCurrent, 2, 1 ) ) ) ) + "." + ;
         AllTrim( Str( Asc( SubStr( cCurrent, 1, 1 ) ) ) )

      if cNewType != nil
         ? "   Changing to... "
         ?? cNewType
         FSeek( hFile, -2, FS_RELATIVE )
         cCurrent = Chr( Val( SubStr( cNewType, At( ".", cNewType ) + 1 ) ) ) + ;
                    Chr( Val( SubStr( cNewType, 1, At( ".", cNewType ) - 1 ) ) )
         if FWrite( hFile, cCurrent, 2 ) == 2
            ?? " Ok"
         endif
         FClose( hFile )
      endif

   endif

return

//----------------------------------------------------------------------------//
