#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

#define HDIB HANDLE

void WindowBoxIn( HDC hDC, RECT * pRect );
void WindowBox( HDC hDC, RECT * pRect );
int  DIBitmapColors( BITMAPINFO FAR * bmi );
HPALETTE CreateDibPalette( HDIB hbm );

BOOL DIBDraw( HDC hDC, HGLOBAL hDib, WORD wCol, WORD wRow,
              HPALETTE hPalette, WORD wWidth, WORD wHeight );

//----------------------------------------------------------------------------//

void DrawBitmap( HDC hdc, HBITMAP hbm, WORD wCol, WORD wRow,
                 WORD wWidth, WORD wHeight, DWORD dwRaster )
{
    HDC       hDcMem, hDcMemX;
    BITMAP    bm, bmx;
    HBITMAP   hBmpOld, hbmx;

    if( !hdc || !hbm )
       return;

    hDcMem  = CreateCompatibleDC( hdc );
    hBmpOld = SelectObject( hDcMem, hbm );

    if( ! dwRaster )
       dwRaster = SRCCOPY;

    GetObject( hbm, sizeof( BITMAP ), ( LPSTR ) &bm );

    if( ! wWidth || ! wHeight )
       BitBlt( hdc, wRow, wCol, bm.bmWidth, bm.bmHeight, hDcMem, 0, 0, dwRaster );
    else
    {
       hDcMemX          = CreateCompatibleDC( hdc );
       bmx              = bm;
       bmx.bmWidth      = wWidth;
       bmx.bmHeight     = wHeight;
       bmx.bmWidthBytes = bmx.bmBitsPixel * bmx.bmWidth;
       if( bmx.bmWidthBytes / 16 )
       {
         bmx.bmWidthBytes += ( bmx.bmWidthBytes % 16 ) / 8;
         bmx.bmWidthBytes += bmx.bmWidthBytes % 2;
       }
       else
         bmx.bmWidthBytes = 2;

       hbmx = CreateBitmapIndirect( &bmx );

       SelectObject( hDcMemX, hbmx );
       StretchBlt( hDcMemX, 0, 0, wWidth, wHeight, hDcMem, 0, 0,
                   bm.bmWidth, bm.bmHeight, dwRaster );
       BitBlt( hdc, wRow, wCol, wWidth, wHeight, hDcMemX, 0, 0, dwRaster );
       DeleteDC( hDcMemX );
       DeleteObject( hbmx );
    }

    SelectObject( hDcMem, hBmpOld );
    DeleteDC( hDcMem );
}

//----------------------------------------------------------------------------//

CLIPPER DRAWBITMAP() //  hDC, hBitmap, nRow, nCol, nWidth, nHeight, nRaster
{
   DrawBitmap( _parni( 1 ), _parni( 2 ), _parni( 3 ), _parni( 4 ),
               _parni( 5 ), _parni( 6 ), _parnl( 7 ) );
}

//---------------------------------------------------------------------------//

CLIPPER BTNPAINT() // ( hWnd, hDib1, hPal1, hDib2, hPal2, lPressed, lAdjust )
{
    HWND hWnd      = _parni( 1 );
    HANDLE hDib1   = _parni( 2 );
    HPALETTE hPal1 = _parni( 3 );
    HANDLE hDib2   = _parni( 4 );
    HPALETTE hPal2 = _parni( 5 );
    BOOL bPressed  = _parl( 6 );
    BOOL bAdjust   = _parl( 7 );
    HDC hDC        = GetDC( hWnd );
    RECT rct;

    GetClientRect( hWnd, &rct );

    if( hDib2 )
    {
        if( bPressed )
            DIBDraw( hDC, hDib2, 2, 2, hPal2,
                     bAdjust ? rct.right - 1: 0,
                     bAdjust ? rct.bottom - 1: 0 );
        else
            DIBDraw( hDC, hDib1, 1, 1, hPal1,
                     bAdjust ? rct.right - 1: 0,
                     bAdjust ? rct.bottom - 1: 0 );

    }
    else
    {
       if( bPressed )
       {
           if( hDib1 )
               DIBDraw( hDC, hDib1, 2, 2, hPal1,
                        bAdjust ? rct.right - 1: 0,
                        bAdjust ? rct.bottom - 1: 0 );


           WindowBoxIn( hDC, &rct );
       }
       else
       {
          if( hDib1 )
              DIBDraw( hDC, hDib1, 1, 1, hPal1,
                       bAdjust ? rct.right - 1: 0,
                       bAdjust ? rct.bottom - 1: 0 );
          rct.bottom--;
          rct.right--;

          WindowBox( hDC, &rct );
       }
    }
    ReleaseDC( hWnd, hDC );
}

//---------------------------------------------------------------------------//
