#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

//----------------------------------------------------------------------------//

CLIPPER WSay()
{
   HWND hWnd        = _parni( 1 );
   HDC  hDC         = _parni( 2 );
   WORD wRow        = _parni( 3 );
   WORD wCol        = _parni( 4 );
   LPSTR szText     = _parc( 5 );
   COLORREF clrFore = ( PCOUNT() > 5 ) ? _parnl( 6 ): 0;
   COLORREF clrBack = ( PCOUNT() > 6 ) ? _parnl( 7 ): RGB( 255, 255, 255 );
   HFONT hFont      = _parni( 8 );
   BOOL bPixel      = _parl( 9 );
   HFONT hOldFont;
   BOOL bDestroyDC  = FALSE;
   TEXTMETRIC tm;

   if( ! hDC )
   {
      bDestroyDC = TRUE;
      hDC = GetDC( hWnd );
   }

   GetTextMetrics( hDC, &tm );

   SetTextColor( hDC, clrFore );
   SetBkColor( hDC, clrBack );

   if( hFont )
      hOldFont = SelectObject( hDC, hFont );

   TextOut( hDC, bPixel ? wCol: ( tm.tmAveCharWidth * wCol ),
                 bPixel ? wRow: ( tm.tmHeight * wRow ),
                 szText, strlen( szText ) );

   if( hFont )
      SelectObject( hDC, hOldFont );

   if( bDestroyDC )
      ReleaseDC( hWnd, hDC );
}

//----------------------------------------------------------------------------//

CLIPPER WSayRect()
{
   HWND hWnd        = _parni( 1 );
   HDC  hDC         = _parni( 2 );
   WORD wRow        = _parni( 3 );
   WORD wCol        = _parni( 4 );
   LPSTR szText     = _parc( 5 );
   COLORREF clrFore = ( PCOUNT() > 5 ) ? _parnl( 6 ): 0;
   COLORREF clrBack = ( PCOUNT() > 6 ) ? _parnl( 7 ): RGB( 255, 255, 255 );
   WORD wRectLen    = _parni( 8 );
   BOOL bDestroyDC  = FALSE;
   TEXTMETRIC tm;
   RECT rct;

   if( ! hDC )
   {
      bDestroyDC = TRUE;
      hDC = GetDC( hWnd );
   }

   GetTextMetrics( hDC, &tm );

   SetTextColor( hDC, clrFore );
   SetBkColor( hDC, clrBack );

   rct.top    = tm.tmHeight * wRow;
   rct.bottom = tm.tmHeight * ( wRow + 1 );
   rct.left   = tm.tmAveCharWidth * wCol;
   rct.right  = rct.left + wRectLen;

   ExtTextOut( hDC, rct.left, rct.top, ETO_OPAQUE, &rct, szText,
               strlen( szText ), 0 );

   if( bDestroyDC )
      ReleaseDC( hWnd, hDC );
}

//----------------------------------------------------------------------------//
