
DEFINT A-Z

'
'  NAME   The_Prn.Bas  Copyright 1994, Rob W. Smetana  All Rights Reserved.
'  ====
'         BASIC include file describing printer code structures/types.
'
'
'  PURPOSE
'  =======
'
'  Provide the "field structure" of both Printer.Dat (large database)
'  and Printer.Cfg (small configuration file saved by Printer.Exe).
'
'
'  RECORD LAYOUT
'  =============
'
'  Each record (for each printer) is 1024 bytes in length.
'
'  Some printers have 2 or more records if it can emulate 2 or more other
'  printers.  In other words, each emulation is treated as a separate printer.
'  The field "EmMode" tells you which printer is being emulated.
'
'  ALL fields are STRINGS and all are 14 bytes long EXCEPT the first two:
'    - VerifiedFlag is 1 byte   (should be either blank or not)
'    - Printer Manufacturer is 15 bytes
'
'
'  PLACEHOLDERS:  ASCII character 251 ()
'  ============
'
'  Some printer codes require "variables."  For example, to specify, say
'  3/48 inch line spacing (instead of the normal 6 lines per inch), you
'  send a code like Chr$(27);"L03" (for a Toshiba printer).  In this case
'  both "0" and "3" are variables.
'   - The database would store this code as:  L
'   - Escape is stored as ASCII character 27.
'   - ASCII 251 () is simply a "placeholder" which YOU must replace
'     with appropriate characters.
'
'  You MUST replace the placeholder -- the printer code is meaningless
'  otherwise.
'
'
'  TWO TYPES
'  =========
'
'  Below are 2 TYPES BASIC programmers can use to read printer records.
'  If you program in other langauges, you should have little trouble
'  translating these into structures appropriate for other langages.
'
'   * These TYPES can be used to read either the large database itself
'     (Printer.Dat) or the small config. file (Printer.Cfg) saved by
'     Printer.Exe when you select a printer.
'
'   * The first TYPE (Header) reads the 1st 44 bytes of records.
'     Here you'll find the printer's Manufacturer, Model and Emulation mode.
'
'   * The 2nd TYPE (Printer) will read/hold actual printer codes.
'
'
'  NOTE:  By separating these, if you don't care about the header, you're
'         not forced to keep it around.  Read it (with any 44-byte variable),
'         throw it away, then read just the printer codes.


TYPE Hdr

'=========== Start with a header (Printer manufacturer, model and emulation).

       VerifiedCode AS STRING * 1      'Used for development (reserved)

       Manufacturer AS STRING * 15     'eg., Epson, Panasonic, Star, etc.


'=========== All remaining fields are 14 bytes.

              Model AS STRING * 14     'Specific printer model (eg., LQ-510)

             EmMode AS STRING * 14     'If not blank, this describes the
                                       'printer being emulated.

                                       '44 bytes through here !!!
END TYPE

DIM Header AS Hdr

TYPE Printer

'=========== 70, 14-byte printer codes follow.
'
'            The last few are blank, "expansion" fields for our
'            use (if we add codes), or by you or your user.
'
'            NOTE:  We may expand into these -- starting with the
'            first.  If you're concerned that later we might collide
'            with you, start your codes at the end, then move forward.


         Initialize AS STRING * 14     'Reset to power-on mode (many printers
                                       'have no reset -- a shame).

'...pitch/character sets/master attributes

          Pitch10ON AS STRING * 14     'Turn on 10 characters-per-inch (CPI; Pica)
          Pitch12ON AS STRING * 14     'Turn on 12 CPI (eg., Elite)
        CondensedON AS STRING * 14     'Turn on Condensed mode (15-17 CPI)
       CondensedOFF AS STRING * 14     'Turn Condensed mode off
ProportionalSpacing AS STRING * 14     'Turn on Proportional Spacing
       FixedSpacing AS STRING * 14     'Turn on Fixed Spacing

      SelectCharSet AS STRING * 14     'Select Character Set (USA, French, etc.)
   SelectMasterFont AS STRING * 14     'Select Master Font (Roman, Prestige, etc.)
   SelectPrintStyle AS STRING * 14     'Select Elite, Condensed, etc.
          DraftMode AS STRING * 14     'Turn Draft Mode on (high speed)
  NearLetterQuality AS STRING * 14     'Turn on Near-Letter Quality mode

'... Line spacing

      LinesPerInch6 AS STRING * 14     'Turn on 6 lines-per-inch (LPI)
      LinesPerInch8 AS STRING * 14     '  "  "  8    "   "   "
     LinesPerInch12 AS STRING * 14     '  "  "  12   "   "   "

  VariableLineSpace AS STRING * 14     'Change line spacing (LPI) -- fine increments
    AltVariableLine AS STRING * 14     'Alternate way to change line spacing

'... Attributes/Emphasis/SuperScript/Etc

     DoubleStrikeON AS STRING * 14     'Turn on Double-Strike mode
    DoubleStrikeOFF AS STRING * 14     '  "  off  "       "     "

       DoubleWideON AS STRING * 14     'Turn Double-Wide on
      DoubleWideOFF AS STRING * 14     '  "    "     "   off

     DoubleHeightON AS STRING * 14     'Turn Double-High on
    DoubleHeightOFF AS STRING * 14     '  "    "     "   off

       EmphasizedON AS STRING * 14     'Turn Emphasized mode on
      EmphasizedOFF AS STRING * 14     '  "       "      "   off

             BoldOn AS STRING * 14     'Turn Bold mode on
            BoldOff AS STRING * 14     '  "   "     "   off

        UnderlineON AS STRING * 14     'Turn Underline mode on
       UnderlineOff AS STRING * 14     '  "       "     "   off

           ItalicON AS STRING * 14     'Turn Italic mode on
          ItalicOff AS STRING * 14     '  "     "     "   off

      SuperScriptON AS STRING * 14     'Superscript on
     SuperScriptOFF AS STRING * 14     '    "       off

        SubScriptON AS STRING * 14     'Subscript on
       SubScriptOFF AS STRING * 14     '    "     off

'... Other

  SkipPerforationON AS STRING * 14     'Skip perforation zone
 SkipPerforationOFF AS STRING * 14     'Turn off Skip perf.

UnidirectionalPrint AS STRING * 14     'Unidirectional print on (for accuracy)
 BidirectionalPrint AS STRING * 14     'Bidirectional print on (for speed)

         PushCursor AS STRING * 14     '(LaserJet) Push (save) cursor position
          PopCursor AS STRING * 14     '     "     Pop (restore)  "       "

   PageLengthInches AS STRING * 14     'Set page length in INCHES
    PageLengthLines AS STRING * 14     'Set page length in LINES

        SetTabStops AS STRING * 14     'Set Tab Stops

       SetTopMargin AS STRING * 14     'Set Top Margin
    SetBottomMargin AS STRING * 14     ' "  Bottom "
      SetLeftMargin AS STRING * 14     ' "  Left   "
     SetRightMargin AS STRING * 14     ' "  Right  "


'... The next 4 codes let you move to vertical or horizontal locations,
'    either in absolute terms (ie., a specific row/column) or relative to
'    where you are (ie., move 5 dots down).

AbsVerticalLocation AS STRING * 14     'Move vertically to a specific Row (or dot)
RelVerticalLocation AS STRING * 14     'Move "y" rows/dots from where we are now

   AbsHorizLocation AS STRING * 14     'Move horizontally to a column (or dot)
   RelHorizLocation AS STRING * 14     'Move "x" columns/dots from where we are

     InterCharSpace AS STRING * 14     'Expand/shrink the spacing between
                                       'letters (some newer printers only)

       PortraitMode AS STRING * 14     'LaserJets/DeskJets:  Switch between
      LandscapeMode AS STRING * 14     'portrait and landscape orientations


'... Expansion fields to give us, you or your users options to add codes.

         User1 AS STRING * 14
         User2 AS STRING * 14
         User3 AS STRING * 14
         User4 AS STRING * 14
         User5 AS STRING * 14
         User6 AS STRING * 14
         User7 AS STRING * 14
         User8 AS STRING * 14
         User9 AS STRING * 14
        User10 AS STRING * 14
        User11 AS STRING * 14
        User12 AS STRING * 14
        User13 AS STRING * 14
        User14 AS STRING * 14
        User15 AS STRING * 14         'This rounds out the TYPE/Structure
                                      'to 1024 bytes.

END TYPE

DIM Printer AS Printer

