/*
** This program is distributed with the FALKEN BBS and with the FALKEN
** Doors Development Kit.  This program is copyright 1989 by Herb Rose
*/

/*
** First, the general include files and some data declarations
*/

#include "stdio.h"
#include <time.h>
#include "structs.h"
#include "bbscfg.h"
#include <sys\types.h>
#include <sys\stat.h>

void endtask();

char menu2[] = "Press [ENTER] to continue";

char active[] = "FALKEN Bulletins Section.\r";

char prompt[] =
"\rFlags : M=Must Read   U=Updated\r\r"
"Enter Bulletin Number or 'q' to quit > ";

extern struct acct_rec *myacct;

char menutext[] =
"\r\r\rFalken Bulletins Section\r\r"
"Number  Flags  Date      Subject\r"
"------  -----  --------  ----------------------------------------\r";

char menuformat[] = "  %2d    %-5s  %8s  %s\r";

char cb[100];

int bulnum;

int nostop = 0;

extern struct cfg_rec *cfg;

int must_read[16];
unsigned long bull_date[16];
unsigned updated[16];

char datestr[16][10];
char subject[16][40];

int dc_monthsiz[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

unsigned dc_yearstart[] = {
    0, 366, 731, 1096, 1461, 1827, 2192, 2557,
    2922, 3288, 3653, 4018, 4383, 4749, 5114, 5479,
    5844, 6210, 6575, 6940, 7305, 7671, 8036, 8401,
    8766, 9132, 9497, 9862, 10227, 10593, 10958, 11323,
    11688, 12054, 12419, 12784, 13149, 13515, 13880, 14245,
    14610, 14976, 15341, 15706, 16071, 16437, 16802, 17167,
    17532, 17898, 18263, 18628, 18993, 19359, 19724, 20089,
    20454, 20820, 21185, 21550, 21915, 22281, 22646, 23011,
    23376, 23742, 24107, 24472, 24837, 25203, 25568, 25933,
    26298, 26664, 27029, 27394, 27759, 28125, 28490, 28855,
    29220, 29586, 29951, 30316, 30681, 31047, 31412, 31777,
    32142, 32508, 32873, 33238, 33603, 33969, 34334, 34699,
    35064, 35430, 35795, 36160, 36525, 36891, 37256, 37621,
    37986, 38352, 38717, 39082, 39447, 39813, 40178, 40543,
40908, 41274, 41639, 42004, 42369, 42735, 43100, 43465};


int numtodate();

/*
** DATETONUM converts 3 integers (mm dd yy) into an unsigned
** integer compatible with FALKEN date representation
*/

unsigned datetonum(kmon, kday, kyear)
unsigned kmon, kday, kyear;
{
    unsigned k, l;
    if (kyear >= 1900)
        kyear -= 1900;
    if (kyear > 118)
        return 0;
    if ((kyear & 3) == 0)
        dc_monthsiz[1] = 29;
    else
        dc_monthsiz[1] = 28;
    k = dc_yearstart[kyear];
    for (l = 1; l < kmon; l++)
        k += dc_monthsiz[l - 1];
    k += kday;
    return k;
}

FILE *fp;

main()
{
    int j, k, n, len;
    int k2;
    unsigned long lj;
    unsigned uk;
    struct stat statrec;
    struct tm *loctptr;
    char tstr[4];

    fp=NULL;

    atexit(endtask);

    for (j = 0; j < 16; j++)
    {
        must_read[j] = 0;
        bull_date[j] = 0L;
        sprintf(cb, "bulletin.%d", j + 1);
        if (stat(cb, &statrec) == 0)    /* this file exists ? */
        {
            loctptr = localtime(&statrec.st_atime);
            sprintf(datestr[j], "%02d/%02d/%02d",
                    loctptr->tm_mon + 1, loctptr->tm_mday,
                    loctptr->tm_year);
            bull_date[j] = statrec.st_atime;
            fp = fopen(cb, "r");
            fgets(cb, 80, fp);
            cb[strlen(cb) - 1] = '\0';
            cb[39] = '\0';
            strcpy(subject[j], cb);
            fclose(fp);
            fp=NULL;
        }
    }

    init();

    for (j = 0, lj = 1L; j < 16; j++, lj <<= 1)
    {
        if (bull_date[j] > myacct->bulreadtime)
        {
            updated[j] = 1;
            if (cfg->bul_must_read_flags & lj)
            {
                must_read[j] = 1;
            }
        }
    }

    send(active);               /* send a 'we are alive' to the user */

/*
**  Now the main loop -
**   basically, we wait for the user to type something.
**   anything except 'exit' is considered to be a file name.
**   if 'exit' is entered, we will terminate normally.
**   else, attempt to open the file, and send it to the user.
**   we will pause between pages.
*/

    for (;;)
    {
        send(menutext);
        for (j = 0; j < 16; j++)
        {
            if (bull_date[j])
            {
                tstr[0] = must_read[j] ? 'M' : ' ';
                tstr[1] = updated[j] ? 'U' : ' ';
                tstr[2] = '\0';
                qprintf(menuformat, j + 1, tstr, datestr[j], subject[j]);
            }
        }

        send(prompt);

        qgets(cb, 80);

        strlwr(cb);
        if ((cb[0] == 'q') || (cb[0] == 'x'))
        {
            for (j = 0, k = 0; j < 16; j++)
            {
                if (must_read[j])
                {
                    k++;
                    qprintf(cb, "You must first read bulletin #%d.\r", j + 1);
                }
            }

            if (!k)
            {
                myacct->bulreadtime = time(NULL);
                exit();
            }
            send("Press [ENTER] to continue..");
            continue;
        }

        j = atoi(cb);
        if (j < 1 || j > 16)
        {
            send("Invalid Bulletin Number.  Press [ENTER] to continue.\r");
            qgets(cb, 80);
            continue;
        }
        sprintf(cb, "bulletin.%d", j);
        bulnum = j - 1;
        fp = fopen(cb, "ra");
        if (fp == NULL)
        {                       /* cannot open file! */
            send("Error opening file.\r");
        }
        else
        {                       /* file is open, so we can start sending it
                                 * to user */
            n = 0;
/*
** This while loop causes us to loop until end of file.
** At that point we go back to the
** outer loop, that continues until the user enters 'exit' to
** terminate the program
*/
            while (!n)
            {
                for (k = 0; k < 23;)
                {
                    if (fgets(cb, 79, fp) == NULL)
                    {
                read_err:
                        n = 1;
                        must_read[bulnum] = 0;
                        updated[bulnum] = 0;
                        send("End of bulletin.  Press [ENTER] to continue\r");
                        qgets(cb, 80);
                        break;
                    }
                    else
                    {
                        cb[79] = '\0';
                        len = strlen(cb);
                        if (len == 0)
                            goto read_err;
                        cb[len - 1] = '\r';
/*
** the screen width of the user's terminal is in the account structure
** as member 'linlen'.  We can determine how many screen lines this
** string will create on the user's screen by dividing the length by
** his screen width.  Add one for the \r at the end
** we will continue sending output until we have sent 23 screen lines.
*/
                        if (len > myacct->linlen)
                            k++;
                        k++;
                        send(cb);
                    }
                }               /* end for */
                if (!n)
                {
                    send(menu2);
                    qgets(cb,80);
                }               /* end if !n */
            }                   /* end while */
            fclose(fp);
            fp=NULL;
        }                       /* end else */
    }                           /* end for (;;) */
}

void endtask()
{
    if(fp != NULL)
        fclose(fp);
}

