/*
** Cswitch interface routines.
** LARGE Model   -  >64K code,  >64K data
*/


#include "dos.h"

void relinq()
{
	union REGS ir;

	ir.h.ah = 1;
	int86(0x62, &ir, &ir);
}

int sem_attach(int semnum)
{
	union REGS ir;

	ir.h.ah = 2;
	ir.x.dx = semnum;
	int86(0x62, &ir, &ir);
	return ir.x.ax;
}

int sem_test(int semnum)
{
	union REGS ir;

	ir.h.ah = 3;
	ir.x.dx = semnum;
	int86(0x62, &ir, &ir);
	return ir.x.ax;
}

int sem_release(int semnum)
{
	union REGS ir;

	ir.h.ah = 4;
	ir.x.dx = semnum;
	int86(0x62, &ir, &ir);
	return ir.x.ax;
}

int delay(int numticks)
{
	union REGS ir;

	ir.h.ah = 5;
	ir.x.bx = numticks;
	int86(0x62, &ir, &ir);
}

int suspend()
{
	union REGS ir;

	ir.h.ah = 6;
	int86(0x62, &ir, &ir);
}

int spawn(void *addr, int pri)
{
	union REGS ir;
	struct SREGS sr;

	segread(&sr);
	ir.h.ah = 7;
	ir.x.cx = pri;
	ir.x.bx = FP_OFF(addr);
	sr.es = FP_SEG(addr);
	int86x(0x62, &ir, &ir, &sr);
	return ir.x.ax;
}

int wakeup(int tasknum)
{
	union REGS ir;

	ir.h.ah = 8;
	ir.x.bx = tasknum;
	int86(0x62, &ir, &ir);
}

int setpri(int pri)
{
	union REGS ir;

	ir.h.ah = 9;
	ir.x.bx = pri;
	int86(0x62, &ir, &ir);
}


int testmsg(int qnum)
{
	union REGS ir;

	ir.h.ah = 10;
	ir.x.dx = qnum;
	int86(0x62, &ir, &ir);
	return ir.x.ax;
}

int send_md_msg(int qnum, char *buf, int len)
{
	union REGS ir;
	struct SREGS sr;

	ir.h.ah = 11;
	ir.x.dx = qnum;
	ir.x.si = FP_OFF(buf);
	sr.ds = FP_SEG(buf);
	ir.x.cx = len;
	int86x(0x62, &ir, &ir, &sr);
	return ir.x.ax;
}

int recvmsg(int qnum, char *buf, int len)
{
	union REGS ir;
	struct SREGS sr;

	do
	{
		ir.h.ah = 12;
		ir.x.dx = qnum;
		ir.x.si = FP_OFF(buf);
		sr.ds = FP_SEG(buf);
		ir.x.cx = len;
		int86x(0x62, &ir, &ir, &sr);
	} while (ir.x.ax == -2);
	return ir.x.ax;
}

int hog()
{
	union REGS ir;

	ir.h.ah = 13;
	int86(0x62, &ir, &ir);
}

int nohog()
{
	union REGS ir;

	ir.h.ah = 14;
	int86(0x62, &ir, &ir);
}

int loadtask(void *addr, int pri, int bgrd)
{
	union REGS ir;
	struct SREGS sr;

	segread(&sr);
	ir.h.ah = 15;
	ir.x.cx = pri;
	ir.x.dx = bgrd;
	ir.x.bx = FP_OFF(addr);
	sr.es = FP_SEG(addr);
	int86x(0x62, &ir, &ir, &sr);
	return ir.x.ax;
}

int spawn_exit()
{
	union REGS ir;

	ir.h.ah = 16;
	int86(0x62, &ir, &ir);
}

/* provide the address of a far pointer! */
int get_tcb_info(void *addr)
{
	union REGS ir;
	struct SREGS sr;

	segread(&sr);
	ir.h.ah = 17;
	ir.x.bx = FP_OFF(addr);
	sr.es = FP_SEG(addr);
	int86x(0x62, &ir, &ir, &sr);
	return ir.x.ax;
}

int get_tcb_address(void *addr)
{
	union REGS ir;
	struct SREGS sr;

	segread(&sr);
	ir.h.ah = 18;
	ir.x.bx = FP_OFF(addr);
	sr.es = FP_SEG(addr);
	int86x(0x62, &ir, &ir, &sr);
	return ir.x.ax;
}

int get_load_status()
{
	union REGS ir;

	ir.h.ah = 19;
	int86(0x62, &ir, &ir);
	return ir.x.ax;
}

/*
** Send data to a pipe.
*/

int send_pipe(int qnum, char *buf, int len)
{
	union REGS ir;
	struct SREGS sr;

	ir.h.ah = 20;
	ir.x.bx = qnum;
	ir.x.dx = FP_OFF(buf);
	sr.ds = FP_SEG(buf);
	ir.x.cx = len;
	int86x(0x62, &ir, &ir, &sr);
	return ir.x.ax;
}

int recv_pipe(int qnum, char *buf, int len)
{
	union REGS ir;
	struct SREGS sr;

	ir.h.ah = 21;
	ir.x.bx = qnum;
	ir.x.dx = FP_OFF(buf);
	sr.ds = FP_SEG(buf);
	ir.x.cx = len;
	int86x(0x62, &ir, &ir, &sr);
	return ir.x.ax;
}


/*
** Like loadtask, but sets the new task up as a 'pipe' task, where
** all I/O to stdin/stdout/stderr goes into a pipe for another task
** to write or read.
*/

int loadpipe(void *addr, int pri, int bgrd)
{
	union REGS ir;
	struct SREGS sr;

	segread(&sr);
	ir.h.ah = 22;
	ir.x.cx = pri;
	ir.x.dx = bgrd;
	ir.x.bx = FP_OFF(addr);
	sr.es = FP_SEG(addr);
	int86x(0x62, &ir, &ir, &sr);
	return ir.x.ax;
}

/*
** Like loadtask, but replaces the caller with the new task, so the
** new task inherits the callers pipe.
*/

int execprog(void *addr, int pri, int bgrd)
{
	union REGS ir;
	struct SREGS sr;

	segread(&sr);
	ir.h.ah = 23;
	ir.x.cx = pri;
	ir.x.dx = bgrd;
	ir.x.bx = FP_OFF(addr);
	sr.es = FP_SEG(addr);
	int86x(0x62, &ir, &ir, &sr);
	return ir.x.ax;
}

int test_pipe(int pipenum)
{
	union REGS ir;
	ir.h.ah = 24;
	ir.x.bx = pipenum;
	int86(0x62, &ir, &ir);
	return ir.x.ax;
}

